/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactoryEx;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.ui.LearnToolWindow;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Ltraining/ui/LearnToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactoryEx;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getAnchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "init", "Companion", "intellij.featuresTrainer"})
public final class LearnToolWindowFactory
implements ToolWindowFactoryEx,
DumbAware {
    @NotNull
    public static final String LEARN_TOOL_WINDOW = "Learn";
    @NotNull
    private static final Map<Project, LearnToolWindow> learnWindowPerProject;
    @NotNull
    public static final Companion Companion;

    public void init(@NotNull ToolWindow toolWindow) {
        ToolWindowEx toolWindowEx;
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super.init(toolWindow);
        ToolWindow toolWindow2 = toolWindow;
        if (!(toolWindow2 instanceof ToolWindowEx)) {
            toolWindow2 = null;
        }
        if ((toolWindowEx = (ToolWindowEx)toolWindow2) == null || (toolWindowEx = toolWindowEx.getProject()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowEx, (String)"(toolWindow as? ToolWindowEx)?.project ?: return");
        ToolWindowEx project = toolWindowEx;
        ((ToolWindowEx)toolWindow).setShowStripeButton(UtilsKt.findLanguageSupport((Project)project) != null);
    }

    @Nullable
    public ToolWindowAnchor getAnchor() {
        String name$iv = "learn tool window anchor setting";
        ActivityCategory category$iv = ActivityCategory.DEFAULT;
        boolean $i$f$runActivity = false;
        Activity activity = StartUpMeasurer.startActivity((String)name$iv, (ActivityCategory)category$iv);
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startActivity(name, category)");
        Activity activity$iv = activity;
        boolean bl = false;
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        return langSupport2 != null ? langSupport2.getToolWindowAnchor() : null;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        String string = applicationInfo.getBuild().asStringWithoutProductCodeAndSnapshot();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationInfo.getInsta\u2026tProductCodeAndSnapshot()");
        String currentBuildStr = string;
        PropertiesComponent.getInstance().setValue("ift.learning.panel.opened.in", currentBuildStr);
        LearnToolWindow learnToolWindow = new LearnToolWindow(project, toolWindow);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        Content content = contentManager2.getFactory().createContent((JComponent)((Object)learnToolWindow), null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"contentManager.factory.c\u2026nToolWindow, null, false)");
        Content content2 = content;
        content2.setCloseable(false);
        contentManager2.addContent(content2);
        learnWindowPerProject.put(project, learnToolWindow);
    }

    static {
        Companion = new Companion(null);
        Map map = ContainerUtil.createWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"ContainerUtil.createWeakMap()");
        learnWindowPerProject = map;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ltraining/ui/LearnToolWindowFactory$Companion;", "", "()V", "LEARN_TOOL_WINDOW", "", "learnWindowPerProject", "", "Lcom/intellij/openapi/project/Project;", "Ltraining/ui/LearnToolWindow;", "getLearnWindowPerProject", "()Ljava/util/Map;", "intellij.featuresTrainer"})
    public static final class Companion {
        @NotNull
        public final Map<Project, LearnToolWindow> getLearnWindowPerProject() {
            return learnWindowPerProject;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

