/*
 * Decompiled with CFR 0.152.
 */
package training.learn.course;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.TaskTestContext;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.course.IftModule;
import training.learn.course.LessonProperties;
import training.learn.course.LessonType;
import training.learn.lesson.LessonListener;
import training.learn.lesson.LessonState;
import training.learn.lesson.LessonStateManager;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0014J\r\u0010/\u001a\u00020!H\u0000\u00a2\u0006\u0002\b0J\u0018\u00101\u001a\u00020-2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020!H\u0016J\r\u00105\u001a\u00020-H\u0000\u00a2\u0006\u0002\b6J\u001d\u00107\u001a\u00020-2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020!H\u0000\u00a2\u0006\u0002\b8J\r\u00109\u001a\u00020-H\u0000\u00a2\u0006\u0002\b:J\u0010\u0010;\u001a\u00020<2\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010=\u001a\u00020-2\u0006\u00102\u001a\u000203H\u0017J\u000e\u0010>\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0014R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\bR\u0014\u0010 \u001a\u00020!8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006?"}, d2={"Ltraining/learn/course/Lesson;", "", "id", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "existedFile", "getExistedFile", "()Ljava/lang/String;", "fileName", "getFileName", "helpLinks", "", "getHelpLinks", "()Ljava/util/Map;", "getId", "languageId", "getLanguageId", "lessonListeners", "", "Ltraining/learn/lesson/LessonListener;", "getLessonListeners$intellij_featuresTrainer", "()Ljava/util/List;", "lessonType", "Ltraining/learn/course/LessonType;", "getLessonType", "()Ltraining/learn/course/LessonType;", "module", "Ltraining/learn/course/IftModule;", "getModule", "()Ltraining/learn/course/IftModule;", "getName", "passed", "", "getPassed$intellij_featuresTrainer", "()Z", "properties", "Ltraining/learn/course/LessonProperties;", "getProperties", "()Ltraining/learn/course/LessonProperties;", "testScriptProperties", "Ltraining/dsl/TaskTestContext$TestScriptProperties;", "getTestScriptProperties", "()Ltraining/dsl/TaskTestContext$TestScriptProperties;", "addLessonListener", "", "lessonListener", "isNewLesson", "isNewLesson$intellij_featuresTrainer", "onLessonEnd", "project", "Lcom/intellij/openapi/project/Project;", "lessonPassed", "onStart", "onStart$intellij_featuresTrainer", "onStop", "onStop$intellij_featuresTrainer", "pass", "pass$intellij_featuresTrainer", "preferredLearnWindowAnchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "prepare", "removeLessonListener", "intellij.featuresTrainer"})
public abstract class Lesson {
    @Nullable
    private final String existedFile;
    @NotNull
    private final LessonProperties properties;
    @NotNull
    private final TaskTestContext.TestScriptProperties testScriptProperties;
    @NotNull
    private final List<LessonListener> lessonListeners;
    @NotNull
    private final String id;
    @NotNull
    private final String name;

    @NotNull
    public abstract IftModule getModule();

    @NotNull
    public String getFileName() {
        String string;
        String id = this.getLanguageId();
        StringBuilder stringBuilder = new StringBuilder().append(this.getModule().getSanitizedName());
        if (id != null) {
            StringBuilder stringBuilder2 = new StringBuilder().append(".");
            Language language = UtilsKt.findLanguageByID(id);
            Intrinsics.checkNotNull((Object)language);
            LanguageFileType languageFileType = language.getAssociatedFileType();
            Intrinsics.checkNotNull((Object)languageFileType);
            Intrinsics.checkNotNullExpressionValue((Object)languageFileType, (String)"findLanguageByID(id)!!.associatedFileType!!");
            string = stringBuilder2.append(languageFileType.getDefaultExtension()).toString();
        } else {
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    @Nullable
    public String getLanguageId() {
        LangSupport langSupport2 = this.getModule().getPrimaryLanguage();
        return langSupport2 != null ? langSupport2.getPrimaryLanguage() : null;
    }

    @NotNull
    public LessonType getLessonType() {
        return this.getModule().getModuleType();
    }

    @NotNull
    public ToolWindowAnchor preferredLearnWindowAnchor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getModule().preferredLearnWindowAnchor(project);
    }

    @Nullable
    public String getExistedFile() {
        return this.existedFile;
    }

    @RequiresBackgroundThread
    public void prepare(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public LessonProperties getProperties() {
        return this.properties;
    }

    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.emptyMap();
    }

    @NotNull
    public TaskTestContext.TestScriptProperties getTestScriptProperties() {
        return this.testScriptProperties;
    }

    public void onLessonEnd(@NotNull Project project, boolean lessonPassed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    public final void addLessonListener(@NotNull LessonListener lessonListener) {
        Intrinsics.checkNotNullParameter((Object)lessonListener, (String)"lessonListener");
        this.lessonListeners.add(lessonListener);
    }

    public final void removeLessonListener(@NotNull LessonListener lessonListener) {
        Intrinsics.checkNotNullParameter((Object)lessonListener, (String)"lessonListener");
        this.lessonListeners.remove(lessonListener);
    }

    public final boolean getPassed$intellij_featuresTrainer() {
        return LessonStateManager.INSTANCE.getStateFromBase(this.id) == LessonState.PASSED;
    }

    @NotNull
    public final List<LessonListener> getLessonListeners$intellij_featuresTrainer() {
        return this.lessonListeners;
    }

    public final void onStart$intellij_featuresTrainer() {
        Iterable $this$forEach$iv = this.lessonListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LessonListener it = (LessonListener)element$iv;
            boolean bl = false;
            it.lessonStarted(this);
        }
    }

    public final void onStop$intellij_featuresTrainer(@NotNull Project project, boolean lessonPassed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$forEach$iv = this.lessonListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LessonListener it = (LessonListener)element$iv;
            boolean bl = false;
            it.lessonStopped(this);
        }
        this.onLessonEnd(project, lessonPassed);
    }

    public final void pass$intellij_featuresTrainer() {
        LessonStateManager.INSTANCE.setPassed(this);
        Iterable $this$forEach$iv = this.lessonListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LessonListener it = (LessonListener)element$iv;
            boolean bl = false;
            it.lessonPassed(this);
        }
    }

    public final boolean isNewLesson$intellij_featuresTrainer() {
        String string = this.getProperties().getAvailableSince();
        if (string == null) {
            return false;
        }
        String availableSince = string;
        BuildNumber buildNumber = BuildNumber.fromString((String)availableSince);
        if (buildNumber == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"BuildNumber.fromString(a\u2026bleSince) ?: return false");
        BuildNumber lessonVersion = buildNumber;
        BuildNumber buildNumber2 = CourseManager.Companion.getInstance().getPreviousOpenedVersion();
        if (buildNumber2 == null) {
            return true;
        }
        BuildNumber previousOpenedVersion = buildNumber2;
        return previousOpenedVersion.compareTo(lessonVersion) < 0;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public Lesson(@NonNls @NotNull String id, @Nls @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.id = id;
        this.name = name;
        this.properties = new LessonProperties(false, false, null, 7, null);
        this.testScriptProperties = new TaskTestContext.TestScriptProperties(0, false, 3, null);
        boolean bl = false;
        this.lessonListeners = new ArrayList();
    }
}

