/*
 * Decompiled with CFR 0.152.
 */
package training.actions;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.util.NlsSafe;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.actions.ChooseProgrammingLanguageForLearningActionKt;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.LearnBundle;
import training.ui.LearnToolWindow;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ltraining/actions/ChooseProgrammingLanguageForLearningAction;", "Lcom/intellij/openapi/actionSystem/ex/ComboBoxAction;", "learnToolWindow", "Ltraining/ui/LearnToolWindow;", "(Ltraining/ui/LearnToolWindow;)V", "createPopupActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "button", "Ljavax/swing/JComponent;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "SelectLanguageAction", "intellij.featuresTrainer"})
public final class ChooseProgrammingLanguageForLearningAction
extends ComboBoxAction {
    private final LearnToolWindow learnToolWindow;

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@Nullable JComponent button2) {
        DefaultActionGroup allActionsGroup = new DefaultActionGroup();
        Iterable $this$sortedBy$iv = LangManager.Companion.getInstance().getSupportedLanguagesExtensions();
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List supportedLanguagesExtensions = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                LanguageExtensionPoint it = (LanguageExtensionPoint)a;
                boolean bl2 = false;
                it = (LanguageExtensionPoint)b;
                Comparable comparable = (Comparable)((Object)it.language);
                bl2 = false;
                String string = it.language;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        });
        for (LanguageExtensionPoint langSupportExt : supportedLanguagesExtensions) {
            String languageId = langSupportExt.language;
            Object object = Language.findLanguageByID((String)languageId);
            if (object == null || (object = object.getDisplayName()) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Language.findLanguageByI\u2026?.displayName ?: continue");
            Object displayName = object;
            String string = languageId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"languageId");
            allActionsGroup.add((AnAction)new SelectLanguageAction(string, (String)displayName));
        }
        return allActionsGroup;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 != null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setText(ChooseProgrammingLanguageForLearningActionKt.access$getDisplayName(langSupport2));
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setDescription(LearnBundle.INSTANCE.message("learn.choose.language.description.combo.box", new Object[0]));
    }

    public ChooseProgrammingLanguageForLearningAction(@NotNull LearnToolWindow learnToolWindow) {
        Intrinsics.checkNotNullParameter((Object)((Object)learnToolWindow), (String)"learnToolWindow");
        this.learnToolWindow = learnToolWindow;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ltraining/actions/ChooseProgrammingLanguageForLearningAction$SelectLanguageAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "languageId", "", "displayName", "(Ltraining/actions/ChooseProgrammingLanguageForLearningAction;Ljava/lang/String;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.featuresTrainer"})
    private final class SelectLanguageAction
    extends AnAction {
        private final String languageId;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Iterable $this$singleOrNull$iv = LangManager.Companion.getInstance().getSupportedLanguagesExtensions();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    LanguageExtensionPoint it = (LanguageExtensionPoint)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.language, (Object)this.languageId)) continue;
                    if (found$iv) {
                        v0 = null;
                        break block3;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            LanguageExtensionPoint languageExtensionPoint = v0;
            if (languageExtensionPoint == null) {
                return;
            }
            LanguageExtensionPoint ep = languageExtensionPoint;
            Object object = ep.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ep.instance");
            UtilsKt.resetPrimaryLanguage((LangSupport)object);
            ChooseProgrammingLanguageForLearningAction.this.learnToolWindow.setModulesPanel$intellij_featuresTrainer();
        }

        public SelectLanguageAction(@NlsSafe @NotNull String languageId, String displayName) {
            Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            super(displayName);
            this.languageId = languageId;
        }
    }
}

