/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class SqlSubqueryUtilsCore {
    @Nullable
    public static SqlExpression findCteAbleParent(@Nullable PsiElement el, boolean strict) {
        if (strict && el != null) {
            el = el.getParent();
        }
        while (el != null) {
            if (el instanceof SqlResultSetExpression && !(el instanceof SqlNAryExpression)) {
                return (SqlExpression)el;
            }
            el = el.getParent();
        }
        return null;
    }

    public static SqlExpression findEnclosingQueryWithContext(PsiElement el) {
        PsiElement possibleWithClause;
        SqlExpression ex;
        if (el == null) {
            return null;
        }
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)el.getParent(), SqlWithQueryExpression.class);
        if (withEx != null) {
            if (withEx.getExpression() != el) {
                return null;
            }
            el = el.getParent();
        }
        if ((ex = SqlSubqueryUtilsCore.findCteAbleParent(el, true)) == null || ObjectUtils.tryCast((Object)ex, SqlWithQueryExpression.class) != null) {
            return null;
        }
        PsiElement parent2 = ex.getParent();
        if (parent2 instanceof SqlNamedQueryDefinitionImpl && (possibleWithClause = parent2.getParent()) instanceof SqlWithClause) {
            parent2 = possibleWithClause.getParent();
        }
        return (withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)parent2, SqlWithQueryExpression.class)) != null ? withEx : ex;
    }
}

