/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.stubs.SqlNamedChildElementStub;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlNamedStubElementType;
import com.intellij.sql.psi.stubs.SqlSpecificChildStubElementType;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStubbedDefinitionImpl<T extends SqlNamedElementStub<?>>
extends SqlStubbedElement<T>
implements SqlDefinition,
ItemPresentation,
StubBasedPsiElement<T> {
    private static final Logger LOG = Logger.getInstance(SqlStubbedDefinitionImpl.class);
    private volatile String myCachedName;

    public SqlStubbedDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlStubbedDefinitionImpl(T stub) {
        super(stub, stub.getStubType());
    }

    public ItemPresentation getPresentation() {
        return this;
    }

    @Nullable
    public BasicMetaObject<?> getMetaObject() {
        DasObject p2;
        BasicMetaObject<?> pMeta;
        BasicMetaObject res2;
        ObjectKind pKind;
        SqlReferenceElementType type = this.getExpectedNameReferenceElementType();
        ObjectKind kind = this.getKind();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        Dbms dbms = dialect.getDbms();
        BasicMetaModel<?> metaModel = DbImplUtilCore.getMetaModel(dbms);
        ArrayList objects2 = ContainerUtil.newArrayList(metaModel.findMetaObjects(kind));
        if (objects2.size() <= 1 && !SqlStubbedDefinitionImpl.isMultipleKind(kind)) {
            return (BasicMetaObject)ContainerUtil.getFirstItem((List)objects2);
        }
        ObjectKind objectKind = pKind = this.getExpectedParentType() == null ? null : this.getExpectedParentType().getTargetKind();
        if (pKind != null) {
            objects2.removeIf(o -> o.getParent() == null || o.getParent().kind != pKind);
            if (objects2.size() <= 1) {
                return (BasicMetaObject)ContainerUtil.getFirstItem((List)objects2);
            }
        }
        if ((res2 = BasicMetaUtils.findChild(pMeta = SqlImplUtil.getMetaObject(p2 = this.getDasParentWithoutResolve()), kind)) == null && kind == ObjectKind.OBJECT_TYPE) {
            res2 = BasicMetaUtils.findChild(pMeta, ObjectKind.ALIAS_TYPE);
        }
        if (res2 == null) {
            SqlReferenceExpression pRef = this.getParentRef();
            if (pRef != null) {
                ObjectKind pKind2 = pRef.getReferenceElementType().getTargetKind();
                objects2.removeIf(o -> o.getParent() == null || o.getParent().kind != pKind2);
                return (BasicMetaObject)ContainerUtil.getFirstItem((List)objects2);
            }
            if (this.getElementType().shouldCreateStub(this.getNode())) {
                return (BasicMetaObject)ContainerUtil.getFirstItem((List)objects2);
            }
        }
        return res2;
    }

    private static boolean isMultipleKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(1);
        }
        return kind == ObjectKind.VARIABLE || kind == ObjectKind.ARGUMENT || kind == ObjectKind.EXCEPTION || kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.COLLECTION_TYPE || kind == ObjectKind.ALIAS_TYPE;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return DbPresentationCore.getIcon((DasObject)((Object)this));
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = SqlImplUtil.getSqlDialectDbms((PsiElement)this);
        if (dbms == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(2);
        }
        return dbms;
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        if (this instanceof SqlCreateStatement) {
            visitor2.visitSqlCreateStatement((SqlCreateStatement)this);
        } else {
            visitor2.visitSqlDefinition((SqlDefinition)this);
        }
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedName = null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(3);
        }
        this.getNode();
        SqlNameElement element2 = this.getNameElement();
        if (element2 != null) {
            element2.setName(name);
        }
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        String cached = this.myCachedName;
        if (cached != null) {
            String string = cached;
            if (string == null) {
                SqlStubbedDefinitionImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        String name = this.calcName();
        this.myCachedName = (String)ObjectUtils.notNull((Object)name, (Object)SqlImplUtil.NULL_STRING);
        if (this.myCachedName == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(5);
        }
        return this.myCachedName;
    }

    @Nullable
    protected String calcName() {
        SqlNameElement element2 = this.getNameElement();
        return element2 == null ? null : element2.getName();
    }

    public short getPosition() {
        return (Short)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcPosition(), (Object[])new Object[]{SqlImplUtil.sqlParent((PsiElement)this)}));
    }

    protected short calcPosition() {
        return SqlImplUtil.calcPosition(this);
    }

    @Nullable
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        SqlNamedStubElementType type = (SqlNamedStubElementType)((Object)ObjectUtils.tryCast((Object)PsiUtilCore.getElementType((PsiElement)this), SqlNamedStubElementType.class));
        return type == null ? null : type.getTargetReferenceType();
    }

    public SqlNameElement getNameElement() {
        SqlNamedElementStub stub = (SqlNamedElementStub)this.getStub();
        SqlReferenceElementType refType = this.getExpectedNameReferenceElementType();
        if (stub != null) {
            return stub.getNameReference(refType);
        }
        if (refType != null) {
            return (SqlNameElement)this.findChildByType((IElementType)refType);
        }
        return (SqlNameElement)this.findChildByClass(SqlReferenceExpression.class);
    }

    @NotNull
    public ObjectKind getKind() {
        SqlReferenceElementType refType = this.getExpectedNameReferenceElementType();
        if (refType != null) {
            ObjectKind objectKind = refType.getTargetKind();
            if (objectKind == null) {
                SqlStubbedDefinitionImpl.$$$reportNull$$$0(6);
            }
            return objectKind;
        }
        SqlNameElement element2 = this.getNameElement();
        if (!(element2 instanceof SqlReferenceExpression)) {
            String msg = this.getContainingFile().getLanguage() + "/" + ((Object)((Object)this)).getClass().getSimpleName() + "/" + PsiUtilCore.getElementType((PsiElement)this) + ": " + element2;
            Application app = ApplicationManager.getApplication();
            if (app == null || app.isUnitTestMode()) {
                throw new AssertionError((Object)(msg + "\n" + this.getText()));
            }
            LOG.warn(msg);
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                SqlStubbedDefinitionImpl.$$$reportNull$$$0(7);
            }
            return objectKind;
        }
        ObjectKind objectKind = ((SqlReferenceExpression)element2).getReferenceElementType().getTargetKind();
        if (objectKind == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(8);
        }
        return objectKind;
    }

    public String getPresentableText() {
        return StringUtil.notNullize((String)this.getName(), (String)"<unknown>");
    }

    public String getLocationString() {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)this);
        if (virtualFile == null) {
            return this.getContainingFile().getName();
        }
        if (ScratchUtil.isScratch((VirtualFile)virtualFile)) {
            return ScratchUtil.getRelativePath((Project)this.getProject(), (VirtualFile)virtualFile);
        }
        VirtualFile root2 = SqlStubbedDefinitionImpl.getAnyRoot(virtualFile, this.getProject());
        return root2 != null ? VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)root2) : virtualFile.getPath();
    }

    @Nullable
    private static VirtualFile getAnyRoot(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        ProjectFileIndex index2;
        VirtualFile root2;
        if (virtualFile == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(9);
        }
        if (project == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(10);
        }
        if ((root2 = (index2 = ProjectFileIndex.SERVICE.getInstance((Project)project)).getContentRootForFile(virtualFile)) == null) {
            root2 = index2.getClassRootForFile(virtualFile);
        }
        if (root2 == null) {
            root2 = index2.getSourceRootForFile(virtualFile);
        }
        return root2;
    }

    public Icon getIcon(boolean open) {
        return this.getIcon();
    }

    public int getTextOffset() {
        this.getNode();
        SqlNameElement nameElement = this.getNameElement();
        if (nameElement != null) {
            return nameElement.getTextOffset();
        }
        return super.getTextOffset();
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getNameElement();
    }

    @Override
    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor2, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlExpression qualifier;
        SqlNameElement nameElement = this.getNameElement();
        if (lastParent != nameElement && nameElement instanceof SqlReferenceExpression && PsiTreeUtil.isContextAncestor((PsiElement)this, (PsiElement)lastParent, (boolean)true) && (qualifier = ((SqlReferenceExpression)nameElement).getQualifierExpression()) instanceof SqlReferenceExpression && !SqlImplUtil.processQualifier((SqlReferenceExpression)qualifier, processor2, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor2, state, lastParent, place);
    }

    @Nullable
    public String getComment() {
        if (this.getStub() != null) {
            return null;
        }
        SqlStringLiteralExpression comment = (SqlStringLiteralExpression)PsiTreeUtil.findChildOfType((PsiElement)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COMMENT_CLAUSE), SqlStringLiteralExpression.class);
        return comment == null ? null : String.valueOf(comment.getValue());
    }

    @Nullable
    public SqlReferenceExpression getParentRef() {
        SqlReferenceExpression alteredRef;
        SqlNamedElementStub stub = (SqlNamedElementStub)this.getStub();
        if (this instanceof SqlTargetContextProvider) {
            return ((SqlTargetContextProvider)this).getTargetContextExpression();
        }
        if (stub != null) {
            SqlNamedChildElementStub childStub = (SqlNamedChildElementStub)((Object)ObjectUtils.tryCast((Object)((Object)stub), SqlNamedChildElementStub.class));
            SqlSpecificChildStubElementType type = (SqlSpecificChildStubElementType)((Object)ObjectUtils.tryCast((Object)PsiUtilCore.getElementType((PsiElement)this), SqlSpecificChildStubElementType.class));
            if (childStub != null && type != null) {
                return childStub.getParentReference(type.getParentType());
            }
        }
        if ((alteredRef = this.getParentAlterTargetRef()) != null) {
            return alteredRef;
        }
        if (stub != null) {
            return null;
        }
        SqlOnTargetClauseImpl targetClause = (SqlOnTargetClauseImpl)PsiTreeUtil.getChildOfType((PsiElement)this, SqlOnTargetClauseImpl.class);
        return targetClause != null ? (SqlReferenceExpression)ObjectUtils.tryCast((Object)targetClause.getTargetExpression(), SqlReferenceExpression.class) : null;
    }

    @Nullable
    protected SqlReferenceExpression getParentAlterTargetRef() {
        SqlAlterStatement alterStmt;
        SqlNamedElementStub stub = (SqlNamedElementStub)this.getStub();
        if (stub != null) {
            StubElement ps = stub.getParentStub();
            if (ps != null && ps.getPsi() instanceof SqlAlterInstruction) {
                ps = ps.getParentStub();
            }
            alterStmt = ps == null ? null : (SqlAlterStatement)ObjectUtils.tryCast((Object)ps.getPsi(), SqlAlterStatement.class);
        } else {
            PsiElement parent2 = this.getParent();
            alterStmt = (SqlAlterStatement)ObjectUtils.tryCast((Object)parent2, SqlAlterStatement.class);
            if (alterStmt == null && parent2 instanceof SqlAlterInstruction) {
                alterStmt = (SqlAlterStatement)ObjectUtils.tryCast((Object)parent2.getParent(), SqlAlterStatement.class);
            }
        }
        return alterStmt != null ? alterStmt.getAlterTargetReference() : null;
    }

    @Nullable
    public SqlReferenceElementType getExpectedParentType() {
        IStubElementType type = this.getElementType();
        if (type instanceof SqlSpecificChildStubElementType) {
            return ((SqlSpecificChildStubElementType)type).getParentType();
        }
        return null;
    }

    @Nullable
    public DasObject getDasParentWithoutResolve() {
        return SqlStubbedDefinitionImpl.getParentImpl(this);
    }

    public DasObject getDasParent() {
        PsiElement resolved;
        SqlReferenceExpression ref = this.getParentRef();
        PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
        if (resolved != null) {
            return (DasObject)ObjectUtils.tryCast((Object)resolved, DasObject.class);
        }
        return this.getDasParentWithoutResolve();
    }

    @Nullable
    public static DasObject getParentImpl(@NotNull SqlDefinition def) {
        if (def == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(11);
        }
        Couple<SqlFileImpl.GroupImpl> m = SqlImplUtil.getMirror(def);
        if (m.first != null) {
            return (DasObject)m.first;
        }
        if (m.second != null) {
            return ((SqlFileImpl.GroupImpl)m.second).getDasParent();
        }
        for (PsiElement e = def.getContext(); e != null; e = e.getContext()) {
            if (e instanceof SqlDefinition) {
                m = SqlImplUtil.getMirror((SqlDefinition)e);
                return m.second != null ? (DasObject)m.second : (DasObject)e;
            }
            if (e instanceof DasObject) {
                return (DasObject)e;
            }
            if (e instanceof SqlFileImpl) {
                return ((SqlFileImpl)e).findDbParent(def);
            }
            if (e instanceof PsiFile) break;
        }
        return null;
    }

    @NotNull
    public JBIterable<? extends DasObject> getDasChildren(@Nullable ObjectKind kind) {
        if (this instanceof DasTableChild) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlStubbedDefinitionImpl.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        JBIterable jBIterable = SqlImplUtil.childrenIt((PsiElement)this).filter(PsiObject.class).filter(DasUtil.byKind(kind));
        if (jBIterable == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @Nullable
    public PsiReference getReference() {
        SqlIdentifier nameElement = (SqlIdentifier)ObjectUtils.tryCast((Object)this.getNameElement(), SqlIdentifier.class);
        return SqlImplUtil.getReference((PsiElement)this, nameElement);
    }

    public boolean isNameQuoted() {
        return DbSqlUtilCore.isQuoted(this.getNameElement());
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(14);
        }
        if (state == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(15);
        }
        if (place == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(16);
        }
        if (!super.processDeclarations(processor2, state, lastParent, place)) {
            return false;
        }
        return SqlStubbedDefinitionImpl.ignoreTablesOrViewsIfNeeded(processor2, this, lastParent, place);
    }

    public static boolean ignoreTablesOrViewsIfNeeded(@NotNull SqlScopeProcessor processor2, @NotNull SqlStubbedDefinitionImpl<?> definition, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(17);
        }
        if (definition == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(18);
        }
        if (place == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(19);
        }
        if (definition instanceof SqlStatement && lastParent != null && lastParent.getContext() == definition && SqlImplUtil.forbidGlobalTablesResolve(place)) {
            return SqlImplUtil.ignoreKinds(processor2, ModelConsts.TABLE_OR_VIEW_KINDS);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMultipleKind";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAnyRoot";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParentImpl";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "ignoreTablesOrViewsIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

