/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasScopeProcessor;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.Version;
import com.intellij.lang.ASTNode;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.completion.SqlCompletionScopeProcessor;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.JdbcProcedureCall;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlLabelHolder;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveCache;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlAsteriskSymbol;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlLabelDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlResolveResultImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlReferenceImpl
implements SqlReference {
    public static final Key<Boolean> USE_SQL_DATA_SOURCE_MODEL = Key.create((String)"USE_SQL_DATA_SOURCE_MODEL");
    public static final Key<Boolean> IGNORE_DATA_SOURCES = Key.create((String)"IGNORE_DATA_SOURCES");
    public static final Key<Boolean> LOOK_AT_MINICAT = Key.create((String)"LOOK_AT_MINICAT");
    @NotNull
    private static final ResolveCache.PolyVariantResolver<SqlReferenceImpl> MY_RESOLVER = (reference, incompleteCode) -> {
        PsiFile file = reference.getElement().getContainingFile();
        if (file instanceof SqlFileImpl && reference.getQualifier() == null) {
            SqlResolveCache cache = ((SqlFileImpl)file).getResolveCache();
            ResolveResult[] result2 = cache.getResult((PsiReference)reference);
            if (result2 != null) {
                return result2;
            }
            ResolveResult[] computed = reference.resolveInner();
            cache.cacheResult((PsiReference)reference, computed);
            return computed;
        }
        return reference.resolveInner();
    };
    @NotNull
    private static final ResolveCache.AbstractResolver<SqlReferenceImpl, SqlType> MY_TYPE_RESOLVER = (reference, incompleteCode) -> reference.getSqlTypeInner();
    private final SqlElement myElement;

    public SqlReferenceImpl(@NotNull SqlElement element2) {
        if (element2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(0);
        }
        this.myElement = element2;
    }

    @Nullable
    public SqlExpression getQualifier() {
        return this.getQualifierExpression();
    }

    @Nullable
    public abstract SqlExpression getQualifierExpression();

    @NotNull
    public abstract String getReferenceName();

    public boolean isQuoted() {
        return DbSqlUtilCore.isQuoted((SqlNameElement)ObjectUtils.tryCast((Object)this.getElement(), SqlNameElement.class));
    }

    @NotNull
    public SqlType getSqlType() {
        SqlType type = (SqlType)ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiReference)this, MY_TYPE_RESOLVER, true, false);
        Object object = type == null ? SqlType.UNKNOWN : type;
        if (object == null) {
            SqlReferenceImpl.$$$reportNull$$$0(1);
        }
        return object;
    }

    @NotNull
    public DasType getDasType() {
        DasType dasType = SqlImplUtil.getCacheableDasType((PsiElement)this.myElement, () -> {
            SqlLanguageDialectEx dialect = this.getSqlDialect();
            ResolveResult result2 = this.resolveSingle();
            PsiElement element2 = result2 != null ? result2.getElement() : null;
            DasSymbol symbol = DasSymbolUtil.getSymbol(result2);
            return dialect.getTypeSystem().getDasType(this, element2, symbol);
        });
        if (dasType == null) {
            SqlReferenceImpl.$$$reportNull$$$0(2);
        }
        return dasType;
    }

    public boolean resolveStrict() {
        if (SqlPsiMiscUtil.isDropTarget((PsiElement)this.myElement) || SqlPsiMiscUtil.isJoinUsingColumn((PsiElement)this.myElement)) {
            return true;
        }
        SqlSetAssignment assignment = (SqlSetAssignment)ObjectUtils.tryCast((Object)this.myElement.getParent(), SqlSetAssignment.class);
        return PsiTreeUtil.getParentOfType((PsiElement)assignment, SqlUpdateStatement.class) != null && assignment.getLValue() == this.myElement;
    }

    @NotNull
    private SqlType getSqlTypeInner() {
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        ResolveResult result2 = this.resolveSingle();
        PsiElement element2 = result2 != null ? result2.getElement() : null;
        DasSymbol symbol = DasSymbolUtil.getSymbol(result2);
        SqlType sqlType = dialect.getTypeSystem().getSqlType(this, element2, symbol);
        if (sqlType == null) {
            SqlReferenceImpl.$$$reportNull$$$0(3);
        }
        return sqlType;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        SqlExpression qual = this.getQualifier();
        if (SqlImplUtil.isAsteriskRef((PsiElement)this.myElement)) {
            PsiElement qualifier = qual instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qual).resolve() : null;
            DasSymbol symbol = DasSymbolUtil.getInlineSymbol(this);
            SqlType sqlType = this.getSqlDialect().getTypeSystem().getSqlType(this, (PsiElement)this.myElement, symbol);
            Object immediateTarget = this.myElement;
            if (sqlType instanceof SqlTableType) {
                PsiElement context = ((SqlTableType)sqlType).getTypeElement();
                if (context == null) {
                    context = this.myElement;
                }
                immediateTarget = new SqlAsteriskSymbol(context, (SqlTableType)sqlType);
            }
            SqlResolveResult[] sqlResolveResultArray = SqlResolveResultImpl.createSingleSqlResults(qualifier, (PsiElement)immediateTarget, (PsiElement)this.myElement, symbol);
            if (sqlResolveResultArray == null) {
                SqlReferenceImpl.$$$reportNull$$$0(4);
            }
            return sqlResolveResultArray;
        }
        PsiElement parent2 = this.myElement.getParent();
        if (SqlPsiElementFactory.isROFile(parent2)) {
            parent2 = parent2.getContext();
        }
        if (parent2 instanceof SqlDefinition && ((SqlDefinition)parent2).getNameElement() == this.myElement) {
            SqlResolveResult[] sqlResolveResultArray = SqlResolveResultImpl.createSingleSqlResults(null, parent2, parent2, (DasSymbol)((SqlDefinition)parent2));
            if (sqlResolveResultArray == null) {
                SqlReferenceImpl.$$$reportNull$$$0(5);
            }
            return sqlResolveResultArray;
        }
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, incompleteCode);
        if (resolveResultArray == null) {
            SqlReferenceImpl.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    public ResolveResult resolveSingle() {
        ResolveResult[] results2;
        for (ResolveResult result2 : results2 = this.multiResolve(false)) {
            if (SqlReferenceImpl.isFakeGroup(result2) || SqlImplUtil.isMarkedUnresolved(result2)) continue;
            return result2;
        }
        return results2.length == 0 ? null : results2[0];
    }

    @Nullable
    public PsiElement resolveImmediate() {
        ResolveResult result2 = this.resolveSingle();
        PsiElement immediateTarget = result2 instanceof SqlResolveResult ? ((SqlResolveResult)result2).getImmediateTarget() : null;
        return immediateTarget != null ? immediateTarget : this.resolve();
    }

    private static boolean isFakeGroup(ResolveResult res2) {
        return SqlFileImpl.isFakeGroup(res2.getElement());
    }

    public PsiElement resolve() {
        ResolveResult result2 = this.resolveSingle();
        return result2 == null ? null : result2.getElement();
    }

    @NotNull
    public Collection<? extends Symbol> resolveReference() {
        List list = SqlImplUtil.resolveVisible((PsiPolyVariantReference)this).map(resolveResult -> PsiSymbolService.getInstance().asSymbol(Objects.requireNonNull(resolveResult.getElement()))).toList();
        if (list == null) {
            SqlReferenceImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public PsiElement getElement() {
        SqlElement sqlElement = this.myElement;
        if (sqlElement == null) {
            SqlReferenceImpl.$$$reportNull$$$0(8);
        }
        return sqlElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            SqlReferenceImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(10);
        }
        if (this.isReferenceTo(element2)) {
            return this.myElement;
        }
        if (element2 instanceof PsiNamedElement) {
            return this.handleElementRename(((PsiNamedElement)element2).getName());
        }
        return this.myElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement e1) {
        if (e1 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(11);
        }
        if (SqlReferenceImpl.isEmptyReferenceTo((PsiElement)this.myElement, e1)) {
            return true;
        }
        SqlReferenceElementType refType = this.getReferenceElementType();
        for (ResolveResult result2 : this.multiResolve(false)) {
            SqlNameElement element2;
            PsiElement e2 = result2.getElement();
            if (this.myElement.getManager().areElementsEquivalent(e1, e2)) {
                return true;
            }
            if (refType != SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE || !(e2 instanceof SqlDefinition) || (element2 = ((SqlDefinition)e2).getNameElement()) == null || !SqlReferenceImpl.isEmptyReferenceTo((PsiElement)element2, e1)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmptyReferenceTo(PsiElement element2, PsiElement e1) {
        PsiElement lastChild;
        PsiElement psiElement = lastChild = element2 instanceof SqlReferenceExpression ? element2.getLastChild() : null;
        if (element2.getFirstChild() == lastChild && lastChild instanceof SqlReferenceExpression) {
            SqlReferenceExpression refExpression = (SqlReferenceExpression)lastChild;
            return refExpression.getReference().isReferenceTo(e1);
        }
        return false;
    }

    @NotNull
    public SqlReferenceElementType getReferenceElementType() {
        ASTNode astNode = this.myElement.getNode();
        IElementType elementType = astNode != null ? astNode.getElementType() : null;
        SqlReferenceElementType sqlReferenceElementType = elementType instanceof SqlReferenceElementType ? (SqlReferenceElementType)elementType : SqlCompositeElementTypes.SQL_REFERENCE;
        if (sqlReferenceElementType == null) {
            SqlReferenceImpl.$$$reportNull$$$0(12);
        }
        return sqlReferenceElementType;
    }

    @NotNull
    public SqlScopeProcessor createResolveProcessor(final @NotNull PairConsumer<? super DasSymbol, ? super ResolveState> consumer2) {
        if (consumer2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(13);
        }
        String referenceName = this.getReferenceName();
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        List<DbDataSource> dataSources = SqlImplUtil.getDataSources((PsiElement)SqlImplUtil.getTopLevelSqlFile(this.myElement.getContainingFile()));
        boolean dontCheckName = StringUtil.isEmpty((String)referenceName) && this.getQualifierExpression() != null;
        final NameChecker nameChecker = dontCheckName ? null : new NameChecker(referenceName, this.isQuoted(), SqlImplUtil.getCasingProvider(dialect, dataSources), dialect);
        return new SqlScopeProcessorBase(referenceName, dialect, dataSources, (PsiElement)this.myElement){
            boolean isEmpty;
            {
                super(referenceName, dialect, dataSources, place);
                this.isEmpty = true;
            }

            public boolean isResultEmpty() {
                return this.isEmpty;
            }

            public boolean executeTarget(@NotNull DasSymbol symbol, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (nameChecker != null && !(SqlReferenceImpl.this.myElement instanceof SqlPositionalReference) && !nameChecker.checkName(symbol, forcedCaseSens)) {
                    return true;
                }
                if (!this.checkType(symbol, sqlType)) {
                    return true;
                }
                if (!DasSymbolUtil.isUnresolved(symbol)) {
                    this.isEmpty = false;
                }
                consumer2.consume((Object)symbol, (Object)state);
                return sqlType == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "symbol";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/psi/impl/SqlReferenceImpl$1";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private SqlResolveResult findConflictingResult(@NotNull OrderedSet<SqlResolveResult> result2, @NotNull PsiElement newTarget) {
        if (result2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(14);
        }
        if (newTarget == null) {
            SqlReferenceImpl.$$$reportNull$$$0(15);
        }
        for (SqlResolveResult resolveResult : result2) {
            if (!SqlImplUtil.isMarkedUnresolved((ResolveResult)resolveResult)) continue;
            return resolveResult;
        }
        if (newTarget instanceof SqlParameterDefinition) {
            return (SqlResolveResult)ContainerUtil.find(result2, r -> r.getElement() instanceof DasColumn);
        }
        if (newTarget instanceof DasColumn) {
            Dbms dbms = this.getSqlDialect().getDbms();
            return dbms.isSnowflake() || dbms.isRedshift() ? (SqlResolveResult)ContainerUtil.find(result2, r -> r.getElement() instanceof SqlAsExpression) : null;
        }
        return null;
    }

    @NotNull
    private ResolveConflictPolicy getPreference(@NotNull SqlResolveResult currentResult, @NotNull SqlResolveResult newResult) {
        if (currentResult == null) {
            SqlReferenceImpl.$$$reportNull$$$0(16);
        }
        if (newResult == null) {
            SqlReferenceImpl.$$$reportNull$$$0(17);
        }
        if (SqlImplUtil.isMarkedUnresolved((ResolveResult)currentResult)) {
            ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_EXISTING;
            if (resolveConflictPolicy == null) {
                SqlReferenceImpl.$$$reportNull$$$0(18);
            }
            return resolveConflictPolicy;
        }
        if (SqlImplUtil.isMarkedUnresolved((ResolveResult)newResult)) {
            ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_NEW;
            if (resolveConflictPolicy == null) {
                SqlReferenceImpl.$$$reportNull$$$0(19);
            }
            return resolveConflictPolicy;
        }
        Dbms dbms = this.getSqlDialect().getDbms();
        PsiElement newPsi = newResult.getElement();
        PsiElement currentPsi = currentResult.getElement();
        if (currentPsi instanceof DasColumn && newPsi instanceof SqlParameterDefinition) {
            if (dbms.isOracle() || dbms.isHsqldb() || dbms.isDb2()) {
                ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.HIDE_NEW;
                if (resolveConflictPolicy == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(20);
                }
                return resolveConflictPolicy;
            }
            if (dbms.isMysql() || dbms.isSnowflake() || dbms.isGreenplum()) {
                ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_EXISTING;
                if (resolveConflictPolicy == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(21);
                }
                return resolveConflictPolicy;
            }
            if (dbms == Dbms.POSTGRES) {
                SqlRoutineDefinition routine = (SqlRoutineDefinition)PsiTreeUtil.getParentOfType((PsiElement)newPsi, SqlRoutineDefinition.class);
                if (routine == null) {
                    ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.KEEP_BOTH;
                    if (resolveConflictPolicy == null) {
                        SqlReferenceImpl.$$$reportNull$$$0(22);
                    }
                    return resolveConflictPolicy;
                }
                SqlElement statement = (SqlElement)routine.getBody().first();
                if (statement == null) {
                    ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.KEEP_BOTH;
                    if (resolveConflictPolicy == null) {
                        SqlReferenceImpl.$$$reportNull$$$0(23);
                    }
                    return resolveConflictPolicy;
                }
                for (PsiElement sibling : SqlImplUtil.revSiblings((PsiElement)statement)) {
                    String valueText;
                    PsiElement kind;
                    PsiElement mark2;
                    if (!(sibling instanceof SqlClause) || PsiUtilCore.getElementType((PsiElement)(mark2 = sibling.getFirstChild())) != SqlCommonTokens.SQL_HASHMARK || (kind = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)mark2)) == null || !"variable_conflict".equalsIgnoreCase(kind.getText())) continue;
                    PsiElement value2 = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)kind);
                    String string = valueText = value2 != null ? value2.getText() : null;
                    if ("use_column".equalsIgnoreCase(valueText)) {
                        ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_NEW;
                        if (resolveConflictPolicy == null) {
                            SqlReferenceImpl.$$$reportNull$$$0(24);
                        }
                        return resolveConflictPolicy;
                    }
                    if (!"use_variable".equalsIgnoreCase(valueText)) continue;
                    ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_EXISTING;
                    if (resolveConflictPolicy == null) {
                        SqlReferenceImpl.$$$reportNull$$$0(25);
                    }
                    return resolveConflictPolicy;
                }
            }
        }
        if ((dbms.isSnowflake() || dbms.isRedshift()) && currentPsi instanceof SqlAsExpression && newPsi instanceof DasColumn) {
            ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_EXISTING;
            if (resolveConflictPolicy == null) {
                SqlReferenceImpl.$$$reportNull$$$0(26);
            }
            return resolveConflictPolicy;
        }
        ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.KEEP_BOTH;
        if (resolveConflictPolicy == null) {
            SqlReferenceImpl.$$$reportNull$$$0(27);
        }
        return resolveConflictPolicy;
    }

    private ResolveResult[] resolveInner() {
        OrderedSet result2 = new OrderedSet();
        SqlScopeProcessor processor2 = this.createResolveProcessor((PairConsumer<? super DasSymbol, ? super ResolveState>)((PairConsumer)(symbol, state) -> {
            PsiElement psi = DasSymbolUtil.getSinglePsiSource(symbol);
            if (psi == null) {
                psi = this.myElement;
            }
            SqlResolveResultImpl newResult = new SqlResolveResultImpl(SqlImplUtil.getQualifier(state), SqlImplUtil.getImmediateTarget(state), SqlImplUtil.getImmediateQualifier(state), psi, (DasSymbol)symbol);
            SqlResolveResult currentResult = null;
            ResolveConflictPolicy preference = this.getSqlDialect().shouldHide((DasSymbol)symbol, (PsiElement)this.myElement) ? ResolveConflictPolicy.HIDE_NEW : ((currentResult = this.findConflictingResult((OrderedSet<SqlResolveResult>)result2, psi)) != null ? this.getPreference(currentResult, newResult) : ResolveConflictPolicy.KEEP_BOTH);
            switch (preference) {
                case DROP_EXISTING: {
                    result2.remove((Object)currentResult);
                    result2.add((Object)newResult);
                    break;
                }
                case DROP_NEW: {
                    break;
                }
                case HIDE_NEW: {
                    result2.add((Object)newResult.hide());
                    break;
                }
                case KEEP_BOTH: {
                    result2.add((Object)newResult);
                }
            }
        }));
        if (SqlImplUtil.isOracleDbLinkedTableRef(this.myElement) || !this.initExpectedTargetTypes(processor2)) {
            result2.add((Object)new SqlResolveResultImpl(null, (PsiElement)this.myElement, null, (PsiElement)this.myElement, DasSymbolUtil.getInlineSymbol(this)));
        } else {
            this.processResolveVariants(processor2);
        }
        if (this.myElement instanceof SqlPositionalReference) {
            return SqlResolveResultImpl.createSqlResults((Collection<SqlResolveResult>)result2);
        }
        if (processor2.isResultEmpty()) {
            processor2.getDialect().processReservedEntitiesWithType(processor2.getReferenceName(), (PsiElement)this.myElement, true, processor2);
        }
        if (processor2.isResultEmpty()) {
            SqlElement setLValue;
            PsiElement parent2 = this.myElement.getParent();
            SqlElement sqlElement = setLValue = parent2 instanceof SqlSetAssignment ? ((SqlSetAssignment)parent2).getLValue() : null;
            if (setLValue instanceof SqlReferenceExpression && ((SqlReferenceExpression)setLValue).getReferenceElementType() == SqlCompositeElementTypes.SQL_SYSTEM_REFERENCE) {
                return SqlResolveResultImpl.createSingleSqlResults(null, this.getElement(), this.getElement(), DasSymbolUtil.getInlineSymbol(this));
            }
        }
        return SqlResolveResultImpl.createSqlResults((Collection<SqlResolveResult>)result2);
    }

    public boolean isSoft() {
        return false;
    }

    public boolean processResolveVariants(@NotNull SqlScopeProcessor processor2) {
        if (processor2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(28);
        }
        ResolveState state = ResolveState.initial();
        if (this.getReferenceElementType() == SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE) {
            return this.processLabelBackRef(processor2, state);
        }
        SqlExpression qualifierExpression = this.getQualifierExpression();
        if (qualifierExpression == null) {
            return this.processUnqualifiedResolveVariants(processor2, state);
        }
        if (qualifierExpression instanceof SqlReferenceExpression && !SqlImplUtil.processQualifier((SqlReferenceExpression)qualifierExpression, processor2, state, (PsiElement)this.myElement)) {
            return false;
        }
        if (!processor2.getDialect().processQualifiedResolve(processor2, state, (SqlReference)this, qualifierExpression)) {
            return false;
        }
        if (!SqlImplUtil.processDeclarationsInType(qualifierExpression, processor2, state, (PsiElement)this.myElement)) {
            return false;
        }
        if (this.myElement.getParent() instanceof SqlFunctionCallExpression && processor2.isResultEmpty()) {
            return this.processFunctionVariants(processor2);
        }
        return true;
    }

    protected boolean processLabelBackRef(@NotNull SqlScopeProcessor processor2, ResolveState state) {
        SqlElement labeled;
        if (processor2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(29);
        }
        if ((labeled = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, (Class[])new Class[]{SqlProcedureDefinitionImpl.class, SqlStatement.class})) == null) {
            return true;
        }
        if (labeled instanceof DasSymbol) {
            return processor2.execute((DasSymbol)labeled, state);
        }
        for (SqlLabelDefinitionImpl def : SqlImplUtil.sqlChildren((PsiElement)labeled).takeWhile(c2 -> !(c2 instanceof SqlStatement)).filter(SqlLabelDefinitionImpl.class)) {
            if (processor2.execute((DasSymbol)((Object)def), state)) continue;
            return false;
        }
        DasSymbol parentDef = (DasSymbol)ObjectUtils.tryCast((Object)labeled.getParent(), DasSymbol.class);
        return parentDef == null || processor2.execute(parentDef, state);
    }

    public Set<ObjectKind> getExpectedTargetTypes(boolean forResolve, boolean strict) {
        PsiFile containingFile = this.myElement.getContainingFile();
        int maxLev = forResolve && containingFile == containingFile.getOriginalFile() ? 0 : -1;
        return this.getExpectedTargetTypes(forResolve, SqlImplUtil.getSqlDialectSafe((PsiElement)containingFile), -1, maxLev, strict);
    }

    public boolean initExpectedTargetTypes(@NotNull SqlScopeProcessor processor2) {
        if (processor2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(30);
        }
        boolean strict = this.resolveStrict();
        Set<ObjectKind> set = this.getExpectedTargetTypes(processor2.getReferenceName() != null, strict);
        if (this.shouldNotBeChecked(set)) {
            return false;
        }
        processor2.setExpectedKinds(set);
        processor2.setStrict(strict);
        return true;
    }

    @NotNull
    public Set<ObjectKind> getExpectedTypes(boolean resolve) {
        PsiFile containingFile = this.myElement.getContainingFile();
        int maxLev = resolve && containingFile == containingFile.getOriginalFile() ? 0 : -1;
        return this.getExpectedTargetTypes(resolve, this.getSqlDialect(), -1, maxLev, this.resolveStrict());
    }

    private boolean shouldNotBeChecked(@NotNull Set<ObjectKind> expectedTypes) {
        Dbms dbms;
        if (expectedTypes == null) {
            SqlReferenceImpl.$$$reportNull$$$0(31);
        }
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        PsiElement parent2 = this.myElement.getParent();
        if (expectedTypes.contains(ObjectKind.ROUTINE) && parent2 != null && parent2.getParent() instanceof JdbcProcedureCall) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.OBJECT_TYPE) && parent2 instanceof SqlTypeElement && this.getQualifierExpression() == null && PsiTreeUtil.getDeepestFirst((PsiElement)this.myElement).getNode().getElementType() == SqlTokens.SQL_IDENT_DELIMITED && ((dbms = dialect.getDbms()).isTransactSql() || dbms.isPostgres())) {
            String name = this.getReferenceName();
            return !dialect.shouldQuotedTypeReferenceBeChecked(name);
        }
        return false;
    }

    @Nullable
    private SqlLanguageDialectEx.BuiltinFunctions getGlobalBuiltins(SqlLanguageDialect dialect) {
        SqlLanguageDialectEx.BuiltinFunctions builtins = dialect instanceof SqlLanguageDialectEx ? ((SqlLanguageDialectEx)dialect).getSupportedFunctions() : null;
        return builtins;
    }

    public SqlLanguageDialectEx.BuiltinFunctions getRelevantBuiltins(SqlLanguageDialect dialect) {
        boolean isInstance;
        String typeName;
        SqlLanguageDialectEx.BuiltinFunctions builtins = this.getGlobalBuiltins(dialect);
        SqlExpression qualifier = this.getQualifier();
        if (qualifier != null) {
            DasSymbol symbol;
            SqlType qualifyingType = qualifier.getSqlType();
            typeName = qualifyingType == SqlType.UNKNOWN && qualifier instanceof SqlReferenceExpression ? ((symbol = ((SqlReferenceExpression)qualifier).resolveSymbol()) != null ? symbol.getKind().name() : null) : qualifyingType.getDisplayName();
            isInstance = true;
        } else {
            SqlType qualifyingType = SqlImplUtil.getScopingType(this.getElement());
            typeName = qualifyingType != null ? qualifyingType.getDisplayName() : null;
            isInstance = false;
        }
        if (builtins != null && typeName != null) {
            builtins = builtins.typeMethods(typeName, isInstance);
        }
        return builtins;
    }

    private boolean processFunctionVariants(@NotNull SqlScopeProcessor processor2) {
        if (processor2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(32);
        }
        SqlLanguageDialect dialect = processor2.getDialect();
        if (processor2.getReferenceName() == null || !this.shouldProcessFunctionVariants()) {
            return true;
        }
        SqlLanguageDialectEx.BuiltinFunctions builtins = this.getRelevantBuiltins(dialect);
        SqlFunctionDefinition builtin = null;
        if (builtins != null) {
            builtin = builtins.get(this.getReferenceName());
        } else if (this.getQualifier() != null) {
            SqlLanguageDialectEx.BuiltinFunctions globalBuiltins = this.getGlobalBuiltins(dialect);
            SqlFunctionDefinition candidate = globalBuiltins != null ? globalBuiltins.get(this.getReferenceName()) : null;
            SqlFunctionDefinition sqlFunctionDefinition = builtin = candidate != null && candidate.getPostfixType() != null ? candidate : null;
        }
        return builtin == null || !SqlImplUtil.hasLocationOf(builtin, ((SqlLanguageDialectEx)dialect).getExpectedFunctionLocations((SqlExpression)ObjectUtils.tryCast((Object)this.myElement, SqlExpression.class))) || processor2.executeTarget((DasSymbol)((Object)builtin), null, dialect.getDbms().isMysql() ? Boolean.valueOf(false) : null, ResolveState.initial());
    }

    private SqlLanguageDialectEx getSqlDialect() {
        return SqlImplUtil.getSqlDialectSafe((PsiElement)this.myElement);
    }

    protected boolean shouldProcessFunctionVariants() {
        return false;
    }

    public boolean processUnqualifiedResolveVariants(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state) {
        if (processor2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(33);
        }
        if (state == null) {
            SqlReferenceImpl.$$$reportNull$$$0(34);
        }
        if (!this.myElement.isValid()) {
            return true;
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        PsiFile topContainingFile = SqlImplUtil.getTopLevelSqlFile(containingFile);
        PsiFile topOriginalFile = topContainingFile.getOriginalFile();
        if (!processor2.getDialect().processUnqualifiedResolve(processor2, state, (PsiReference)this)) {
            return false;
        }
        PsiElement maxScope = SqlImplUtil.getResolveScope(topContainingFile);
        boolean callableExpected = processor2.isExpected(ObjectKind.ROUTINE);
        if (callableExpected && !this.processFunctionVariants(processor2)) {
            return false;
        }
        if (!SqlImplUtil.treeWalkUp((DasScopeProcessor)processor2, (PsiElement)this.myElement, maxScope, state)) {
            return false;
        }
        ObjectKind targetType = this.getReferenceElementType().getTargetKind();
        if (targetType == SqlDbElementType.LABEL && !processor2.getDialect().getDbms().isMysql() && !this.processLabels(processor2)) {
            return false;
        }
        if (targetType == ObjectKind.VARIABLE || targetType == SqlDbElementType.LABEL) {
            return true;
        }
        if (!(callableExpected || processor2.getReferenceName() != null && !(this.myElement.getParent() instanceof SqlFunctionCallExpression) || this.processFunctionVariants(processor2))) {
            return false;
        }
        if (Boolean.TRUE.equals(IGNORE_DATA_SOURCES.get((UserDataHolder)topOriginalFile))) {
            PsiElement context = topOriginalFile.getContext();
            if (context instanceof DbElement) {
                DbDataSource dataSource2 = ((DbElement)context).getDataSource();
                return this.processUnqualifiedResolveInDataSource(processor2, state, topContainingFile, null, false, dataSource2);
            }
            return true;
        }
        SqlImportState importChecker = topOriginalFile instanceof SqlFile ? SqlDialectImplUtilCore.getImportCheckerAt((SqlFile)topOriginalFile, (PsiElement)this.myElement) : null;
        boolean includeAllTopLevelNamespaces = processor2 instanceof SqlCompletionScopeProcessor && ((SqlCompletionScopeProcessor)processor2).shouldIncludeAllNamespaces();
        HashSet<String> visited = new HashSet<String>();
        LinkedList queue = new LinkedList(processor2.getDataSources());
        boolean resolvesToLocalDataSource = false;
        while (!queue.isEmpty()) {
            DbDataSource dataSource3 = (DbDataSource)queue.remove(0);
            if (!visited.add(dataSource3.getUniqueId()) || importChecker != null && !importChecker.isImported(dataSource3.getDelegate(), null)) continue;
            resolvesToLocalDataSource |= DbImplUtilCore.getMaybeLocalDataSource(dataSource3) != null;
            if (!this.processUnqualifiedResolveInDataSource(processor2, state, topContainingFile, importChecker, includeAllTopLevelNamespaces, dataSource3)) {
                return false;
            }
            DatabaseSystem d2 = dataSource3.getDelegate();
            if (!(d2 instanceof SqlDataSource)) continue;
            ContainerUtil.addIfNotNull(queue, (Object)((SqlDataSource)d2).getParentDataSource());
        }
        return resolvesToLocalDataSource && (!Boolean.TRUE.equals((Boolean)LOOK_AT_MINICAT.get((UserDataHolder)this.myElement.getContainingFile(), (Object)false) != false || processor2.getDialect().getAdditionalExpandCondition(processor2, (PsiElement)this.myElement) != null) || !processor2.isResultEmpty()) || this.processMiniCatalog(processor2, state, topContainingFile, importChecker, includeAllTopLevelNamespaces);
    }

    private boolean processUnqualifiedResolveInDataSource(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, PsiFile topContainingFile, SqlImportState importChecker, boolean includeAllTopLevelNamespaces, DbDataSource dataSource2) {
        DatabaseSystem d2;
        if (processor2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(35);
        }
        if (state == null) {
            SqlReferenceImpl.$$$reportNull$$$0(36);
        }
        if ((d2 = dataSource2.getDelegate()) instanceof SqlDataSource && !((Boolean)USE_SQL_DATA_SOURCE_MODEL.get((UserDataHolder)processor2.getPlace(), (Object)false)).booleanValue()) {
            SqlDataSource sqlDataSource = (SqlDataSource)d2;
            for (SqlFile file : sqlDataSource.getSqlFiles()) {
                if (file.processDeclarations(processor2, state, (PsiElement)topContainingFile, (PsiElement)this.myElement)) continue;
                return false;
            }
        } else {
            Condition<DasObject> condition;
            Condition<DasObject> condition2 = condition = importChecker != null ? SqlFileImpl.importedCondition(importChecker, d2, includeAllTopLevelNamespaces) : Conditions.alwaysTrue();
            if (!SqlFileImpl.processDeclarationsImpl(processor2, state, dataSource2, condition, true, (PsiElement)this.myElement)) {
                return false;
            }
        }
        return true;
    }

    public boolean processMiniCatalog(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, PsiFile topContainingFile, SqlImportState importChecker, boolean includeAllTopLevelNamespaces) {
        if (processor2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(37);
        }
        if (state == null) {
            SqlReferenceImpl.$$$reportNull$$$0(38);
        }
        Condition expandCondition = importChecker != null ? SqlFileImpl.importedCondition(importChecker, null, includeAllTopLevelNamespaces) : Conditions.alwaysTrue();
        Condition dialectCondition = processor2.getDialect().getAdditionalExpandCondition(processor2, (PsiElement)this.myElement);
        if (dialectCondition != null) {
            expandCondition = Conditions.or(expandCondition, (Condition)dialectCondition);
        }
        Project project = topContainingFile.getProject();
        Function mapper = o -> DasSymbolUtil.wrapObjectToSymbol(o, project);
        Dbms dbms = processor2.getDialect().getDbms();
        if (processor2.getReferenceName() != null) {
            ModelNameIndex miniCatIndex = DataSourceSnapshotManager.INSTANCE.getSnapshotModelIndex(dbms, Version.INFINITY);
            if (miniCatIndex == null) {
                return true;
            }
            return SqlFileImpl.processNameIndex(processor2, state, miniCatIndex, (Condition<? super DasObject>)expandCondition, (Function<? super DasObject, ? extends DasSymbol>)mapper);
        }
        BasicModel miniCatModel = DataSourceSnapshotManager.INSTANCE.getSnapshotModel(dbms, Version.INFINITY);
        if (miniCatModel == null) {
            return true;
        }
        JBIterable candidates2 = ((JBTreeTraverser)miniCatModel.traverser().expand(expandCondition)).bfsTraversal();
        return SqlFileImpl.processCandidateObjects(processor2, state, (JBIterable<DasObject>)candidates2, (Function<? super DasObject, ? extends DasSymbol>)mapper);
    }

    private boolean processLabels(@NotNull SqlScopeProcessor processor2) {
        SqlLabelHolder block;
        if (processor2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(39);
        }
        if ((block = (SqlLabelHolder)PsiTreeUtil.getTopmostParentOfType((PsiElement)this.myElement, SqlLabelHolder.class)) != null) {
            for (SqlDefinition label : block.getLabels()) {
                if (processor2.execute((DasSymbol)label, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Set<ObjectKind> getExpectedTargetTypes(boolean resolve, SqlLanguageDialectEx dialect, int minLev, int maxLev, boolean strict) {
        THashSet expectedStrict = this.getExpectedTargetTypesStrict(dialect);
        boolean addCallable = false;
        PsiElement parent2 = this.myElement.getParent();
        Dbms dbms = dialect.getDbms();
        if (!strict && dbms.isPostgres() && parent2 instanceof SqlExpressionList && parent2.getParent() instanceof SqlFunctionCallExpression && expectedStrict.contains(ObjectKind.COLUMN)) {
            expectedStrict = SqlReferenceImpl.makeMutable(expectedStrict);
            expectedStrict.add(ObjectKind.TABLE);
        }
        if (!resolve && !strict && (expectedStrict.contains(ObjectKind.COLUMN) || expectedStrict.contains(ObjectKind.TABLE))) {
            PsiElement info = this.myElement.getNextSibling();
            while (info instanceof PsiWhiteSpace || info instanceof PsiComment) {
                info = info.getNextSibling();
            }
            boolean bl = addCallable = SqlInfoElementType.getValue(info, SqlFunctionDefinition.ReferenceParameter.class) == null;
        }
        if (maxLev == 0) {
            if (addCallable) {
                expectedStrict = SqlReferenceImpl.makeMutable(expectedStrict);
                expectedStrict.add((ObjectKind)ObjectKind.ROUTINE);
            }
        } else {
            THashSet parents2 = new THashSet();
            if (addCallable) {
                parents2.add((Object)ObjectKind.ROUTINE);
            }
            for (ObjectKind type : expectedStrict) {
                this.getParentTypes(dialect, type, minLev, maxLev, (Set<ObjectKind>)parents2);
            }
            expectedStrict = parents2;
        }
        THashSet tHashSet = expectedStrict;
        if (tHashSet == null) {
            SqlReferenceImpl.$$$reportNull$$$0(40);
        }
        return tHashSet;
    }

    @NotNull
    private static Set<ObjectKind> makeMutable(Set<ObjectKind> expectedStrict) {
        if (!(expectedStrict instanceof THashSet)) {
            THashSet result2 = new THashSet();
            result2.addAll(expectedStrict);
            expectedStrict = result2;
        }
        THashSet tHashSet = expectedStrict;
        if (tHashSet == null) {
            SqlReferenceImpl.$$$reportNull$$$0(41);
        }
        return tHashSet;
    }

    private int getParentTypes(@NotNull SqlLanguageDialectEx dialect, ObjectKind type, int minLevel, int maxLevel, Set<ObjectKind> result2) {
        if (dialect == null) {
            SqlReferenceImpl.$$$reportNull$$$0(42);
        }
        Set<ObjectKind> ignored = dialect.getIgnoredParentKinds((PsiElement)this.myElement, this.getReferenceElementType().getTargetKind());
        return SqlImplUtil.getParentTypes(dialect, type, minLevel, maxLevel, ignored, result2);
    }

    @NotNull
    public Set<ObjectKind> getExpectedTargetTypesStrict(@NotNull SqlLanguageDialectEx dialect) {
        ObjectKind realLastRefType;
        ObjectKind thisTargetType;
        if (dialect == null) {
            SqlReferenceImpl.$$$reportNull$$$0(43);
        }
        if ((thisTargetType = this.getReferenceElementType().getTargetKind()) != SqlDbElementType.ANY) {
            Set set = JBIterable.of((Object)thisTargetType).append(dialect.getExtraKindsStrict(this)).toSet();
            if (set == null) {
                SqlReferenceImpl.$$$reportNull$$$0(44);
            }
            return set;
        }
        SqlElement lastRefElement = this.myElement;
        SqlReferenceImpl lastRef = this;
        int inParentLevel = 0;
        int starCount = 0;
        boolean linkReached = false;
        PsiElement parent2 = this.myElement.getParent();
        while (parent2 instanceof SqlElement && parent2.getReference() instanceof SqlReferenceImpl) {
            lastRefElement = (SqlElement)parent2;
            lastRef = (SqlReferenceImpl)parent2.getReference();
            if (!linkReached) {
                ++inParentLevel;
                if (Objects.equals("*", lastRef.getReferenceName())) {
                    ++starCount;
                }
            }
            linkReached |= TreeUtil.findSibling((ASTNode)lastRefElement.getNode(), (IElementType)SqlCompositeElementTypes.SQL_GENERIC_AT_REFERENCE) != null;
            parent2 = parent2.getParent();
        }
        ObjectKind lastRefType = lastRef != this ? lastRef.getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
        ObjectKind objectKind = realLastRefType = lastRefType != SqlDbElementType.ANY || !(parent2 instanceof SqlCompositeElementImpl) ? lastRefType : ((SqlCompositeElementImpl)parent2).getExpectedReferenceTargetType(lastRefElement);
        if (lastRefType != SqlDbElementType.ANY) {
            THashSet curType = new THashSet();
            this.getParentTypes(dialect, realLastRefType, inParentLevel - starCount, inParentLevel, (Set<ObjectKind>)curType);
            for (ObjectKind extraKind : dialect.getExtraKindsStrict(lastRef)) {
                this.getParentTypes(dialect, extraKind, inParentLevel - starCount, inParentLevel, (Set<ObjectKind>)curType);
            }
            THashSet tHashSet = curType;
            if (tHashSet == null) {
                SqlReferenceImpl.$$$reportNull$$$0(45);
            }
            return tHashSet;
        }
        Set<ObjectKind> set = Collections.singleton(SqlDbElementType.ANY);
        if (set == null) {
            SqlReferenceImpl.$$$reportNull$$$0(46);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlReferenceImpl that = (SqlReferenceImpl)o;
        return this.myElement.equals(that.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlReferenceImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTarget";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentResult";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newResult";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlTypeInner";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReference";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElementType";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreference";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTargetTypes";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "makeMutable";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTargetTypesStrict";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createResolveProcessor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findConflictingResult";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPreference";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processResolveVariants";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processLabelBackRef";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "initExpectedTargetTypes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "shouldNotBeChecked";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processFunctionVariants";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolveVariants";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolveInDataSource";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processMiniCatalog";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processLabels";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getParentTypes";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTargetTypesStrict";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ResolveConflictPolicy {
        DROP_EXISTING,
        DROP_NEW,
        HIDE_NEW,
        KEEP_BOTH;

    }
}

