/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlLimitClause;
import com.intellij.sql.psi.SqlOffsetClause;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQualifyClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQueryExpressionImpl
extends SqlExpressionImpl
implements SqlQueryExpression {
    public SqlQueryExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlQueryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlQueryExpression((SqlQueryExpression)this);
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        SqlWithClause withClause;
        if (processor2 == null) {
            SqlQueryExpressionImpl.$$$reportNull$$$0(1);
        }
        if (state == null) {
            SqlQueryExpressionImpl.$$$reportNull$$$0(2);
        }
        if (place == null) {
            SqlQueryExpressionImpl.$$$reportNull$$$0(3);
        }
        SqlSelectClause selectClause = this.getSelectClause();
        SqlTableExpression tableExpression = this.getTableExpression();
        if (selectClause != null && lastParent != selectClause && !(lastParent instanceof SqlOrderByClause)) {
            SqlClause clause;
            boolean processSelect = tableExpression == null || lastParent != tableExpression;
            SqlClause sqlClause = clause = processSelect ? null : (SqlClause)ObjectUtils.tryCast((Object)SqlQueryExpressionImpl.findAncestorChild((PsiElement)tableExpression, place), SqlClause.class);
            if (clause != null) {
                Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)this).getDbms();
                if (clause instanceof SqlWhereClause) {
                    processSelect = dbms.isMongo() || dbms.isSqlite() || dbms == Dbms.SNOWFLAKE || dbms.isRedshift();
                } else if (clause instanceof SqlHavingClause) {
                    processSelect = dbms.isMongo() || dbms.isSqlite() || dbms == Dbms.SNOWFLAKE || dbms.isMysql() || dbms.isH2() || dbms.isRedshift();
                } else if (clause instanceof SqlGroupByClause) {
                    processSelect = dbms.isMongo() || dbms.isSqlite() || dbms == Dbms.SNOWFLAKE || dbms.isMysql() || dbms.isPostgres() || dbms.isH2() || dbms.isCockroach();
                } else if (clause instanceof SqlQualifyClause && dbms.isSnowflake()) {
                    processSelect = true;
                }
            }
            if (processSelect && !selectClause.processDeclarations(processor2, state, lastParent, place)) {
                return false;
            }
        }
        if (tableExpression != null && lastParent != tableExpression && !tableExpression.processDeclarations(processor2, state, lastParent, place)) {
            return false;
        }
        for (SqlExtraDeclarationsProvider child : SqlImplUtil.childrenTreeIt((PsiElement)this).filter(SqlExtraDeclarationsProvider.class)) {
            if (child.processExtraDeclarations(processor2, state, lastParent, place)) continue;
            return false;
        }
        PsiElement firstChild = this.getFirstChild();
        SqlWithClause sqlWithClause = withClause = firstChild instanceof SqlWithClause ? (SqlWithClause)firstChild : null;
        if (withClause != null && !withClause.processDeclarations(processor2, state, lastParent, place)) {
            return false;
        }
        return lastParent == null || !PsiTreeUtil.isContextAncestor((PsiElement)this, (PsiElement)lastParent, (boolean)true) || this.processImplicitContextDeclarations(processor2, state, lastParent, place);
    }

    private static PsiElement findAncestorChild(PsiElement ancestor, PsiElement child) {
        PsiElement parent2;
        PsiElement tmp2 = child;
        while (tmp2 != null && (parent2 = tmp2.getParent()) != ancestor) {
            tmp2 = parent2;
        }
        return tmp2;
    }

    public SqlTableExpression getTableExpression() {
        return (SqlTableExpression)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_TABLE_EXPRESSION);
    }

    public SqlSelectClause getSelectClause() {
        return (SqlSelectClause)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_SELECT_CLAUSE);
    }

    @NotNull
    private <T extends PsiElement> JBIterable<T> getLimitingClauses(Class<T> aClass) {
        Object[] clauses1 = PsiTreeUtil.getChildrenOfType((PsiElement)this.getSelectClause(), aClass);
        Object[] clauses2 = PsiTreeUtil.getChildrenOfType((PsiElement)this, aClass);
        JBIterable iterable = JBIterable.of((Object[])clauses1);
        JBIterable jBIterable = clauses2 != null ? iterable.append(clauses2) : iterable;
        if (jBIterable == null) {
            SqlQueryExpressionImpl.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<SqlLimitClause> getLimitClauses() {
        return this.getLimitingClauses(SqlLimitClause.class);
    }

    @NotNull
    public JBIterable<SqlOffsetClause> getOffsetClauses() {
        return this.getLimitingClauses(SqlOffsetClause.class);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlReferenceList refs;
        PsiElement flatten = (PsiElement)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_QUERY_FLATTEN_CLAUSE);
        if (flatten != null) {
            SqlType sqlType = this.getSqlTypeForCategory(SqlType.Category.STRING);
            DasType dasType = SqlImplUtil.getTypeService((PsiElement)this).getStringType();
            SqlTableType sqlTableType = SqlTableTypeBase.ensureTableType(sqlType, dasType, flatten, null);
            if (sqlTableType == null) {
                SqlQueryExpressionImpl.$$$reportNull$$$0(5);
            }
            return sqlTableType;
        }
        SqlTableExpression tableExpression = this.getTableExpression();
        SqlSelectClause selectClause = this.getSelectClause();
        if (selectClause == null) {
            Object object = tableExpression == null ? SqlType.UNKNOWN : tableExpression.getSqlType();
            if (object == null) {
                SqlQueryExpressionImpl.$$$reportNull$$$0(6);
            }
            return object;
        }
        List expressions2 = selectClause.getExpressions();
        if (expressions2.isEmpty() && (refs = (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)tableExpression, SqlReferenceList.class)) != null) {
            SqlTableType sqlTableType = tableExpression.getSqlType().alias(null, (PsiElement)tableExpression, refs.getReferenceList());
            if (sqlTableType == null) {
                SqlQueryExpressionImpl.$$$reportNull$$$0(7);
            }
            return sqlTableType;
        }
        SqlTableType sqlTableType = SqlImplUtil.getSelectType(expressions2, (PsiElement)this);
        if (sqlTableType == null) {
            SqlQueryExpressionImpl.$$$reportNull$$$0(8);
        }
        return sqlTableType;
    }

    @Override
    @NotNull
    public DasType getDasType() {
        SqlType sqlType = this.getSqlType();
        DasType dasType = sqlType instanceof SqlTableType ? (SqlTableType)sqlType : DasType.UNKNOWN;
        if (dasType == null) {
            SqlQueryExpressionImpl.$$$reportNull$$$0(9);
        }
        return dasType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlQueryExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlQueryExpressionImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLimitingClauses";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

