/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasTypedObjectEx;
import com.intellij.database.model.DasUserDefinedTypeEx;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasCallableType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturnsClause;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlScopingExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.impl.SqlVariableDefinitionImpl;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionCallExpressionImpl
extends SqlExpressionImpl
implements SqlFunctionCallExpression,
NavigationItem {
    public SqlFunctionCallExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlFunctionCallExpression((SqlFunctionCallExpression)this);
    }

    @Nullable
    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getCallableExpression(), SqlReferenceExpression.class);
    }

    @Nullable
    public SqlExpression getCallableExpression() {
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlExpression.class);
    }

    public SqlExpressionList getParameterList() {
        for (PsiElement c2 = this.getLastChild(); c2 != null; c2 = c2.getPrevSibling()) {
            if (!(c2 instanceof SqlExpressionList)) continue;
            return (SqlExpressionList)c2;
        }
        return null;
    }

    @Nullable
    private SqlFunctionDefinition.Prototype getPrototypeForReturnType() {
        DasSymbol callableSymbol;
        SqlFunctionDefinition.Prototype prototype = SqlFunctionsUtil.chooseTheBestPrototype(this, true);
        SqlReferenceExpression nameElement = this.getNameElement();
        if (prototype == null && nameElement != null && (callableSymbol = nameElement.resolveSymbol()) instanceof SqlFunctionDefinition) {
            SqlFunctionDefinition.Prototype[] prototypes = ((SqlFunctionDefinition)((Object)callableSymbol)).getPrototypes();
            prototype = prototypes.length == 1 ? prototypes[0] : null;
        }
        return prototype;
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlFunctionDefinition.Prototype prototype = this.getPrototypeForReturnType();
        SqlReferenceExpression nameElement = this.getNameElement();
        if (prototype != null) {
            SqlType sqlType = SqlFunctionCallExpressionImpl.createBuiltinFunctionReturnType(prototype, nameElement, (PsiElement)this.getParameterList(), (PsiElement)this);
            if (sqlType == null) {
                SqlFunctionCallExpressionImpl.$$$reportNull$$$0(1);
            }
            return sqlType;
        }
        if (nameElement == null) {
            SqlExpression expression = this.getCallableExpression();
            SqlType type = expression == null ? null : expression.getSqlType();
            Object object = type instanceof SqlTableType ? type : SqlType.UNKNOWN;
            if (object == null) {
                SqlFunctionCallExpressionImpl.$$$reportNull$$$0(2);
            }
            return object;
        }
        SqlType sqlType = SqlFunctionCallExpressionImpl.createFunctionReturnType(nameElement, (PsiElement)this);
        if (sqlType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(3);
        }
        return sqlType;
    }

    public static SqlType createFunctionReturnType(@Nullable SqlReferenceExpression nameElement, @NotNull PsiElement routineElement) {
        SqlType type;
        Object target;
        if (routineElement == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(4);
        }
        PsiElement resolve = nameElement == null ? null : nameElement.getReference().resolve();
        Object object = target = resolve instanceof DbElement ? ((DbElement)resolve).getDelegate() : resolve;
        if (target instanceof SqlFileImpl.GroupImpl) {
            target = ((SqlFileImpl.GroupImpl)target).delegates().first();
        }
        if (target instanceof DasRoutine) {
            return SqlFunctionCallExpressionImpl.createRoutineType(resolve, (DasRoutine)target, false, routineElement);
        }
        if (target instanceof SqlCreateTypeStatement && (type = ((SqlCreateTypeStatement)target).getSqlType()) != null) {
            return type;
        }
        if (target instanceof SqlTypedDefinition) {
            SqlTypedDefinition definition = (SqlTypedDefinition)target;
            return SqlImplUtil.getSqlType(definition, SqlImplUtil.getSqlDialectSafe(routineElement), (PsiElement)nameElement);
        }
        return SqlType.UNKNOWN;
    }

    @Nullable
    private static SqlTableType createReturnTypeForCallWithColumns(@Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params, @NotNull PsiElement routineElement) {
        if (routineElement == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(5);
        }
        if (params instanceof SqlExpressionList) {
            ArrayList columns = new ArrayList();
            if (!SqlFunctionCallExpressionImpl.collectColumnDefs(columns, params, SqlColumnDefinition.class)) {
                SqlFunctionCallExpressionImpl.collectColumnDefs(columns, routineElement, SqlColumnDefinition.class);
            }
            if (!columns.isEmpty()) {
                return new TableBasedSqlTableTypeImpl(columns, (PsiElement)ObjectUtils.chooseNotNull((Object)nameElement, (Object)routineElement));
            }
        }
        return null;
    }

    public static SqlType createBuiltinFunctionReturnType(@NotNull SqlFunctionDefinition.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params, @NotNull PsiElement routineElement) {
        DataType dataType;
        SqlLanguageDialectEx dialect;
        SqlType typeFromDialect;
        if (prototype == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(6);
        }
        if (routineElement == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(7);
        }
        if ((typeFromDialect = (dialect = SqlImplUtil.getSqlDialectSafe(routineElement)).getTypeSystem().getBuiltinFunctionReturnType(prototype, nameElement, params, routineElement)) != null) {
            return typeFromDialect;
        }
        SqlFunctionDefinition.Type returnType = prototype.getReturnType();
        if (returnType == SqlFunctionDefinition.UNNEST) {
            List<SqlExpression> cols;
            List<Object> list = params instanceof SqlExpressionList ? ((SqlExpressionList)params).getExpressionList() : (cols = params instanceof SqlExpression ? Collections.singletonList((SqlExpression)params) : null);
            if (nameElement == null || ContainerUtil.isEmpty(cols)) {
                return SqlTableTypeBase.EMPTY_TABLE;
            }
            if (cols.size() == 1 && dialect.getDbms().isPostgres()) {
                return SqlImplUtil.getSqlType(cols.get(0).getSqlType().getDataType(), dialect, routineElement);
            }
            StringBuilder builder = new StringBuilder("table(");
            for (SqlExpression col : cols) {
                if (builder.charAt(builder.length() - 1) != '(') {
                    builder.append(", ");
                }
                builder.append(prototype.getFunction().getName()).append(" ").append(SqlImplUtil.getArrayElement(col.getSqlType().getDataType()).getSpecification());
            }
            builder.append(")");
            return SqlFunctionCallExpressionImpl.getSqlType(routineElement, DataTypeFactory.of(builder.toString()));
        }
        DataType dataType2 = dataType = returnType == null ? null : returnType.getDataType();
        if (dataType != null) {
            SqlTableType typeWithColumns = SqlFunctionCallExpressionImpl.createReturnTypeForCallWithColumns(nameElement, params, routineElement);
            if (typeWithColumns != null) {
                return typeWithColumns;
            }
            if ("table".equalsIgnoreCase(dataType.typeName)) {
                SqlType sqlType;
                if (dataType.vagueArg == null) {
                    dataType = DataTypeFactory.of("table(" + prototype.getFunction().getName() + " record)");
                }
                if ((sqlType = SqlImplUtil.getSqlType(dataType, dialect, routineElement)) instanceof SqlTableType && ((SqlTableType)sqlType).getColumnCount() == 1 && dialect.getDbms().isPostgres()) {
                    return ((SqlTableType)sqlType).getColumnType(0);
                }
                return sqlType;
            }
            return SqlTypeFactory.of(dataType, dialect);
        }
        if (returnType instanceof SqlFunctionDefinition.ParamType && params instanceof SqlExpressionList) {
            int index2 = ((SqlFunctionDefinition.ParamType)returnType).getIndex();
            List parameters = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)params, SqlCompositeElement.class);
            if (index2 > 0 && index2 <= parameters.size()) {
                SqlCompositeElement element2 = (SqlCompositeElement)parameters.get(index2 - 1);
                return SqlFunctionCallExpressionImpl.getParamType((SqlElement)element2);
            }
            if (index2 == 0) {
                SqlPrimitiveType curType = SqlType.UNKNOWN;
                for (SqlCompositeElement param : parameters) {
                    SqlType type = SqlFunctionCallExpressionImpl.getParamType((SqlElement)param);
                    if (curType == SqlType.UNKNOWN || SqlType.Category.REAL.is(type)) {
                        curType = type;
                        continue;
                    }
                    if (!SqlType.Category.INTEGER.is((SqlType)curType)) continue;
                    curType = SqlTypeFactory.defaultType(SqlType.Category.REAL, dialect);
                }
                return curType;
            }
        }
        return SqlType.UNKNOWN;
    }

    static <T extends DasTypedObject> boolean collectColumnDefs(List<T> columns, PsiElement container, Class<T> columnClass) {
        ((SyntaxTraverser)SqlImplUtil.sqlTraverser(container).expandAndSkip(o -> o == container || o instanceof SqlClause)).filter(columnClass).addAllTo(columns);
        return !columns.isEmpty();
    }

    public static SqlType createRoutineType(@NotNull PsiElement resolve, @NotNull DasRoutine target, boolean ensureTable, @NotNull PsiElement qualifier) {
        if (resolve == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(8);
        }
        if (target == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(9);
        }
        if (qualifier == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(10);
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(qualifier);
        Dbms dbms = dialect.getDbms();
        DasArgument retArg = target.getReturnArgument();
        if (dbms.isPostgres()) {
            DataType retType;
            DataType dataType = retType = retArg == null ? null : retArg.getDataType();
            if (retType == null || retType.typeName.equalsIgnoreCase("record") || retType.typeName.equals("setof") && "record".equalsIgnoreCase(retType.suffix)) {
                JBIterable args = JBIterable.from(target.getArguments()).filter(o -> o.getArgumentDirection().isOut());
                if (!args.isEmpty()) {
                    return SqlFunctionCallExpressionImpl.createTypeFromColumns(resolve, (Iterable<? extends DasTypedObject>)args, true, qualifier);
                }
            } else if (retType.typeName.equals("setof") && retType.suffix != null) {
                SqlTypeElement typeElement;
                if (retArg instanceof SqlReturnsClause && (typeElement = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)((SqlReturnsClause)retArg).getTypeElement(), SqlTypeElement.class)) != null) {
                    return typeElement.findSqlType();
                }
                return SqlImplUtil.getSqlType(DataTypeFactory.of(retType.suffix), dialect, qualifier);
            }
        } else if (dbms.isMicrosoft() && retArg == null) {
            return SqlFunctionCallExpressionImpl.createTypeFromColumns(resolve, (Iterable<? extends DasTypedObject>)target.getDasChildren(ObjectKind.NONE).filter(DasTypedObject.class), true, qualifier);
        }
        return retArg == null ? SqlType.UNKNOWN : SqlFunctionCallExpressionImpl.createType(resolve, retArg, ensureTable, qualifier);
    }

    @NotNull
    private static SqlType getParamType(SqlElement element2) {
        Object object = element2 instanceof SqlTypeElement ? ((SqlTypeElement)element2).findSqlType() : (element2 instanceof SqlExpression ? ((SqlExpression)element2).getSqlType() : SqlType.UNKNOWN);
        if (object == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(11);
        }
        return object;
    }

    @NotNull
    private static DasType getParamDasType(SqlElement element2) {
        DasType dasType = element2 instanceof SqlTypeElement ? ((SqlTypeElement)element2).getDasType() : (element2 instanceof SqlExpression ? ((SqlExpression)element2).getDasType() : DasType.UNKNOWN);
        if (dasType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(12);
        }
        return dasType;
    }

    private static SqlType createTypeFromColumns(@NotNull PsiElement routine, @NotNull Iterable<? extends DasTypedObject> args, boolean ensureTable, @NotNull PsiElement qualifier) {
        if (routine == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(13);
        }
        if (args == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(14);
        }
        if (qualifier == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(15);
        }
        int size = Iterables.size(args);
        ArrayList<SqlImplUtil.Column> columns = new ArrayList<SqlImplUtil.Column>(size);
        for (DasTypedObject dasTypedObject : args) {
            SqlType sqlType = dasTypedObject instanceof SqlTypedDefinition ? ((SqlTypedDefinition)dasTypedObject).getSqlType() : SqlFunctionCallExpressionImpl.getSqlType(routine, dasTypedObject.getDataType());
            DasType dasType = dasTypedObject instanceof DasTypedObjectEx ? ((DasTypedObjectEx)dasTypedObject).getDasType() : DasType.UNKNOWN;
            columns.add(new SqlImplUtil.Column(dasTypedObject.getName(), sqlType, dasType, (PsiElement)(dasTypedObject instanceof PsiElement ? (PsiElement)dasTypedObject : new FakeParameter(qualifier, dasTypedObject)), null));
        }
        if (!ensureTable && columns.size() == 1) {
            return ((SqlImplUtil.Column)columns.get((int)0)).type;
        }
        return SqlImplUtil.createType(columns, qualifier);
    }

    private static SqlType createType(@NotNull PsiElement routine, @NotNull DasArgument retArg, boolean ensureTable, @NotNull PsiElement qualifier) {
        DasType dasType;
        if (routine == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(16);
        }
        if (retArg == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(17);
        }
        if (qualifier == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(18);
        }
        SqlType sqlType = SqlFunctionCallExpressionImpl.getReturnType(routine, retArg);
        DasType dasType2 = dasType = retArg instanceof DasTypedObjectEx ? ((DasTypedObjectEx)((Object)retArg)).getDasType() : DasType.UNKNOWN;
        if (sqlType != SqlType.UNKNOWN && retArg instanceof SqlElement) {
            SqlType res2;
            Object object = res2 = ensureTable ? SqlTableTypeBase.ensureTableType(sqlType, dasType, (PsiElement)((SqlElement)retArg), qualifier) : sqlType;
            if (sqlType instanceof SqlTableType) {
                String name = routine instanceof DasObject ? ((DasObject)routine).getName() : (routine instanceof SqlExpression ? ((SqlExpression)routine).getName() : null);
                res2 = ((SqlTableType)res2).alias(name, qualifier, Collections.emptyList());
            }
            return res2;
        }
        if (!ensureTable) {
            return sqlType;
        }
        List<SqlImplUtil.Column> columns = Collections.singletonList(new SqlImplUtil.Column(retArg.getName(), sqlType, dasType, (PsiElement)(retArg instanceof PsiElement ? (PsiElement)retArg : new FakeParameter(qualifier, retArg)), null));
        return SqlImplUtil.createType(columns, qualifier);
    }

    private static SqlType getReturnType(@NotNull PsiElement routine, @NotNull DasArgument retArg) {
        if (routine == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(19);
        }
        if (retArg == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(20);
        }
        SqlType sqlType = null;
        Dbms dbms = SqlImplUtil.getSqlDialectSafe(routine).getDbms();
        if (retArg instanceof SqlTypedDefinition) {
            sqlType = ((SqlTypedDefinition)retArg).getSqlType();
            if (dbms.isPostgres() && SqlType.Category.SETOF.is(sqlType)) {
                return SqlFunctionCallExpressionImpl.getSqlType(routine, SqlFunctionCallExpressionImpl.trimSetOf(sqlType.getDataType()));
            }
        }
        DataType dataType = retArg.getDataType();
        if (dbms.isPostgres()) {
            dataType = SqlFunctionCallExpressionImpl.trimSetOf(dataType);
        }
        return sqlType != null ? sqlType : SqlFunctionCallExpressionImpl.getSqlType(routine, dataType);
    }

    @NotNull
    private static DataType trimSetOf(DataType dataType) {
        DataType dataType2 = dataType.typeName.equals("setof") && dataType.suffix != null ? DataTypeFactory.of(dataType.suffix) : dataType;
        if (dataType2 == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(21);
        }
        return dataType2;
    }

    private static SqlType getSqlType(@NotNull PsiElement routine, @NotNull DataType dataType) {
        if (routine == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(22);
        }
        if (dataType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(23);
        }
        if (dataType == DataType.UNKNOWN) {
            return SqlType.UNKNOWN;
        }
        return SqlImplUtil.getSqlType(dataType, SqlImplUtil.getSqlDialectSafe(routine), routine);
    }

    @Override
    @NotNull
    public DasType getDasType() {
        SqlFunctionDefinition.Prototype prototype = this.getPrototypeForReturnType();
        SqlReferenceExpression nameElement = this.getNameElement();
        if (prototype != null) {
            DasType dasType = SqlFunctionCallExpressionImpl.getBuiltinFunctionReturnDasType(prototype, nameElement, (PsiElement)this.getParameterList(), (PsiElement)this);
            if (dasType == null) {
                SqlFunctionCallExpressionImpl.$$$reportNull$$$0(24);
            }
            return dasType;
        }
        if (nameElement == null) {
            SqlExpression expression = this.getCallableExpression();
            SqlType type = expression == null ? null : expression.getSqlType();
            DasType dasType = type instanceof SqlTableType ? (SqlTableType)type : DasType.UNKNOWN;
            if (dasType == null) {
                SqlFunctionCallExpressionImpl.$$$reportNull$$$0(25);
            }
            return dasType;
        }
        DasType dasType = SqlFunctionCallExpressionImpl.getFunctionReturnDasType(nameElement, (PsiElement)this);
        if (dasType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(26);
        }
        return dasType;
    }

    public static DasType getBuiltinFunctionReturnDasType(@NotNull SqlFunctionDefinition.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params, @NotNull PsiElement routineElement) {
        DataType dataType;
        DasType dasType;
        SqlTableType typeWithColumns;
        if (prototype == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(27);
        }
        if (routineElement == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(28);
        }
        if ((typeWithColumns = SqlFunctionCallExpressionImpl.createReturnTypeForCallWithColumns(nameElement, params, routineElement)) != null) {
            return typeWithColumns;
        }
        SqlFunctionDefinition.Type returnType = prototype.getReturnType();
        DasType dasType2 = dasType = returnType == null ? null : returnType.getDasType();
        if (dasType != null) {
            return dasType;
        }
        DataType dataType2 = dataType = returnType == null ? null : returnType.getDataType();
        if (dataType != null && "table".equalsIgnoreCase(dataType.typeName)) {
            SqlLanguageDialectEx dialect;
            SqlType sqlType;
            if (dataType.vagueArg == null) {
                dataType = DataTypeFactory.of("table(" + prototype.getFunction().getName() + " record)");
            }
            return (sqlType = SqlImplUtil.getSqlType(dataType, dialect = SqlImplUtil.getSqlDialectSafe(routineElement), routineElement)) instanceof SqlTableType ? (SqlTableType)sqlType : DasType.UNKNOWN;
        }
        if (returnType instanceof SqlFunctionDefinition.ParamType && params instanceof SqlExpressionList) {
            int index2 = ((SqlFunctionDefinition.ParamType)returnType).getIndex();
            List parameters = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)params, SqlCompositeElement.class);
            if (index2 > 0 && index2 <= parameters.size()) {
                return SqlFunctionCallExpressionImpl.getParamDasType((SqlElement)parameters.get(index2 - 1));
            }
        }
        return DasType.UNKNOWN;
    }

    private static DasType getFunctionReturnDasType(@Nullable SqlReferenceExpression nameElement, @NotNull PsiElement routineElement) {
        Object target;
        ResolveResult[] results2;
        if (routineElement == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(29);
        }
        ResolveResult[] resolveResultArray = results2 = nameElement == null ? ResolveResult.EMPTY_ARRAY : nameElement.getReference().multiResolve(false);
        if (results2.length != 1) {
            return DasType.UNKNOWN;
        }
        PsiElement resolve = results2[0].getElement();
        Object object = target = resolve instanceof DbElement ? ((DbElement)resolve).getDelegate() : resolve;
        if (target instanceof SqlFileImpl.GroupImpl) {
            target = ((SqlFileImpl.GroupImpl)target).delegates().first();
        }
        if (target instanceof DasRoutine) {
            DasArgument argument = ((DasRoutine)target).getReturnArgument();
            if (argument == null) {
                return DasType.VOID;
            }
            if (argument instanceof DasTypedObjectEx) {
                return ((DasTypedObjectEx)((Object)argument)).getDasType();
            }
            return DasType.UNKNOWN;
        }
        DasType dasType = target instanceof DasUserDefinedTypeEx ? ((DasUserDefinedTypeEx)target).getDasType() : (target instanceof DasTypedObjectEx ? ((DasTypedObjectEx)target).getDasType() : DasType.UNKNOWN);
        dasType = DasTypeUtilsKt.unwrapAlias(dasType);
        return dasType instanceof DasCallableType ? ((DasCallableType)((Object)dasType)).getReturnType() : dasType;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                SqlReferenceExpression nameElement = SqlFunctionCallExpressionImpl.this.getNameElement();
                return nameElement == null ? null : nameElement.getName();
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }
        };
    }

    @Nullable
    public SqlFunctionDefinition getFunctionDefinition() {
        if (this.getParent() instanceof SqlScopingExpression) {
            return null;
        }
        SqlReferenceExpression nameElement = this.getNameElement();
        if (nameElement == null) {
            return null;
        }
        String functionName = nameElement.getName();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        SqlFunctionDefinition definition = dialect.getSupportedFunctions().get(functionName);
        return definition == null || SqlImplUtil.hasLocationOf(definition, dialect.getExpectedFunctionLocations((SqlExpression)nameElement)) ? definition : null;
    }

    @Override
    public ObjectKind getExpectedReferenceTargetType(SqlElement referenceElement) {
        return referenceElement == this.getNameElement() && this.getFirstChild() != this.getLastChild() ? ObjectKind.ROUTINE : super.getExpectedReferenceTargetType(referenceElement);
    }

    private boolean isFunctionWithColumnQualifier(SqlScopeProcessor processor2) {
        if (!processor2.getDialect().getDbms().isMicrosoft()) {
            return false;
        }
        SqlFunctionDefinition funDef = this.getFunctionDefinition();
        if (funDef == null) {
            return false;
        }
        String name = funDef.getName();
        return name.equalsIgnoreCase("CONTAINSTABLE") || name.equalsIgnoreCase("FREETEXTTABLE");
    }

    @Override
    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor2, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor2, ObjectKind.ARGUMENT)) {
            return true;
        }
        if (!SqlFunctionCallExpressionImpl.processNamedArgument((Processor<? super DasSymbol>)((Processor)e -> processor2.execute(e, state)), this.getNameElement(), place)) {
            return false;
        }
        if (processor2.mayAccept(ObjectKind.COLUMN) && this.isFunctionWithColumnQualifier(processor2)) {
            SqlExpressionList parameterList = this.getParameterList();
            List expressions2 = parameterList != null ? parameterList.getExpressionList() : Collections.emptyList();
            for (SqlExpression expression : expressions2) {
                if (!(expression instanceof SqlReferenceExpression) || ((SqlReferenceExpression)expression).getKind() != ObjectKind.TABLE || SqlImplUtil.processFromReferences(processor2, state, expression, place, lastParent)) continue;
                return false;
            }
        }
        return super.processImplicitContextDeclarations(processor2, state, lastParent, place);
    }

    public static boolean processNamedArgument(Processor<? super DasSymbol> processor2, SqlReferenceExpression ref, PsiElement place) {
        SqlNamedParameterValueExpression expr = (SqlNamedParameterValueExpression)((Object)ObjectUtils.tryCast((Object)(place == null ? null : place.getParent()), SqlNamedParameterValueExpression.class));
        if (expr != null && place == expr.getLOperand()) {
            SqlFunctionCallExpressionImpl.processParameters(ref, processor2, place);
            return false;
        }
        return true;
    }

    public static boolean processParameters(@Nullable SqlReferenceExpression fooRef, Processor<? super DasSymbol> processor2, PsiElement place) {
        if (fooRef == null) {
            return true;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)fooRef);
        Case casing = dialect.getCasing((ObjectKind)ObjectKind.ARGUMENT, null).plain;
        SqlFunctionDefinition definition = dialect.getSupportedFunctions().get(fooRef.getName());
        if (definition != null) {
            JBIterable params = ((JBTreeTraverser)JBTreeTraverser.from(SqlFunctionCallExpressionImpl::getParameters).withRoots((Iterable)JBIterable.of((Object[])definition.getPrototypes()))).filter(SqlFunctionDefinition.SimpleParameter.class);
            for (SqlFunctionDefinition.SimpleParameter param : params) {
                DataType dataType;
                String name = casing.apply(param.getName());
                if (processor2.process((Object)DasSymbolUtil.createSimpleVariable((SqlElement)fooRef, name, dataType = param.getType().getDataType()))) continue;
                return false;
            }
        }
        for (ResolveResult res2 : fooRef.multiResolve(false)) {
            Object object;
            DasSymbol symbol = DasSymbolUtil.getSymbol(res2);
            Object object2 = object = symbol != null ? symbol.getDasObject() : null;
            if (object instanceof DbElement) {
                object = ((DbElement)object).getDelegate();
            }
            DasRoutine routine = (DasRoutine)ObjectUtils.tryCast((Object)object, DasRoutine.class);
            SqlVariableDefinitionImpl curs = (SqlVariableDefinitionImpl)((Object)ObjectUtils.tryCast((Object)object, SqlVariableDefinitionImpl.class));
            if (dialect.getDbms().isOracle() && curs != null && curs.getKind() == SqlDbElementType.CURSOR) {
                for (DasArgument parameter : SqlImplUtil.childrenIt((PsiElement)curs).filter(SqlParameterDefinition.class)) {
                    if (processor2.process((Object)parameter)) continue;
                    return false;
                }
            }
            if (routine == null) continue;
            if (object instanceof SqlProcedureDefinitionImpl) {
                SqlProcedureDefinitionImpl procedure = (SqlProcedureDefinitionImpl)((Object)object);
                Iterable<SqlParameterDefinition> parameters = procedure.getArguments();
                for (SqlParameterDefinition parameter : parameters) {
                    if (processor2.process((Object)parameter)) continue;
                    return false;
                }
                continue;
            }
            for (DasArgument parameter : DasUtil.getParameters(routine)) {
                if (processor2.process((Object)DasSymbolUtil.wrapObjectToSymbol(parameter, fooRef.getProject()))) continue;
                return false;
            }
        }
        return true;
    }

    private static Iterable<? extends SqlFunctionDefinition.Parameter> getParameters(SqlFunctionDefinition.Parameter p2) {
        return p2 instanceof SqlFunctionDefinition.ParameterBlock ? JBIterable.of((Object[])((SqlFunctionDefinition.ParameterBlock)p2).getParams()) : JBIterable.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routineElement";
                break;
            }
            case 6: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retArg";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamDasType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "trimSetOf";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionReturnType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createReturnTypeForCallWithColumns";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createBuiltinFunctionReturnType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRoutineType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromColumns";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinFunctionReturnDasType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionReturnDasType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FakeParameter
    extends SqlFileImpl.FakeDefinition
    implements DasTypedObject {
        private final PsiElement myParent;
        @Nullable
        private final DasTypedObject myDelegate;

        public FakeParameter(@NotNull PsiElement parent2, @NotNull DasTypedObject parameter) {
            if (parent2 == null) {
                FakeParameter.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                FakeParameter.$$$reportNull$$$0(1);
            }
            this(parent2, StringUtil.notNullize((String)parameter.getName()), parameter);
        }

        public FakeParameter(@NotNull PsiElement parent2, @NotNull String name, @Nullable DasTypedObject delegate) {
            if (parent2 == null) {
                FakeParameter.$$$reportNull$$$0(2);
            }
            if (name == null) {
                FakeParameter.$$$reportNull$$$0(3);
            }
            super(parent2, name);
            this.myParent = parent2;
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = SqlImplUtil.getSqlDialectDbms(this.getParent());
            if (dbms == null) {
                FakeParameter.$$$reportNull$$$0(4);
            }
            return dbms;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDelegate == null ? DataType.UNKNOWN : this.myDelegate.getDataType();
            if (dataType == null) {
                FakeParameter.$$$reportNull$$$0(5);
            }
            return dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myDelegate != null && this.myDelegate.isNotNull();
        }

        @Override
        @Nullable
        public String getDefault() {
            return this.myDelegate == null ? null : this.myDelegate.getDefault();
        }

        public boolean isNameQuoted() {
            return DbSqlUtilCore.isQuoted(this.myDelegate);
        }

        public int getTextOffset() {
            return this.myParent.getTextOffset();
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.ARGUMENT;
            if (objectKind == null) {
                FakeParameter.$$$reportNull$$$0(6);
            }
            return objectKind;
        }

        @Override
        public String getTypeName() {
            if (this.myDelegate != null) {
                SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe(this.getParent());
                DatabaseDialectEx dbDialect = sqlDialect.getDatabaseDialect();
                return new DdlBuilder().applyCodeStyle(this.getProject(), sqlDialect).withDialect(dbDialect).type(this.myDelegate).getStatement();
            }
            return super.getTypeName();
        }

        @Override
        public Icon getIcon() {
            return DatabaseIcons.Col;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

