/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.JoinConditionInfo;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/intentions/SqlConvertJoinOnToNaturalIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getTargetElement", "Lcom/intellij/sql/psi/SqlJoinConditionClause;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlConvertJoinOnToNaturalIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.replace.on.with.natural.join", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026ce.on.with.natural.join\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.getTargetElement(element2) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlJoinConditionClause sqlJoinConditionClause = this.getTargetElement(element2);
        if (sqlJoinConditionClause == null) {
            return;
        }
        JoinUtilsKt.convertToNaturalJoin(project, (SqlClause)sqlJoinConditionClause);
    }

    private final SqlJoinConditionClause getTargetElement(PsiElement element2) {
        JoinConditionInfo<SqlJoinConditionClause> joinConditionInfo = JoinUtilsKt.getJoinOnInfo(element2);
        if (joinConditionInfo == null) {
            return null;
        }
        JoinConditionInfo<SqlJoinConditionClause> info = joinConditionInfo;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element2);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"SqlImplUtil.getSqlDialectSafe(element)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        SqlJoinConditionClause sqlJoinConditionClause = info.getClause();
        boolean bl = false;
        boolean bl2 = false;
        SqlJoinConditionClause it2 = sqlJoinConditionClause;
        boolean bl3 = false;
        return dialect.supportsNaturalJoin() && JoinUtilsKt.canBeNaturalJoin(info.getColumnRefs(), info.getLeftTableRef(), info.getRightTableRef(), dialect) ? sqlJoinConditionClause : null;
    }
}

