/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u0013\u001a\u00020\u0012*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getInfo", "Lcom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention$Info;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "isNot", "Lcom/intellij/sql/psi/SqlUnaryExpression;", "dbms", "Lcom/intellij/database/Dbms;", "Info", "intellij.database.sql.impl"})
public final class SqlConvertComparisonToBetweenIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.replace.comparison.with.between.expression", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026with.between.expression\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.getInfo(element2) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Info info = this.getInfo(element2);
        if (info == null) {
            return;
        }
        Info info2 = info;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(info2.getElementToReplace());
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"SqlImplUtil.getSqlDialec\u2026fe(info.elementToReplace)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        DdlBuilder ddlBuilder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect()).plain(info2.getSubject().getText()).keyword(info2.isNot() ? " not between " : " between ").plain(info2.getLowerBound().getText()).keyword(" and ").plain(info2.getUpperBound().getText());
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"DdlBuilder()\n      .conf\u2026ain(info.upperBound.text)");
        String string = ddlBuilder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DdlBuilder()\n      .conf\u2026nd.text)\n      .statement");
        String betweenExprText = string;
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(betweenExprText, dialect, project, null);
        Intrinsics.checkNotNull((Object)sqlExpression);
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"SqlPsiElementFactory.cre\u2026dialect, project, null)!!");
        SqlExpression betweenExpr = sqlExpression;
        info2.getElementToReplace().replace((PsiElement)betweenExpr);
    }

    /*
     * WARNING - void declaration
     */
    private final Info getInfo(PsiElement element2) {
        SqlExpression sqlExpression;
        void rightRef;
        void leftRef;
        Object v4;
        SqlReferenceExpression it2;
        Dbms dbms;
        block15: {
            void $this$firstOrNull$iv;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element2);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"SqlImplUtil.getSqlDialectSafe(element)");
            Dbms dbms2 = sqlLanguageDialectEx.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms2, (String)"SqlImplUtil.getSqlDialectSafe(element).dbms");
            dbms = dbms2;
            JBIterable jBIterable = SqlImplUtil.sqlParents(element2).filter(SqlBinaryExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil\n        .sql\u2026ryExpression::class.java)");
            Iterable iterable = (Iterable)jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it2 = (SqlReferenceExpression)element$iv;
                boolean bl = false;
                SqlReferenceExpression sqlReferenceExpression = it2;
                Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceExpression, (String)"it");
                if (!UtilsKt.isAnd((SqlBinaryExpression)sqlReferenceExpression, dbms)) continue;
                v4 = element$iv;
                break block15;
            }
            v4 = null;
        }
        SqlBinaryExpression sqlBinaryExpression = v4;
        if (sqlBinaryExpression == null) {
            return null;
        }
        SqlBinaryExpression andExpr = sqlBinaryExpression;
        SqlExpression sqlExpression2 = andExpr.getLOperand();
        if (!(sqlExpression2 instanceof SqlBinaryExpression)) {
            sqlExpression2 = null;
        }
        SqlBinaryExpression sqlBinaryExpression2 = (SqlBinaryExpression)sqlExpression2;
        if (sqlBinaryExpression2 == null) {
            return null;
        }
        SqlBinaryExpression leftCmp = sqlBinaryExpression2;
        SqlExpression sqlExpression3 = andExpr.getROperand();
        if (!(sqlExpression3 instanceof SqlBinaryExpression)) {
            sqlExpression3 = null;
        }
        SqlBinaryExpression sqlBinaryExpression3 = (SqlBinaryExpression)sqlExpression3;
        if (sqlBinaryExpression3 == null) {
            return null;
        }
        SqlBinaryExpression rightCmp = sqlBinaryExpression3;
        SqlReferenceExpression sqlReferenceExpression = UtilsKt.splitWithReference(leftCmp);
        if (sqlReferenceExpression == null) {
            return null;
        }
        it2 = sqlReferenceExpression;
        SqlReferenceExpression sqlReferenceExpression2 = (SqlReferenceExpression)it2.component1();
        SqlExpression leftExpr = (SqlExpression)it2.component2();
        Pair<SqlReferenceExpression, SqlExpression> pair = UtilsKt.splitWithReference(rightCmp);
        if (pair == null) {
            return null;
        }
        Pair<SqlReferenceExpression, SqlExpression> pair2 = pair;
        it2 = (SqlReferenceExpression)pair2.component1();
        SqlExpression rightExpr = (SqlExpression)pair2.component2();
        if (!UtilsKt.checkEquivalence((SqlReferenceExpression)leftRef, (SqlReferenceExpression)rightRef)) {
            return null;
        }
        SqlExpression lowerBound = null;
        SqlExpression upperBound = null;
        if (Intrinsics.areEqual((Object)leftCmp.getOpSign(), (Object)SqlCommonTokens.SQL_OP_LE) && Intrinsics.areEqual((Object)rightCmp.getOpSign(), (Object)SqlCommonTokens.SQL_OP_GE)) {
            upperBound = leftExpr;
            lowerBound = rightExpr;
        } else if (Intrinsics.areEqual((Object)leftCmp.getOpSign(), (Object)SqlCommonTokens.SQL_OP_GE) && Intrinsics.areEqual((Object)rightCmp.getOpSign(), (Object)SqlCommonTokens.SQL_OP_LE)) {
            lowerBound = leftExpr;
            upperBound = rightExpr;
        }
        if ((sqlExpression = UtilsKt.topParenthesized((SqlExpression)andExpr)) == null) {
            sqlExpression = (SqlExpression)andExpr;
        }
        PsiElement parent2 = sqlExpression.getParent();
        boolean isNot = parent2 instanceof SqlUnaryExpression && this.isNot((SqlUnaryExpression)parent2, dbms);
        PsiElement psiElement = isNot ? parent2 : (PsiElement)andExpr;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"if (isNot) parent else andExpr");
        SqlExpression sqlExpression4 = lowerBound;
        if (sqlExpression4 == null) {
            return null;
        }
        SqlExpression sqlExpression5 = upperBound;
        if (sqlExpression5 == null) {
            return null;
        }
        return new Info(isNot, psiElement, (SqlReferenceExpression)leftRef, sqlExpression4, sqlExpression5);
    }

    private final boolean isNot(SqlUnaryExpression $this$isNot, Dbms dbms) {
        IElementType iElementType = $this$isNot.getOpSign();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"opSign");
        IElementType opToken = iElementType;
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonKeywords.SQL_NOT)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NOT2) && (dbms.isHive() || dbms.isSpark());
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention$Info;", "", "isNot", "", "elementToReplace", "Lcom/intellij/psi/PsiElement;", "subject", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "lowerBound", "Lcom/intellij/sql/psi/SqlExpression;", "upperBound", "(ZLcom/intellij/psi/PsiElement;Lcom/intellij/sql/psi/SqlReferenceExpression;Lcom/intellij/sql/psi/SqlExpression;Lcom/intellij/sql/psi/SqlExpression;)V", "getElementToReplace", "()Lcom/intellij/psi/PsiElement;", "()Z", "getLowerBound", "()Lcom/intellij/sql/psi/SqlExpression;", "getSubject", "()Lcom/intellij/sql/psi/SqlReferenceExpression;", "getUpperBound", "intellij.database.sql.impl"})
    private static final class Info {
        private final boolean isNot;
        @NotNull
        private final PsiElement elementToReplace;
        @NotNull
        private final SqlReferenceExpression subject;
        @NotNull
        private final SqlExpression lowerBound;
        @NotNull
        private final SqlExpression upperBound;

        public final boolean isNot() {
            return this.isNot;
        }

        @NotNull
        public final PsiElement getElementToReplace() {
            return this.elementToReplace;
        }

        @NotNull
        public final SqlReferenceExpression getSubject() {
            return this.subject;
        }

        @NotNull
        public final SqlExpression getLowerBound() {
            return this.lowerBound;
        }

        @NotNull
        public final SqlExpression getUpperBound() {
            return this.upperBound;
        }

        public Info(boolean isNot, @NotNull PsiElement elementToReplace, @NotNull SqlReferenceExpression subject, @NotNull SqlExpression lowerBound, @NotNull SqlExpression upperBound) {
            Intrinsics.checkNotNullParameter((Object)elementToReplace, (String)"elementToReplace");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter((Object)lowerBound, (String)"lowerBound");
            Intrinsics.checkNotNullParameter((Object)upperBound, (String)"upperBound");
            this.isNot = isNot;
            this.elementToReplace = elementToReplace;
            this.subject = subject;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }
    }
}

