/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.configuration;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.inspections.SqlResolveInspection;
import com.intellij.sql.psi.SqlFile;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCurrentSchemaInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "SqlCurrentSchemaInspection";
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ObjectPath path;
        PsiFile topLevelFile;
        VirtualFile vfile;
        if (file == null) {
            SqlCurrentSchemaInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlCurrentSchemaInspection.$$$reportNull$$$0(1);
        }
        if (!isOnTheFly || !(file instanceof SqlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = manager.getProject();
        JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, vfile = (topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file)).getVirtualFile());
        ObjectPath objectPath = path = console == null ? null : console.getCurrentNamespace();
        if (path == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        TreePattern scope = console.getDataSource().getIntrospectionScope();
        if (DataSourceSchemaMapping.matches(scope, path)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DasObject nsp = (DasObject)QNameUtil.findByPath(console.getDataSource().getModel(), path).first();
        if (nsp != null && DataSourceSchemaMapping.isIntrospected(scope, nsp)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DbDataSource dbDataSource = DbPsiFacade.getInstance(project).findDataSource(console.getDataSource().getUniqueId());
        ArrayList<SqlResolveInspection.IntrospectSchemaFix> fixes = new ArrayList<SqlResolveInspection.IntrospectSchemaFix>();
        if (dbDataSource != null) {
            fixes.add(new SqlResolveInspection.IntrospectSchemaFix(Collections.singletonList(Pair.create((Object)dbDataSource, (Object)path)), path.kind));
        }
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)file, SqlBundle.message("inspection.message.current.not.introspected", DbPresentationCore.getPresentableName(path.kind, console.getDataSource().getDbms())), true, fixes.toArray(LocalQuickFix.EMPTY_ARRAY), ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/configuration/SqlCurrentSchemaInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

