/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlUnusedSubqueryItemInspection;
import com.intellij.sql.inspections.SqlUnusedVariableInspection;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlUnusedSubqueryItemInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlUnusedSubqueryItemInspection
extends SqlInspectionBase {
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<? extends ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(onTheFly, manager, dialect, result2, manager, dialect, result2){
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public void visitSqlQueryExpression(@NotNull SqlQueryExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                selectClause = o.getSelectClause();
                if (selectClause == null) {
                    return;
                }
                hasNoArgAggregate = false;
                var5_4 = selectClause.getExpressions().iterator();
                while (var5_4.hasNext()) {
                    v0 = expression = (SqlExpression)var5_4.next();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"expression");
                    if (this.isStarReference(v0)) {
                        return;
                    }
                    if (!(expression instanceof SqlFunctionCallExpression)) continue;
                    if (((SqlFunctionCallExpression)expression).getParameterList() == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)parameterList, (String)"expression.parameterList ?: continue");
                    if (parameterList.getExpressionList().size() != 0) ** GOTO lbl-1000
                    v1 = ((SqlFunctionCallExpression)expression).getFunctionDefinition();
                    if (!(v1 instanceof SqlFunctionDefinition)) {
                        v1 = null;
                    }
                    v2 = (SqlFunctionDefinition)v1;
                    if (v2 == null) ** GOTO lbl-1000
                    if (SqlPsiUtilCoreKt.isAggregate(v2)) {
                        v3 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        v3 = false;
                    }
                    hasNoArgAggregate = v3;
                }
                expression = new Ref.ObjectRef();
                v4 = o.getTableExpression();
                v5 /* !! */  = v4 != null && (v4 = v4.getFromClause()) != null ? v4.getFromExpression() : (expression.element = null);
                if ((SqlExpression)fromExpression.element instanceof SqlAsExpression && !SqlUnusedVariableInspection.foundAnyRefs((PsiElement)((SqlExpression)fromExpression.element), (Condition<? super SqlElement>)new Condition(this, (Ref.ObjectRef)fromExpression){
                    final /* synthetic */ createAnnotationVisitor.1 this$0;
                    final /* synthetic */ Ref.ObjectRef $fromExpression;

                    public final boolean value(SqlElement it2) {
                        return it2 == (SqlExpression)this.$fromExpression.element ? true : it2 instanceof SqlReferenceExpression && createAnnotationVisitor.1.access$isQualifier(this.this$0, (SqlReferenceExpression)it2);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$fromExpression = objectRef;
                    }
                }, o.getUseScope())) {
                    fromExpression.element = ((SqlAsExpression)((SqlExpression)fromExpression.element)).getExpression();
                }
                while ((SqlExpression)fromExpression.element instanceof SqlParenthesizedExpression) {
                    Intrinsics.checkNotNullExpressionValue((Object)((SqlParenthesizedExpression)((SqlExpression)fromExpression.element)).getExpressionList(), (String)"fromExpression.expressionList");
                    if (expressionList.size() != 1) break;
                    fromExpression.element = (SqlExpression)expressionList.get(0);
                }
                v6 = ContainerUtil.emptyList();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"ContainerUtil.emptyList<SqlExpression>()");
                expressionBranches = v6;
                while ((SqlExpression)fromExpression.element instanceof SqlNAryExpression) {
                    if (expressionBranches.isEmpty()) {
                        var6_7 = false;
                        expressionBranches = new ArrayList<E>();
                    }
                    v7 = ((SqlNAryExpression)((SqlExpression)fromExpression.element)).getOperands();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"fromExpression.operands");
                    expressionBranches.addAll(v7);
                    fromExpression.element = ((SqlNAryExpression)((SqlExpression)fromExpression.element)).getLOperand();
                }
                if ((SqlExpression)fromExpression.element instanceof SqlQueryExpression) {
                    this.inspectQueryExpression((SqlQueryExpression)((SqlExpression)fromExpression.element), (SearchScope)new LocalSearchScope((PsiElement)o), expressionBranches, hasNoArgAggregate);
                }
                super.visitSqlQueryExpression(o);
            }

            private final SqlExpression skipParenthesized(SqlExpression expression) {
                PsiElement parent2;
                while ((parent2 = SqlImplUtil.sqlParent((PsiElement)expression)) instanceof SqlParenthesizedExpression && ((SqlParenthesizedExpression)parent2).getExpressionList().size() == 1) {
                    expression = (SqlExpression)parent2;
                }
                return expression;
            }

            private final boolean isQualifier(SqlReferenceExpression expression) {
                SqlExpression baseExpression = this.skipParenthesized((SqlExpression)expression);
                PsiElement psiElement = baseExpression.getParent();
                if (!(psiElement instanceof SqlReferenceExpression)) {
                    psiElement = null;
                }
                SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)psiElement;
                return Intrinsics.areEqual((Object)(sqlReferenceExpression != null ? sqlReferenceExpression.getQualifierExpression() : null), (Object)baseExpression);
            }

            private final boolean isStarReference(SqlExpression expression) {
                boolean bl;
                block3: {
                    JBIterable jBIterable = SqlImplUtil.sqlTraverser((PsiElement)expression).filter(SqlReferenceExpression.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil.sqlTraverser\u2026ceExpression::class.java)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            SqlReferenceExpression e = (SqlReferenceExpression)element$iv;
                            boolean bl2 = false;
                            SqlReferenceExpression sqlReferenceExpression = e;
                            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceExpression, (String)"e");
                            if (!Intrinsics.areEqual((Object)"*", (Object)sqlReferenceExpression.getName())) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final void inspectQueryExpression(SqlQueryExpression o, SearchScope searchScope, List<? extends SqlExpression> expressionBranches, boolean hasNoArgAggregate) {
                boolean bl;
                List expressions2;
                block9: {
                    SqlSelectClause sqlSelectClause = o.getSelectClause();
                    if (sqlSelectClause == null) {
                        return;
                    }
                    SqlSelectClause selectClause = sqlSelectClause;
                    List list = selectClause.getExpressions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"selectClause.expressions");
                    expressions2 = list;
                    if (expressions2.size() == 1 && hasNoArgAggregate) {
                        return;
                    }
                    List list2 = selectClause.getOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"selectClause.options");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            SqlSelectOption it2 = (SqlSelectOption)element$iv;
                            boolean bl2 = false;
                            SqlSelectOption sqlSelectOption = it2;
                            Intrinsics.checkNotNullExpressionValue((Object)sqlSelectOption, (String)"it");
                            String string = sqlSelectOption.getOptionName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.optionName");
                            if (!StringsKt.startsWith((String)string, (String)"DISTINCT", (boolean)true)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                for (SqlExpression expression : expressions2) {
                    PsiElement element2;
                    if (expression instanceof SqlAsExpression) {
                        this.reportErrorForName(expression, this.getErrorElementName(o, (SqlAsExpression)expression, expressionBranches, searchScope));
                    }
                    if (SqlImplUtil.isAsteriskRef((PsiElement)expression)) {
                        SqlExpression sqlExpression = expression;
                        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"expression");
                        this.validateStarReference(o, sqlExpression, expressionBranches, searchScope);
                        continue;
                    }
                    if (!(expression instanceof SqlReferenceExpression) || ((SqlReferenceExpression)expression).getReferenceElementType() != SqlCompositeElementTypes.SQL_COLUMN_REFERENCE || (element2 = ((SqlReferenceExpression)expression).resolve()) == null) continue;
                    this.reportErrorForName(expression, this.getErrorElementName(o, element2, (PsiElement)expression, expressionBranches, searchScope, false));
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void validateStarReference(SqlQueryExpression o, SqlExpression expression, List<? extends SqlExpression> expressionBranches, SearchScope searchScope) {
                SqlTableType sqlType;
                SqlTableExpression sqlTableExpression = o.getTableExpression();
                Object object = sqlType = sqlTableExpression != null ? sqlTableExpression.getSqlType() : null;
                if (sqlType == null || sqlType instanceof SqlTableTypeBase.Empty) {
                    return;
                }
                THashSet unusedNames = new THashSet(sqlType.getColumnCount());
                THashSet usedNames = new THashSet(sqlType.getColumnCount());
                int n = 0;
                int n2 = sqlType.getColumnCount();
                if (n <= n2) {
                    while (true) {
                        void index2;
                        try {
                            PsiElement element2;
                            Intrinsics.checkNotNullExpressionValue((Object)sqlType.getColumnElement((int)index2), (String)"sqlType.getColumnElement(index)");
                            String name = this.getErrorElementName(o, element2, (PsiElement)expression, expressionBranches, searchScope, false);
                            if (name != null) {
                                unusedNames.add((Object)name);
                            } else {
                                usedNames.add((Object)sqlType.getColumnName((int)index2));
                            }
                        }
                        catch (Throwable e) {
                            return;
                        }
                        if (index2 == n2) break;
                        ++index2;
                    }
                }
                if (unusedNames.isEmpty()) {
                    return;
                }
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, SqlBundle.message("subquery.item.star.includes.unused", unusedNames.stream().map(createAnnotationVisitor.validateStarReference.1.INSTANCE).collect(Collectors.joining(", ")), "select " + StringUtil.join((Collection)((Collection)usedNames), (String)", ")), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }

            private final String getErrorElementName(SqlQueryExpression inspected, SqlAsExpression expression, List<? extends SqlExpression> expressionBranches, SearchScope scope) {
                List list = expression.getColumnAliasList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expression.columnAliasList");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SqlDefinition colAlias = (SqlDefinition)element$iv;
                    boolean bl = false;
                    PsiElement psiElement = (PsiElement)colAlias;
                    SqlDefinition sqlDefinition = colAlias;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlDefinition, (String)"colAlias");
                    if (this.getErrorElementName(inspected, psiElement, (PsiElement)sqlDefinition, expressionBranches, scope, true) != null) continue;
                    return null;
                }
                if (this.getErrorElementName(inspected, (PsiElement)expression, (PsiElement)expression, expressionBranches, scope, true) == null) {
                    return null;
                }
                Object object = expression.getNameElement();
                if (object == null || (object = object.getName()) == null) {
                    object = expression.getText();
                }
                return object;
            }

            private final String getErrorElementName(SqlQueryExpression inspected, PsiElement element2, PsiElement originalElement, List<? extends SqlExpression> expressionBranches, SearchScope scope, boolean isAlias) {
                if (SqlUnusedVariableInspection.foundAnyRefs(element2, (Condition<? super SqlElement>)new Condition(this, originalElement, expressionBranches, inspected, isAlias){
                    final /* synthetic */ createAnnotationVisitor.1 this$0;
                    final /* synthetic */ PsiElement $originalElement;
                    final /* synthetic */ List $expressionBranches;
                    final /* synthetic */ SqlQueryExpression $inspected;
                    final /* synthetic */ boolean $isAlias;

                    public final boolean value(SqlElement it2) {
                        SqlElement sqlElement = it2;
                        Intrinsics.checkNotNullExpressionValue((Object)sqlElement, (String)"it");
                        return createAnnotationVisitor.1.access$hasOnlyLocalRefs(this.this$0, sqlElement, this.$originalElement, this.$expressionBranches) ? true : createAnnotationVisitor.1.access$hasOnlyInnerUsages(this.this$0, this.$inspected, (PsiElement)it2, this.$isAlias);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$originalElement = psiElement;
                        this.$expressionBranches = list;
                        this.$inspected = sqlQueryExpression;
                        this.$isAlias = bl;
                    }
                }, scope)) {
                    return null;
                }
                PsiElement psiElement = element2;
                if (!(psiElement instanceof PsiNamedElement)) {
                    psiElement = null;
                }
                PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement;
                return psiNamedElement != null ? psiNamedElement.getName() : null;
            }

            private final void reportErrorForName(SqlExpression expression, String name) {
                if (name == null) {
                    return;
                }
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, SqlBundle.message("subquery.item.never.used", name), true, ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$onTheFly, new LocalQuickFix[0]));
            }

            private final boolean hasOnlyInnerUsages(SqlQueryExpression inspected, PsiElement it2, boolean isAlias) {
                if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)inspected), (PsiElement)it2, (boolean)true)) {
                    return false;
                }
                SqlSelectClause selectClause = inspected.getSelectClause();
                if (selectClause == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)selectClause), (PsiElement)it2, (boolean)true)) {
                    return !isAlias;
                }
                return PsiTreeUtil.getParentOfType((PsiElement)it2, SqlAsExpression.class, (boolean)true, (Class[])new Class[]{SqlSelectClause.class}) == null;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean hasOnlyLocalRefs(SqlElement e, PsiElement originalElement, List<? extends SqlExpression> expressionBranches) {
                SqlExpression b2;
                if (e == originalElement) return true;
                Iterable $this$any$iv = expressionBranches;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv = iterator.next();
                    b2 = (SqlExpression)element$iv;
                    boolean bl = false;
                } while (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)b2), (PsiElement)((PsiElement)e), (boolean)true));
                return true;
            }
            {
                this.$onTheFly = $captured_local_variable$0;
                this.$manager = $captured_local_variable$1;
                this.$dialect = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public static final /* synthetic */ boolean access$isQualifier(createAnnotationVisitor.1 $this, SqlReferenceExpression expression) {
                return $this.isQualifier(expression);
            }

            public static final /* synthetic */ boolean access$hasOnlyLocalRefs(createAnnotationVisitor.1 $this, SqlElement e, PsiElement originalElement, List expressionBranches) {
                return $this.hasOnlyLocalRefs(e, originalElement, expressionBranches);
            }

            public static final /* synthetic */ boolean access$hasOnlyInnerUsages(createAnnotationVisitor.1 $this, SqlQueryExpression inspected, PsiElement it2, boolean isAlias) {
                return $this.hasOnlyInnerUsages(inspected, it2, isAlias);
            }
        };
    }
}

