/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.run.actions.ChooseSessionAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlResolveConfigurable;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.SqlAnnotator;
import com.intellij.sql.inspections.SqlEditorAwareFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.JdbcProcedureCall;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGrantStatement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlRevokeStatement;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlValueReferenceExpression;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveInspection
extends SqlInspectionBase {
    public boolean suppressForPossibleStringLiterals;
    private static final int MAX_COL_NAME_LENGTH = 30;

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(final @NotNull SqlFile file, final @NotNull SqlLanguageDialectEx dialect, final @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (file == null) {
            SqlResolveInspection.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            SqlResolveInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlResolveInspection.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SqlResolveInspection.$$$reportNull$$$0(3);
        }
        final SyntaxTraverser traverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().filter(Conditions.instanceOf(SqlReferenceExpression.class));
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){
            final Map<PsiFile, List<DbDataSource>> dataSources;
            private boolean myRefreshFixInitialized;
            private RefreshSchemaFix myRefreshSchemaFix;
            {
                super(arg0, arg1, arg2);
                this.dataSources = FactoryMap.create(o -> SqlImplUtil.getDataSources((PsiElement)o));
                this.myRefreshFixInitialized = false;
                this.myRefreshSchemaFix = null;
            }

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression re) {
                if (re == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (PsiElement element2 : (SyntaxTraverser)traverser.withRoot((Object)re)) {
                    SqlReferenceExpression o = (SqlReferenceExpression)element2;
                    if (this.shouldNotCheckElement((SqlElement)o)) {
                        return;
                    }
                    SqlReferenceElementType refType = o.getReferenceElementType();
                    ObjectKind type = refType.getTargetKind();
                    if (refType == SqlCompositeElementTypes.SQL_OPTIONAL_REFERENCE || !this.myDialect.shallResolve(o, type)) {
                        return;
                    }
                    if (o instanceof SqlPositionalReference && o.resolve() == null) {
                        Iterator elementToReport = (PsiElement)ObjectUtils.notNull((Object)((SqlPositionalReference)o).getPositionElement(), (Object)o);
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)elementToReport, SqlBundle.message("inspection.message.invalid.column.index", new Object[0]), true, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly, LocalQuickFix.EMPTY_ARRAY));
                        return;
                    }
                    for (SqlReferenceExpression subRef : SqlImplUtil.sqlChildren((PsiElement)o).filter(SqlReferenceExpression.class)) {
                        if (!dialect.isMultiIdReference(subRef)) continue;
                        this.visitSqlReferenceExpression(subRef);
                    }
                    SqlExpression qualifier = o.getQualifierExpression();
                    SqlIdentifier idElement = o.getIdentifier();
                    if (idElement == null) {
                        idElement = SqlImplUtil.getAsterisk((PsiElement)o);
                    }
                    boolean afterIfExists = this.afterIfExistsClause(o);
                    if (qualifier instanceof SqlReferenceExpression) {
                        if (((SqlReferenceExpression)qualifier).resolve() == null) continue;
                        this.checkIdentifier((PsiElement)idElement, afterIfExists);
                        break;
                    }
                    this.checkIdentifier((PsiElement)idElement, afterIfExists);
                }
            }

            private void checkIdentifier(@Nullable PsiElement identifier, boolean afterIfExists) {
                if (identifier == null || afterIfExists) {
                    return;
                }
                this.checkResolve(identifier);
            }

            private boolean afterIfExistsClause(@NotNull SqlReferenceExpression o) {
                PsiElement parent2;
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                return ((parent2 = o.getParent()) instanceof SqlDropStatement || parent2 instanceof SqlAlterStatement || parent2 instanceof SqlAlterInstruction) && FormatterUtil.hasPrecedingSiblingOfType((ASTNode)o.getNode(), (IElementType)SqlCompositeElementTypes.SQL_IF_EXISTS_CLAUSE, (IElementType[])new IElementType[0]);
            }

            public void visitSqlIdentifier(@NotNull SqlIdentifier o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (o.getParent() instanceof SqlRenameToClause) {
                    return;
                }
                this.checkResolve((PsiElement)o);
            }

            public void visitSqlParameter(SqlParameter o) {
            }

            private boolean checkResolve(@Nullable PsiElement o) {
                String name;
                SqlFunctionCallExpression foo;
                boolean isFunction;
                SqlReferenceExpression ref;
                ResolveResult[] results2;
                PsiElement grandPa;
                if (o == null || o.getTextLength() == 0) {
                    return false;
                }
                IElementType firstChildType = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
                if (firstChildType == SqlTokens.SQL_EXTERNAL_PARAM || firstChildType == SqlTokens.SQL_EXTERNAL_PARAM_PREFIX || firstChildType == SqlTokens.SQL_CUSTOM_PARAM_LQUOTE) {
                    return true;
                }
                if (o.getFirstChild() instanceof SqlParameter) {
                    return true;
                }
                if (o.getLastChild() instanceof SqlParameter) {
                    return true;
                }
                PsiElement parent2 = o.getParent();
                PsiElement psiElement = grandPa = parent2 == null ? null : parent2.getParent();
                if (o instanceof SqlIdentifier && ((SqlIdentifier)o).isQuotedIdentifier() && dialect.getDbms().isMysql() && parent2 instanceof SqlReferenceExpression && ((SqlReferenceExpression)parent2).getQualifierExpression() == null && SqlResolveInspection.this.suppressForPossibleStringLiterals) {
                    return true;
                }
                if (parent2 instanceof SqlReferenceExpression && grandPa instanceof SqlDefinition && grandPa instanceof SqlAlterStatement) {
                    return this.checkAlterResolve(o, (SqlDefinition)grandPa);
                }
                PsiElement target = SqlAnnotator.getTargetByIdElement(o);
                if (SqlFileImpl.isUnresolved(target)) {
                    target = null;
                }
                boolean softHighlighting = false;
                if (target instanceof SqlReferenceExpression && (results2 = (ref = (SqlReferenceExpression)target).multiResolve(false)).length == 1 && SqlImplUtil.isMarkedUnresolved(results2[0])) {
                    target = null;
                    softHighlighting = true;
                }
                boolean isStar = "*".equals(o.getText());
                if (target == parent2 && isStar && (!(parent2 instanceof SqlExpression) || SqlType.UNKNOWN == ((SqlExpression)parent2).getSqlType())) {
                    SqlStatement st = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)o, SqlStatement.class);
                    if (st instanceof SqlGrantStatement || st instanceof SqlRevokeStatement) {
                        return true;
                    }
                    this.addDescriptor(this.myManager.createProblemDescriptor(o, SqlBundle.message("inspection.message.unable.to.resolve.in.this.context", new Object[0]), true, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly, new LocalQuickFix[0]));
                    return false;
                }
                if (target instanceof DasSynonym && onTheFly) {
                    DasNamespace namespace = ((DasSynonym)target).getTargetNamespace();
                    if (namespace == null) {
                        return true;
                    }
                    JBIterable dsToIntrospect = JBIterable.from(SqlImplUtil.getDataSources((PsiElement)file)).filter(ds -> {
                        LocalDataSource lds = DbImplUtilCore.getMaybeLocalDataSource(ds);
                        return lds != null && !DataSourceSchemaMapping.isIntrospected(lds.getIntrospectionScope(), namespace);
                    });
                    if (dsToIntrospect.isEmpty()) {
                        return true;
                    }
                    ObjectPath namespacePath = ObjectPaths.of(namespace);
                    IntrospectSchemaFix fix = new IntrospectSchemaFix(dsToIntrospect.map(ds -> Pair.create((Object)ds, (Object)namespacePath)).toList(), namespace.getKind());
                    this.addDescriptor(manager.createProblemDescriptor(o, SqlBundle.message("unable.to.resolve.synonym.target", new Object[0]), (LocalQuickFix)fix, ProblemHighlightType.WEAK_WARNING, onTheFly));
                }
                if (target != null) {
                    return true;
                }
                if (isStar && !SqlImplUtil.isAsteriskRef(parent2)) {
                    return true;
                }
                if (grandPa instanceof SqlValueReferenceExpression) {
                    return true;
                }
                ObjectKind expectedType = parent2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent2).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
                boolean bl = isFunction = expectedType == ObjectKind.ROUTINE;
                if (isFunction && parent2.getParent().getParent() instanceof JdbcProcedureCall) {
                    return true;
                }
                SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
                if (expectedType == ObjectKind.ARGUMENT && (foo = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)api.parents((Object)parent2).skip(3).first(), SqlFunctionCallExpression.class)) != null) {
                    if (foo.getParent() instanceof JdbcProcedureCall) {
                        return true;
                    }
                    name = foo.getNameElement();
                    if (name == null || name.resolve() == null) {
                        return true;
                    }
                }
                String kindName = DbPresentationCore.getPresentableName(expectedType, SqlImplUtil.getSqlDialectSafe(o).getDbms());
                String string = name = o instanceof SqlIdentifier ? ((SqlIdentifier)o).getName() : o.getText();
                String message2 = isFunction ? SqlBundle.message("unknown.function", name) : (expectedType != SqlDbElementType.ANY ? SqlBundle.message("unable.to.resolve.symbol.0.1", kindName, name) : SqlBundle.message("unable.to.resolve.symbol.0", name));
                List<LocalQuickFix> fixes = this.createQuickFixesFor(o, parent2, expectedType);
                ProblemHighlightType highlightType = softHighlighting ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
                this.addDescriptor(this.myManager.createProblemDescriptor(o, message2, true, highlightType, onTheFly, onTheFly ? fixes.toArray(LocalQuickFix.EMPTY_ARRAY) : LocalQuickFix.EMPTY_ARRAY));
                return false;
            }

            private boolean checkAlterResolve(PsiElement o, SqlDefinition def) {
                boolean resolved;
                Object[] elements = SqlImplUtil.getRelatedElements(def);
                boolean bl = resolved = elements.length != 0;
                if (resolved) {
                    PsiElement res2 = (PsiElement)JBIterable.of((Object[])elements).filter(x -> !(x instanceof SqlAlterStatement)).first();
                    boolean bl2 = resolved = res2 != null;
                }
                if (!resolved) {
                    String name = o instanceof SqlIdentifier ? ((SqlIdentifier)o).getName() : o.getText();
                    String message2 = SqlBundle.message("unable.to.resolve.symbol.0.1", def.getKind(), name);
                    List<LocalQuickFix> fixes = this.createQuickFixesFor(o, o.getParent(), def.getKind());
                    this.addDescriptor(this.myManager.createProblemDescriptor(o, message2, true, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly, onTheFly ? fixes.toArray(LocalQuickFix.EMPTY_ARRAY) : LocalQuickFix.EMPTY_ARRAY));
                }
                return resolved;
            }

            private boolean isInsertIntoArg(@NotNull PsiElement o) {
                SqlInsertDmlInstruction insert;
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((insert = (SqlInsertDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)o, SqlInsertDmlInstruction.class, (boolean)true, (Class[])new Class[]{SqlStatement.class})) == null) {
                    return false;
                }
                SqlTableColumnsList list = insert.getColumnsList();
                if (list == null) {
                    return false;
                }
                SqlReferenceExpression reference = list.getTableReference();
                return reference != null && PsiTreeUtil.isAncestor((PsiElement)reference, (PsiElement)o, (boolean)true);
            }

            private boolean addFixesByExpectedType(@NotNull PsiElement o, @Nullable PsiElement parent2, @NotNull ObjectKind expectedType, @NotNull List<LocalQuickFix> result2) {
                block16: {
                    block19: {
                        Object reference;
                        block17: {
                            PsiElement resolveResult;
                            block20: {
                                SqlExpression expression;
                                PsiElement resolve;
                                block18: {
                                    SqlExpression qualifierExpression;
                                    LeafPsiElement beginKeyword;
                                    SqlLanguageDialectEx dialect2;
                                    Dbms dbms;
                                    if (o == null) {
                                        1.$$$reportNull$$$0(4);
                                    }
                                    if (expectedType == null) {
                                        1.$$$reportNull$$$0(5);
                                    }
                                    if (result2 == null) {
                                        1.$$$reportNull$$$0(6);
                                    }
                                    PsiFile containingFile = o.getContainingFile();
                                    boolean isInjected = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).isInjectedFragment(containingFile);
                                    if (expectedType == ObjectKind.TABLE) {
                                        Dbms dbms2;
                                        if (!isInjected) {
                                            result2.add((LocalQuickFix)new AddSqlTableFix(o, false));
                                        }
                                        result2.add((LocalQuickFix)new AddDbTableFix(o));
                                        if (!isInjected && this.isInsertIntoArg(o) && AddSqlTableFix.supportsNonVarTemporaryTables(dbms2 = SqlImplUtil.getSqlDialectSafe(o).getDbms())) {
                                            result2.add((LocalQuickFix)new AddSqlTableFix(o, true));
                                        }
                                        return true;
                                    }
                                    if (expectedType == ObjectKind.VARIABLE) {
                                        if (!isInjected && this.isInsertIntoArg(o)) {
                                            if (SqlImplUtil.getSqlDialectSafe(o).getDbms().isMicrosoft()) {
                                                result2.add((LocalQuickFix)new AddSqlTableFix(o, true));
                                            }
                                            return true;
                                        }
                                        String text2 = DeclareUserVariableFix.wrapVariableText(o);
                                        if (text2 != null) {
                                            result2.add((LocalQuickFix)new DeclareUserVariableFix(o, text2));
                                        }
                                        return true;
                                    }
                                    if (expectedType != ObjectKind.COLUMN) break block16;
                                    if (!(parent2 instanceof SqlReferenceExpression)) {
                                        return true;
                                    }
                                    SqlBlockStatement blockStatement = (SqlBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)parent2, SqlBlockStatement.class);
                                    if (blockStatement != null && DeclarePlVariableFix.supportsPlSql(dbms = (dialect2 = SqlImplUtil.getSqlDialectSafe((PsiElement)blockStatement)).getDbms()) && (beginKeyword = (LeafPsiElement)SqlImplUtil.sqlChildren((PsiElement)blockStatement).filter(LeafPsiElement.class).filter(e -> e.getElementType() == SqlCommonKeywords.SQL_BEGIN).first()) != null) {
                                        result2.add((LocalQuickFix)new DeclarePlVariableFix(o));
                                    }
                                    if (!((qualifierExpression = ((SqlReferenceExpression)parent2).getQualifierExpression()) instanceof SqlReferenceExpression)) break block17;
                                    reference = qualifierExpression.getReference();
                                    PsiElement psiElement = resolve = reference != null ? reference.resolve() : null;
                                    if (!(resolve instanceof DbTable) || ((DbTable)resolve).getKind() != ObjectKind.TABLE) break block18;
                                    result2.add((LocalQuickFix)new AddDbColumnFix(o, (DbTable)resolve));
                                    break block19;
                                }
                                if (!(resolve instanceof SqlAsExpression) || !((expression = ((SqlAsExpression)resolve).getExpression()) instanceof SqlReferenceExpression)) break block19;
                                PsiReference psiReference = expression.getReference();
                                PsiElement psiElement = resolveResult = psiReference != null ? psiReference.resolve() : null;
                                if (!(resolveResult instanceof DbTable) || ((DbTable)resolveResult).getKind() != ObjectKind.TABLE) break block20;
                                result2.add((LocalQuickFix)new AddDbColumnFix(o, (DbTable)resolveResult));
                                break block19;
                            }
                            if (!(resolveResult instanceof SqlCreateTableStatement)) break block19;
                            result2.add((LocalQuickFix)new AddSqlColumnFix(o, (SqlCreateTableStatement)resolveResult));
                            break block19;
                        }
                        reference = (SqlReferenceImpl)ObjectUtils.tryCast((Object)((SqlReferenceExpression)parent2).getReference(), SqlReferenceImpl.class);
                        if (reference != null) {
                            MyResolveContextProcessor processor2 = new MyResolveContextProcessor(((SqlReferenceImpl)reference).getReferenceName(), this.myDialect, this.dataSources.get(parent2.getContainingFile()), parent2);
                            if (((SqlReferenceImpl)reference).initExpectedTargetTypes(processor2)) {
                                ((SqlReferenceImpl)reference).processResolveVariants(processor2);
                            }
                            for (DbTable dbTable : processor2.dbTables) {
                                if (dbTable.getKind() != ObjectKind.TABLE) continue;
                                result2.add((LocalQuickFix)new AddDbColumnFix(o, dbTable));
                            }
                            for (SqlCreateTableStatement sqlCreateTableStatement : processor2.sqlTables) {
                                result2.add((LocalQuickFix)new AddSqlColumnFix(o, sqlCreateTableStatement));
                            }
                        }
                    }
                    return true;
                }
                return false;
            }

            private void addRefreshFix(@NotNull List<LocalQuickFix> result2) {
                if (result2 == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (!this.myRefreshFixInitialized) {
                    ObjectPath path;
                    PsiFile topLevelFile;
                    VirtualFile vfile;
                    this.myRefreshFixInitialized = true;
                    Project project = file.getProject();
                    JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, vfile = (topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file)).getVirtualFile());
                    ObjectPath objectPath = path = console == null ? null : console.getCurrentNamespace();
                    if (path == null) {
                        return;
                    }
                    DbDataSource dbDataSource = DbPsiFacade.getInstance(project).findDataSource(console.getDataSource().getUniqueId());
                    LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource(dbDataSource);
                    if (localDataSource == null) {
                        return;
                    }
                    DasObject namespace = (DasObject)QNameUtil.findByPath(console.getDataSource().getModel(), path).first();
                    if (namespace == null) {
                        return;
                    }
                    this.myRefreshSchemaFix = new RefreshSchemaFix(localDataSource, namespace);
                }
                if (this.myRefreshSchemaFix != null) {
                    result2.add((LocalQuickFix)this.myRefreshSchemaFix);
                }
            }

            private void addIntrospectFixesForQualifier(@Nullable PsiElement element2, @NotNull List<LocalQuickFix> result2) {
                if (result2 == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (!(element2 instanceof SqlReferenceExpression)) {
                    return;
                }
                SqlExpression qualifierExpression = ((SqlReferenceExpression)element2).getQualifierExpression();
                if (!(qualifierExpression instanceof SqlReferenceExpression)) {
                    return;
                }
                SqlIdentifier qualifierIdentifier = ((SqlReferenceExpression)qualifierExpression).getIdentifier();
                if (qualifierIdentifier == null) {
                    return;
                }
                PsiElement qualifier = ((SqlReferenceExpression)qualifierExpression).resolve();
                if (!(qualifier instanceof DasObject)) {
                    return;
                }
                ObjectKind kind = ((DasObject)qualifier).getKind();
                if (kind == ObjectKind.SCHEMA || kind == ObjectKind.DATABASE) {
                    this.addIntrospectFixes((PsiElement)qualifierIdentifier, (PsiElement)qualifierExpression, result2);
                }
            }

            @NotNull
            private List<LocalQuickFix> createQuickFixesFor(@NotNull PsiElement o, @Nullable PsiElement parent2, @NotNull ObjectKind expectedType) {
                boolean addGenericFixes;
                if (o == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (expectedType == null) {
                    1.$$$reportNull$$$0(10);
                }
                ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
                VirtualFile file2 = SqlImplUtil.getTopLevelFile(o.getContainingFile());
                if (file2 != null && JdbcConsoleProvider.isItPossibleToAttachConsoleTo(file2)) {
                    result2.add((LocalQuickFix)new ChooseSchemaFix());
                }
                this.addRefreshFix(result2);
                if (!this.addFixesByExpectedType(o, parent2, expectedType, result2)) {
                    this.addIntrospectFixes(o, parent2, result2);
                }
                this.addIntrospectFixesForQualifier(parent2, result2);
                boolean bl = addGenericFixes = expectedType != ObjectKind.COLUMN && file2 != null && !(file2.getFileSystem() instanceof NonPhysicalFileSystem) && !DbSrcUtilsCore.isDbSrcFile(file2) && !DbVFSUtils.isConsoleFile(file2);
                if (addGenericFixes) {
                    result2.add((LocalQuickFix)new GoToResolutionScopesFix());
                    if (onTheFly && JdbcConsoleProvider.getValidConsole(o.getProject(), file2) == null) {
                        result2.add((LocalQuickFix)new AttachSessionFix());
                    }
                }
                ArrayList<LocalQuickFix> arrayList = result2;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(11);
                }
                return arrayList;
            }

            private void addIntrospectFixes(@NotNull PsiElement o, @Nullable PsiElement parent2, @NotNull List<LocalQuickFix> result2) {
                String name;
                List candidates2;
                SqlReferenceImpl ref;
                if (o == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(13);
                }
                SqlReferenceImpl sqlReferenceImpl = ref = parent2 instanceof SqlReferenceExpression ? (SqlReferenceImpl)ObjectUtils.tryCast((Object)parent2.getReference(), SqlReferenceImpl.class) : null;
                if (ref == null) {
                    return;
                }
                MyResolveContextProcessor processor2 = new MyResolveContextProcessor(ref.getReferenceName(), this.myDialect, this.dataSources.get(parent2.getContainingFile()), parent2);
                ref.initExpectedTargetTypes(processor2);
                boolean schemaExpected = processor2.isExpected(ObjectKind.SCHEMA);
                boolean dbExpected = processor2.isExpected(ObjectKind.DATABASE);
                if (!schemaExpected && !dbExpected) {
                    return;
                }
                SqlReferenceExpression qualifier = (SqlReferenceExpression)ObjectUtils.tryCast((Object)((SqlReferenceExpression)parent2).getQualifierExpression(), SqlReferenceExpression.class);
                Object[] resolved = qualifier == null ? ResolveResult.EMPTY_ARRAY : qualifier.multiResolve(false);
                JBIterable namespaces2 = JBIterable.empty();
                if (resolved.length == 0) {
                    SqlFile file2 = (SqlFile)ObjectUtils.tryCast((Object)o.getContainingFile(), SqlFile.class);
                    if (file2 != null) {
                        SqlImportState checker = SqlDialectImplUtilCore.getImportCheckerAt(file2, o);
                        for (DbDataSource source : processor2.getDataSources()) {
                            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)source.getDelegate().getModel(), BasicModel.class);
                            if (model == null) continue;
                            namespaces2 = namespaces2.append((Iterable)((JBTreeTraverser)model.traverser().expand(SqlFileImpl.importedCondition(checker, source))).filter(BasicMateNamespace.class).transform(n -> Pair.create((Object)source, (Object)n)));
                        }
                    }
                } else {
                    namespaces2 = JBIterable.of((Object[])resolved).map(ResolveResult::getElement).filter(DbElement.class).flatten(e -> {
                        BasicElement object = (BasicElement)ObjectUtils.tryCast((Object)e.getDelegate(), BasicElement.class);
                        DbDataSource source = e.getDataSource();
                        return object == null ? JBIterable.empty() : object.getChildren().filter(BasicMateNamespace.class).map(n -> Pair.create((Object)source, (Object)n));
                    });
                }
                if (!(candidates2 = namespaces2.filter(arg_0 -> 1.lambda$addIntrospectFixes$8(name = ref.getReferenceName(), dialect, schemaExpected, dbExpected, arg_0)).map(p2 -> Pair.create((Object)((DbDataSource)p2.first), (Object)ObjectPaths.of((DasObject)p2.second))).toList()).isEmpty()) {
                    ObjectKind kind = dbExpected && schemaExpected ? ObjectKind.NONE : (dbExpected ? ObjectKind.DATABASE : ObjectKind.SCHEMA);
                    result2.add((LocalQuickFix)new IntrospectSchemaFix(candidates2, kind));
                }
            }

            private static /* synthetic */ boolean lambda$addIntrospectFixes$8(String name, SqlLanguageDialectEx dialect2, boolean schemaExpected, boolean dbExpected, Pair n) {
                return !DataSourceSchemaMapping.isIntrospected(DbImplUtilCore.getIntrospectionScope((DasDataSource)n.first), (DasObject)n.second) && DasUtil.nameEqual((DasObject)n.second, name, dialect2) && (((BasicMateNamespace)n.second).getKind() == ObjectKind.SCHEMA && schemaExpected || ((BasicMateNamespace)n.second).getKind() == ObjectKind.DATABASE && dbExpected);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 11: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 11: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "re";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 9: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 5: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedType";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$1";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createQuickFixesFor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitSqlReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "afterIfExistsClause";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitSqlIdentifier";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isInsertIntoArg";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "addFixesByExpectedType";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "addRefreshFix";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "addIntrospectFixesForQualifier";
                        break;
                    }
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "createQuickFixesFor";
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 12: 
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "addIntrospectFixes";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 11: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void setVariable(TemplateImpl copy, String valueString, int index2, String varName, boolean stop) {
        Variable variable = (Variable)copy.getVariables().get(index2);
        assert (varName.equals(variable.getName()));
        variable.setDefaultValueString("\"" + valueString + "\"");
        variable.setAlwaysStopAt(stop);
    }

    @NotNull
    private static String getTypeText(SqlType type, Dbms dbms) {
        String typeName;
        String string = typeName = type == null ? "int" : type.getDisplayName();
        if ((dbms.isOracle() || dbms.isMysql()) && "varchar".equalsIgnoreCase(typeName)) {
            String string2 = typeName + "(255)";
            if (string2 == null) {
                SqlResolveInspection.$$$reportNull$$$0(4);
            }
            return string2;
        }
        String string3 = typeName;
        if (string3 == null) {
            SqlResolveInspection.$$$reportNull$$$0(5);
        }
        return string3;
    }

    private static List<SqlType> mergeTypes(Collection<Collection<SqlType>> types) {
        ArrayList<SqlType> result2 = new ArrayList<SqlType>();
        for (Collection<SqlType> typeList : types) {
            if (result2.isEmpty()) {
                result2.addAll(typeList);
                continue;
            }
            int i2 = 0;
            for (SqlType type : typeList) {
                if (i2 < result2.size()) {
                    result2.set(i2, SqlResolveInspection.merge((SqlType)result2.get(i2), type));
                }
                ++i2;
            }
        }
        return result2;
    }

    private static SqlType merge(SqlType type, SqlType type1) {
        if (type == null) {
            return type1;
        }
        if (type1 == null) {
            return type;
        }
        return type == type1 ? type : (SqlFunctionsUtil.isAssignable(type, type1) ? type1 : type);
    }

    private static void collectColumnTypes(SqlStatement statement, Collection<Collection<SqlType>> types, List<Boolean> nullableFlags) {
        SqlImplUtil.sqlTraverser((PsiElement)statement).filter(SqlValuesExpression.class).forEach(e -> e.getExpressions().filter(SqlParenthesizedExpression.class).forEach(pe -> {
            types.add(ContainerUtil.map((Collection)pe.getExpressionList(), el -> el.getSqlType()));
            List nullableState = ContainerUtil.map((Collection)pe.getExpressionList(), ex -> ex instanceof SqlLiteralExpression && "null".equals(ex.getText()));
            if (nullableFlags.isEmpty()) {
                nullableFlags.addAll(nullableState);
            } else {
                for (int i2 = 0; i2 < nullableFlags.size(); ++i2) {
                    if (i2 >= nullableState.size()) continue;
                    nullableFlags.set(i2, (Boolean)nullableFlags.get(i2) != false || (Boolean)nullableState.get(i2) != false);
                }
            }
        }));
        SqlQueryExpression queryExpression = SqlResolveInspection.getQueryExpression(statement);
        if (queryExpression == null) {
            return;
        }
        SqlType type = queryExpression.getSqlType();
        if (type instanceof SqlTableType && !(type instanceof SqlTableTypeBase.Empty)) {
            int columnCount = ((SqlTableType)type).getColumnCount();
            ArrayList<SqlType> allTypes = new ArrayList<SqlType>(columnCount);
            for (int i2 = 0; i2 < columnCount; ++i2) {
                try {
                    SqlType columnType = ((SqlTableType)type).getColumnType(i2);
                    allTypes.add(columnType);
                    continue;
                }
                catch (Exception e2) {
                    allTypes.add(null);
                }
            }
            types.add(allTypes);
        }
    }

    @Nullable
    private static SqlQueryExpression getQueryExpression(SqlStatement statement) {
        if (!(statement instanceof SqlInsertStatement)) {
            return null;
        }
        SqlInsertDmlInstruction insert = (SqlInsertDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)statement, SqlInsertDmlInstruction.class);
        if (insert == null) {
            return null;
        }
        SqlQueryExpression queryExpression = insert.getQueryExpression();
        if (queryExpression == null) {
            return null;
        }
        return queryExpression;
    }

    private static void collectColumnNames(@NotNull PsiElement element2, @NotNull SqlStatement statement, @NotNull Collection<String> columnsNames) {
        if (element2 == null) {
            SqlResolveInspection.$$$reportNull$$$0(6);
        }
        if (statement == null) {
            SqlResolveInspection.$$$reportNull$$$0(7);
        }
        if (columnsNames == null) {
            SqlResolveInspection.$$$reportNull$$$0(8);
        }
        SqlQueryExpression queryExpression = SqlResolveInspection.getQueryExpression(statement);
        String defaultName = "col";
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element2);
        Project project = element2.getProject();
        if (queryExpression != null) {
            SqlType type = queryExpression.getSqlType();
            if (type instanceof SqlTableType && !(type instanceof SqlTableTypeBase.Empty)) {
                for (int i2 = 0; i2 < ((SqlTableType)type).getColumnCount(); ++i2) {
                    columnsNames.add(SqlResolveInspection.guessColumnName(columnsNames, defaultName, dialect, project, (SqlTableType)type, i2));
                }
            }
            return;
        }
        SqlLanguageDialectEx sqlLanguage = SqlImplUtil.getSqlDialectSafe((PsiElement)statement);
        CasingProvider casingProvider = SqlImplUtil.getCasingProvider(sqlLanguage, SqlImplUtil.getDataSources((PsiElement)statement));
        SqlAsExpression asExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlAsExpression.class);
        JBIterable iterable = SqlImplUtil.sqlTraverser((PsiElement)statement).filter(SqlReferenceExpression.class);
        for (SqlReferenceExpression e : iterable) {
            ObjectKind type = e.getReferenceElementType().getTargetKind();
            SqlIdentifier identifier = e.getIdentifier();
            if (type != ObjectKind.COLUMN || identifier == null || e.resolve() != null && !SqlImplUtil.isMarkedUnresolved(e)) continue;
            SqlReferenceExpression qualifier = (SqlReferenceExpression)ObjectUtils.tryCast((Object)e.getQualifierExpression(), SqlReferenceExpression.class);
            PsiElement parent2 = element2.getParent();
            if (asExpression != null && qualifier != null && !asExpression.equals(qualifier.resolve()) && (!(parent2 instanceof DasNamed) || !new NameChecker(qualifier, sqlLanguage, casingProvider).checkName((DasNamed)parent2, false))) continue;
            columnsNames.add(identifier.getText());
        }
    }

    @Nullable
    private static String computeNameFromReference(@Nullable SqlReferenceExpression expression) {
        if (expression == null) {
            return null;
        }
        SqlExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression != null) {
            StringBuilder fullName = new StringBuilder(expression.getName());
            expression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)qualifierExpression, SqlReferenceExpression.class);
            while (expression != null) {
                fullName.insert(0, expression.getName() + "_");
                expression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)expression.getQualifierExpression(), SqlReferenceExpression.class);
            }
            return fullName.toString();
        }
        return null;
    }

    private static String getNameFromElement(@Nullable PsiElement element2, boolean allowUnqualifiedRefs) {
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof SqlReferenceExpression) {
            String nameFromReference = SqlResolveInspection.computeNameFromReference((SqlReferenceExpression)element2);
            return nameFromReference == null && allowUnqualifiedRefs ? ((SqlReferenceExpression)element2).getName() : nameFromReference;
        }
        if (element2 instanceof SqlFunctionCallExpression) {
            SqlReferenceExpression nameElement = ((SqlFunctionCallExpression)element2).getNameElement();
            if (nameElement == null) {
                return null;
            }
            String func_Name = nameElement.getName();
            StringBuilder nameBuilder = new StringBuilder(func_Name);
            SqlExpressionList list = ((SqlFunctionCallExpression)element2).getParameterList();
            if (list != null) {
                for (SqlExpression expression : list.getExpressionList()) {
                    String innerName = SqlResolveInspection.getNameFromElement((PsiElement)expression, true);
                    if (innerName == null) continue;
                    nameBuilder.insert(0, innerName + "_");
                }
            }
            return nameBuilder.toString();
        }
        SqlFunctionCallExpression functionCallExpression = (SqlFunctionCallExpression)SqlImplUtil.sqlTraverser(element2).filter(SqlFunctionCallExpression.class).first();
        if (functionCallExpression != null) {
            return SqlResolveInspection.getNameFromElement((PsiElement)functionCallExpression, true);
        }
        return SqlResolveInspection.getNameFromElement((PsiElement)SqlImplUtil.sqlTraverser(element2).filter(SqlReferenceExpression.class).first(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static String guessColumnName(@NotNull Collection<String> columnsNames, String defaultName, SqlLanguageDialectEx dialect, Project project, SqlTableType type, int i2) {
        block10: {
            String columnName;
            block11: {
                String string;
                if (columnsNames == null) {
                    SqlResolveInspection.$$$reportNull$$$0(9);
                }
                try {
                    columnName = type.getColumnName(i2);
                    if (columnName == null) break block10;
                    if (!columnsNames.contains(columnName) && StringUtil.indexOfAny((String)columnName, (String)"(\r\n") < 0) break block11;
                    try {
                        PsiElement element2 = type.getColumnElement(i2);
                        String nameFromElement = SqlResolveInspection.getNameFromElement(element2, false);
                        if (nameFromElement == null) break block11;
                        string = SqlResolveInspection.disambiguateAndQuote(columnsNames, nameFromElement, dialect, project);
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break block11;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                    break block10;
                }
                if (string == null) {
                    SqlResolveInspection.$$$reportNull$$$0(10);
                }
                return string;
            }
            columnName = StringUtil.replace((String)columnName, (String)"\r", (String)" ");
            if ((columnName = StringUtil.replace((String)columnName, (String)"\n", (String)" ")).length() <= 30) {
                String string = SqlResolveInspection.disambiguateAndQuote(columnsNames, columnName, dialect, project);
                if (string == null) {
                    SqlResolveInspection.$$$reportNull$$$0(11);
                }
                return string;
            }
        }
        String string = SqlResolveInspection.disambiguateAndQuote(columnsNames, defaultName, dialect, project);
        if (string == null) {
            SqlResolveInspection.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static String disambiguateAndQuote(@NotNull Collection<String> columnsNames, String columnName, SqlLanguageDialectEx dialect, Project project) {
        if (columnsNames == null) {
            SqlResolveInspection.$$$reportNull$$$0(13);
        }
        Object finalName = columnName;
        int localIdx = 0;
        while (columnsNames.contains(finalName)) {
            finalName = columnName + ++localIdx;
        }
        return dialect.quoteIdentifier(project, (String)finalName, ObjectKind.COLUMN);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(SqlBundle.message("sql.resolve.inspection.checkbox.suppress.for.quoted", new Object[0]), (InspectionProfileEntry)this, "suppressForPossibleStringLiterals");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "guessColumnName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectColumnNames";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "guessColumnName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "disambiguateAndQuote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolveContextProcessor
    extends SqlScopeProcessorBase {
        final Set<DbTable> dbTables;
        final Set<SqlCreateTableStatement> sqlTables;

        MyResolveContextProcessor(@NotNull String referenceName, @NotNull SqlLanguageDialectEx dialect, @NotNull List<DbDataSource> dataSources, @Nullable PsiElement place) {
            if (referenceName == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(0);
            }
            if (dialect == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(1);
            }
            if (dataSources == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(2);
            }
            super(referenceName, dialect, dataSources, place);
            this.dbTables = new HashSet<DbTable>();
            this.sqlTables = new HashSet<SqlCreateTableStatement>();
        }

        public boolean isResultEmpty() {
            return this.dbTables.isEmpty() && this.sqlTables.isEmpty();
        }

        public void setResolveContext(@Nullable PsiElement context) {
            if (context == null) {
                return;
            }
            if (context instanceof SqlDmlInstruction) {
                SqlExpression targetExpression = ((SqlDmlInstruction)context).getTargetExpression();
                this.processReference(targetExpression == null ? null : targetExpression.getReference());
            }
            PsiElement contextParent = context.getParent();
            PsiRecursiveElementVisitor visitor2 = new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (o instanceof SqlReferenceExpression) {
                        this.processReference(o.getReference());
                        return;
                    }
                    super.visitElement(o);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor$1", "visitElement"));
                }
            };
            if (contextParent instanceof SqlQueryExpression) {
                SqlTableExpression tableExpression = ((SqlQueryExpression)contextParent).getTableExpression();
                if (tableExpression != null) {
                    tableExpression.accept((PsiElementVisitor)visitor2);
                }
            } else if (contextParent instanceof SqlTableColumnsList) {
                SqlReferenceExpression tableReference = ((SqlTableColumnsList)contextParent).getTableReference();
                this.processReference((PsiReference)(tableReference == null ? null : tableReference.getReference()));
            } else if (contextParent instanceof SqlTableExpression) {
                contextParent.accept((PsiElementVisitor)visitor2);
            } else if (contextParent instanceof SqlAlterStatement) {
                SqlReferenceExpression reference = ((SqlAlterStatement)contextParent).getAlterTargetReference();
                this.processReference((PsiReference)(reference == null ? null : reference.getReference()));
            } else if (context instanceof PsiObject) {
                this.processObject(context);
            }
        }

        private void processReference(@Nullable PsiReference ref) {
            this.processObject(ref != null ? ref.resolve() : null);
        }

        private void processObject(PsiElement resolve) {
            if (resolve instanceof DbTable) {
                this.dbTables.add((DbTable)resolve);
            } else if (resolve instanceof SqlCreateTableStatement) {
                this.sqlTables.add((SqlCreateTableStatement)resolve);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "referenceName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialect";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSources";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddDbColumnFix
    extends SqlEditorAwareFix<PsiElement> {
        final ObjectPath myTable;
        final String myColumnName;

        AddDbColumnFix(@NotNull PsiElement o, @NotNull DbTable table) {
            if (o == null) {
                AddDbColumnFix.$$$reportNull$$$0(0);
            }
            if (table == null) {
                AddDbColumnFix.$$$reportNull$$$0(1);
            }
            super(o);
            this.myColumnName = o instanceof SqlIdentifier ? ((SqlIdentifier)o).getName() : o.getText();
            this.myTable = ObjectPaths.of(table);
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message("intention.name.add.column", this.myColumnName, this.myTable.getName());
            if (string == null) {
                AddDbColumnFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element2, @Nullable Editor editor) {
            DbDataSourceImpl dataSource2;
            if (project == null) {
                AddDbColumnFix.$$$reportNull$$$0(3);
            }
            if (element2 == null) {
                AddDbColumnFix.$$$reportNull$$$0(4);
            }
            if ((dataSource2 = (DbDataSourceImpl)DbImplUtilCore.getForcedDataSource(element2.getContainingFile())) == null) {
                return;
            }
            DbElement table = DbSqlUtilCore.findElement(dataSource2, this.myTable);
            if (table == null || table.getKind() != ObjectKind.TABLE) {
                return;
            }
            DdlActions.AddColumnAction.perform((DbTable)table, null, element2.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddDbTableFix
    extends SqlEditorAwareFix<PsiElement> {
        AddDbTableFix(@Nullable PsiElement o) {
            super(o);
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message("intention.name.add.table", new Object[0]);
            if (string == null) {
                AddDbTableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element2, @Nullable Editor editor) {
            List strings;
            if (project == null) {
                AddDbTableFix.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                AddDbTableFix.$$$reportNull$$$0(2);
            }
            DbDataSource dataSource2 = DbImplUtilCore.getForcedDataSource(element2.getContainingFile());
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class);
            List list = strings = statement == null ? ContainerUtil.emptyList() : new ArrayList();
            if (statement != null) {
                SqlResolveInspection.collectColumnNames(element2, statement, strings);
            }
            if (dataSource2 != null) {
                AddDbTableFix.showDialog(dataSource2, element2, strings);
            } else if (editor != null) {
                ArrayList<PersistenceConsoleProvider.Runner> runners = new ArrayList<PersistenceConsoleProvider.Runner>();
                for (DbDataSource source : DbPsiFacade.getInstance(project).getDataSources()) {
                    runners.add(DatabaseRunners.createDataSourceRunner(source, () -> AddDbTableFix.showDialog(source, element2, strings)));
                }
                RunQueryInConsoleIntentionAction.chooseAndRunRunners(SqlBundle.message("data.source.chooser.title", new Object[0]), runners, editor, null);
            }
        }

        private static void showDialog(@NotNull DbDataSource source, @NotNull PsiElement element2, @NotNull Collection<String> strings) {
            if (source == null) {
                AddDbTableFix.$$$reportNull$$$0(3);
            }
            if (element2 == null) {
                AddDbTableFix.$$$reportNull$$$0(4);
            }
            if (strings == null) {
                AddDbTableFix.$$$reportNull$$$0(5);
            }
            DdlActions.AddTableAction.showAddTableDialogAndRun(null, DbRefactoringHelper.createContext(source, element2, false), element2.getText(), strings);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showDialog";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DeclareUserVariableFix
    extends SqlEditorAwareFix<PsiElement> {
        private final String myText;

        protected DeclareUserVariableFix(@Nullable PsiElement element2, @NotNull String text2) {
            if (text2 == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(0);
            }
            super(element2);
            this.myText = text2;
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message("intention.name.declare.variable", new Object[0]);
            if (string == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element2, @Nullable Editor editor) {
            SqlStatement statement;
            if (project == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(2);
            }
            if (element2 == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(3);
            }
            if ((statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class)) == null) {
                return;
            }
            SqlStatement statementFromText = SqlPsiElementFactory.createStatementFromText(this.myText, SqlImplUtil.getSqlDialectSafe(element2), project, element2);
            assert (statementFromText != null);
            statement.getParent().addBefore((PsiElement)statementFromText, (PsiElement)statement);
        }

        @NotNull
        static String getTypeString(@NotNull PsiElement element2) {
            IElementType sign;
            SqlExpression expression;
            SqlElement value2;
            SqlSetAssignment assignment;
            if (element2 == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(4);
            }
            if ((assignment = (SqlSetAssignment)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlSetAssignment.class)) != null && (value2 = assignment.getRValue()) != null && (expression = SqlPsiElementFactory.createExpressionFromText(value2.getText(), SqlImplUtil.getSqlDialectSafe(element2), element2)) != null) {
                String string = expression.getSqlType().getDisplayName();
                if (string == null) {
                    DeclareUserVariableFix.$$$reportNull$$$0(5);
                }
                return string;
            }
            SqlBinaryExpression binary = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlBinaryExpression.class, (boolean)true, (Class[])new Class[]{SqlStatement.class});
            if (binary != null && DeclareUserVariableFix.isSuitableBinary(sign = binary.getOpSign())) {
                SqlExpression left = binary.getLOperand();
                SqlExpression right = binary.getROperand();
                if (right != null) {
                    SqlExpression other;
                    SqlExpression owner = PsiTreeUtil.isAncestor((PsiElement)left, (PsiElement)element2, (boolean)true) ? left : right;
                    SqlExpression sqlExpression = other = owner == left ? right : left;
                    if (owner.getText().equals(element2.getText())) {
                        String string = other.getSqlType().getDisplayName();
                        if (string == null) {
                            DeclareUserVariableFix.$$$reportNull$$$0(6);
                        }
                        return string;
                    }
                }
            }
            return "int";
        }

        private static boolean isSuitableBinary(IElementType sign) {
            return sign == SqlCommonTokens.SQL_OP_EQ || sign == SqlCommonTokens.SQL_OP_EQEQ || sign == SqlCommonTokens.SQL_OP_NEQ;
        }

        @Nullable
        static String wrapVariableText(PsiElement o) {
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(o);
            Dbms dbms = dialect.getDbms();
            String name = o.getText();
            String type = DeclareUserVariableFix.getTypeString(o);
            if (dbms.isMicrosoft() || dbms.isDb2() || dbms.isSybase()) {
                return "declare " + name + " " + type + ";";
            }
            if ("OracleSqlPlus".equals(dialect.getID())) {
                return "define " + name + ";";
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$DeclareUserVariableFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$DeclareUserVariableFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DeclarePlVariableFix
    extends SqlEditorAwareFix<PsiElement> {
        protected DeclarePlVariableFix(@Nullable PsiElement element2) {
            super(element2);
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message("intention.name.declare.pl.variable", new Object[0]);
            if (string == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element2, @Nullable Editor editor) {
            if (project == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(2);
            }
            SqlBlockStatement blockStatement = (SqlBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlBlockStatement.class);
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element2);
            SqlStatement statement = SqlPsiElementFactory.createStatementFromText(DeclarePlVariableFix.createTemplate(dialect.getDbms(), element2.getText(), DeclareUserVariableFix.getTypeString(element2)), dialect, project, element2);
            SqlVariableDefinition newDefinition = (SqlVariableDefinition)SqlImplUtil.sqlTraverser((PsiElement)statement).filter(SqlVariableDefinition.class).first();
            assert (newDefinition != null);
            SqlVariableDefinition variableDefinition = (SqlVariableDefinition)SqlImplUtil.sqlChildren((PsiElement)blockStatement).filter(SqlVariableDefinition.class).first();
            if (variableDefinition != null) {
                variableDefinition.getParent().addBefore((PsiElement)newDefinition, (PsiElement)variableDefinition);
                DeclarePlVariableFix.addSemiAndNewlineBefore(project, dialect, (PsiElement)variableDefinition);
                return;
            }
            LeafPsiElement beginKeyword = DeclarePlVariableFix.findChildToken(blockStatement, SqlCommonKeywords.SQL_BEGIN);
            assert (beginKeyword != null);
            LeafPsiElement existingDeclare = DeclarePlVariableFix.findChildToken(blockStatement, SqlCommonKeywords.SQL_DECLARE);
            if (existingDeclare == null) {
                LeafPsiElement declareKeyword = (LeafPsiElement)SqlImplUtil.sqlTraverser((PsiElement)statement).filter(LeafPsiElement.class).filter(e -> e.getElementType() == SqlCommonKeywords.SQL_DECLARE).first();
                assert (declareKeyword != null);
                beginKeyword.getParent().addBefore((PsiElement)declareKeyword, (PsiElement)beginKeyword);
            }
            beginKeyword.getParent().addBefore((PsiElement)newDefinition, (PsiElement)beginKeyword);
            DeclarePlVariableFix.addSemiAndNewlineBefore(project, dialect, (PsiElement)beginKeyword);
        }

        private static void addSemiAndNewlineBefore(@NotNull Project project, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement element2) {
            if (project == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(3);
            }
            if (dialect == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(4);
            }
            if (element2 == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(5);
            }
            element2.getParent().addBefore(SqlPsiElementFactory.createLeafFromText(project, dialect, ";"), element2);
            element2.getParent().addBefore(SqlPsiElementFactory.createLeafFromText(project, dialect, "\n"), element2);
        }

        private static LeafPsiElement findChildToken(SqlBlockStatement blockStatement, SqlTokenType tokenType) {
            return (LeafPsiElement)SqlImplUtil.sqlChildren((PsiElement)blockStatement).filter(LeafPsiElement.class).filter(e -> e.getElementType() == tokenType).first();
        }

        static boolean supportsPlSql(@NotNull Dbms dbms) {
            if (dbms == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(6);
            }
            return dbms.isPostgres() || dbms.isOracle();
        }

        private static String createTemplate(Dbms dbms, String name, String type) {
            String common = "DECLARE\n  " + name + " " + type + ";\nBEGIN\nEND";
            if (dbms.isPostgres()) {
                return "DO $$\n" + common + " $$;";
            }
            if (dbms.isOracle()) {
                return common + "/";
            }
            if (dbms.isDb2()) {
                return common;
            }
            throw new NotImplementedError("Not implemented for DBMS: " + dbms.getDisplayName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$DeclarePlVariableFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$DeclarePlVariableFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addSemiAndNewlineBefore";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "supportsPlSql";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddSqlTableFix
    extends SqlEditorAwareFix<PsiElement> {
        private final boolean myTemporary;

        AddSqlTableFix(PsiElement o, boolean temporary) {
            super(o);
            this.myTemporary = temporary;
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message(this.myTemporary ? "quickfix.name.create.table.declaration" : "quickfix.name.create.table.definition", new Object[0]);
            if (string == null) {
                AddSqlTableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element2, @Nullable Editor editor) {
            if (project == null) {
                AddSqlTableFix.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                AddSqlTableFix.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                return;
            }
            SqlStatement placeForInsertBefore = (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element2, SqlStatement.class);
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class);
            if (statement == null || placeForInsertBefore == null) {
                return;
            }
            LinkedHashSet<String> columnsNames = new LinkedHashSet<String>();
            ArrayList<Collection<SqlType>> columnsTypes = new ArrayList<Collection<SqlType>>();
            ArrayList<Boolean> nullableFlags = new ArrayList<Boolean>();
            SqlResolveInspection.collectColumnNames(element2, statement, columnsNames);
            SqlResolveInspection.collectColumnTypes(statement, columnsTypes, nullableFlags);
            List<SqlType> typesMerged = SqlResolveInspection.mergeTypes(columnsTypes);
            int offset = placeForInsertBefore.getTextRange().getStartOffset();
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = this.getTemplate(templateManager, element2, columnsNames, typesMerged, nullableFlags);
            if (template == null) {
                return;
            }
            editor.getCaretModel().moveToOffset(offset);
            templateManager.startTemplate(editor, template);
        }

        @Nullable
        private Template getTemplate(@NotNull TemplateManager templateManager, @NotNull PsiElement element2, @NotNull Collection<String> columnsNames, @NotNull List<SqlType> typesMerged, @NotNull List<Boolean> nullableFlags) {
            if (templateManager == null) {
                AddSqlTableFix.$$$reportNull$$$0(3);
            }
            if (element2 == null) {
                AddSqlTableFix.$$$reportNull$$$0(4);
            }
            if (columnsNames == null) {
                AddSqlTableFix.$$$reportNull$$$0(5);
            }
            if (typesMerged == null) {
                AddSqlTableFix.$$$reportNull$$$0(6);
            }
            if (nullableFlags == null) {
                AddSqlTableFix.$$$reportNull$$$0(7);
            }
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element2);
            if (columnsNames.isEmpty() && !this.myTemporary) {
                TemplateImpl template = TemplateSettings.getInstance().getTemplate("tab", "SQL");
                if (template == null) {
                    return null;
                }
                TemplateImpl copy = template.copy();
                String s2 = copy.getString();
                if (!s2.endsWith("\n")) {
                    copy.setString(s2 + "\n");
                }
                SqlResolveInspection.setVariable(copy, element2.getText(), 0, "table", false);
                return copy;
            }
            Template template = templateManager.createTemplate("", "");
            template.setToReformat(true);
            template.addTextSegment((String)(this.myTemporary ? AddSqlTableFix.createTemporaryTableStart(element2.getText(), dialect.getDbms()) : "create table " + element2.getText()) + " (\n");
            int size = columnsNames.size();
            int i2 = 0;
            for (String name : columnsNames) {
                template.addTextSegment(name);
                template.addTextSegment(" ");
                template.addVariable("type" + i2, (Expression)new ConstantNode(i2 < typesMerged.size() ? SqlResolveInspection.getTypeText(typesMerged.get(i2), dialect.getDbms()) : "int"), true);
                if (!dialect.getDbms().isClickHouse()) {
                    template.addTextSegment(" ");
                    template.addVariable("not_null" + i2, (Expression)new ConstantNode(i2 < nullableFlags.size() && nullableFlags.get(i2) != false ? "null" : "not null"), true);
                }
                if (i2 != size - 1) {
                    template.addTextSegment(",");
                }
                template.addTextSegment("\n");
                ++i2;
            }
            template.addTextSegment(");\n");
            return template;
        }

        @NotNull
        private static String createTemporaryTableStart(String name, @NotNull Dbms dbms) {
            if (dbms == null) {
                AddSqlTableFix.$$$reportNull$$$0(8);
            }
            if (dbms.isMicrosoft()) {
                String string = "declare " + name + " table";
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(9);
                }
                return string;
            }
            if (dbms.isClickHouse()) {
                String string = "create temporary table " + name;
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(10);
                }
                return string;
            }
            if (dbms.isDb2() || dbms.isDerby()) {
                String string = "declare global temporary table " + name;
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(11);
                }
                return string;
            }
            if (dbms.isHsqldb() || dbms.isMysql()) {
                String string = "declare local temporary table " + name;
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(12);
                }
                return string;
            }
            if (dbms.isOracle()) {
                String string = "create global temporary table " + name;
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(13);
                }
                return string;
            }
            throw new NotImplementedError("DBMS " + dbms.getDisplayName() + " not supported here");
        }

        static boolean supportsNonVarTemporaryTables(@NotNull Dbms dbms) {
            if (dbms == null) {
                AddSqlTableFix.$$$reportNull$$$0(14);
            }
            return dbms.isClickHouse() || dbms.isDb2() || dbms.isDerby() || dbms.isHsqldb() || dbms.isMysql() || dbms.isOracle();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 14: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 14: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateManager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnsNames";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typesMerged";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullableFlags";
                    break;
                }
                case 8: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemporaryTableStart";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplate";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemporaryTableStart";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "supportsNonVarTemporaryTables";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 14: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddSqlColumnFix
    extends SqlEditorAwareFix<PsiElement> {
        final SmartPsiElementPointer<SqlCreateTableStatement> myTable;
        final String myTableName;
        final String myColumnName;

        AddSqlColumnFix(@NotNull PsiElement o, @NotNull SqlCreateTableStatement table) {
            if (o == null) {
                AddSqlColumnFix.$$$reportNull$$$0(0);
            }
            if (table == null) {
                AddSqlColumnFix.$$$reportNull$$$0(1);
            }
            super(o);
            this.myTable = SmartPointerManager.getInstance((Project)o.getProject()).createSmartPsiElementPointer((PsiElement)table);
            this.myTableName = table.getName();
            this.myColumnName = o instanceof SqlIdentifier ? ((SqlIdentifier)o).getName() : o.getText();
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message("intention.name.add.column", this.myColumnName, this.myTableName);
            if (string == null) {
                AddSqlColumnFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void applyFix(final @NotNull Project project, @NotNull PsiElement element2, final @Nullable Editor editor) {
            if (project == null) {
                AddSqlColumnFix.$$$reportNull$$$0(3);
            }
            if (element2 == null) {
                AddSqlColumnFix.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                return;
            }
            SqlCreateTableStatement table = (SqlCreateTableStatement)this.myTable.getElement();
            if (table == null) {
                return;
            }
            PsiColumn last = (PsiColumn)table.getDasChildren(ObjectKind.COLUMN).filter(PsiColumn.class).last();
            int offset = -1;
            boolean insertComma = true;
            if (last == null) {
                ASTNode lParen;
                ASTNode elements = table.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_TABLE_ELEMENT_LIST);
                ASTNode aSTNode = lParen = elements == null ? null : elements.findChildByType((IElementType)SqlCommonTokens.SQL_LEFT_PAREN);
                if (lParen != null) {
                    offset = lParen.getTextRange().getEndOffset();
                    insertComma = false;
                }
            } else {
                offset = last.getTextRange().getEndOffset();
            }
            if (offset == -1) {
                return;
            }
            TemplateManager instance = TemplateManager.getInstance((Project)project);
            TemplateImpl template = TemplateSettings.getInstance().getTemplate("col", "SQL");
            if (template == null) {
                return;
            }
            TemplateImpl copy = template.copy();
            SqlResolveInspection.setVariable(copy, element2.getText(), 0, "col", false);
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class);
            ArrayList<Collection<SqlType>> columnsTypes = new ArrayList<Collection<SqlType>>();
            ArrayList<Boolean> nullableFlags = new ArrayList<Boolean>();
            SqlResolveInspection.collectColumnTypes(statement, columnsTypes, nullableFlags);
            List<SqlType> typesMerged = SqlResolveInspection.mergeTypes(columnsTypes);
            if (typesMerged.size() > table.getDasChildren(ObjectKind.COLUMN).filter(PsiColumn.class).size()) {
                SqlType lastType = (SqlType)ContainerUtil.getLastItem(typesMerged);
                if (lastType != null) {
                    SqlResolveInspection.setVariable(copy, SqlResolveInspection.getTypeText(lastType, SqlImplUtil.getSqlDialectSafe(element2).getDbms()), 1, "type", true);
                }
                if (ContainerUtil.getLastItem(nullableFlags) == Boolean.TRUE) {
                    SqlResolveInspection.setVariable(copy, "NULL", 2, "null", true);
                }
            }
            editor.getCaretModel().moveToOffset(offset);
            String newLine = (insertComma ? "," : "") + "\n";
            editor.getDocument().insertString(offset, (CharSequence)newLine);
            editor.getCaretModel().moveToOffset(offset + newLine.length());
            instance.startTemplate(editor, (Template)copy, (TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (brokenOff) {
                        return;
                    }
                    PsiFile file = myTable.getContainingFile();
                    Segment range = myTable.getRange();
                    if (file == null || range == null) {
                        return;
                    }
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    WriteAction.run(() -> CodeStyleManager.getInstance((Project)project).reformatText(file, range.getStartOffset(), range.getEndOffset()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix$1", "templateFinished"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class IntrospectSchemaFix
    extends IntentionAndQuickFixAction {
        final List<Pair<DbDataSource, ObjectPath>> myCandidates;
        final String myKindName;

        public IntrospectSchemaFix(@NotNull List<Pair<DbDataSource, ObjectPath>> candidates2, @NotNull ObjectKind kind) {
            if (candidates2 == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(1);
            }
            this.myCandidates = candidates2;
            Pair first2 = (Pair)ContainerUtil.getFirstItem(candidates2);
            this.myKindName = StringUtil.capitalize((String)DbPresentationCore.getPresentableName(kind, first2 == null ? Dbms.UNKNOWN : ((DbDataSource)first2.first).getDbms()));
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = SqlBundle.message("intention.name.introspect.schema.fix", StringUtil.toLowerCase((String)this.myKindName));
            if (string == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(4);
            }
            if (this.myCandidates.size() <= 1 || ApplicationManager.getApplication().isUnitTestMode()) {
                IntrospectSchemaFix.setVisible(this.myCandidates);
            } else {
                final Set ds = JBIterable.from(this.myCandidates).transform(p2 -> (DbDataSource)p2.first).toSet();
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new MultiSelectionListPopupStep<Pair<DbDataSource, ObjectPath>>(SqlBundle.message("popup.title.add.to.view", new Object[0]), this.myCandidates){

                    public Icon getIconFor(Pair<DbDataSource, ObjectPath> value2) {
                        return DbPresentationCore.getIcon(((DbDataSource)value2.first).getDbms(), ((ObjectPath)value2.second).kind);
                    }

                    @NotNull
                    public String getTextFor(Pair<DbDataSource, ObjectPath> value2) {
                        ObjectPath parent2 = ((ObjectPath)value2.second).parent;
                        @Nls StringBuilder text2 = new StringBuilder();
                        if (ds.size() > 1) {
                            text2.append(((DbDataSource)value2.first).getName()).append("\u2006.\u2006");
                        }
                        if (parent2 != null) {
                            text2.append(parent2.getName()).append("\u2006.\u2006");
                        }
                        text2.append(((ObjectPath)value2.second).getName());
                        String string = text2.toString();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public PopupStep<?> onChosen(List<Pair<DbDataSource, ObjectPath>> selectedValues, boolean finalChoice) {
                        IntrospectSchemaFix.setVisible(selectedValues);
                        return FINAL_CHOICE;
                    }

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix$1", "getTextFor"));
                    }
                }).showCenteredInCurrentWindow(project);
            }
        }

        private static void setVisible(List<Pair<DbDataSource, ObjectPath>> selectedValues) {
            MultiMap byDs = MultiMap.create();
            selectedValues.forEach(e -> byDs.putValue((Object)((DbDataSource)e.first), (Object)((ObjectPath)e.second)));
            for (Map.Entry entry : byDs.entrySet()) {
                ObjectPath item = (ObjectPath)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue()));
                if (item == null) continue;
                DbDataSource dataSource2 = (DbDataSource)entry.getKey();
                LocalDataSource localDs = (LocalDataSource)dataSource2.getDelegate();
                TreePattern oldScope = localDs.getIntrospectionScope();
                if (!DataSourceUtil.setPathsVisible(dataSource2.getProject(), localDs, (Iterable)entry.getValue(), true)) continue;
                LoaderContext context = new LoaderContext(dataSource2.getProject(), localDs);
                DataSourceUiUtil.scopeChange(context, oldScope, localDs.getIntrospectionScope());
                DataSourceUtil.performManualSyncTask(context);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RefreshSchemaFix
    extends IntentionAndQuickFixAction
    implements HighPriorityAction {
        private final LocalDataSource myDataSource;
        private final DasObject myNamespace;
        private final String myKindName;

        public RefreshSchemaFix(@NotNull LocalDataSource dataSource2, @NotNull DasObject namespace) {
            if (dataSource2 == null) {
                RefreshSchemaFix.$$$reportNull$$$0(0);
            }
            if (namespace == null) {
                RefreshSchemaFix.$$$reportNull$$$0(1);
            }
            this.myDataSource = dataSource2;
            this.myNamespace = namespace;
            this.myKindName = StringUtil.capitalize((String)DbPresentationCore.getPresentableName(namespace.getKind(), dataSource2.getDbms()));
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                RefreshSchemaFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = SqlBundle.message("intention.name.refresh.schema.fix", StringUtil.toLowerCase((String)this.myKindName));
            if (string == null) {
                RefreshSchemaFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                RefreshSchemaFix.$$$reportNull$$$0(4);
            }
            LoaderContext context = new LoaderContext(project, this.myDataSource);
            context.include(this.myNamespace);
            DataSourceUtil.performManualSyncTask(context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$RefreshSchemaFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$RefreshSchemaFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ChooseSchemaFix
    extends IntentionAndQuickFixAction
    implements HighPriorityAction {
        private ChooseSchemaFix() {
        }

        @NotNull
        public String getName() {
            String string = SqlBundle.message("intention.name.choose.schema", new Object[0]);
            if (string == null) {
                ChooseSchemaFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                ChooseSchemaFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static void doChooseSchema(@NotNull Editor editor) {
            if (editor == null) {
                ChooseSchemaFix.$$$reportNull$$$0(2);
            }
            ChooseSchemaAction action2 = new ChooseSchemaAction();
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"unknown", (DataContext)dataContext);
            action2.actionPerformed(event);
        }

        private static void onDataSourceChosen(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DbDataSource dataSource2) {
            if (file == null) {
                ChooseSchemaFix.$$$reportNull$$$0(3);
            }
            if (editor == null) {
                ChooseSchemaFix.$$$reportNull$$$0(4);
            }
            if (dataSource2 == null) {
                ChooseSchemaFix.$$$reportNull$$$0(5);
            }
            LocalDataSource localDataSource = DbImplUtilCore.getLocalDataSource(dataSource2);
            Project project = file.getProject();
            DatabaseSession session2 = DatabaseSessionManager.openSession(project, localDataSource, "default");
            JdbcConsoleProvider.attachConsole(project, session2, file.getVirtualFile());
            ChooseSchemaFix.doChooseSchema(editor);
        }

        private void attachConsoleAndChooseSchema(final @NotNull PsiFile file, final @NotNull Editor editor) {
            List dataSources;
            if (file == null) {
                ChooseSchemaFix.$$$reportNull$$$0(6);
            }
            if (editor == null) {
                ChooseSchemaFix.$$$reportNull$$$0(7);
            }
            if ((dataSources = ChooseSessionAction.getDataSources(file).toList()).size() == 1) {
                ChooseSchemaFix.onDataSourceChosen(file, editor, (DbDataSource)dataSources.get(0));
            } else if (!dataSources.isEmpty()) {
                BaseListPopupStep<DbDataSource> step = new BaseListPopupStep<DbDataSource>(DatabaseBundle.message("datasource.chooser.title", new Object[0]), dataSources){

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }

                    @NotNull
                    public String getTextFor(DbDataSource dataSource2) {
                        String string = dataSource2.getName();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public Icon getIconFor(DbDataSource dataSource2) {
                        return dataSource2.getIcon();
                    }

                    public PopupStep<?> onChosen(DbDataSource dataSource2, boolean finalChoice) {
                        ChooseSchemaFix.onDataSourceChosen(file, editor, dataSource2);
                        return FINAL_CHOICE;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$ChooseSchemaFix$1", "getTextFor"));
                    }
                };
                ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
                DbUIUtil.showPopup((JBPopup)popup2, editor, null);
            }
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                ChooseSchemaFix.$$$reportNull$$$0(8);
            }
            if (editor == null || !EditorUtil.isRealFileEditor((Editor)editor)) {
                return;
            }
            JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file.getVirtualFile());
            if (console != null) {
                ChooseSchemaFix.doChooseSchema(editor);
            } else {
                this.attachConsoleAndChooseSchema(file, editor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$ChooseSchemaFix";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$ChooseSchemaFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doChooseSchema";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "onDataSourceChosen";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "attachConsoleAndChooseSchema";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AttachSessionFix
    extends IntentionAndQuickFixAction {
        private AttachSessionFix() {
        }

        @NotNull
        public String getName() {
            String string = SqlBundle.message("intention.name.attach.session", new Object[0]);
            if (string == null) {
                AttachSessionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                AttachSessionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                AttachSessionFix.$$$reportNull$$$0(2);
            }
            if (editor == null || !EditorUtil.isRealFileEditor((Editor)editor)) {
                return;
            }
            ChooseSessionAction action2 = new ChooseSessionAction();
            action2.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"unknown", (DataContext)DataManager.getInstance().getDataContext((Component)editor.getContentComponent())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AttachSessionFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AttachSessionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class GoToResolutionScopesFix
    extends IntentionAndQuickFixAction {
        private GoToResolutionScopesFix() {
        }

        @NotNull
        public String getName() {
            String string = SqlBundle.message("intention.name.go.to.sql.resolution.scopes", new Object[0]);
            if (string == null) {
                GoToResolutionScopesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                GoToResolutionScopesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                GoToResolutionScopesFix.$$$reportNull$$$0(2);
            }
            SqlResolveConfigurable.openResolveScopesConfigurable(project, SqlImplUtil.getTopLevelFile(file));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$GoToResolutionScopesFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$GoToResolutionScopesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

