/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlSingleNodeBlock;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0005H\u0016J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001a01J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u0013H\u0016J\b\u00105\u001a\u000203H$J\u001d\u00106\u001a\u0002032\u0006\u0010#\u001a\u00020\u00012\u0006\u00107\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b8R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0011R\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R$\u0010#\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001@TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0011\"\u0004\b%\u0010&R\u001c\u0010'\u001a\n )*\u0004\u0018\u00010(0(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00069"}, d2={"Lcom/intellij/sql/formatter/model/SqlInjectionHostBlock;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlSingleNodeBlock;", "()V", "<set-?>", "Lcom/intellij/lang/ASTNode;", "blockNode", "getBlockNode", "()Lcom/intellij/lang/ASTNode;", "setBlockNode", "(Lcom/intellij/lang/ASTNode;)V", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "firstNestedSqlBlock", "getFirstNestedSqlBlock", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "grown", "", "getGrown$intellij_database_sql_core_impl", "()Z", "setGrown$intellij_database_sql_core_impl", "(Z)V", "injectedBlocks", "", "Lcom/intellij/formatting/Block;", "getInjectedBlocks", "()Ljava/util/List;", "lastNestedSqlBlock", "getLastNestedSqlBlock", "minLength", "", "getMinLength", "()I", "parent", "getParent", "setParent", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "range", "Lcom/intellij/openapi/util/TextRange;", "kotlin.jvm.PlatformType", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "contains", "char", "", "getNode", "getSubBlocks", "", "grow", "", "isLeaf", "makeInjectionBlocks", "setup", "node", "setup$intellij_database_sql_core_impl", "intellij.database.sql.core.impl"})
public abstract class SqlInjectionHostBlock
extends SqlBlock
implements SqlSingleNodeBlock {
    protected SqlBlock parent;
    protected ASTNode blockNode;
    @NotNull
    private final List<Block> injectedBlocks = new ArrayList();
    private boolean grown;

    @Override
    @NotNull
    public SqlBlock getParent() {
        SqlBlock sqlBlock = this.parent;
        if (sqlBlock == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        return sqlBlock;
    }

    protected void setParent(@NotNull SqlBlock sqlBlock) {
        Intrinsics.checkNotNullParameter((Object)sqlBlock, (String)"<set-?>");
        this.parent = sqlBlock;
    }

    @Override
    @NotNull
    public SqlFormattingContext getContext() {
        return this.getParent().getContext();
    }

    @Override
    @NotNull
    public ASTNode getBlockNode() {
        ASTNode aSTNode = this.blockNode;
        if (aSTNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blockNode");
        }
        return aSTNode;
    }

    protected void setBlockNode(@NotNull ASTNode aSTNode) {
        Intrinsics.checkNotNullParameter((Object)aSTNode, (String)"<set-?>");
        this.blockNode = aSTNode;
    }

    @NotNull
    protected final List<Block> getInjectedBlocks() {
        return this.injectedBlocks;
    }

    public final boolean getGrown$intellij_database_sql_core_impl() {
        return this.grown;
    }

    public final void setGrown$intellij_database_sql_core_impl(boolean bl) {
        this.grown = bl;
    }

    public final void setup$intellij_database_sql_core_impl(@NotNull SqlBlock parent2, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean bl = Intrinsics.areEqual((Object)parent2, (Object)this) ^ true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.setParent(parent2);
        this.setBlockNode(node);
        this.setShape(BlockShape.DECIDE_LATER);
    }

    @Override
    public void grow() {
        if (this.grown) {
            return;
        }
        this.grown = true;
        this.makeInjectionBlocks();
    }

    protected abstract void makeInjectionBlocks();

    @Override
    @NotNull
    public ASTNode getNode() {
        return this.getBlockNode();
    }

    @Override
    public TextRange getRange() {
        return this.getBlockNode().getTextRange();
    }

    @Override
    public int getMinLength() {
        return this.getBlockNode().getTextLength();
    }

    @Override
    @NotNull
    public final List<Block> getSubBlocks() {
        this.grow();
        return this.injectedBlocks;
    }

    @Override
    @Nullable
    public SqlBlock getFirstNestedSqlBlock() {
        return null;
    }

    @Override
    @Nullable
    public SqlBlock getLastNestedSqlBlock() {
        return null;
    }

    @Override
    public boolean contains(char c2) {
        SqlFormattingContext sqlFormattingContext = this.getContext();
        TextRange textRange = this.getBlockNode().getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"blockNode.textRange");
        return sqlFormattingContext.textContains(textRange, c2);
    }

    public boolean isLeaf() {
        return this.grown ? this.injectedBlocks.isEmpty() : !SqlFormattingModelFunKt.hasInjection(this.getBlockNode());
    }

    public SqlInjectionHostBlock() {
        super(null);
    }

    @Override
    @NotNull
    public IElementType getBlockElementTypes() {
        return SqlSingleNodeBlock.DefaultImpls.getBlockElementTypes(this);
    }
}

