/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Indent;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockCommentBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/formatter/model/SqlCommentsFlowBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "incomplete", "", "produceNestedBlocks", "", "intellij.database.sql.core.impl"})
public final class SqlCommentsFlowBlock
extends SqlRangeBlock {
    @Override
    protected void produceNestedBlocks() {
        BlockRole blockRole;
        super.produceNestedBlocks();
        int n = this.getNestedBlocks().size();
        switch (n) {
            case 0: {
                blockRole = BlockRole.LINE_COMMENT;
                break;
            }
            case 1: {
                blockRole = ((SqlBlock)CollectionsKt.first(this.getNestedBlocks())).getRole();
                break;
            }
            default: {
                blockRole = BlockRole.LARGE_COMMENT;
            }
        }
        this.setRole(blockRole);
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    public boolean incomplete() {
        return false;
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        SqlBlock b1 = blocks.getBlock1();
        if (blocks.getSame() && b1 instanceof SqlBlockCommentBlock) {
            return b1.getNewLineIndent(blocks);
        }
        return null;
    }
}

