/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingModelDumper;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.TextRange;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock$WhenMappings;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010B\u001a\u00020CH&J\u0010\u0010D\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020FH&J\u0010\u0010G\u001a\u00020!2\u0006\u0010H\u001a\u00020\u0000H\u0016J\u0006\u0010I\u001a\u00020JJ\b\u0010K\u001a\u00020CH\u0002J\n\u0010L\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u0017H\u0016J\b\u0010P\u001a\u00020JH\u0016J\n\u0010Q\u001a\u0004\u0018\u00010JH\u0014J\b\u0010R\u001a\u00020!H\u0016J\u0012\u0010S\u001a\u0004\u0018\u00010J2\u0006\u0010T\u001a\u00020UH\u0016J\u001c\u0010V\u001a\u0004\u0018\u00010W2\b\u0010X\u001a\u0004\u0018\u00010\u00012\u0006\u0010Y\u001a\u00020\u0001H\u0016J\u000e\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00010-H\u0016J\b\u0010[\u001a\u000203H\u0016J\n\u0010\\\u001a\u0004\u0018\u00010'H\u0016J\n\u0010]\u001a\u0004\u0018\u00010'H\u0016J\b\u0010^\u001a\u00020CH&J\b\u0010_\u001a\u00020\u000fH\u0016J\b\u0010`\u001a\u00020\u000fH\u0016J\b\u0010a\u001a\u00020CH&J\b\u0010b\u001a\u00020\u000fH\u0016J\b\u0010c\u001a\u00020\u000fH\u0016J-\u0010d\u001a\u00020C2\n\b\u0002\u0010e\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010f\u001a\u0004\u0018\u00010!2\n\b\u0002\u0010g\u001a\u0004\u0018\u00010\u001bH\u0086\bJ\b\u0010h\u001a\u00020JH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00000-X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\rR\u0012\u00102\u001a\u000203X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u001a\u00106\u001a\u000207X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010A\u0082\u0001\u0004ij\bk\u00a8\u0006l"}, d2={"Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/formatting/Block;", "()V", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "firstLeafBlock", "Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "getFirstLeafBlock", "()Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "firstNestedSqlBlock", "getFirstNestedSqlBlock", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "isFirst", "", "()Z", "isLast", "lastLeafBlock", "getLastLeafBlock", "lastNestedSqlBlock", "getLastNestedSqlBlock", "minLength", "", "getMinLength", "()I", "myAlign", "Lcom/intellij/formatting/Alignment;", "getMyAlign", "()Lcom/intellij/formatting/Alignment;", "setMyAlign", "(Lcom/intellij/formatting/Alignment;)V", "myIndent", "Lcom/intellij/formatting/Indent;", "getMyIndent", "()Lcom/intellij/formatting/Indent;", "setMyIndent", "(Lcom/intellij/formatting/Indent;)V", "myWrap", "Lcom/intellij/formatting/Wrap;", "getMyWrap", "()Lcom/intellij/formatting/Wrap;", "setMyWrap", "(Lcom/intellij/formatting/Wrap;)V", "nestedBlocks", "", "getNestedBlocks", "()Ljava/util/List;", "parent", "getParent", "range", "Lcom/intellij/openapi/util/TextRange;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "setRole", "(Lcom/intellij/sql/formatter/model/BlockRole;)V", "shape", "Lcom/intellij/sql/formatter/model/BlockShape;", "getShape", "()Lcom/intellij/sql/formatter/model/BlockShape;", "setShape", "(Lcom/intellij/sql/formatter/model/BlockShape;)V", "analyze", "", "contains", "char", "", "defaultChildIndent", "block", "dump", "", "ensureModelProcessed", "getAlignment", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "getDebugName", "getDebugNameSuffix", "getIndent", "getNewLineIndent", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "getSubBlocks", "getTextRange", "getTransitiveWrap", "getWrap", "grow", "incomplete", "isIncomplete", "refine", "requiresFollowingBreak", "requiresPrecedingBreak", "setAttributes", "wrap", "indent", "align", "toString", "Lcom/intellij/sql/formatter/model/SqlRootBlock;", "Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "Lcom/intellij/sql/formatter/model/SqlInjectionHostBlock;", "intellij.database.sql.core.impl"})
public abstract class SqlBlock
implements Block {
    @NotNull
    private BlockRole role = BlockRole.NOTHING;
    @NotNull
    private BlockShape shape = BlockShape.NOT_DECIDED;
    @Nullable
    private Wrap myWrap;
    @Nullable
    private Indent myIndent;
    @Nullable
    private Alignment myAlign;

    @Nullable
    public abstract SqlBlock getParent();

    @NotNull
    public abstract SqlFormattingContext getContext();

    @NotNull
    public abstract TextRange getRange();

    public abstract int getMinLength();

    @NotNull
    public final BlockRole getRole() {
        return this.role;
    }

    public final void setRole(@NotNull BlockRole blockRole) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockRole), (String)"<set-?>");
        this.role = blockRole;
    }

    @NotNull
    public final BlockShape getShape() {
        return this.shape;
    }

    public final void setShape(@NotNull BlockShape blockShape) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockShape), (String)"<set-?>");
        this.shape = blockShape;
    }

    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @NotNull
    public abstract List<SqlBlock> getNestedBlocks();

    public abstract void grow();

    @NotNull
    public List<Block> getSubBlocks() {
        this.grow();
        return this.getNestedBlocks();
    }

    @Nullable
    public final Wrap getMyWrap() {
        return this.myWrap;
    }

    public final void setMyWrap(@Nullable Wrap wrap2) {
        this.myWrap = wrap2;
    }

    @Nullable
    public final Indent getMyIndent() {
        return this.myIndent;
    }

    public final void setMyIndent(@Nullable Indent indent) {
        this.myIndent = indent;
    }

    @Nullable
    public final Alignment getMyAlign() {
        return this.myAlign;
    }

    public final void setMyAlign(@Nullable Alignment alignment) {
        this.myAlign = alignment;
    }

    public final void setAttributes(@Nullable Wrap wrap2, @Nullable Indent indent, @Nullable Alignment align) {
        int $i$f$setAttributes = 0;
        this.setMyWrap(wrap2);
        this.setMyIndent(indent);
        this.setMyAlign(align);
    }

    public static /* synthetic */ void setAttributes$default(SqlBlock this_, Wrap wrap2, Indent indent, Alignment align, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setAttributes");
        }
        if ((n & 1) != 0) {
            wrap2 = this_.getMyWrap();
        }
        if ((n & 2) != 0) {
            indent = this_.getMyIndent();
        }
        if ((n & 4) != 0) {
            align = this_.getMyAlign();
        }
        boolean $i$f$setAttributes = false;
        this_.setMyWrap(wrap2);
        this_.setMyIndent(indent);
        this_.setMyAlign(align);
    }

    @Nullable
    public Wrap getWrap() {
        if (this.myWrap == null && this.getContext().getReformatting()) {
            this.ensureModelProcessed();
        }
        return this.myWrap;
    }

    @NotNull
    public Indent getIndent() {
        Indent indent;
        Object object;
        if (this.myIndent == null) {
            this.ensureModelProcessed();
        }
        if ((object = this.myIndent) == null) {
            SqlBlock sqlBlock = this.getParent();
            object = indent = sqlBlock != null ? sqlBlock.defaultChildIndent(this) : null;
        }
        if (object == null) {
            indent = SqlFormattingFunKt.getNONE_INDENT();
        }
        return indent;
    }

    @Nullable
    public Alignment getAlignment() {
        if (this.myAlign == null) {
            this.ensureModelProcessed();
        }
        return this.myAlign;
    }

    private final void ensureModelProcessed() {
        block2: {
            if (!this.getContext().getJustAdjust()) break block2;
            SqlBlock sqlBlock = this.getParent();
            if (sqlBlock != null) {
                sqlBlock.analyze();
            }
            SqlBlock sqlBlock2 = this.getParent();
            if (sqlBlock2 != null) {
                sqlBlock2.refine();
            }
        }
    }

    public boolean requiresPrecedingBreak() {
        return SqlFormattingModelFunKt.isAlways(this.myWrap);
    }

    public boolean requiresFollowingBreak() {
        return false;
    }

    public boolean incomplete() {
        return false;
    }

    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        return null;
    }

    public abstract void analyze();

    public abstract void refine();

    @Nullable
    public Wrap getTransitiveWrap() {
        SqlBlock sqlBlock = this.getParent();
        return sqlBlock != null ? sqlBlock.getTransitiveWrap() : null;
    }

    public final boolean isFirst() {
        boolean bl;
        if (this.getParent() != null) {
            SqlBlock sqlBlock = this.getParent();
            Intrinsics.checkNotNull((Object)sqlBlock);
            bl = sqlBlock.getFirstNestedSqlBlock() == this;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isLast() {
        boolean bl;
        if (this.getParent() != null) {
            SqlBlock sqlBlock = this.getParent();
            Intrinsics.checkNotNull((Object)sqlBlock);
            bl = sqlBlock.getLastNestedSqlBlock() == this;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public SqlBlock getFirstNestedSqlBlock() {
        return (SqlBlock)CollectionsKt.firstOrNull(this.getNestedBlocks());
    }

    @Nullable
    public SqlBlock getLastNestedSqlBlock() {
        return (SqlBlock)CollectionsKt.lastOrNull(this.getNestedBlocks());
    }

    @Nullable
    public SqlLeafBlock getFirstLeafBlock() {
        SqlBlock sqlBlock = this.getFirstNestedSqlBlock();
        return sqlBlock != null ? sqlBlock.getFirstLeafBlock() : null;
    }

    @Nullable
    public SqlLeafBlock getLastLeafBlock() {
        SqlBlock sqlBlock = this.getLastNestedSqlBlock();
        return sqlBlock != null ? sqlBlock.getLastLeafBlock() : null;
    }

    public abstract boolean contains(char var1);

    @NotNull
    public final String dump() {
        String string = FormattingModelDumper.dumpFormattingModelToString((Block)this);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FormattingModelDumper.du\u2026attingModelToString(this)");
        return string;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.getRange();
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(SqlFormattingFunKt.getNONE_INDENT(), null);
    }

    public boolean isIncomplete() {
        return this.incomplete();
    }

    @NotNull
    public String getDebugName() {
        char c2;
        StringBuilder b2 = new StringBuilder();
        if (this.role.getExists()) {
            b2.append(this.role.getCode()).append(':').append(' ');
        }
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.javaClass.simpleName");
        String simpleName = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"Sql"), (CharSequence)"Block");
        b2.append(simpleName);
        String suffix = this.getDebugNameSuffix();
        if (suffix != null) {
            b2.append('(').append(suffix).append(')');
        }
        if (this.getMinLength() > 0 && this.getMinLength() < Integer.MAX_VALUE) {
            b2.append(' ').append('[').append(this.getMinLength()).append(']');
        }
        switch (SqlBlock$WhenMappings.$EnumSwitchMapping$0[this.shape.ordinal()]) {
            case 1: {
                c2 = '\u0000';
                break;
            }
            case 2: {
                c2 = '\u25b1';
                break;
            }
            case 3: {
                c2 = '\u25d2';
                break;
            }
            case 4: {
                c2 = '\u25a3';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        char shapeChar = c2;
        if (this.shape.getExists()) {
            b2.append(' ').append(shapeChar).append(' ');
        }
        String string2 = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"b.toString()");
        return string2;
    }

    @Nullable
    protected String getDebugNameSuffix() {
        return null;
    }

    @NotNull
    public String toString() {
        return this.getDebugName();
    }

    private SqlBlock() {
    }

    public /* synthetic */ SqlBlock(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

