/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCommentBlock;
import com.intellij.sql.formatter.model.SqlFileBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlIdentifierBlock;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlLiteralBlock;
import com.intellij.sql.formatter.model.SqlRealRootBlock;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a8\u0006\n"}, d2={"adjustEnclosingBlocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "blocks", "findEnclosingBlocks", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "offset", "", "getLineIndentInsideLeaf", "", "intellij.database.sql.core.impl"})
public final class SqlLineIndentProviderKt {
    private static final String getLineIndentInsideLeaf(AdjacentBlocks blocks) {
        SqlBlock b2 = blocks.getBlock1();
        return b2 instanceof SqlLiteralBlock ? "" : (b2 instanceof SqlIdentifierBlock ? (((SqlIdentifierBlock)b2).getQuoted() ? "" : LineIndentProvider.DO_NOT_ADJUST) : (b2 instanceof SqlCommentBlock ? b2.getNewLineIndent(blocks) : LineIndentProvider.DO_NOT_ADJUST));
    }

    /*
     * WARNING - void declaration
     */
    private static final AdjacentBlocks findEnclosingBlocks(SqlBlock block, int offset) {
        if (block instanceof SqlRealRootBlock) {
            return SqlLineIndentProviderKt.findEnclosingBlocks(((SqlRealRootBlock)block).getNestedBlock$intellij_database_sql_core_impl(), offset);
        }
        TextRange r = block.getRange();
        if (offset <= r.getStartOffset()) {
            return new AdjacentBlocks(null, block);
        }
        if (offset >= r.getEndOffset()) {
            return new AdjacentBlocks(block, null);
        }
        if (block instanceof SqlLeafBlock) {
            return new AdjacentBlocks(block, block);
        }
        block.grow();
        List<SqlBlock> children2 = block.getNestedBlocks();
        int n = children2.size();
        if (n == 0) {
            return new AdjacentBlocks(block, block);
        }
        SqlBlock b0 = children2.get(0);
        TextRange r0 = b0.getRange();
        if (offset <= r0.getStartOffset()) {
            return new AdjacentBlocks(null, b0);
        }
        if (offset < r0.getEndOffset()) {
            return SqlLineIndentProviderKt.findEnclosingBlocks(b0, offset);
        }
        int n2 = 1;
        int n3 = n;
        while (n2 < n3) {
            void i2;
            SqlBlock b2 = children2.get((int)i2);
            TextRange r2 = b2.getRange();
            if (offset <= r2.getStartOffset()) {
                return new AdjacentBlocks(children2.get((int)(i2 - true)), b2);
            }
            if (offset < r2.getEndOffset()) {
                return SqlLineIndentProviderKt.findEnclosingBlocks(b2, offset);
            }
            ++i2;
        }
        if (offset < block.getRange().getEndOffset()) {
            return new AdjacentBlocks((SqlBlock)CollectionsKt.last(children2), null);
        }
        return new AdjacentBlocks(block, block);
    }

    private static final AdjacentBlocks adjustEnclosingBlocks(AdjacentBlocks blocks) {
        SqlBlock sqlBlock = blocks.getBlock1();
        if (sqlBlock == null) {
            return blocks;
        }
        SqlBlock b1 = sqlBlock;
        SqlBlock b2 = blocks.getBlock2();
        boolean changed = false;
        b1.grow();
        if (b1 instanceof SqlFileBlock && b2 == null) {
            List<SqlBlock> b1nest = ((SqlFileBlock)b1).getNestedBlocks();
            Collection collection = b1nest;
            boolean bl = false;
            if (!collection.isEmpty()) {
                b1 = (SqlBlock)CollectionsKt.last(b1nest);
                b2 = null;
                changed = true;
            }
        }
        if (!b1.incomplete()) {
            return changed ? new AdjacentBlocks(b1, b2) : blocks;
        }
        while (b1 instanceof SqlFlowBlock) {
            Collection collection = ((SqlFlowBlock)b1).getNestedBlocks();
            boolean bl = false;
            if (!(!collection.isEmpty()) || !b1.incomplete()) break;
            Intrinsics.checkNotNull((Object)b1.getLastNestedSqlBlock());
            b2 = null;
            b1.grow();
        }
        return new AdjacentBlocks(b1, b2);
    }

    public static final /* synthetic */ AdjacentBlocks access$adjustEnclosingBlocks(AdjacentBlocks blocks) {
        return SqlLineIndentProviderKt.adjustEnclosingBlocks(blocks);
    }

    public static final /* synthetic */ AdjacentBlocks access$findEnclosingBlocks(SqlBlock block, int offset) {
        return SqlLineIndentProviderKt.findEnclosingBlocks(block, offset);
    }

    public static final /* synthetic */ String access$getLineIndentInsideLeaf(AdjacentBlocks blocks) {
        return SqlLineIndentProviderKt.getLineIndentInsideLeaf(blocks);
    }
}

