/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.formatter.Change;
import com.intellij.sql.formatter.SqlPreFormatHelper;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTokenElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0012H\u0002J\u0010\u00108\u001a\u0002042\u0006\u00109\u001a\u000206H\u0002J\u0010\u0010:\u001a\u0002042\u0006\u00109\u001a\u000206H\u0002J\"\u0010;\u001a\u0002042\u0006\u00109\u001a\u0002062\b\u0010<\u001a\u0004\u0018\u0001062\b\u0010=\u001a\u0004\u0018\u000106J\u001a\u0010>\u001a\u0002042\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010BH\u0002J\u0010\u0010C\u001a\u0002042\u0006\u0010D\u001a\u000206H\u0002J\u0010\u0010E\u001a\u0002042\u0006\u0010D\u001a\u000206H\u0002J$\u0010F\u001a\u0002042\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010B2\b\u0010G\u001a\u0004\u0018\u00010HH\u0002J\f\u0010I\u001a\u00020\t*\u000206H\u0002J\f\u0010J\u001a\u00020\t*\u000206H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010*\u001a\t\u0018\u00010+\u00a2\u0006\u0002\b,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/intellij/sql/formatter/SqlCasePreFormatter;", "", "dbms", "Lcom/intellij/database/Dbms;", "settings", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "document", "Lcom/intellij/openapi/editor/Document;", "allowResolving", "", "readOnlyFragments", "", "Lcom/intellij/openapi/util/TextRange;", "changes", "", "Lcom/intellij/sql/formatter/Change;", "(Lcom/intellij/database/Dbms;Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;Lcom/intellij/openapi/editor/Document;ZLjava/util/List;Ljava/util/Collection;)V", "builtInCase", "Lcom/intellij/database/util/Case;", "builtInCaseToChange", "builtInIsSensitive", "builtInTypeCase", "builtInTypeCaseToChange", "customTypeCase", "customTypeCaseToChange", "dbDialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "identifierCase", "identifierCaseOrigin", "identifierCaseToChange", "identifierToQuote", "identifierToUnquote", "isTransactSql", "keywordCase", "keywordCaseToChange", "namingService", "Lcom/intellij/database/script/generator/NamingService;", "plainIsSensitive", "quotationDependsOnKind", "quotedCase", "quotedCaseToChange", "quotedIsSensitive", "quotesPriority", "", "Lorg/jetbrains/annotations/Nullable;", "text", "", "toChangeSomething", "typeIsSensitive", "useWordAS", "", "changeCase", "", "word", "Lcom/intellij/psi/PsiElement;", "case", "processBuiltIn", "element", "processCustomType", "processElement", "pa", "grandpa", "processIdentifier", "identifier", "Lcom/intellij/sql/psi/SqlIdentifier;", "kind", "Lcom/intellij/database/model/ObjectKind;", "processKeyword", "keyword", "processKeywordType", "processQuotedIdentifier", "parentElementType", "Lcom/intellij/psi/tree/IElementType;", "intersectsWithReadOnlyFragments", "isQuoted", "intellij.database.sql.core.impl"})
public final class SqlCasePreFormatter {
    private final CharSequence text;
    private final DatabaseDialectEx dbDialect;
    private final NamingService namingService;
    private final boolean builtInIsSensitive;
    private final boolean typeIsSensitive;
    private final boolean plainIsSensitive;
    private final boolean quotedIsSensitive;
    private final boolean isTransactSql;
    private final boolean quotationDependsOnKind;
    private final Case keywordCase;
    private final boolean keywordCaseToChange;
    private final Case identifierCase;
    private final boolean identifierCaseToChange;
    private final boolean identifierCaseOrigin;
    private final boolean identifierToQuote;
    private final boolean identifierToUnquote;
    private final Case builtInTypeCase;
    private final boolean builtInTypeCaseToChange;
    private final Case customTypeCase;
    private final boolean customTypeCaseToChange;
    private final Case builtInCase;
    private final boolean builtInCaseToChange;
    private final Case quotedCase;
    private final boolean quotedCaseToChange;
    private final String quotesPriority;
    private final int useWordAS;
    private final boolean toChangeSomething;
    private final boolean allowResolving;
    private final List<TextRange> readOnlyFragments;
    private final Collection<Change> changes;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void processElement(@NotNull PsiElement element, @Nullable PsiElement pa, @Nullable PsiElement grandpa) {
        block19: {
            block20: {
                block21: {
                    block18: {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        if (!this.toChangeSomething) {
                            return;
                        }
                        v0 = PsiTreeUtilKt.getElementType((PsiElement)element);
                        if (v0 == null) {
                            return;
                        }
                        et = v0;
                        v1 = pa;
                        v2 /* !! */  = pet = v1 != null ? PsiTreeUtilKt.getElementType((PsiElement)v1) : null;
                        if (pet == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE) {
                            return;
                        }
                        if (element.textMatches((CharSequence)"*")) {
                            return;
                        }
                        if (this.intersectsWithReadOnlyFragments(element)) {
                            return;
                        }
                        isRemapped = pa instanceof SqlIdentifier;
                        isInsideSpecialLiteral = Intrinsics.areEqual((Object)pet, (Object)SqlCompositeElementTypes.SQL_SPECIAL_LITERAL) != false && StringUtil.equalsIgnoreCase((CharSequence)element.getText(), (CharSequence)"null") == false;
                        isKeyword = et instanceof SqlKeywordTokenType != false && isRemapped == false && isInsideSpecialLiteral == false;
                        v3 = element;
                        if (!(v3 instanceof SqlIdentifier)) {
                            v3 = null;
                        }
                        identifier = (SqlIdentifier)v3;
                        if (!isKeyword) break block18;
                        if (pa instanceof SqlTypeElement) {
                            this.processKeywordType(element);
                        } else {
                            this.processKeyword(element);
                        }
                        break block19;
                    }
                    if (identifier == null) break block20;
                    v4 = kind = this.allowResolving != false && this.quotationDependsOnKind != false ? SqlImplUtil.getIdentifierKind(identifier) : null;
                    if (!this.isQuoted(element)) break block21;
                    this.processQuotedIdentifier((SqlIdentifier)element, kind, pet);
                    break block19;
                }
                isReferencePart = pa instanceof SqlReferenceExpression;
                if (!isReferencePart) ** GOTO lbl-1000
                v5 = (SqlTokenElement)SqlImplUtil.getSiblingToTheLeftOfType(element, false, new Class[]{SqlTokenElement.class});
                if (Intrinsics.areEqual((Object)(v5 != null ? v5.getElementType() : null), (Object)SqlCommonTokens.SQL_PERIOD)) {
                    v6 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v6 = false;
                }
                isSecond = v6;
                isBuiltIn = isSecond == false && SqlPreFormatHelper.identifierIsBuiltInFunction(pa) != false;
                if (isBuiltIn) {
                    this.processBuiltIn(element);
                } else if (grandpa instanceof SqlTypeElement) {
                    this.processCustomType(element);
                } else if (pa instanceof SqlTypeElement || pet == SqlCompositeElementTypes.SQL_TYPE_REFERENCE) {
                    this.processCustomType(element);
                } else if (pet == SqlCompositeElementTypes.SQL_ALIAS_TYPE_REFERENCE || pet == SqlCompositeElementTypes.SQL_TABLE_TYPE_REFERENCE || pet == SqlCompositeElementTypes.SQL_COLLECTION_TYPE_REFERENCE) {
                    this.processCustomType(element);
                } else {
                    this.processIdentifier((SqlIdentifier)element, kind);
                }
                break block19;
            }
            if (!isRemapped || !SqlPreFormatHelper.identifierIsBuiltInFunction(grandpa) || this.isQuoted(element)) break block19;
            this.processBuiltIn(element);
        }
    }

    private final void processKeyword(PsiElement keyword) {
        if (this.keywordCaseToChange) {
            this.changeCase(keyword, this.keywordCase);
        }
    }

    private final void processKeywordType(PsiElement keyword) {
        if (this.builtInTypeCaseToChange) {
            this.changeCase(keyword, this.builtInTypeCase);
        }
    }

    private final void processCustomType(PsiElement element2) {
        if (this.customTypeCaseToChange) {
            this.changeCase(element2, this.customTypeCase);
        }
    }

    private final void processBuiltIn(PsiElement element2) {
        if (this.builtInCaseToChange) {
            this.changeCase(element2, this.builtInCase);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void processIdentifier(SqlIdentifier identifier, ObjectKind kind) {
        boolean bl;
        String newWord;
        String oldWord;
        block8: {
            block6: {
                block7: {
                    oldWord = identifier.getText();
                    CharSequence charSequence = oldWord;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (charSequence == null) return;
                    if (StringsKt.isBlank((CharSequence)charSequence)) {
                        return;
                    }
                    boolean bl4 = false;
                    if (bl4) {
                        return;
                    }
                    newWord = null;
                    if (!this.identifierToQuote) break block6;
                    if (!this.isTransactSql) break block7;
                    String string = identifier.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"identifier.name");
                    if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) break block6;
                }
                String prefix = identifier.getNamePrefix();
                String string = identifier.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"identifier.name");
                newWord = this.namingService.enquote(string, kind, this.quotesPriority);
                if (prefix != null) {
                    CharSequence charSequence = prefix;
                    bl = false;
                    if (charSequence.length() > 0) {
                        newWord = prefix + newWord;
                    }
                }
                break block8;
            }
            if (this.identifierCaseOrigin) {
                newWord = SqlPreFormatHelper.obtainOriginalCase(identifier);
            }
            if (this.identifierCaseToChange && newWord == null) {
                newWord = this.identifierCase.apply(oldWord);
            }
        }
        if (newWord == null) return;
        if (!(Intrinsics.areEqual((Object)newWord, (Object)oldWord) ^ true)) return;
        TextRange textRange = identifier.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"identifier.textRange");
        Change change = Change.Companion.replace(textRange, newWord);
        Collection<Change> collection = this.changes;
        bl = false;
        collection.add(change);
    }

    private final void processQuotedIdentifier(SqlIdentifier identifier, ObjectKind kind, IElementType parentElementType) {
        String string = identifier.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"identifier.name");
        String oldName = string;
        String oldWord = identifier.getText();
        String newWord = null;
        if (this.identifierToUnquote) {
            boolean canUnquote = false;
            if (parentElementType == SqlCompositeElementTypes.SQL_AS_EXPRESSION) {
                boolean bl;
                LeafPsiElement followedToken = (LeafPsiElement)SqlImplUtil.getSiblingToTheLeftOfType((PsiElement)identifier, true, LeafPsiElement.class);
                switch (this.useWordAS) {
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 2: {
                        bl = false;
                        break;
                    }
                    default: {
                        bl = followedToken != null && SqlImplUtil.getElementType((PsiElement)followedToken) == SqlCommonKeywords.SQL_AS;
                    }
                }
                boolean afterAS = bl;
                canUnquote = this.dbDialect.canUnquoteAlias(oldName, kind, afterAS);
            } else {
                canUnquote = SqlImplUtil.canUnquote(oldName, kind, this.namingService);
            }
            newWord = canUnquote ? this.identifierCase.apply(oldName) : this.quotedCase.apply(oldWord);
        } else if (this.quotedCaseToChange) {
            newWord = this.quotedCase.apply(oldWord);
        }
        if (newWord != null && Intrinsics.areEqual((Object)newWord, (Object)oldWord) ^ true) {
            TextRange textRange = identifier.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"identifier.textRange");
            Change change = Change.Companion.replace(textRange, newWord);
            Collection<Change> collection = this.changes;
            boolean bl = false;
            collection.add(change);
        }
    }

    private final void changeCase(PsiElement word, Case case_) {
        String newWord;
        int b2 = word.getTextOffset();
        int e = b2 + word.getTextLength();
        CharSequence charSequence = this.text;
        boolean bl = false;
        String oldWord = ((Object)charSequence.subSequence(b2, e)).toString();
        if (Intrinsics.areEqual((Object)oldWord, (Object)(newWord = case_.apply(oldWord))) ^ true) {
            String string = newWord;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newWord");
            Change change = Change.Companion.replace(b2, e, string);
            Collection<Change> collection = this.changes;
            boolean bl2 = false;
            collection.add(change);
        }
    }

    private final boolean isQuoted(PsiElement $this$isQuoted) {
        boolean bl;
        if ($this$isQuoted instanceof SqlNameElement) {
            bl = ((SqlNameElement)$this$isQuoted).isQuotedIdentifier();
        } else {
            String string = $this$isQuoted.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.text");
            bl = this.namingService.isQuoted(string);
        }
        return bl;
    }

    private final boolean intersectsWithReadOnlyFragments(PsiElement $this$intersectsWithReadOnlyFragments) {
        if (this.readOnlyFragments == null) {
            return false;
        }
        for (TextRange fragment : this.readOnlyFragments) {
            if (!$this$intersectsWithReadOnlyFragments.getTextRange().intersectsStrict(fragment)) continue;
            return true;
        }
        return false;
    }

    public SqlCasePreFormatter(@NotNull Dbms dbms, @NotNull SqlCodeStyleSettings settings, @NotNull Document document, boolean allowResolving, @Nullable List<? extends TextRange> readOnlyFragments, @NotNull Collection<Change> changes) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.allowResolving = allowResolving;
        this.readOnlyFragments = readOnlyFragments;
        this.changes = changes;
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        this.text = charSequence;
        DatabaseDialectEx databaseDialectEx = DbImplUtilCore.getDatabaseDialect(dbms);
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"DbImplUtilCore.getDatabaseDialect(dbms)");
        this.dbDialect = databaseDialectEx;
        this.namingService = NamingServices.getNamingService$default(dbms, null, null, 6, null);
        this.builtInIsSensitive = Intrinsics.areEqual((Object)dbms, (Object)Dbms.CLICKHOUSE);
        this.typeIsSensitive = Intrinsics.areEqual((Object)dbms, (Object)Dbms.CLICKHOUSE);
        this.plainIsSensitive = this.namingService.getDefaultCasing().plain.sensitive;
        this.quotedIsSensitive = this.namingService.getDefaultCasing().quoted.sensitive;
        this.quotationDependsOnKind = this.isTransactSql = dbms.isTransactSql();
        Case case_ = settings.getKeywordCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_), (String)"settings.keywordCase");
        this.keywordCase = case_;
        this.keywordCaseToChange = SqlPreFormatHelper.getToChange(this.keywordCase);
        Case case_2 = settings.getIdentifierCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_2), (String)"settings.identifierCase");
        this.identifierCase = case_2;
        this.identifierCaseToChange = SqlPreFormatHelper.getToChange(this.identifierCase) && !this.plainIsSensitive;
        this.identifierCaseOrigin = settings.ORIGINAL_CASE && this.allowResolving;
        this.identifierToQuote = settings.QUOTE_IDENTIFIER == 2 && this.allowResolving;
        this.identifierToUnquote = settings.QUOTE_IDENTIFIER == 1 && this.allowResolving;
        Case case_3 = settings.getBuiltInTypeCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_3), (String)"settings.builtInTypeCase");
        this.builtInTypeCase = case_3;
        this.builtInTypeCaseToChange = SqlPreFormatHelper.getToChange(this.builtInTypeCase) && !this.typeIsSensitive;
        Case case_4 = settings.getCustomTypeCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_4), (String)"settings.customTypeCase");
        this.customTypeCase = case_4;
        this.customTypeCaseToChange = SqlPreFormatHelper.getToChange(this.customTypeCase) && !this.typeIsSensitive;
        Case case_5 = settings.getBuiltInCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_5), (String)"settings.builtInCase");
        this.builtInCase = case_5;
        this.builtInCaseToChange = SqlPreFormatHelper.getToChange(this.builtInCase) && !this.builtInIsSensitive;
        Case case_6 = settings.getQuotedIdentifierCase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)case_6), (String)"settings.quotedIdentifierCase");
        this.quotedCase = case_6;
        this.quotedCaseToChange = SqlPreFormatHelper.getToChange(this.quotedCase) && !this.quotedIsSensitive;
        this.quotesPriority = settings.getQuotesPriority();
        this.useWordAS = settings.SELECT_USE_AS_WORD;
        this.toChangeSomething = this.keywordCaseToChange || this.identifierCaseToChange || this.builtInTypeCaseToChange || this.builtInCaseToChange || this.quotedCaseToChange || this.quotedCaseToChange || this.identifierToQuote || this.identifierToUnquote;
    }
}

