/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0000H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/editor/SqlValidatingHighlightVisitor;", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "()V", "delegate", "Lcom/intellij/sql/editor/SqlValidatingHighlightVisitor$Delegate;", "analyze", "", "file", "Lcom/intellij/psi/PsiFile;", "updateWholeFile", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "action", "Ljava/lang/Runnable;", "clone", "suitableForFile", "visit", "", "element", "Lcom/intellij/psi/PsiElement;", "Delegate", "intellij.database.sql.core.impl"})
public final class SqlValidatingHighlightVisitor
implements HighlightVisitor {
    private Delegate delegate;

    public boolean suitableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof SqlFile;
    }

    public void visit(@NotNull PsiElement element2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            PsiElement psiElement = element2;
            if (!(psiElement instanceof SqlElement)) {
                psiElement = null;
            }
            SqlElement sqlElement = (SqlElement)psiElement;
            if (sqlElement == null) break block1;
            sqlElement.accept((SqlVisitor)this.delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.delegate = SqlImplUtil.getSqlDialectSafe((PsiElement)file).createValidationDelegate(holder);
        try {
            action2.run();
        }
        finally {
            this.delegate = null;
        }
        return true;
    }

    @NotNull
    public SqlValidatingHighlightVisitor clone() {
        return new SqlValidatingHighlightVisitor();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u001a\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/editor/SqlValidatingHighlightVisitor$Delegate;", "Lcom/intellij/sql/psi/SqlVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getHolder", "()Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "report", "", "info", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "reportError", "element", "Lcom/intellij/psi/PsiElement;", "message", "", "intellij.database.sql.core.impl"})
    public static abstract class Delegate
    extends SqlVisitor {
        @NotNull
        private final SqlLanguageDialectEx dialect;
        @NotNull
        private final HighlightInfoHolder holder;

        protected final void report(@NotNull HighlightInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this.holder.add(info);
        }

        protected final void reportError(@NotNull PsiElement element2, @InspectionMessage @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element2).descriptionAndTooltip(message2).create();
            if (highlightInfo == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfo, (String)"HighlightInfo\n          \u2026      .create() ?: return");
            HighlightInfo info = highlightInfo;
            this.report(info);
        }

        @NotNull
        protected final SqlLanguageDialectEx getDialect() {
            return this.dialect;
        }

        @NotNull
        protected final HighlightInfoHolder getHolder() {
            return this.holder;
        }

        public Delegate(@NotNull SqlLanguageDialectEx dialect, @NotNull HighlightInfoHolder holder) {
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.dialect = dialect;
            this.holder = holder;
        }
    }
}

