/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.database.Dbms;
import com.intellij.icons.AllIcons;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016J\r\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0016J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0012\u0010\u0010\u001a\f0\u0011\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/editor/SqlRecursiveCallLineMakerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "getIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getLineMarkerInfo", "element", "getName", "", "Lorg/jetbrains/annotations/Nls;", "isRecursiveCall", "", "refExpr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "SqlRecursiveCallMarkerInfo", "intellij.database.sql.impl"})
public final class SqlRecursiveCallLineMakerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        String string = SqlBundle.message("SqlRecursiveCallLineMakerProvider.gutter.name.recursive.call", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"SqlRe\u2026ter.name.recursive.call\")");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Gutter.RecursiveMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Gutter.RecursiveMethod");
        return icon;
    }

    @Nullable
    public LineMarkerInfo<PsiElement> getLineMarkerInfo(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return null;
    }

    private final boolean isRecursiveCall(SqlReferenceExpression refExpr) {
        ResolveResult[] resolveResultArray = refExpr.multiResolve(false);
        int n = resolveResultArray.length;
        for (int j = 0; j < n; ++j) {
            PsiElement target;
            block13: {
                block12: {
                    ResolveResult result2;
                    ResolveResult resolveResult = result2 = resolveResultArray[j];
                    Intrinsics.checkNotNullExpressionValue((Object)resolveResult, (String)"result");
                    if (resolveResult.getElement() == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)target, (String)"result.element ?: continue");
                    if (!(target instanceof SqlRoutineDefinition)) break block12;
                    PsiElement psiElement = refExpr.getParent();
                    if (!(psiElement instanceof SqlFunctionCallExpression)) {
                        psiElement = null;
                    }
                    SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)psiElement;
                    if (Intrinsics.areEqual((Object)(sqlFunctionCallExpression != null ? sqlFunctionCallExpression.getNameElement() : null), (Object)refExpr)) break block13;
                }
                if (!(target instanceof SqlAsExpression)) continue;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)target, (PsiElement)((PsiElement)refExpr), (boolean)true)) {
                return true;
            }
            PsiFile psiFile = refExpr.getContainingFile();
            if (!(psiFile instanceof SqlCodeFragment)) {
                psiFile = null;
            }
            SqlCodeFragment sqlCodeFragment = (SqlCodeFragment)psiFile;
            if (sqlCodeFragment == null) {
                return false;
            }
            SqlCodeFragment file = sqlCodeFragment;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"SqlImplUtil.getSqlDialectSafe(file)");
            Dbms dbms = sqlLanguageDialectEx.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"SqlImplUtil.getSqlDialectSafe(file).dbms");
            if (!dbms.isSnowflake()) {
                return false;
            }
            if (Intrinsics.areEqual((Object)file.getElementType(), (Object)SqlCompositeElementTypes.SQL_EVALUABLE_EXPRESSION) ^ true) {
                return false;
            }
            PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file);
            if (psiLanguageInjectionHost == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiLanguageInjectionHost, (String)"InjectedLanguageManager.\u2026ost(file) ?: return false");
            PsiLanguageInjectionHost injectionHost = psiLanguageInjectionHost;
            return PsiTreeUtil.isAncestor((PsiElement)target, (PsiElement)((PsiElement)injectionHost), (boolean)true);
        }
        return false;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        for (PsiElement psiElement : elements) {
            SqlReferenceExpression refExpr;
            ProgressManager.checkCanceled();
            PsiElement psiElement2 = psiElement.getParent();
            if (!(psiElement2 instanceof SqlIdentifier)) {
                psiElement2 = null;
            }
            SqlIdentifier sqlIdentifier = (SqlIdentifier)psiElement2;
            Object object = sqlIdentifier != null ? sqlIdentifier.getParent() : null;
            if (!(object instanceof SqlReferenceExpression)) {
                object = null;
            }
            if ((SqlReferenceExpression)object == null) {
                continue;
            }
            if (!this.isRecursiveCall(refExpr)) continue;
            Collection<LineMarkerInfo<?>> collection = result2;
            SqlRecursiveCallMarkerInfo sqlRecursiveCallMarkerInfo = new SqlRecursiveCallMarkerInfo(psiElement);
            boolean bl = false;
            collection.add(sqlRecursiveCallMarkerInfo);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/editor/SqlRecursiveCallLineMakerProvider$SqlRecursiveCallMarkerInfo;", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "name", "(Lcom/intellij/psi/PsiElement;)V", "createGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "intellij.database.sql.impl"})
    private static final class SqlRecursiveCallMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        @Nullable
        public GutterIconRenderer createGutterRenderer() {
            if (this.myIcon == null) {
                return null;
            }
            return (GutterIconRenderer)new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>(this, (LineMarkerInfo)this){
                final /* synthetic */ SqlRecursiveCallMarkerInfo this$0;

                @Nullable
                public AnAction getClickAction() {
                    return null;
                }
                {
                    this.this$0 = this$0;
                    super($super_call_param$1);
                }
            };
        }

        public SqlRecursiveCallMarkerInfo(@NotNull PsiElement name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, name.getTextRange(), AllIcons.Gutter.RecursiveMethod, (Function)1.INSTANCE, null, GutterIconRenderer.Alignment.RIGHT);
        }
    }
}

