/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.database.Dbms;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlBaseValidationDelegate;
import com.intellij.sql.editor.SqlValidatingHighlightVisitor;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlDeclareConditionHandlerStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlErrorSpec;
import com.intellij.sql.psi.SqlExceptionWhenClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlRaiseStatement;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlConditionDefinition;
import com.intellij.sql.psi.impl.SqlConditionErrorSpec;
import com.intellij.sql.psi.impl.SqlErrorCodeSpec;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSignalStatement;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0019H\u0016R\u0015\u0010\u0007\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/sql/editor/SqlBaseValidationDelegate;", "Lcom/intellij/sql/editor/SqlValidatingHighlightVisitor$Delegate;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "minDbmsVersion", "Lcom/intellij/database/util/Version;", "Lorg/jetbrains/annotations/Nullable;", "checkBadErrorCode", "", "errorCodeExpr", "Lcom/intellij/sql/psi/SqlExpression;", "reportOn", "Lcom/intellij/psi/PsiElement;", "checkBadSqlState", "sqlStateExpr", "checkErrorCodeExpr", "checkSignalStatement", "o", "Lcom/intellij/sql/psi/impl/SqlSignalStatement;", "getOptionKeywords", "Lcom/intellij/util/containers/JBIterable;", "statement", "Lcom/intellij/sql/psi/SqlRaiseStatement;", "isGoodSqlState", "", "expression", "visitSqlDeclareConditionHandlerStatement", "Lcom/intellij/sql/psi/SqlDeclareConditionHandlerStatement;", "visitSqlDefinition", "Lcom/intellij/sql/psi/SqlDefinition;", "visitSqlIdentifier", "Lcom/intellij/sql/psi/SqlIdentifier;", "visitSqlRaiseStatement", "intellij.database.sql.core.impl"})
public class SqlBaseValidationDelegate
extends SqlValidatingHighlightVisitor.Delegate {
    private final Version minDbmsVersion;

    private final boolean isGoodSqlState(SqlExpression expression) {
        if (!(expression instanceof SqlStringLiteralExpression)) {
            return false;
        }
        String string = ((SqlStringLiteralExpression)expression).getValue();
        if (string == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression.value ?: return false");
        String value2 = string;
        return value2.length() == 5 && !StringsKt.startsWith$default((String)value2, (String)"00", (boolean)false, (int)2, null);
    }

    private final void checkBadSqlState(SqlExpression sqlStateExpr, PsiElement reportOn) {
        if (!this.isGoodSqlState(sqlStateExpr)) {
            String string = SqlBundle.message("inspection.message.sqlstate.value.must.be.character.string.literal.may.not.start.with", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026eral.may.not.start.with\")");
            this.reportError(reportOn, string);
        }
    }

    static /* synthetic */ void checkBadSqlState$default(SqlBaseValidationDelegate sqlBaseValidationDelegate, SqlExpression sqlExpression, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkBadSqlState");
        }
        if ((n & 2) != 0) {
            psiElement = (PsiElement)sqlExpression;
        }
        sqlBaseValidationDelegate.checkBadSqlState(sqlExpression, psiElement);
    }

    private final void checkBadErrorCode(SqlExpression errorCodeExpr, PsiElement reportOn) {
        String string = errorCodeExpr.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errorCodeExpr.text");
        Integer n = StringsKt.toIntOrNull((String)string);
        if (n != null && n == 0) {
            String string2 = SqlBundle.message("inspection.message.error.code.may.not.be.zero", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SqlBundle.message(\"inspe\u2026or.code.may.not.be.zero\")");
            this.reportError(reportOn, string2);
        }
    }

    static /* synthetic */ void checkBadErrorCode$default(SqlBaseValidationDelegate sqlBaseValidationDelegate, SqlExpression sqlExpression, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkBadErrorCode");
        }
        if ((n & 2) != 0) {
            psiElement = (PsiElement)sqlExpression;
        }
        sqlBaseValidationDelegate.checkBadErrorCode(sqlExpression, psiElement);
    }

    private final void checkErrorCodeExpr(SqlExpression errorCodeExpr, PsiElement reportOn) {
        block1: {
            SqlExpression sqlExpression;
            block0: {
                sqlExpression = errorCodeExpr;
                if (!(sqlExpression instanceof SqlStringLiteralExpression)) break block0;
                this.checkBadSqlState(errorCodeExpr, reportOn);
                break block1;
            }
            if (!(sqlExpression instanceof SqlLiteralExpression)) break block1;
            this.checkBadErrorCode(errorCodeExpr, reportOn);
        }
    }

    static /* synthetic */ void checkErrorCodeExpr$default(SqlBaseValidationDelegate sqlBaseValidationDelegate, SqlExpression sqlExpression, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkErrorCodeExpr");
        }
        if ((n & 2) != 0) {
            psiElement = (PsiElement)sqlExpression;
        }
        sqlBaseValidationDelegate.checkErrorCodeExpr(sqlExpression, psiElement);
    }

    private final JBIterable<PsiElement> getOptionKeywords(SqlRaiseStatement statement) {
        JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)statement.getOptionsClause()).filter(SqlSetAssignment.class).map((Function)getOptionKeywords.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil\n      .sqlCh\u2026         .first()\n      }");
        return jBIterable;
    }

    private final void checkSignalStatement(SqlSignalStatement o) {
        SqlDeclareConditionHandlerStatement parentHandler;
        SqlErrorSpec errorSpec = o.getErrorSpec();
        if (errorSpec instanceof SqlErrorCodeSpec) {
            SqlExpression sqlExpression = ((SqlErrorCodeSpec)errorSpec).getErrorCode();
            if (sqlExpression != null) {
                SqlExpression sqlExpression2 = sqlExpression;
                boolean bl = false;
                boolean bl2 = false;
                SqlExpression it2 = sqlExpression2;
                boolean bl3 = false;
                SqlExpression sqlExpression3 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)sqlExpression3, (String)"it");
                SqlBaseValidationDelegate.checkBadSqlState$default(this, sqlExpression3, null, 2, null);
            }
        } else if (errorSpec instanceof SqlConditionErrorSpec) {
            SqlExpression errorCodeExpr;
            SqlConditionDefinition condition;
            SqlCompositeElementImpl sqlCompositeElementImpl;
            PsiElement psiElement = ((SqlConditionErrorSpec)errorSpec).resolve();
            if (!(psiElement instanceof SqlConditionDefinition)) {
                psiElement = null;
            }
            SqlExpression sqlExpression = (sqlCompositeElementImpl = (condition = (SqlConditionDefinition)psiElement)) != null && (sqlCompositeElementImpl = ((SqlConditionDefinition)sqlCompositeElementImpl).getErrorSpec()) != null ? ((SqlErrorCodeSpec)sqlCompositeElementImpl).getErrorCode() : (errorCodeExpr = null);
            if (errorCodeExpr != null && !(errorCodeExpr instanceof SqlStringLiteralExpression)) {
                PsiElement psiElement2 = (PsiElement)errorSpec;
                String string = SqlBundle.message("inspection.message.condition.used.in.signal.statement.must.be.associated.with.sqlstate.value", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026ted.with.sqlstate.value\")");
                this.reportError(psiElement2, string);
            }
        }
        Dbms dbms = this.getDialect().getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        if (dbms.isMysql()) {
            HashSet<PsiElement> visitedNames = new HashSet<PsiElement>();
            for (PsiElement optionKeyword : this.getOptionKeywords(o)) {
                Object object = optionKeyword;
                if (object == null || (object = object.getText()) == null) {
                    continue;
                }
                Object optionName = object;
                if (visitedNames.add((PsiElement)optionName)) continue;
                String string = SqlBundle.message("inspection.message.duplicate.condition.information.item", optionName);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026mation.item\", optionName)");
                this.reportError(optionKeyword, string);
            }
        }
        if (o.isReraise() && (parentHandler = (SqlDeclareConditionHandlerStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), SqlDeclareConditionHandlerStatement.class, (boolean)true, (Class[])new Class[]{SqlDefinition.class})) == null) {
            PsiElement psiElement = (PsiElement)o;
            String string = SqlBundle.message("inspection.message.resignal.may.not.be.used.outside.condition.handler.context", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026ndition.handler.context\")");
            this.reportError(psiElement, string);
        }
    }

    public void visitSqlDefinition(@NotNull SqlDefinition o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (o instanceof SqlConditionDefinition) {
            SqlErrorCodeSpec sqlErrorCodeSpec = ((SqlConditionDefinition)o).getErrorSpec();
            if (sqlErrorCodeSpec == null || (sqlErrorCodeSpec = sqlErrorCodeSpec.getErrorCode()) == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlErrorCodeSpec), (String)"o.errorSpec?.errorCode ?: return");
            SqlErrorCodeSpec errorCodeExpr = sqlErrorCodeSpec;
            SqlBaseValidationDelegate.checkErrorCodeExpr$default(this, (SqlExpression)errorCodeExpr, null, 2, null);
        } else {
            super.visitSqlDefinition(o);
        }
    }

    public void visitSqlDeclareConditionHandlerStatement(@NotNull SqlDeclareConditionHandlerStatement o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        for (SqlErrorSpec errorSpec : o.getErrorSpecs()) {
            SqlErrorCodeSpec sqlErrorCodeSpec;
            SqlErrorCodeSpec errorCodeSpec = null;
            PsiElement reportOn = null;
            SqlErrorSpec sqlErrorSpec = errorSpec;
            if (sqlErrorSpec instanceof SqlErrorCodeSpec) {
                errorCodeSpec = (SqlErrorCodeSpec)errorSpec;
            } else if (sqlErrorSpec instanceof SqlConditionErrorSpec) {
                PsiElement psiElement = ((SqlConditionErrorSpec)errorSpec).resolve();
                if (!(psiElement instanceof SqlConditionDefinition)) {
                    psiElement = null;
                }
                SqlConditionDefinition sqlConditionDefinition = (SqlConditionDefinition)psiElement;
                errorCodeSpec = sqlConditionDefinition != null ? sqlConditionDefinition.getErrorSpec() : null;
                reportOn = (PsiElement)errorSpec;
            }
            if ((sqlErrorCodeSpec = errorCodeSpec) == null || (sqlErrorCodeSpec = sqlErrorCodeSpec.getErrorCode()) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlErrorCodeSpec), (String)"errorCodeSpec?.errorCode ?: continue");
            SqlErrorCodeSpec errorCodeExpr = sqlErrorCodeSpec;
            PsiElement psiElement = reportOn;
            if (psiElement == null) {
                psiElement = (PsiElement)errorCodeExpr;
            }
            this.checkErrorCodeExpr((SqlExpression)errorCodeExpr, psiElement);
        }
        Dbms dbms = this.getDialect().getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        if ((dbms2.isMysql() || dbms2.isDb2()) && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)o.getKindKeyword()), (Object)SqlCommonKeywords.SQL_UNDO)) {
            PsiElement psiElement = o.getKindKeyword();
            Intrinsics.checkNotNull((Object)psiElement);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"o.kindKeyword!!");
            String string = SqlBundle.message("inspection.message.undo.handlers.are.not.supported", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026dlers.are.not.supported\")");
            this.reportError(psiElement, string);
        }
        JBIterable jBIterable = o.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"o.body");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlStatement it2 = (SqlStatement)element$iv;
            boolean bl = false;
            it2.accept((SqlVisitor)this);
        }
    }

    public void visitSqlRaiseStatement(@NotNull SqlRaiseStatement o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (o instanceof SqlSignalStatement) {
            this.checkSignalStatement((SqlSignalStatement)o);
        } else {
            Dbms dbms = this.getDialect().getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
            Dbms dbms2 = dbms;
            if (dbms2.isOracle() || dbms2.isPostgres()) {
                PsiElement psiElement = o.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"o.firstChild");
                if (psiElement.getNextSibling() == null) {
                    JBIterable jBIterable = SqlImplUtil.sqlParents((PsiElement)o).filter(SqlExceptionWhenClause.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil.sqlParents(o\u2026onWhenClause::class.java)");
                    if (jBIterable.isEmpty()) {
                        PsiElement psiElement2 = (PsiElement)o;
                        String string = SqlBundle.message("inspection.message.raise.without.arguments.may.not.be.used.outside.exception.handler", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026tside.exception.handler\")");
                        this.reportError(psiElement2, string);
                    }
                }
            }
            if (dbms2.isPostgres() && o.getErrorSpec() != null) {
                Object v5;
                block8: {
                    Iterable $this$firstOrNull$iv = (Iterable)this.getOptionKeywords(o);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it2 = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCommonKeywords.SQL_ERRCODE)) continue;
                        v5 = element$iv;
                        break block8;
                    }
                    v5 = null;
                }
                PsiElement errorCodeOption = v5;
                if (errorCodeOption != null) {
                    PsiElement psiElement = errorCodeOption.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"errorCodeOption.parent");
                    String string = SqlBundle.message("inspection.message.raise.error.code.already.specified", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026.code.already.specified\")");
                    this.reportError(psiElement, string);
                }
            }
        }
    }

    public void visitSqlIdentifier(@NotNull SqlIdentifier o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        int maxLength = this.getDialect().getMaxIdentifierLength(o, this.minDbmsVersion);
        if (o.getName().length() > maxLength) {
            PsiElement psiElement = (PsiElement)o;
            String string = SqlBundle.message("inspection.message.identifier.too.long.should.not.exceed.characters", maxLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026d.characters\", maxLength)");
            this.reportError(psiElement, string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SqlBaseValidationDelegate(@NotNull SqlLanguageDialectEx dialect, @NotNull HighlightInfoHolder holder) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(dialect, holder);
        List<DbDataSource> list = SqlImplUtil.getDataSources((PsiElement)holder.getContextFile());
        Intrinsics.checkNotNullExpressionValue(list, (String)"SqlImplUtil.getDataSources(holder.contextFile)");
        Iterable iterable = list;
        SqlBaseValidationDelegate sqlBaseValidationDelegate = this;
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Version version;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DbDataSource it2 = (DbDataSource)element$iv$iv;
            boolean bl2 = false;
            DbDataSource dbDataSource = it2;
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"it");
            if (dbDataSource.getVersion() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Version it$iv$iv = version;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        sqlBaseValidationDelegate.minDbmsVersion = (Version)CollectionsKt.minOrNull((Iterable)list2);
    }
}

