/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DasUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlValuesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        SqlExpression place;
        if (parameters == null) {
            SqlValuesCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlValuesCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlValuesCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((place = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), (Class[])new Class[]{SqlReferenceExpression.class, SqlStringLiteralExpression.class})) == null) {
            return;
        }
        this.addElementsForValuesExpression((Consumer<LookupElement>)result2, (PsiElement)place);
    }

    @Nullable
    private static DasTable resolveTable(@NotNull PsiElement place) {
        if (place == null) {
            SqlValuesCompletionProvider.$$$reportNull$$$0(3);
        }
        if (!(place instanceof SqlExpression)) {
            return null;
        }
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)place, SqlStatement.class);
        if (!(statement instanceof SqlInsertStatement)) {
            return null;
        }
        for (PsiElement element2 : SqlImplUtil.sqlTraverser((PsiElement)statement).filterTypes(t -> t == SqlCompositeElementTypes.SQL_TABLE_REFERENCE)) {
            PsiElement resolve;
            if (!(element2 instanceof SqlReferenceExpression) || !((resolve = ((SqlReferenceExpression)element2).resolve()) instanceof DasTable)) continue;
            return (DasTable)resolve;
        }
        return null;
    }

    int resolveColumnIndex(@NotNull SqlValuesExpression values2, @NotNull PsiElement place) {
        if (values2 == null) {
            SqlValuesCompletionProvider.$$$reportNull$$$0(4);
        }
        if (place == null) {
            SqlValuesCompletionProvider.$$$reportNull$$$0(5);
        }
        for (SqlExpression expression : values2.getExpressions()) {
            int index2;
            if (!(expression instanceof SqlParenthesizedExpression) || (index2 = ((SqlParenthesizedExpression)expression).getExpressionList().indexOf(place)) < 0) continue;
            return index2;
        }
        return -1;
    }

    private void addElementsForValuesExpression(@NotNull Consumer<LookupElement> consumer2, @NotNull PsiElement place) {
        SqlValuesExpression values2;
        if (consumer2 == null) {
            SqlValuesCompletionProvider.$$$reportNull$$$0(6);
        }
        if (place == null) {
            SqlValuesCompletionProvider.$$$reportNull$$$0(7);
        }
        if ((values2 = (SqlValuesExpression)PsiTreeUtil.getParentOfType((PsiElement)place, SqlValuesExpression.class, (boolean)true, (Class[])new Class[]{SqlStatement.class})) == null) {
            return;
        }
        int index2 = this.resolveColumnIndex(values2, place);
        if (index2 < 0) {
            return;
        }
        DasTable table = SqlValuesCompletionProvider.resolveTable(place);
        if (table == null) {
            return;
        }
        List columns = DasUtil.getColumns(table).toList();
        if (index2 >= columns.size()) {
            return;
        }
        SqlCompletionUtil.addItemsFromExpectedColumnType(consumer2, (DasColumn)columns.get(index2), place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/completion/providers/SqlValuesCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveTable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveColumnIndex";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addElementsForValuesExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

