/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.database.Dbms;
import com.intellij.database.SqlUiService;
import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasPsiSymbol;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.completion.SqlCompletionScopeProcessor;
import com.intellij.sql.completion.SqlInsertHandlers;
import com.intellij.sql.completion.SqlQualifiedResolveResult;
import com.intellij.sql.completion.options.SqlCodeCompletionSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.formatter.SqlPreFormatHelper;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlPrefixedElement;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.symbols.DasInlineSymbol;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.sql.symbols.virtual.DasVirtualSymbol;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompletionUtil {
    private static final ElementPattern<PsiElement> NUMERIC_LITERAL = PlatformPatterns.psiElement().withElementType((ElementPattern)PlatformPatterns.elementType().oneOf((Object[])new IElementType[]{SqlTokens.SQL_INTEGER_TOKEN, SqlTokens.SQL_FLOAT_TOKEN}));
    private static final String SELF = "SELF";

    /*
     * WARNING - void declaration
     */
    public static boolean addLookupElement(@NotNull SqlLanguageDialectEx dialect, @NotNull DasSymbol symbol, @NotNull Project project, @NotNull Consumer<? super LookupElement> resultSet, boolean addDot, double forcePriority, @NotNull Dbms dbms) {
        void dbms2;
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(2);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(3);
        }
        if (dbms == null) {
            SqlCompletionUtil.$$$reportNull$$$0(4);
        }
        return SqlCompletionUtil.addLookupElement(dialect, (Dbms)dbms2, symbol, null, project, resultSet, addDot, forcePriority, null);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean addLookupElement(@NotNull SqlLanguageDialectEx dialect, @NotNull Dbms dbms, @NotNull DasSymbol symbol, @Nullable PsiElement forcedContext, @NotNull Project project, @NotNull Consumer<? super LookupElement> resultSet, boolean addDot, double forcePriority, @Nullable PsiElement psiElement) {
        void context;
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            SqlCompletionUtil.$$$reportNull$$$0(6);
        }
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(8);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(9);
        }
        return SqlCompletionUtil.addLookupElement(dialect, dbms, symbol, forcedContext, project, resultSet, addDot, forcePriority, (PsiElement)context, ContainerUtil.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean addLookupElement(@NotNull SqlLanguageDialectEx dialect, @NotNull Dbms dbms, @NotNull DasSymbol symbol, @Nullable PsiElement forcedContext, @NotNull Project project, @NotNull Consumer<? super LookupElement> resultSet, boolean addDot, double forcePriority, @Nullable PsiElement context, @NotNull Collection<SqlType> collection) {
        void expectedSqlTypes;
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(10);
        }
        if (dbms == null) {
            SqlCompletionUtil.$$$reportNull$$$0(11);
        }
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(13);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(14);
        }
        if (collection == null) {
            SqlCompletionUtil.$$$reportNull$$$0(15);
        }
        NamingService namingService = NamingServices.getNamingService(dbms);
        if (symbol instanceof DasInlineSymbol) {
            PsiElement psi = ((DasInlineSymbol)symbol).getDeclaringElement();
            return psi instanceof SqlReferenceExpression && SqlCompletionUtil.forSqlReference((SqlReferenceExpression)psi, resultSet, namingService, context);
        }
        DasObject dasObject = symbol.getDasObject();
        if (dasObject instanceof SqlAsExpression) {
            return SqlCompletionUtil.forAlias((SqlAsExpression)dasObject, forcedContext, resultSet, namingService, context);
        }
        if (dasObject instanceof SqlFunctionDefinition) {
            return SqlCompletionUtil.forSqlFunction(dialect, (SqlFunctionDefinition)((Object)dasObject), resultSet);
        }
        if (dasObject instanceof DasRoutine) {
            return SqlCompletionUtil.forProcedureInfo(symbol, resultSet, dialect, context, project);
        }
        return SqlCompletionUtil.forSymbol(symbol, project, forcedContext, resultSet, addDot, forcePriority, namingService, context, (Collection<SqlType>)expectedSqlTypes);
    }

    private static boolean forSqlReference(@NotNull SqlReferenceExpression r, @NotNull Consumer<? super LookupElement> resultSet, NamingService namingService, PsiElement context) {
        LookupElementBuilder builder;
        SqlIdentifier identifier;
        if (r == null) {
            SqlCompletionUtil.$$$reportNull$$$0(16);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(17);
        }
        String prefix = (identifier = r.getIdentifier()) == null ? null : identifier.getNamePrefix();
        SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings((PsiElement)r);
        String name = r.getName();
        if (prefix != null) {
            ObjectKind kind = r.getKind();
            builder = LookupElementBuilder.create((String)(prefix + name)).withPresentableText(prefix + namingService.catToScript(name, kind, settings.getQuotesPriority())).withInsertHandler(SqlInsertHandlers.createPrefixHandler(name, kind, prefix, namingService));
        } else {
            builder = LookupElementBuilder.create((String)name);
        }
        if (SqlCompletionUtil.canQualify(context)) {
            builder = builder.withInsertHandler(SqlInsertHandlers.chainHandlers(builder.getInsertHandler(), SqlInsertHandlers.createQualifierHandler(namingService)));
        }
        resultSet.consume((Object)builder);
        return true;
    }

    public static boolean canQualify(@Nullable IElementType elementType) {
        return elementType != SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE && elementType != SqlCompositeElementTypes.SQL_SHORT_REFERENCE;
    }

    public static boolean canQualify(@Nullable PsiElement element2) {
        return !(element2 instanceof SqlReferenceExpression) || SqlCompletionUtil.canQualify((IElementType)((SqlReferenceExpression)element2).getReferenceElementType());
    }

    private static boolean forSqlFunction(@NotNull SqlLanguageDialectEx dialect, @NotNull SqlFunctionDefinition f, @NotNull Consumer<? super LookupElement> resultSet) {
        SqlFunctionDefinition.Prototype[] prototypes;
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(18);
        }
        if (f == null) {
            SqlCompletionUtil.$$$reportNull$$$0(19);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(20);
        }
        if ((prototypes = f.getPrototypes()).length == 0) {
            return false;
        }
        for (SqlFunctionDefinition.Prototype prototype : prototypes) {
            resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(prototype, dialect), (double)1.0));
        }
        return true;
    }

    private static boolean forAlias(@NotNull SqlAsExpression t, @Nullable PsiElement forcedContext, @NotNull Consumer<? super LookupElement> resultSet, @NotNull NamingService namingService, @Nullable PsiElement context) {
        String name;
        if (t == null) {
            SqlCompletionUtil.$$$reportNull$$$0(21);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(22);
        }
        if (namingService == null) {
            SqlCompletionUtil.$$$reportNull$$$0(23);
        }
        if (StringUtil.isEmpty((String)(name = SqlCompletionUtil.calcName((DasSymbol)t, null, (Function<? super PsiFile, Case>)((Function)SqlPsiMiscUtil::getAliasCase))))) {
            return false;
        }
        LookupElementBuilder item = LookupElementBuilder.create((Object)new SqlQualifiedResolveResult(forcedContext, (DasSymbol)t), (String)name).withInsertHandler(SqlInsertHandlers.getQuoteAndDotHandler((DasSymbol)t, t.getProject(), namingService, false, SqlCompletionUtil.isQuotedPlace(context)));
        if (forcedContext != null) {
            String qname;
            String string = qname = forcedContext instanceof DbDataSource || !(forcedContext instanceof DasObject) ? null : QNameUtil.getQualifiedName((DasObject)forcedContext);
            if (StringUtil.isNotEmpty(qname)) {
                item = item.withTailText(" (" + qname + ")", true);
            }
            if (SqlCompletionUtil.canQualify(context)) {
                item = item.withInsertHandler(SqlInsertHandlers.chainHandlers(item.getInsertHandler(), SqlInsertHandlers.createQualifierHandler(namingService)));
            }
        }
        resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)PrioritizedLookupElement.withGrouping((LookupElement)item, (int)1), (double)10.0));
        return true;
    }

    public static void addReferenceCompletionVariants(@NotNull SqlReferenceImpl reference, @NotNull PrefixMatcher prefixMatcher, @NotNull Consumer<LookupElement> resultSet, @NotNull CompletionParameters completionParameters, @Nullable BiConsumer<? super DasObject, PsiElement> acceptedElementConsumer) {
        if (reference == null) {
            SqlCompletionUtil.$$$reportNull$$$0(24);
        }
        if (prefixMatcher == null) {
            SqlCompletionUtil.$$$reportNull$$$0(25);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(26);
        }
        if (completionParameters == null) {
            SqlCompletionUtil.$$$reportNull$$$0(27);
        }
        SqlElement refElement = (SqlElement)reference.getElement();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)refElement);
        List<DbDataSource> dataSources = SqlImplUtil.getDataSources((PsiElement)SqlImplUtil.getTopLevelSqlFile(refElement.getContainingFile()));
        CamelHumpMatcher adjustedMatcher = new CamelHumpMatcher(prefixMatcher.getPrefix(), false);
        boolean missingFrom = SqlCompletionUtil.hasMissingFrom(refElement);
        SqlExpression qualifier = reference.getQualifier();
        boolean filterPgRoutines = qualifier != null && dialect.getDbms().isPostgres() && SqlImplUtil.canResolveToPgFunctionColumn((PsiElement)refElement);
        SqlPrimitiveType qualifierType = filterPgRoutines ? qualifier.getSqlType() : SqlType.UNKNOWN;
        Set<ObjectKind> expectedTypesStrict = reference.getExpectedTargetTypesStrict(dialect);
        boolean addColumns = SqlCompletionUtil.shouldAddMissingColumns(reference);
        SqlCompletionScopeProcessor processor2 = new SqlCompletionScopeProcessor(dialect, dataSources, refElement, addColumns, adjustedMatcher, resultSet, missingFrom, filterPgRoutines, (SqlType)qualifierType, expectedTypesStrict, completionParameters, acceptedElementConsumer);
        if (reference.initExpectedTargetTypes(processor2)) {
            reference.processResolveVariants(processor2);
        }
        dialect.processReservedEntitiesWithType(null, (PsiElement)refElement, false, processor2);
    }

    public static boolean hasMissingFrom(SqlElement refElement) {
        boolean missingFrom = false;
        SqlQueryExpression closestSelect = (SqlQueryExpression)SyntaxTraverser.psiApi().parents((Object)refElement).filter(SqlQueryExpression.class).filter(q -> q.getSelectClause() != null).first();
        if (closestSelect != null) {
            SqlTableExpression tableExpression = closestSelect.getTableExpression();
            missingFrom = tableExpression == null || tableExpression.getFromClause() == null;
        }
        return missingFrom;
    }

    private static boolean shouldAddMissingColumns(@NotNull SqlReferenceImpl reference) {
        if (reference == null) {
            SqlCompletionUtil.$$$reportNull$$$0(28);
        }
        if (reference.getReferenceElementType().getTargetKind() != ObjectKind.COLUMN) {
            return false;
        }
        SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), SqlQueryExpression.class);
        if (query == null) {
            return false;
        }
        if (!PsiTreeUtil.isContextAncestor((PsiElement)query.getSelectClause(), (PsiElement)reference.getElement(), (boolean)true)) {
            return false;
        }
        SqlTableExpression tableExpression = query.getTableExpression();
        SqlFromClause fromClause = tableExpression != null ? tableExpression.getFromClause() : null;
        return fromClause == null || fromClause.getFromExpression() == null;
    }

    public static boolean isCompletionAllowed(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            SqlCompletionUtil.$$$reportNull$$$0(29);
        }
        if (!parameters.isAutoPopup()) {
            return true;
        }
        int offset = parameters.getOffset() - 1;
        PsiFile file = parameters.getOriginalFile();
        PsiElement element2 = offset >= 0 && offset < file.getTextLength() ? file.findElementAt(offset) : null;
        return element2 == null || !NUMERIC_LITERAL.accepts((Object)element2);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean forSymbol(@NotNull DasSymbol symbol, @NotNull Project project, @Nullable PsiElement forcedContext, @NotNull Consumer<? super LookupElement> resultSet, boolean addDot, double forcePriority, @NotNull NamingService namingService, @Nullable PsiElement element2, @NotNull Collection<SqlType> collection) {
        boolean foundInSearchPath;
        double priority;
        DasObject dasObject;
        LookupElementBuilder lookup;
        block20: {
            void expectedSqlTypes;
            DasObject context;
            String name;
            if (symbol == null) {
                SqlCompletionUtil.$$$reportNull$$$0(30);
            }
            if (project == null) {
                SqlCompletionUtil.$$$reportNull$$$0(31);
            }
            if (resultSet == null) {
                SqlCompletionUtil.$$$reportNull$$$0(32);
            }
            if (namingService == null) {
                SqlCompletionUtil.$$$reportNull$$$0(33);
            }
            if (collection == null) {
                SqlCompletionUtil.$$$reportNull$$$0(34);
            }
            if (StringUtil.isEmpty((String)(name = SqlCompletionUtil.calcName(symbol, element2, (Function<? super PsiFile, Case>)((Function)SqlPsiMiscUtil::getIdentifierCase))))) {
                return false;
            }
            if (SqlImplUtil.getDbms(element2).isCouchbase()) {
                name = name.contains(".") ? name.substring(name.lastIndexOf(".") + 1) : name;
            }
            Icon icon = DasSymbolUtil.getIcon(symbol);
            lookup = LookupElementBuilder.create((Object)new SqlQualifiedResolveResult(forcedContext, symbol), (String)name).withTypeText(SqlCompletionUtil.typeText(symbol)).withInsertHandler(SqlInsertHandlers.getQuoteAndDotHandler(symbol, project, namingService, addDot, SqlCompletionUtil.isQuotedPlace(element2))).withIcon(icon);
            String prefix = SqlCompletionUtil.getPrefix(symbol);
            if (prefix != null) {
                lookup = lookup.withPresentableText(prefix + namingService.catToScript(symbol.getName(), symbol.getKind(), SqlPsiMiscUtil.settings(symbol, project).getQuotesPriority()));
            }
            if (name.contains(" ")) {
                lookup = lookup.withLookupString(StringUtil.toLowerCase((String)name).replaceAll(" ", "_")).withLookupString(name.replaceAll(" ", "_"));
            }
            dasObject = symbol.getDasObject();
            DasObject dasObject2 = context = forcedContext == null && dasObject != null ? dasObject.getDasParent() : (DasObject)ObjectUtils.tryCast((Object)forcedContext, DasObject.class);
            if (context != null) {
                String qname;
                String string = qname = context instanceof DbDataSource ? null : QNameUtil.getQualifiedName(context);
                if (StringUtil.isNotEmpty((String)qname)) {
                    lookup = lookup.withTailText(" (" + qname + ")", true);
                }
            }
            priority = SqlCompletionUtil.isTypeMatch(symbol, project, (PsiElement)(symbol instanceof DasPsiSymbol ? (DasPsiSymbol)symbol : element2), (Collection<SqlType>)expectedSqlTypes) ? 250.0 : (dasObject instanceof DbElement || dasObject instanceof BasicElement ? 5.0 : 10.0);
            for (DasObject cur2 = dasObject; cur2 != null; cur2 = cur2.getDasParent()) {
                priority += 0.1;
            }
            JdbcConsoleCore console = element2 != null ? JdbcConsoleProviderCore.getValidConsole(project, element2.getContainingFile().getOriginalFile().getVirtualFile()) : null;
            SearchPath searchPath = console != null ? console.getSearchPath() : null;
            List<Object> chosenObjectPaths = searchPath != null ? searchPath.elements : Collections.emptyList();
            foundInSearchPath = false;
            if (!chosenObjectPaths.isEmpty()) {
                ObjectPath candidatePath = ObjectPaths.of(dasObject);
                int searchPathSize = chosenObjectPaths.size();
                double step = 5.0 / (double)searchPathSize;
                for (int i2 = 0; i2 < searchPathSize; ++i2) {
                    ObjectPath chosenObjectPath = (ObjectPath)chosenObjectPaths.get(i2);
                    ObjectPath currentPath = candidatePath;
                    while (currentPath != null) {
                        if (currentPath.equals(chosenObjectPath)) {
                            priority += step * (double)(searchPathSize - i2);
                            foundInSearchPath = true;
                            break block20;
                        }
                        currentPath = currentPath.parent;
                    }
                }
            } else {
                foundInSearchPath = true;
            }
        }
        if (SqlCodeCompletionSettings.getInstance().isSuggestObjectsFromSearchPathOnly() && !foundInSearchPath) {
            return false;
        }
        if (SqlCompletionUtil.canQualify(element2)) {
            lookup = lookup.withInsertHandler(SqlInsertHandlers.chainHandlers(lookup.getInsertHandler(), SqlInsertHandlers.createQualifierHandler(namingService)));
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element2);
        if (dasObject instanceof DasTable && element2 instanceof SqlReferenceExpression && ((SqlReferenceExpression)element2).getReferenceElementType() == SqlCompositeElementTypes.SQL_TABLE_REFERENCE && SqlCodeCompletionSettings.getInstance().isAutoAliasTable() && dialect.isTableAliasAllowedAt(element2)) {
            Case keywordCase = SqlPsiMiscUtil.settings(element2 != null ? element2.getContainingFile() : null).getKeywordCase();
            String delimiter = dialect.requiresAsForAliasAt(element2) ? " " + keywordCase.apply("as") + " " : " ";
            lookup = lookup.withPresentableText(lookup.getLookupString() + delimiter + SqlNamesGenerator.suggestAliasName(dasObject.getName(), element2)).withInsertHandler(SqlInsertHandlers.chainHandlers(lookup.getInsertHandler(), SqlInsertHandlers.ADD_TABLE_ALIAS_HANDLER));
        }
        resultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)lookup, (double)Math.max(forcePriority, priority)));
        return true;
    }

    private static boolean isQuotedPlace(@Nullable PsiElement element2) {
        return element2 instanceof SqlReferenceExpression && ((SqlReferenceExpression)element2).isQuotedIdentifier();
    }

    private static boolean isTypeMatch(@NotNull DasSymbol symbol, @NotNull Project project, @Nullable PsiElement context, @NotNull Collection<SqlType> expectedSqlTypes) {
        SqlType ownType;
        DasObject object;
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(35);
        }
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(36);
        }
        if (expectedSqlTypes == null) {
            SqlCompletionUtil.$$$reportNull$$$0(37);
        }
        if ((object = symbol.getDasObject()) instanceof DasColumn && (DasUtil.isPrimary((DasColumn)object) || DasUtil.isForeign((DasColumn)object))) {
            return false;
        }
        SqlType sqlType = ownType = object instanceof DasTypedObject ? SqlImplUtil.getSqlType((DasTypedObject)object, DasSymbolUtil.getSqlDialect(symbol), (UserDataHolder)symbol, context, project) : null;
        if (ownType == null || expectedSqlTypes.size() == 0) {
            return false;
        }
        return expectedSqlTypes.stream().anyMatch(t -> SqlFunctionsUtil.isAssignable(t, ownType));
    }

    @Nullable
    private static String calcName(@NotNull DasSymbol symbol, @Nullable PsiElement e, @NotNull Function<? super PsiFile, Case> plainCaseGetter) {
        PsiFile contextFile;
        String roughName;
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(38);
        }
        if (plainCaseGetter == null) {
            SqlCompletionUtil.$$$reportNull$$$0(39);
        }
        if (StringUtil.isEmpty((String)(roughName = SqlCompletionUtil.roughName(symbol)))) {
            return null;
        }
        SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(e != null ? e.getContainingFile() : null);
        if (settings != null && settings.QUOTE_IDENTIFIER == 2) {
            if (!(symbol instanceof SqlDefinition)) {
                return roughName;
            }
            SqlDefinition definition = (SqlDefinition)symbol;
            if (definition.isNameQuoted()) {
                return roughName;
            }
            Casing casing = DasSymbolUtil.getSqlDialect(symbol).getCasing(definition.getKind(), (DasObject)definition);
            return casing.plain.apply(roughName);
        }
        if (settings != null && settings.ORIGINAL_CASE) {
            return (String)ObjectUtils.notNull((Object)SqlPreFormatHelper.obtainOriginalCase(null, symbol), (Object)roughName);
        }
        PsiElement source = DasSymbolUtil.getSinglePsiSource(symbol);
        PsiFile psiFile = contextFile = source != null ? source.getContainingFile() : null;
        if (contextFile == null) {
            contextFile = e != null ? e.getContainingFile() : null;
        }
        return SqlCompletionUtil.getMode(contextFile, symbol, plainCaseGetter).apply(roughName);
    }

    @NotNull
    private static Case getMode(@Nullable PsiFile file, @NotNull DasSymbol symbol, @NotNull Function<? super PsiFile, Case> plainCaseGetter) {
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(40);
        }
        if (plainCaseGetter == null) {
            SqlCompletionUtil.$$$reportNull$$$0(41);
        }
        Case case_ = SqlCompletionUtil.hasPlainIdentifier(symbol) ? (Case)((Object)plainCaseGetter.fun((Object)file)) : SqlPsiMiscUtil.getQuotedIdentifierCase(file);
        if (case_ == null) {
            SqlCompletionUtil.$$$reportNull$$$0(42);
        }
        return case_;
    }

    public static boolean hasPlainIdentifier(@NotNull DasSymbol symbol) {
        DasObject obj;
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(43);
        }
        if ((obj = symbol.getDasObject()) != null) {
            String id;
            boolean isSql = DbSqlUtilCore.isSqlObject(obj);
            if (isSql) {
                return !DbSqlUtilCore.isQuoted(obj);
            }
            NamingService namingService = NamingServices.getNamingService(SqlImplUtil.getDbms(obj));
            return !namingService.isQuoted(id = namingService.catToScript(obj.getName(), obj.getKind()));
        }
        return !symbol.isQuoted();
    }

    @NotNull
    private static String roughName(@NotNull DasSymbol symbol) {
        String origin;
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(44);
        }
        if (symbol instanceof SqlFileImpl.GroupImpl && (origin = ((SqlFileImpl.GroupImpl)symbol).getOriginalName()) != null) {
            String string = origin;
            if (string == null) {
                SqlCompletionUtil.$$$reportNull$$$0(45);
            }
            return string;
        }
        String prefix = SqlCompletionUtil.getPrefix(symbol);
        Object object = prefix == null ? symbol.getName() : prefix + symbol.getName();
        if (object == null) {
            SqlCompletionUtil.$$$reportNull$$$0(46);
        }
        return object;
    }

    @NotNull
    private static String typeText(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(47);
        }
        if (symbol instanceof DasTypedObject) {
            String string = JdbcUtil.getJdbcTypeName(((DasTypedObject)((Object)symbol)).getDataType());
            if (string == null) {
                SqlCompletionUtil.$$$reportNull$$$0(48);
            }
            return string;
        }
        if (symbol instanceof DasVirtualSymbol) {
            String string = DasSymbolUtil.getTypeName(symbol);
            if (string == null) {
                SqlCompletionUtil.$$$reportNull$$$0(49);
            }
            return string;
        }
        if (symbol instanceof DbElement) {
            String string = ((DbElement)symbol).getDataSource().getName();
            if (string == null) {
                SqlCompletionUtil.$$$reportNull$$$0(50);
            }
            return string;
        }
        PsiElement psi = DasSymbolUtil.getSinglePsiSource(symbol);
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psi);
        String string = file == null ? symbol.getName() : SqlUiService.getInstance().getPresentableNameForUi(psi.getProject(), file);
        if (string == null) {
            SqlCompletionUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    @Nullable
    static SqlPrefixedElement getPrefixed(@NotNull PsiNamedElement o) {
        if (o == null) {
            SqlCompletionUtil.$$$reportNull$$$0(52);
        }
        return (SqlPrefixedElement)ObjectUtils.tryCast((Object)(o instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)o).getNameIdentifier() : o), SqlPrefixedElement.class);
    }

    @Nullable
    private static String getPrefix(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(53);
        }
        SqlPrefixedElement prefixed = symbol instanceof PsiNamedElement ? SqlCompletionUtil.getPrefixed((PsiNamedElement)symbol) : null;
        return prefixed == null ? null : prefixed.getNamePrefix();
    }

    private static boolean forProcedureInfo(@NotNull DasSymbol symbol, @NotNull Consumer<? super LookupElement> resultSet, @NotNull SqlLanguageDialectEx dialect, @Nullable PsiElement context, @NotNull Project project) {
        LookupElement routineItem;
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(54);
        }
        if (resultSet == null) {
            SqlCompletionUtil.$$$reportNull$$$0(55);
        }
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(56);
        }
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(57);
        }
        if ((routineItem = SqlCompletionUtil.createRoutineLookupItem(symbol, dialect, context, project)) != null) {
            LookupElement procedureLookup = PrioritizedLookupElement.withPriority((LookupElement)routineItem, (double)0.0);
            resultSet.consume((Object)procedureLookup);
        }
        return true;
    }

    @NotNull
    public static LookupElement createEntityLookupItem(@NotNull PsiFile psiFile, @NotNull String entityName, @Nullable SqlType type, @NotNull ObjectKind kind, boolean forcedCaseSens) {
        if (psiFile == null) {
            SqlCompletionUtil.$$$reportNull$$$0(58);
        }
        if (entityName == null) {
            SqlCompletionUtil.$$$reportNull$$$0(59);
        }
        if (kind == null) {
            SqlCompletionUtil.$$$reportNull$$$0(60);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)(forcedCaseSens ? entityName : SqlPsiMiscUtil.getIdentifierCase(psiFile).apply(entityName))).bold().withTypeText(SqlCompletionUtil.getTypeText(type, kind)).withIcon(DbPresentationCore.getIcon(kind));
        if (lookupElementBuilder == null) {
            SqlCompletionUtil.$$$reportNull$$$0(61);
        }
        return lookupElementBuilder;
    }

    @Nullable
    private static String getTypeText(@Nullable SqlType type, @NotNull ObjectKind kind) {
        if (kind == null) {
            SqlCompletionUtil.$$$reportNull$$$0(62);
        }
        if (type instanceof SqlTableType) {
            return null;
        }
        return type != null && type != SqlTypeFactory.REFERENCE ? type.getDisplayName() : StringUtil.toLowerCase((String)kind.name());
    }

    @NotNull
    public static LookupElementBuilder createLookupItem(@NotNull String str, boolean boldness, boolean strikeout, boolean caseSensitivity, @Nullable InsertHandler<LookupElement> handler, @NotNull Collection<String> aliases) {
        if (str == null) {
            SqlCompletionUtil.$$$reportNull$$$0(63);
        }
        if (aliases == null) {
            SqlCompletionUtil.$$$reportNull$$$0(64);
        }
        LookupElementBuilder element2 = LookupElementBuilder.create((String)str).withBoldness(boldness).withStrikeoutness(strikeout).withCaseSensitivity(caseSensitivity).withInsertHandler(handler);
        LookupElementBuilder lookupElementBuilder = aliases.isEmpty() ? element2 : element2.withLookupStrings(aliases);
        if (lookupElementBuilder == null) {
            SqlCompletionUtil.$$$reportNull$$$0(65);
        }
        return lookupElementBuilder;
    }

    private static boolean isAlterTarget(@Nullable PsiElement element2) {
        SqlAlterStatement alter = (SqlAlterStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlAlterStatement.class);
        return alter != null && PsiTreeUtil.isContextAncestor((PsiElement)alter.getAlterTargetReference(), (PsiElement)element2, (boolean)false);
    }

    public static boolean isModificationTarget(@Nullable PsiElement element2) {
        return SqlPsiMiscUtil.isDropTarget(element2) || SqlCompletionUtil.isAlterTarget(element2);
    }

    @Nullable
    public static LookupElement createRoutineLookupItem(@NotNull DasSymbol symbol, @NotNull SqlLanguageDialectEx sqlDialect, @Nullable PsiElement context, @NotNull Project project) {
        DasRoutine def;
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(66);
        }
        if (sqlDialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(67);
        }
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(68);
        }
        if ((def = (DasRoutine)ObjectUtils.tryCast((Object)symbol.getDasObject(), DasRoutine.class)) == null) {
            return null;
        }
        @NotNull DatabaseDialectEx dialect = sqlDialect.getDatabaseDialect();
        Iterable<? extends DasArgument> parameters = SqlCompletionUtil.getSignatureArguments(def, dialect);
        DdlBuilder builder = new DdlBuilder(){

            @Override
            @NotNull
            public DdlBuilder identifier(@NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                DdlBuilder ddlBuilder = this.plain(name);
                if (ddlBuilder == null) {
                    1.$$$reportNull$$$0(1);
                }
                return ddlBuilder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/completion/SqlCompletionUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/completion/SqlCompletionUtil$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "identifier";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "identifier";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.withDialect(dialect).applyCodeStyle(project, sqlDialect);
        builder.identifier(def.getName());
        String name = builder.getStatement();
        boolean isModificationTarget = SqlCompletionUtil.isModificationTarget(context);
        boolean supportsOverloads = dialect.getDbms().isPostgres();
        boolean noParensCall = dialect.getDbms().isMicrosoft() && PsiTreeUtil.getParentOfType((PsiElement)context, SqlSelectClause.class) == null;
        boolean modificationNoOverloads = isModificationTarget && !supportsOverloads;
        boolean useSpaces = noParensCall || modificationNoOverloads;
        boolean noParams = Iterables.isEmpty(parameters) || modificationNoOverloads;
        String parametersText = SqlCompletionUtil.addParametersText(builder.clear(), parameters, useSpaces).getStatement();
        String returnTypeText = SqlPsiMiscUtil.addReturnTypeText(builder.clear(), def.getReturnArgument()).getStatement();
        SqlFunctionDefinition definition = sqlDialect.getSupportedFunctions().get(name);
        return LookupElementBuilder.create((Object)symbol, (String)name).withIcon(DatabaseIcons.Function).withPresentableText(name + parametersText).withTypeText(returnTypeText).withInsertHandler((InsertHandler)new SqlInsertHandlers.FunctionElementInsertHandler(dialect.getDbms(), useSpaces, noParams, isModificationTarget && supportsOverloads ? parametersText : null, definition, SqlCompletionUtil.findMatchingPrototype(def, definition)));
    }

    @Nullable
    private static SqlFunctionDefinition.Prototype findMatchingPrototype(@NotNull DasRoutine def, @Nullable SqlFunctionDefinition definition) {
        if (def == null) {
            SqlCompletionUtil.$$$reportNull$$$0(69);
        }
        if (definition == null) {
            return null;
        }
        Iterable<? extends DasArgument> arguments = def.getArguments();
        for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
            Iterator<? extends DasArgument> iterator = arguments.iterator();
            boolean match2 = true;
            for (SqlFunctionDefinition.Parameter param : prototype.getParams()) {
                DataType type2;
                if (!(param instanceof SqlFunctionDefinition.SimpleParameter) || !iterator.hasNext()) {
                    match2 = false;
                    break;
                }
                DasArgument argument = iterator.next();
                DataType type = argument.getDataType();
                if (type.equals(type2 = ((SqlFunctionDefinition.SimpleParameter)param).getType().getDataType())) continue;
                match2 = false;
                break;
            }
            if (!match2 || iterator.hasNext()) continue;
            return prototype;
        }
        return null;
    }

    @NotNull
    private static Iterable<? extends DasArgument> getSignatureArguments(@NotNull DasRoutine def, @NotNull DatabaseDialectEx dialect) {
        DasArgument argument;
        Iterator<? extends DasArgument> iterator;
        if (def == null) {
            SqlCompletionUtil.$$$reportNull$$$0(70);
        }
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(71);
        }
        JBIterable parameters = DasUtil.getParameters(def);
        if (dialect.getDbms().isOracle() && (iterator = def.getArguments().iterator()).hasNext() && SELF.equalsIgnoreCase((argument = iterator.next()).getName())) {
            parameters = parameters.skip(1);
        }
        JBIterable jBIterable = parameters;
        if (jBIterable == null) {
            SqlCompletionUtil.$$$reportNull$$$0(72);
        }
        return jBIterable;
    }

    @NotNull
    public static DdlBuilder addParametersText(@NotNull DdlBuilder builder, @NotNull Iterable<? extends DasArgument> parameters, boolean useSpaces) {
        if (builder == null) {
            SqlCompletionUtil.$$$reportNull$$$0(73);
        }
        if (parameters == null) {
            SqlCompletionUtil.$$$reportNull$$$0(74);
        }
        builder.symbol(useSpaces ? " " : "(");
        boolean first2 = true;
        for (DasArgument dasArgument : parameters) {
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            String name = dasArgument.getName();
            if (name != DasUtil.NO_NAME) {
                builder.identifier(name).symbol(" ");
            }
            builder.type(dasArgument);
        }
        builder.symbol(useSpaces ? "" : ")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SqlCompletionUtil.$$$reportNull$$$0(75);
        }
        return ddlBuilder;
    }

    public static LookupElement createLookupItem(final @NotNull SqlFunctionDefinition.Prototype prototype, @NotNull SqlLanguageDialect dialect) {
        if (prototype == null) {
            SqlCompletionUtil.$$$reportNull$$$0(76);
        }
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(77);
        }
        Case routineCase = ((SqlLanguageDialectEx)dialect).getCasing((ObjectKind)ObjectKind.ROUTINE, null).plain;
        return LookupElementBuilder.create((Object)prototype, (String)prototype.getFunction().getName()).withCaseSensitivity(routineCase.sensitive).withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(@NotNull LookupElement element2, @NotNull LookupElementPresentation presentation) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (presentation == null) {
                    2.$$$reportNull$$$0(1);
                }
                presentation.setIcon(DatabaseIcons.Function);
                presentation.setItemText(element2.getLookupString());
                String params = new SqlFunctionDefinition.ParameterBlock(-1, prototype.getBlockType(), prototype.getParams(), false).toString();
                presentation.appendTailText(params, true);
                presentation.setTypeText(prototype.getReturnType().getDisplayName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlCompletionUtil$2";
                objectArray[2] = "renderElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).withInsertHandler((InsertHandler)new SqlInsertHandlers.FunctionElementInsertHandler(dialect.getDbms(), ((SqlLanguageDialectEx)dialect).canBeCalledWithoutParens(prototype), prototype.getParams().length == 0, null, prototype.getFunction(), prototype));
    }

    public static LookupElement createTextLookup(String lookupString, final String presentationString, double priority) {
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)lookupString).withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(@NotNull LookupElement element2, @NotNull LookupElementPresentation presentation) {
                if (element2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (presentation == null) {
                    3.$$$reportNull$$$0(1);
                }
                presentation.setItemText(presentationString);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlCompletionUtil$3";
                objectArray[2] = "renderElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }), (double)priority);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static LookupElement createKeywordLookupElement(@NotNull Case keywordCase, @NotNull String str, @Nullable InsertHandler<LookupElement> handler, double correction, boolean bl) {
        void strikeout;
        if (keywordCase == null) {
            SqlCompletionUtil.$$$reportNull$$$0(78);
        }
        if (str == null) {
            SqlCompletionUtil.$$$reportNull$$$0(79);
        }
        return SqlCompletionUtil.createKeywordLookupElement(keywordCase, str, handler, correction, ContainerUtil.emptyList(), (boolean)strikeout);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static LookupElement createKeywordLookupElement(@NotNull Case keywordCase, @NotNull String str, @Nullable InsertHandler<LookupElement> handler, double correction, @NotNull Collection<String> aliases, boolean bl) {
        void strikeout;
        if (keywordCase == null) {
            SqlCompletionUtil.$$$reportNull$$$0(80);
        }
        if (str == null) {
            SqlCompletionUtil.$$$reportNull$$$0(81);
        }
        if (aliases == null) {
            SqlCompletionUtil.$$$reportNull$$$0(82);
        }
        boolean caseSensitive = keywordCase == Case.UPPER || keywordCase == Case.LOWER;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(keywordCase.apply(str), true, (boolean)strikeout, caseSensitive, handler, aliases), (double)(7.0 + correction));
        if (lookupElement == null) {
            SqlCompletionUtil.$$$reportNull$$$0(83);
        }
        return lookupElement;
    }

    public static void addItemsFromExpectedColumnType(@NotNull Consumer<? super LookupElement> consumer2, @NotNull DasColumn column2, @NotNull PsiElement place) {
        if (consumer2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(84);
        }
        if (column2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(85);
        }
        if (place == null) {
            SqlCompletionUtil.$$$reportNull$$$0(86);
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(place);
        if (SqlCompletionUtil.addValuesFromDataType(consumer2, column2.getDataType(), place instanceof SqlStringLiteralExpression, dialect)) {
            return;
        }
        SqlType type = SqlCompletionUtil.getColumnSqlType(column2, place);
        SqlCompletionUtil.addItemsFromExpectedColumnType(consumer2, place, type, dialect);
    }

    public static void addItemsFromExpectedColumnType(@NotNull Consumer<? super LookupElement> consumer2, @NotNull PsiElement place, @NotNull SqlType type, SqlLanguageDialectEx dialect) {
        boolean quoted;
        if (consumer2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(87);
        }
        if (place == null) {
            SqlCompletionUtil.$$$reportNull$$$0(88);
        }
        if (type == null) {
            SqlCompletionUtil.$$$reportNull$$$0(89);
        }
        if (!(quoted = place instanceof SqlStringLiteralExpression) && type.getCategory() == SqlType.Category.BOOLEAN) {
            SqlCompletionUtil.addTrueFalse(consumer2);
            return;
        }
        SqlCompletionUtil.addValuesFromDataType(consumer2, type.getDataType(), quoted, dialect);
    }

    private static void addTrueFalse(@NotNull Consumer<? super LookupElement> consumer2) {
        if (consumer2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(90);
        }
        consumer2.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"true").withBoldness(true), (double)250.0));
        consumer2.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"false").withBoldness(true), (double)250.0));
    }

    private static boolean addValuesFromDataType(@NotNull Consumer<? super LookupElement> consumer2, DataType dataType, boolean quoted, SqlLanguageDialectEx dialect) {
        if (consumer2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(91);
        }
        if (!quoted && ("boolean".equals(dataType.typeName) || "bool".equals(dataType.typeName))) {
            SqlCompletionUtil.addTrueFalse(consumer2);
            return true;
        }
        List<String> enumValues = dataType.enumValues;
        if (enumValues != null) {
            boolean added = false;
            for (String enumValue : enumValues) {
                enumValue = SqlCompletionUtil.fixEnumValue(enumValue, quoted, dialect);
                consumer2.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)enumValue), (double)250.0));
                added = true;
            }
            return added;
        }
        return false;
    }

    @NotNull
    private static SqlType getColumnSqlType(@NotNull DasColumn column2, @NotNull PsiElement place) {
        if (column2 == null) {
            SqlCompletionUtil.$$$reportNull$$$0(92);
        }
        if (place == null) {
            SqlCompletionUtil.$$$reportNull$$$0(93);
        }
        SqlType sqlType = SqlImplUtil.getSqlType(column2.getDataType(), SqlImplUtil.getSqlDialectSafe(place), place);
        if (sqlType == null) {
            SqlCompletionUtil.$$$reportNull$$$0(94);
        }
        return sqlType;
    }

    @NotNull
    private static String fixEnumValue(@NotNull String enumValue, boolean insideLiteral, SqlLanguageDialectEx dialect) {
        int quote;
        int eq;
        if (enumValue == null) {
            SqlCompletionUtil.$$$reportNull$$$0(95);
        }
        if (dialect.getDbms().isClickHouse() && (eq = enumValue.indexOf(61, (quote = (quote = enumValue.indexOf(39)) == -1 ? -1 : enumValue.indexOf(39, quote + 1)) == -1 ? 0 : quote)) != -1) {
            enumValue = enumValue.substring(0, eq).trim();
        }
        if (!insideLiteral && !StringUtil.isQuotedString((String)enumValue)) {
            String string = "'" + enumValue + "'";
            if (string == null) {
                SqlCompletionUtil.$$$reportNull$$$0(96);
            }
            return string;
        }
        if (insideLiteral && StringUtil.isQuotedString((String)enumValue)) {
            String string = StringUtil.unquoteString((String)enumValue, (char)'\'');
            if (string == null) {
                SqlCompletionUtil.$$$reportNull$$$0(97);
            }
            return string;
        }
        String string = enumValue;
        if (string == null) {
            SqlCompletionUtil.$$$reportNull$$$0(98);
        }
        return string;
    }

    @Nullable
    public static LookupElement createAllColumnsLookupElement(@NotNull Iterable<? extends DasObject> columns, @NotNull Project project, @NotNull SqlLanguageDialectEx dialect, int priority, boolean parenthesized, boolean canQualify, List<PsiElement> qualifiers, @NotNull Dbms dbms) {
        if (columns == null) {
            SqlCompletionUtil.$$$reportNull$$$0(99);
        }
        if (project == null) {
            SqlCompletionUtil.$$$reportNull$$$0(100);
        }
        if (dialect == null) {
            SqlCompletionUtil.$$$reportNull$$$0(101);
        }
        if (dbms == null) {
            SqlCompletionUtil.$$$reportNull$$$0(102);
        }
        DdlBuilder classic = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect());
        DasObject last = null;
        HashSet<String> names = new HashSet<String>();
        HashSet<String> parentNames = new HashSet<String>();
        for (DasObject dasObject : columns) {
            DasSymbol columnSymbol = DasSymbolUtil.wrapObjectToSymbol(dasObject, project);
            if (names.size() != 0) {
                classic.symbol(",").space();
            }
            classic.suppressQuoteIdentifiers(!DbSqlUtilCore.isQuoted(dasObject));
            String name = SqlCompletionUtil.calcName(columnSymbol, null, (Function<? super PsiFile, Case>)((Function)SqlPsiMiscUtil::getIdentifierCase));
            if (name == null) {
                name = dasObject.getName();
            }
            names.add(name);
            classic.columnRef(name);
            parentNames.add(QNameUtil.getQualifiedName(dasObject.getDasParent()));
            last = dasObject;
        }
        if (last == null || names.size() == 1) {
            return null;
        }
        String statement = classic.getStatement();
        if (statement.isEmpty()) {
            return null;
        }
        InsertHandler<LookupElement> insertHandler = canQualify ? SqlInsertHandlers.createQualifierHandler(NamingServices.getNamingService(dbms), true, qualifiers) : SqlInsertHandlers.DUMMY_HANDLER;
        String parentName = String.join((CharSequence)", ", parentNames);
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create(last, (String)statement).withIcon(IconHolder.ourColumnColumnIcon).withLookupStrings(names).withCaseSensitivity(false).withTailText((String)(StringUtil.isEmpty((String)parentName) ? "" : " (" + parentName + ")"), true).withInsertHandler(parenthesized ? SqlInsertHandlers.chainHandlers(SqlInsertHandlers.ADD_RPAREN_LOOKUP_HANDLER, insertHandler) : insertHandler), (double)priority);
    }

    public static boolean isTriggerFunctionExpected(@NotNull SqlExpression expression) {
        PsiElement parent2;
        if (expression == null) {
            SqlCompletionUtil.$$$reportNull$$$0(103);
        }
        if (!((parent2 = expression.getParent()) instanceof SqlFunctionCallExpression)) {
            return false;
        }
        SqlCreateTriggerStatement trigger = (SqlCreateTriggerStatement)PsiTreeUtil.getParentOfType((PsiElement)parent2, SqlCreateTriggerStatement.class);
        return trigger != null && trigger.getTriggerProcedure() == parent2;
    }

    @Nullable
    private static DasSymbol getOriginalSymbol(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            SqlCompletionUtil.$$$reportNull$$$0(104);
        }
        if (symbol instanceof DasPsiSymbol) {
            return (DasSymbol)CompletionUtil.getOriginalElement((PsiElement)((DasPsiSymbol)symbol));
        }
        if (symbol instanceof DasInlineSymbol) {
            PsiElement element2 = CompletionUtil.getOriginalElement((PsiElement)((DasInlineSymbol)symbol).getDeclaringElement());
            PsiReference reference = element2 != null ? element2.getReference() : null;
            return reference instanceof SqlReference ? DasSymbolUtil.getInlineSymbol((SqlReference)reference) : null;
        }
        return symbol;
    }

    @Nullable
    public static DasSymbol getTargetSymbol(@NotNull LookupElement lookup) {
        Object object;
        if (lookup == null) {
            SqlCompletionUtil.$$$reportNull$$$0(105);
        }
        if ((object = lookup.getObject()) instanceof SqlQualifiedResolveResult) {
            object = ((SqlQualifiedResolveResult)object).getTargetSymbol();
        }
        if (object instanceof DasSymbol) {
            return SqlCompletionUtil.getOriginalSymbol((DasSymbol)object);
        }
        if (object instanceof PsiElement) {
            DasSymbolUtil.getSymbolByPsi(CompletionUtil.getOriginalElement((PsiElement)((PsiElement)object)));
        }
        return null;
    }

    @Nullable
    public static PsiElement getQualifier(@Nullable ResolveResult resolveResult) {
        return SqlCompletionUtil.adjustQualifier(SqlImplUtil.getQualifier(resolveResult), SqlImplUtil.getImmediateTarget(resolveResult));
    }

    @Nullable
    public static PsiElement getQualifier(@NotNull ResolveState state) {
        if (state == null) {
            SqlCompletionUtil.$$$reportNull$$$0(106);
        }
        return SqlCompletionUtil.adjustQualifier(SqlImplUtil.getQualifier(state), SqlImplUtil.getImmediateTarget(state));
    }

    @Nullable
    private static PsiElement adjustQualifier(@Nullable PsiElement qualifier, @Nullable PsiElement immediateTarget) {
        if (qualifier instanceof SqlQueryExpression) {
            if (!(immediateTarget instanceof SqlColumnSymbol)) {
                return null;
            }
            PsiElement contextElement = ((SqlColumnSymbol)immediateTarget).getContextElement();
            if (!(contextElement instanceof SqlReferenceExpression)) {
                return null;
            }
            return SqlImplUtil.getQualifier(((SqlReferenceExpression)contextElement).resolveSingle());
        }
        return qualifier;
    }

    @NotNull
    public static String getNameQuotationSettingAware(@NotNull String name, @Nullable ObjectKind kind, @NotNull PsiFile contextFile) {
        if (name == null) {
            SqlCompletionUtil.$$$reportNull$$$0(107);
        }
        if (contextFile == null) {
            SqlCompletionUtil.$$$reportNull$$$0(108);
        }
        Dbms dbms = SqlImplUtil.getDbms((PsiElement)contextFile);
        NamingService namingService = NamingServices.getNamingService(dbms);
        SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(contextFile);
        String openQuotes = settings.getQuotesPriority();
        String string = settings.QUOTE_IDENTIFIER == 2 ? namingService.enquote(name, kind, openQuotes) : (dbms != Dbms.UNKNOWN ? namingService.catToScript(name, kind, openQuotes) : name);
        if (string == null) {
            SqlCompletionUtil.$$$reportNull$$$0(109);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 61: 
            case 65: 
            case 72: 
            case 75: 
            case 83: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 109: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 61: 
            case 65: 
            case 72: 
            case 75: 
            case 83: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 109: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 30: 
            case 35: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 47: 
            case 53: 
            case 54: 
            case 66: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 8: 
            case 13: 
            case 31: 
            case 36: 
            case 57: 
            case 68: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 26: 
            case 32: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 15: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedSqlTypes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 23: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionParameters";
                break;
            }
            case 29: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plainCaseGetter";
                break;
            }
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 61: 
            case 65: 
            case 72: 
            case 75: 
            case 83: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/SqlCompletionUtil";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityName";
                break;
            }
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 63: 
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 64: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlDialect";
                break;
            }
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordCase";
                break;
            }
            case 84: 
            case 87: 
            case 90: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 85: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 86: 
            case 88: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumValue";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/SqlCompletionUtil";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "roughName";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "typeText";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntityLookupItem";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupItem";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureArguments";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "addParametersText";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeywordLookupElement";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnSqlType";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "fixEnumValue";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameQuotationSettingAware";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLookupElement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "forSqlReference";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "forSqlFunction";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "forAlias";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addReferenceCompletionVariants";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddMissingColumns";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isCompletionAllowed";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "forSymbol";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isTypeMatch";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "calcName";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getMode";
                break;
            }
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 61: 
            case 65: 
            case 72: 
            case 75: 
            case 83: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 109: {
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "hasPlainIdentifier";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "roughName";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "typeText";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixed";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "forProcedureInfo";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createEntityLookupItem";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 63: 
            case 64: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItem";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createRoutineLookupItem";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingPrototype";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureArguments";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addParametersText";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordLookupElement";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "addItemsFromExpectedColumnType";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "addTrueFalse";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "addValuesFromDataType";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getColumnSqlType";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "fixEnumValue";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "createAllColumnsLookupElement";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isTriggerFunctionExpected";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalSymbol";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getTargetSymbol";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getNameQuotationSettingAware";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 61: 
            case 65: 
            case 72: 
            case 75: 
            case 83: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 109: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IconHolder {
        private static final Icon ourColumnColumnIcon = IconHolder.createColumnColumnIcon();

        private IconHolder() {
        }

        @NotNull
        private static Icon createColumnColumnIcon() {
            int w = DatabaseIcons.Col.getIconWidth();
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(DatabaseIcons.Col, 0, 2 * w / 5, 0);
            icon.setIcon(DatabaseIcons.Col, 1);
            LayeredIcon layeredIcon = icon;
            if (layeredIcon == null) {
                IconHolder.$$$reportNull$$$0(0);
            }
            return layeredIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlCompletionUtil$IconHolder", "createColumnColumnIcon"));
        }
    }
}

