/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectCurrentStatementAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SelectCurrentStatementAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(SelectCurrentStatementAction.getStatement(e) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Pair<Editor, SqlStatement> statement;
        if (e == null) {
            SelectCurrentStatementAction.$$$reportNull$$$0(1);
        }
        if ((statement = SelectCurrentStatementAction.getStatement(e)) == null) {
            return;
        }
        TextRange range = ((SqlStatement)statement.second).getTextRange();
        ((Editor)statement.first).getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
    }

    @Nullable
    private static Pair<Editor, SqlStatement> getStatement(@NotNull AnActionEvent event) {
        if (event == null) {
            SelectCurrentStatementAction.$$$reportNull$$$0(2);
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (editor == null || file == null || !JdbcConsoleProvider.isSqlAtPlace(file, editor)) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        int caretPosition = TargetElementUtil.adjustOffset((PsiFile)file, (Document)editor.getDocument(), (int)offset);
        if (!DocumentUtil.isValidOffset((int)caretPosition, (Document)editor.getDocument())) {
            return null;
        }
        PsiElement element2 = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)caretPosition);
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element2, SqlStatement.class);
        return statement == null ? null : Pair.create((Object)editor, (Object)statement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/actions/SelectCurrentStatementAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

