/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.SqlIntroduceHandlerBase;
import com.intellij.sql.refactoring.SqlIntroduceVariableUtilsKt;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlIntroduceVariableHandler
extends SqlIntroduceHandlerBase<SqlExtractVariableHelper> {
    public SqlIntroduceVariableHandler() {
        super(SqlBundle.message("introduce.variable", new Object[0]));
    }

    private void performInplaceIntroduce(@NotNull Editor editor, @NotNull SqlExpression expression, boolean replaceAll) {
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(1);
        }
        List<PsiElement> occurrences = replaceAll ? SqlIntroduceVariableHandler.getOccurrences(expression) : Collections.singletonList(expression);
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)expression);
        SqlExtractVariableHelper helper = dialect.getExtractVariableHelper();
        if (helper == null) {
            return;
        }
        PsiElement declaration = this.performElement(editor, expression, occurrences, dialect, helper);
        if (declaration != null && declaration.isValid()) {
            SqlVariableDefinition target = (SqlVariableDefinition)SqlImplUtil.sqlTraverser().filter(SqlVariableDefinition.class).first();
            if (target == null || !target.isValid()) {
                return;
            }
            editor.getCaretModel().moveToOffset(target.getTextRange().getStartOffset());
            SqlTypeElement type = target.getTypeElement();
            SqlInplaceVariableIntroducer introducer = new SqlInplaceVariableIntroducer(expression.getProject(), editor, (PsiNamedElement)target, type, occurrences);
            introducer.performInplaceRefactoring(new LinkedHashSet());
        }
    }

    @Nullable
    private PsiElement performElement(@NotNull Editor editor, @NotNull SqlExpression expression, @NotNull List<PsiElement> occurrences, @NotNull SqlLanguageDialectEx dialect, @NotNull SqlExtractVariableHelper helper) {
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(2);
        }
        if (expression == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(3);
        }
        if (occurrences == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(4);
        }
        if (dialect == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(5);
        }
        if (helper == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(6);
        }
        Project project = expression.getProject();
        SqlType sqlType = expression.getSqlType();
        if (sqlType.equals(SqlType.UNKNOWN) || !(sqlType instanceof SqlPrimitiveType)) {
            if (helper.isTypeStrict()) {
                this.showError(project, editor, SqlBundle.message("dialog.message.only.primitives.are.supported", new Object[0]));
                return null;
            }
            sqlType = dialect.getTypeSystem().integerType();
        }
        String name = helper.getInitialName();
        String expressionText = expression.getText();
        PsiElement initializer = helper.createInitializerDeclaration(project, name, expressionText);
        PsiElement declaration = helper.createDeclaration(project, name, sqlType.getDataType(), expressionText);
        PsiElement anchor2 = helper.findInitializerAnchor(occurrences);
        PsiElement block = helper.findTopmostBlock((PsiElement)expression);
        if (declaration == null || initializer == null && !helper.canInlineInitializer() || anchor2 == null || block == null) {
            this.showError(project, editor, SqlBundle.message("dialog.message.cannot.perform.refactoring", new Object[0]));
            return null;
        }
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)expression);
        PsiFile file = expression.getContainingFile();
        return (PsiElement)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).withName(SqlBundle.message("command.name.extract.variable", new Object[0])).compute(() -> {
            SqlExpression newExpression;
            PsiDocumentManager dm = PsiDocumentManager.getInstance((Project)project);
            Document document = dm.getDocument(file);
            if (document == null) {
                return null;
            }
            dm.commitDocument(document);
            PsiElement createdDeclaration = helper.addDeclaration(declaration, block, anchor2);
            if (initializer != null) {
                SqlIntroduceVariableUtilsKt.addStatementBefore(initializer, anchor2);
            }
            if ((newExpression = SqlPsiElementFactory.createExpressionFromText(name, language, project, null)) != null) {
                for (PsiElement occurrence : occurrences) {
                    occurrence.replace((PsiElement)newExpression);
                }
            }
            if (createdDeclaration != null) {
                createdDeclaration = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)createdDeclaration);
            }
            return createdDeclaration;
        });
    }

    @NotNull
    static List<PsiElement> getOccurrences(@NotNull SqlExpression expression) {
        SqlLanguageDialectEx dialect;
        SqlExtractVariableHelper helper;
        if (expression == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(7);
        }
        if ((helper = (dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)expression)).getExtractVariableHelper()) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                SqlIntroduceVariableHandler.$$$reportNull$$$0(8);
            }
            return list;
        }
        PsiElement scope = helper.getTopmostScope((PsiElement)expression);
        List list = scope == null ? Collections.emptyList() : ((SyntaxTraverser)SqlImplUtil.sqlTraverser(scope).filter(element2 -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element2, (PsiElement)expression))).toList();
        if (list == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    protected SqlExtractVariableHelper getHelper(@NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(10);
        }
        return dialect.getExtractVariableHelper();
    }

    @Override
    protected void invoke(@NotNull Project project, final @NotNull Editor editor, final @NotNull SqlExpression expression) {
        if (project == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(12);
        }
        if (expression == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(13);
        }
        if (!editor.getSettings().isVariableInplaceRenameEnabled()) {
            return;
        }
        OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)expression, SqlIntroduceVariableHandler.getOccurrences(expression), (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                SqlIntroduceVariableHandler.this.performInplaceIntroduce(editor, expression, replaceChoice == OccurrencesChooser.ReplaceChoice.ALL);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlIntroduceVariableHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlIntroduceVariableHandler";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performInplaceIntroduce";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHelper";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SqlInplaceVariableIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        @NotNull
        private final PsiElement myTarget;
        @Nullable
        private final SqlTypeElement myTypeElement;

        SqlInplaceVariableIntroducer(@NotNull Project project, @NotNull Editor editor, @NotNull PsiNamedElement target, @Nullable SqlTypeElement typeElement, @NotNull List<PsiElement> occurrences) {
            if (project == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(1);
            }
            if (target == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(2);
            }
            if (occurrences == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(3);
            }
            super(target, editor, project, SqlBundle.message("command.name.introduce.variable", new Object[0]), occurrences.toArray(PsiElement.EMPTY_ARRAY), null);
            this.myTarget = target;
            this.myTypeElement = typeElement;
        }

        protected PsiElement checkLocalScope() {
            return this.myTarget.getContainingFile();
        }

        protected void addAdditionalVariables(@NotNull TemplateBuilderImpl builder) {
            if (builder == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(4);
            }
            if (this.myTypeElement != null) {
                builder.replaceElement((PsiElement)this.myTypeElement, this.myTypeElement.getText());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "occurrences";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/SqlIntroduceVariableHandler$SqlInplaceVariableIntroducer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAdditionalVariables";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

