/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ModelTraverserEx;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.ResultProcessorProvider;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.database.view.ui.TableSettings;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.model.Pointer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.text.TextRanges;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericEditingResultProcessor
implements AbstractDbRefactoringDialog.ResultProcessor {
    private final ResultProcessorProvider myProvider;
    protected final TableSettings mySettings;
    private final RangeMarker myInsertPos;
    private final TableDialogSettings myGenSettings;

    public GenericEditingResultProcessor(@NotNull ResultProcessorProvider provider, @NotNull TableSettings settings, @Nullable RangeMarker insertPos) {
        if (provider == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(1);
        }
        this.mySettings = new TableSettings(settings);
        this.mySettings.renameInStorage = DbRenamePsiElementProcessor.getSearchReferencesInStorage(provider.getProject());
        this.myProvider = provider;
        this.myInsertPos = insertPos;
        this.myGenSettings = new TableDialogSettings((Consumer<? super TableSettings>)((Consumer)settings1 -> {
            DbRenamePsiElementProcessor.setSearchReferencesInStorage(provider.getProject(), settings1.renameInStorage);
            this.mySettings.assign((TableSettings)settings1);
            this.myProvider.settingsChanged();
        }), this.mySettings);
    }

    @NotNull
    private DbDataSource getDataSource() {
        DbDataSource dbDataSource = Objects.requireNonNull(this.myProvider.getContext().getDataSource());
        if (dbDataSource == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(2);
        }
        return dbDataSource;
    }

    @NotNull
    private Project getProject() {
        Project project = this.myProvider.getContext().getProject();
        if (project == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(3);
        }
        return project;
    }

    private static void fillContext(@NotNull DeModel model, @NotNull LoaderContext context, @Nullable DbDataSource dataSource2) {
        JBIterable modifiedRoots;
        if (model == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(5);
        }
        if ((modifiedRoots = ((JBTreeTraverser)model.traverser().expandAndSkip(object -> {
            boolean isUpdateRoot = false;
            for (DeObject child : object.getDasChildren(null)) {
                if (child.hasEdited()) continue;
                isUpdateRoot = true;
                break;
            }
            if (!isUpdateRoot) {
                DeObject obj = (DeObject)ObjectUtils.tryCast((Object)object, DeObject.class);
                DeObject edited = obj == null || obj.lightExported ? null : obj.getEditedDeObject();
                isUpdateRoot = edited != null && obj.isAltered(edited);
            }
            SqlElement element2 = GenericEditingResultProcessor.getSqlElement(object, model.getExportHelper().getContext());
            return !isUpdateRoot || element2 != null;
        })).bfsTraversal()).isEmpty()) {
            context.includeAllSchemas();
        } else {
            for (DeObject root2 : modifiedRoots) {
                context.include(root2.getPath());
                context.include(root2.unwrap());
            }
        }
        if (DatabaseSettings.getSettings().trackNamespaces) {
            GenericEditingResultProcessor.scheduleIntrospectionScopeUpdate(model, context);
        }
    }

    private static void scheduleIntrospectionScopeUpdate(@NotNull DeModel model, @NotNull LoaderContext context) {
        JBIterable namespaces2;
        if (model == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(6);
        }
        if (context == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(7);
        }
        if (!(namespaces2 = ((JBTreeTraverser)model.traverser().expand(n -> n.getKind() == ObjectKind.DATABASE)).filter(DeNamespace.class).filter(n -> !n.hasEdited())).isEmpty()) {
            for (DeNamespace namespace : namespaces2) {
                ObjectKind kind = namespace.getKind();
                if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
                context.getScopeUpdater().toAdd(namespace.getPath());
            }
        }
    }

    @Override
    @Nullable
    public JComponent getPreviewWidget() {
        return null;
    }

    @Override
    public String process() {
        return (String)AsyncTask.withBgIndicatorIfNeeded(AsyncTask.frame(this.getTitle()), this.getProject(), null).sync(this::processImpl);
    }

    @NlsContexts.NotificationContent
    @Nullable
    private String processImpl() {
        if (this.mySettings.finalAction == TableSettings.FinalAction.EXEC_IN_DB) {
            return this.processDb();
        }
        SqlDataSource sqlDs2 = DbImplUtilCore.getMaybeSqlDataSource(this.myProvider.getContext().getDataSource());
        if (sqlDs2 != null) {
            return this.processDdl(sqlDs2);
        }
        return this.processSql();
    }

    @NlsContexts.NotificationContent
    private String processDdl(@NotNull SqlDataSource sqlDs2) {
        if (sqlDs2 == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(8);
        }
        EditorModelBase editorModel = this.myProvider.getEditor().getModel();
        ScriptingSingleModelTaskBuilder builder = ((ModelTraverserEx)this.createTraverser(editorModel)).prepareCreateTask();
        Set<File> files2 = DumpToDdlDataSourceActionKt.dump(this.myProvider.getProject(), sqlDs2, builder.getModel(), null, builder.getElements(), false);
        DumpToDdlDataSourceActionKt.selectFile(this.getProject(), files2);
        this.myProvider.success(true);
        return null;
    }

    @NlsContexts.ProgressText
    protected String getTitle() {
        return DatabaseBundle.message("progress.text.refactor", new Object[0]);
    }

    @NlsContexts.NotificationContent
    private String processSql() {
        List<RangeMarker> ranges = this.getRanges();
        if (ranges.isEmpty()) {
            return DatabaseBundle.message("notification.content.unable.to.find.insertion.place", new Object[0]);
        }
        JBIterable<Pair<PsiElement, String>> renames = this.myProvider.collectRenames();
        Boolean withRenames = this.withRenames(renames);
        if (withRenames == null) {
            return null;
        }
        if (withRenames.booleanValue()) {
            this.processWithRenames(renames, ranges);
        } else {
            this.processWithoutRenames(ranges);
        }
        return null;
    }

    private void processWithRenames(@NotNull JBIterable<Pair<PsiElement, String>> renames, final @NotNull List<RangeMarker> ranges) {
        if (renames == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(9);
        }
        if (ranges == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(10);
        }
        Pair pair = Objects.requireNonNull((Pair)renames.first());
        renames = renames.skip(1);
        RenameProcessor processor2 = new RenameProcessor(this.myProvider.getContext().getProject(), (PsiElement)pair.first, (String)pair.second, true, true){

            protected void execute(UsageInfo @NotNull [] usages2) {
                if (usages2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.execute(usages2);
                WriteCommandAction.runWriteCommandAction((Project)GenericEditingResultProcessor.this.getProject(), () -> GenericEditingResultProcessor.this.insertStatement(ranges));
                GenericEditingResultProcessor.this.open(ranges);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/database/view/ui/GenericEditingResultProcessor$1", "execute"));
            }
        };
        for (Pair rename2 : renames) {
            processor2.addElement((PsiElement)rename2.first, (String)rename2.second);
        }
        processor2.setPreviewUsages(this.myProvider.isPreviewUsages());
        processor2.setPrepareSuccessfulSwingThreadCallback(() -> this.myProvider.success(true));
        processor2.run();
    }

    private void processWithoutRenames(@NotNull List<RangeMarker> ranges) {
        if (ranges == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(11);
        }
        if (!this.insertStatement(ranges)) {
            return;
        }
        this.open(ranges);
        this.myProvider.success(true);
    }

    private void open(@NotNull List<RangeMarker> ranges) {
        if (ranges == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(12);
        }
        Project project = this.myProvider.getContext().getProject();
        VirtualFile file = FileDocumentManager.getInstance().getFile(ranges.get(0).getDocument());
        if (file != null) {
            FileEditorManager.getInstance((Project)project).openFile(file, true, true);
        }
    }

    private boolean insertStatement(@NotNull List<RangeMarker> ranges) {
        if (ranges == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(13);
        }
        if (ranges.isEmpty()) {
            return false;
        }
        HashSet<Document> visited = new HashSet<Document>();
        for (RangeMarker marker : ranges) {
            if (visited.add(marker.getDocument())) {
                PsiDocumentManager.getInstance((Project)this.myProvider.getContext().getProject()).doPostponedOperationsAndUnblockDocument(marker.getDocument());
            }
            if (marker.isValid()) continue;
            return false;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProvider.getContext().getProject(), () -> {
            String statement = this.myProvider.statement();
            statement = StringUtil.trimEnd((String)statement, (String)";");
            RangeMarker main = (RangeMarker)ranges.get(0);
            boolean insertBreak = false;
            if (ranges.size() == 1 && main.getStartOffset() == main.getEndOffset()) {
                int lineStart = main.getDocument().getLineStartOffset(main.getDocument().getLineNumber(main.getStartOffset()));
                insertBreak = !main.getDocument().getText(TextRange.create((int)lineStart, (int)main.getStartOffset())).matches("\\s*");
            }
            main.getDocument().replaceString(main.getStartOffset(), main.getEndOffset(), (CharSequence)((insertBreak ? "\n" : "") + statement));
            for (RangeMarker marker : ranges.subList(1, ranges.size())) {
                marker.getDocument().replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)"");
            }
        });
        return true;
    }

    @NotNull
    public List<RangeMarker> getRanges() {
        List<RangeMarker> ranges;
        if (this.mySettings.finalAction == TableSettings.FinalAction.REPLACE_DDL && !(ranges = this.getModifiedElementsRanges()).isEmpty()) {
            List<RangeMarker> list = ranges;
            if (list == null) {
                GenericEditingResultProcessor.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (this.myInsertPos != null && this.myInsertPos.isValid() && this.myInsertPos.getDocument().isWritable()) {
            RangeMarker corrected = this.correctOffset(this.myInsertPos);
            List<RangeMarker> list = Collections.singletonList((RangeMarker)ObjectUtils.chooseNotNull((Object)corrected, (Object)this.myInsertPos));
            if (list == null) {
                GenericEditingResultProcessor.$$$reportNull$$$0(15);
            }
            return list;
        }
        RangeMarker afterParentRange = this.getAfterParentRange();
        if (afterParentRange != null) {
            List<RangeMarker> list = Collections.singletonList(afterParentRange);
            if (list == null) {
                GenericEditingResultProcessor.$$$reportNull$$$0(16);
            }
            return list;
        }
        RangeMarker endOfFile = this.getEndOfFile();
        List<Object> list = endOfFile != null ? Collections.singletonList(endOfFile) : Collections.emptyList();
        if (list == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private List<RangeMarker> getModifiedElementsRanges() {
        EditorModelBase editorModel = this.myProvider.getEditor().getModel();
        Map<PsiFile, TextRanges> rangesPerFile = this.collectRanges((JBIterable<? extends DeObject>)this.createTraverser(editorModel).traverse().transform(action2 -> action2.object), editorModel.getModel());
        Project project = this.myProvider.getContext().getProject();
        if (rangesPerFile.isEmpty()) {
            List<RangeMarker> list = Collections.emptyList();
            if (list == null) {
                GenericEditingResultProcessor.$$$reportNull$$$0(18);
            }
            return list;
        }
        ArrayList<RangeMarker> result2 = new ArrayList<RangeMarker>();
        for (Map.Entry<PsiFile, TextRanges> entry : rangesPerFile.entrySet()) {
            this.patch(entry.getKey(), entry.getValue());
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(entry.getKey());
            if (document == null || !document.isWritable() || entry.getValue().isEmpty()) continue;
            for (TextRange range : entry.getValue()) {
                result2.add(document.createRangeMarker(range));
            }
        }
        ArrayList<RangeMarker> arrayList = result2;
        if (arrayList == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Nullable
    private RangeMarker getAfterParentRange() {
        EditorModelBase editorModel = this.myProvider.getEditor().getModel();
        Project project = this.myProvider.getContext().getProject();
        Map<PsiFile, TextRanges> rangesPerFile = this.collectRanges(editorModel.getModel().getModelRoots(), editorModel.getModel());
        for (Map.Entry<PsiFile, TextRanges> entry : rangesPerFile.entrySet()) {
            this.patch(entry.getKey(), entry.getValue());
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(entry.getKey());
            if (document == null || !document.isWritable() || entry.getValue().isEmpty()) continue;
            TextRange range = (TextRange)entry.getValue().iterator().next();
            int offset = range.getEndOffset();
            return document.createRangeMarker(offset, offset);
        }
        return null;
    }

    private Map<PsiFile, TextRanges> collectRanges(@NotNull JBIterable<? extends DeObject> modifiedObjects, @NotNull DeModel model) {
        if (modifiedObjects == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(20);
        }
        if (model == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(21);
        }
        LinkedHashMap<PsiFile, TextRanges> rangesPerFile = new LinkedHashMap<PsiFile, TextRanges>();
        for (DeObject modifiedObject : modifiedObjects) {
            for (DeObject object : (JBTreeTraverser)model.traverser().withRoot((Object)modifiedObject)) {
                SqlElement element2 = GenericEditingResultProcessor.getSqlElement(object, this.myProvider.getContext());
                PsiFile file = element2 == null ? null : element2.getContainingFile();
                if (file == null) continue;
                TextRanges ranges = (TextRanges)rangesPerFile.get(file);
                if (ranges == null) {
                    ranges = new TextRanges();
                    rangesPerFile.put(file, ranges);
                }
                ranges.union(element2.getTextRange());
            }
        }
        return rangesPerFile;
    }

    @Nullable
    private RangeMarker getEndOfFile() {
        VirtualFile file = this.myProvider.getContext().getOrCreateVirtualFile();
        if (file == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        int length = document.getTextLength();
        return document.createRangeMarker(length, length);
    }

    @Nullable
    private RangeMarker correctOffset(@NotNull RangeMarker pos) {
        ParserDefinition definition;
        Project project;
        PsiFile file;
        if (pos == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(22);
        }
        if ((file = PsiDocumentManager.getInstance((Project)(project = Objects.requireNonNull(this.myProvider.getContext().getProject()))).getPsiFile(pos.getDocument())) == null) {
            return null;
        }
        PsiElement element2 = file.findElementAt(pos.getStartOffset());
        if (element2 == null) {
            return null;
        }
        if ((element2 = PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class)) == null) {
            return null;
        }
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(element2);
        ParserDefinition parserDefinition = definition = dialect == null ? null : (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)dialect);
        if (definition != null) {
            PsiElement next;
            TokenSet skip = TokenSet.orSet((TokenSet[])new TokenSet[]{dialect.getStatementSeparators(), definition.getCommentTokens(), definition.getWhitespaceTokens()});
            while ((next = PsiTreeUtil.nextVisibleLeaf((PsiElement)element2)) != null && skip.contains(GenericEditingResultProcessor.getNodeType(next))) {
                element2 = next;
            }
        }
        int offset = element2.getTextRange().getEndOffset();
        return pos.getDocument().createRangeMarker(offset, offset);
    }

    @Nullable
    private static IElementType getNodeType(@Nullable PsiElement el) {
        return el == null || el.getNode() == null ? null : el.getNode().getElementType();
    }

    private void patch(@NotNull PsiFile file, @NotNull TextRanges ranges) {
        TextRange lastPatch;
        if (file == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(23);
        }
        if (ranges == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(24);
        }
        TokenSet separators = this.myProvider.getContext().getSqlDialect().getStatementSeparators();
        ArrayList<TextRange> patches = new ArrayList<TextRange>();
        for (TextRange range : JBIterable.once((Iterator)ranges.gapIterator())) {
            if (GenericEditingResultProcessor.shouldPlumb(file, range, separators)) {
                patches.add(range);
                continue;
            }
            TextRange expanded = GenericEditingResultProcessor.expand(file, range, separators);
            if (expanded == null) continue;
            patches.add(expanded);
        }
        patches.forEach(arg_0 -> ((TextRanges)ranges).union(arg_0));
        TextRange last = (TextRange)JBIterable.once((Iterator)ranges.revIterator()).first();
        if (last != null && (lastPatch = GenericEditingResultProcessor.expand(file, TextRange.create((int)last.getEndOffset(), (int)file.getTextLength()), separators)) != null) {
            ranges.union(lastPatch);
        }
    }

    private static boolean shouldPlumb(@NotNull PsiFile file, @NotNull TextRange range, @NotNull TokenSet seps) {
        if (file == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(25);
        }
        if (range == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(26);
        }
        if (seps == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(27);
        }
        PsiElement element2 = file.findElementAt(range.getStartOffset());
        while (element2 != null && element2.getTextOffset() < range.getEndOffset()) {
            IElementType type;
            IElementType iElementType = type = element2.getNode() == null ? null : element2.getNode().getElementType();
            if (!seps.contains(type) && !StringUtil.isEmptyOrSpaces((String)element2.getText())) {
                return false;
            }
            element2 = PsiTreeUtil.nextVisibleLeaf((PsiElement)element2);
        }
        return true;
    }

    @Nullable
    private static TextRange expand(@NotNull PsiFile file, @NotNull TextRange range, @NotNull TokenSet seps) {
        if (file == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(28);
        }
        if (range == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(29);
        }
        if (seps == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(30);
        }
        PsiElement element2 = file.findElementAt(range.getStartOffset());
        int expanded = range.getStartOffset();
        while (element2 != null && element2.getTextOffset() < range.getEndOffset()) {
            IElementType type;
            IElementType iElementType = type = element2.getNode() == null ? null : element2.getNode().getElementType();
            if (!seps.contains(type) && (!StringUtil.isEmptyOrSpaces((String)element2.getText()) || element2.getText().contains("\n"))) break;
            expanded = element2.getTextRange().getEndOffset();
            element2 = PsiTreeUtil.nextLeaf((PsiElement)element2);
        }
        if (expanded == range.getStartOffset()) {
            return null;
        }
        return TextRange.create((int)range.getStartOffset(), (int)expanded);
    }

    @NlsContexts.NotificationContent
    private String processDb() {
        DatabaseEditorContext context = this.myProvider.getContext();
        if (!DbImplUtilCore.canConnectTo(context.getDataSource())) {
            return DatabaseBundle.message("notification.content.unable.to.connect.to.data.source", new Object[0]);
        }
        if (!ImportUtil.canModify(context.getDataSource())) {
            return DatabaseBundle.message("notification.content.unable.to.modify.data.source", new Object[0]);
        }
        DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(this.getProject(), DbImplUtil.getLocalDataSource(this.getDataSource()), context.getSearchPath()).setStatement(this.myProvider.statement());
        GenericEditingResultProcessor.fillContext(this.myProvider.getModel(), handler.getContext(), this.myProvider.getContext().getDataSource());
        DeObject edited = (DeObject)this.myProvider.getEditor().getModel().getEditedObjects().first();
        handler.getContext().setElementToFocus(edited == null ? null : edited.getPath());
        JBIterable<Pair<PsiElement, String>> renames = this.myProvider.collectRenames();
        Boolean withRenames = this.withRenames(renames);
        if (withRenames == null) {
            return null;
        }
        if (withRenames.booleanValue()) {
            this.processWithRenames(renames, handler);
        } else {
            this.processWithoutRenames(handler);
        }
        return null;
    }

    @Nullable
    private Boolean withRenames(JBIterable<Pair<PsiElement, String>> renames) {
        if (renames.isEmpty()) {
            return false;
        }
        if (!DumbService.isDumb((Project)this.myProvider.getProject())) {
            return true;
        }
        if (MessageDialogBuilder.yesNo((String)DatabaseBundle.message("dialog.title.indexing.in.progress", new Object[0]), (String)DatabaseBundle.message("dialog.message.usages.won.t.be.renamed.because.indexing.in.progress.proceed", new Object[0])).show() == 0) {
            return false;
        }
        return null;
    }

    @Override
    @NotNull
    public DdlPreview.ModelTraverser createTraverser(@NotNull EditorModelBase model) {
        if (model == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(31);
        }
        return new ModelTraverserEx(this.mySettings, model, this.myProvider.getModel(), this.myProvider.getContext().getDataSource());
    }

    @Override
    @Nullable
    public JComponent getSettingsPanel() {
        return this.myGenSettings.getComponent();
    }

    @Override
    @NlsActions.ActionText
    public String getCurrentAction() {
        if (this.mySettings.finalAction == TableSettings.FinalAction.APPEND_DDL) {
            return DatabaseBundle.message("action.to.editor.text", new Object[0]);
        }
        if (this.mySettings.finalAction == TableSettings.FinalAction.REPLACE_DDL) {
            return DatabaseBundle.message("action.replace.text", new Object[0]);
        }
        if (this.mySettings.finalAction == TableSettings.FinalAction.EXEC_IN_DB) {
            return DatabaseBundle.message("action.execute.text", new Object[0]);
        }
        if (this.mySettings.finalAction == TableSettings.FinalAction.ADD_OBJECT) {
            return DatabaseBundle.message("action.create.1.text", new Object[0]);
        }
        return null;
    }

    @Override
    public void update() {
        JBIterable<? extends DeObject> editedObjects = this.myProvider.getEditor().getModel().getEditedObjects();
        JBIterable allObjects = ((JBTreeTraverser)this.myProvider.getModel().traverser().withRoots(editedObjects)).traverse();
        boolean hasNonSql = !editedObjects.filter(o -> !this.isSql((DeObject)o)).isEmpty();
        boolean hasSql = !allObjects.filter(this::isSql).isEmpty();
        DbDataSource dataSource2 = this.myProvider.getContext().getDataSource();
        boolean dbAvailable = ImportUtil.canConnectToAndModify(dataSource2);
        JBIterable<Pair<PsiElement, String>> renames = this.myProvider.collectRenames();
        this.myGenSettings.setAvailability(dbAvailable && (hasNonSql || GenericEditingResultProcessor.newObjects(editedObjects)), hasSql, DbImplUtilCore.getMaybeSqlDataSource(dataSource2) != null, !renames.isEmpty());
    }

    @Override
    public ValidationInfo validate() {
        JBIterable modified;
        boolean allSql;
        if (this.mySettings.finalAction == TableSettings.FinalAction.REPLACE_DDL && !(allSql = (modified = this.createTraverser(this.myProvider.getEditor().getModel()).traverse().transform(action2 -> action2.object)).filter(o -> !this.isSql((DeObject)o)).isEmpty())) {
            return new ValidationInfo(DatabaseBundle.message("dialog.message.unable.to.replace.ddl.for.some.objects.they.are.in.db", new Object[0]));
        }
        return null;
    }

    private boolean isSql(@NotNull DeObject object) {
        DatabaseEditorContext context;
        if (object == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(32);
        }
        return GenericEditingResultProcessor.getSqlElement(object, context = this.myProvider.getContext()) != null;
    }

    @Nullable
    public static SqlElement getSqlElement(@Nullable DeObject object, @NotNull DatabaseEditorContext context) {
        if (context == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(33);
        }
        return GenericEditingResultProcessor.getSqlElement(object == null ? null : object.unwrap(), context);
    }

    @Nullable
    public static SqlElement getSqlElement(@Nullable BasicElement object, @NotNull DatabaseEditorContext context) {
        Pointer<DasObject> pointer;
        if (context == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(34);
        }
        if (object == null) {
            return null;
        }
        Map<? extends DasObject, Pointer<DasObject>> mapping = context.getMapping();
        if (mapping != null && (pointer = mapping.get(object)) != null) {
            return (SqlElement)ObjectUtils.tryCast((Object)pointer.dereference(), SqlElement.class);
        }
        return (SqlElement)ObjectUtils.tryCast((Object)DbSqlUtil.getSqlSourceElement(context.getDataSource(), object), SqlElement.class);
    }

    private static boolean newObjects(JBIterable<? extends DeObject> objects2) {
        return objects2.filter(DeObject::hasEdited).isEmpty();
    }

    protected void processWithRenames(@NotNull JBIterable<Pair<PsiElement, String>> renames, @NotNull DatabaseRefactoringHandler handler) {
        if (renames == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(35);
        }
        if (handler == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(36);
        }
        RenameProcessor processor2 = this.createRenameProcessor(renames, handler);
        processor2.setPrepareSuccessfulSwingThreadCallback(() -> this.myProvider.success(true));
        processor2.setPreviewUsages(this.myProvider.isPreviewUsages());
        processor2.run();
    }

    @NotNull
    protected RenameProcessor createRenameProcessor(@NotNull JBIterable<Pair<PsiElement, String>> renames, @NotNull DatabaseRefactoringHandler handler) {
        Pair r;
        if (renames == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(37);
        }
        if (handler == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(38);
        }
        if ((r = (Pair)renames.first()) == null) {
            throw new AssertionError((Object)"No renames");
        }
        return new DbRenamePsiElementProcessor.MyRenameProcessor(this.getProject(), (PsiElement)r.first, handler, (String)r.second, (Iterable<Pair<PsiElement, String>>)renames.skip(1), (SearchScope)GlobalSearchScope.projectScope((Project)this.getProject()), this.mySettings.renameInCommentsAndLiterals, this.mySettings.renameTextOccurrences);
    }

    @NotNull
    protected AsyncTask<Boolean> processWithoutRenames(@NotNull DatabaseRefactoringHandler handler) {
        if (handler == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(39);
        }
        AsyncTask<Boolean> asyncTask = handler.runStatements(true).handle().apply(AsyncUtil.getEdtExecutor(), p2 -> {
            if (p2.second != null) {
                if (!AsyncUtil.isCancellation((Throwable)p2.second)) {
                    AsyncUtil.addUnhandledError(handler.getErrorHandler(), (Throwable)p2.second, handler.getDataSource());
                }
                if (!handler.getErrorHandler().getSummary().isEmpty()) {
                    this.myProvider.error(handler.getErrorHandler().getSummary(DatabaseBundle.message("notification.content.cancelled", new Object[0])));
                }
                if (handler.isAbortedByUser()) {
                    this.myProvider.success(false);
                }
                throw new ProcessCanceledException();
            }
            this.myProvider.success(true);
            return (Boolean)p2.first;
        });
        if (asyncTask == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(40);
        }
        return asyncTask;
    }

    public static boolean isModified(@NotNull DeObject object) {
        DeObject de;
        if (object == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(41);
        }
        return (de = object.getEditedDeObject()) == null || object.isAltered(de);
    }

    @NotNull
    public static DdlPreview.ObjectAction assignAction(@NotNull DeObject object) {
        if (object == null) {
            GenericEditingResultProcessor.$$$reportNull$$$0(42);
        }
        return new DdlPreview.ObjectAction(object.hasEdited() ? DdlPreview.ObjectAction.Action.ALTER : DdlPreview.ObjectAction.Action.CREATE, object);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/GenericEditingResultProcessor";
                break;
            }
            case 4: 
            case 6: 
            case 21: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: 
            case 7: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlDs";
                break;
            }
            case 9: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renames";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedObjects";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seps";
                break;
            }
            case 32: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/GenericEditingResultProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedElementsRanges";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "processWithoutRenames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 40: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scheduleIntrospectionScopeUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processDdl";
                break;
            }
            case 9: 
            case 10: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processWithRenames";
                break;
            }
            case 11: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processWithoutRenames";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertStatement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectRanges";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "correctOffset";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "patch";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shouldPlumb";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createTraverser";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isSql";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSqlElement";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createRenameProcessor";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "assignAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AppendDroppedSiblings
    implements Function<DeObject, Iterable<DdlPreview.ObjectAction>> {
        private final Set<DeObject> myProcessedParents;
        private final TableSettings mySettings;

        public AppendDroppedSiblings(@NotNull TableSettings settings) {
            if (settings == null) {
                AppendDroppedSiblings.$$$reportNull$$$0(0);
            }
            this.myProcessedParents = new HashSet<DeObject>();
            this.mySettings = settings;
        }

        public Iterable<DdlPreview.ObjectAction> fun(DeObject object) {
            JBIterable res2 = this.processParent(object.getParent());
            if (GenericEditingResultProcessor.isModified(object) || this.mySettings.finalAction == TableSettings.FinalAction.APPEND_DDL && this.mySettings.codeType == TableSettings.CodeType.CREATE_ALL_CODE) {
                res2 = this.mySettings.codeType == TableSettings.CodeType.ALTER_CODE ? res2.append((Object)GenericEditingResultProcessor.assignAction(object)) : res2.append((Object)new DdlPreview.ObjectAction(DdlPreview.ObjectAction.Action.CREATE, object));
            }
            return res2;
        }

        @NotNull
        private JBIterable<DdlPreview.ObjectAction> processParent(@Nullable DeObject object) {
            if (!(object instanceof DeTable) || !object.hasEdited() || this.myProcessedParents.contains(object)) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    AppendDroppedSiblings.$$$reportNull$$$0(1);
                }
                return jBIterable;
            }
            this.myProcessedParents.add(object);
            Set modified = object.getDasChildren(null).filterMap(DeObject::getEditedDeObject).toSet();
            JBIterable jBIterable = Objects.requireNonNull(object.getEditedDeObject()).getDasChildren(null).filter(o -> !modified.contains(o)).map(o -> new DdlPreview.ObjectAction(DdlPreview.ObjectAction.Action.DROP, (DeObject)o));
            if (jBIterable == null) {
                AppendDroppedSiblings.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/GenericEditingResultProcessor$AppendDroppedSiblings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/GenericEditingResultProcessor$AppendDroppedSiblings";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processParent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

