/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.structure.DvTreeAbstractLayer;
import com.intellij.database.view.structure.DvTreeContext;
import com.intellij.database.view.structure.DvTreeLayoutLayer;
import com.intellij.database.view.structure.DvTreeModelLayer;
import com.intellij.database.view.structure.DvTreeOptimizationLayer;
import com.intellij.database.view.structure.DvTreeTransformLayer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0019J#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0010J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"J\u0012\u0010#\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0006\u0010&\u001a\u00020\u0013J\u0010\u0010'\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0013\u0010(\u001a\u00070)\u00a2\u0006\u0002\b*2\u0006\u0010\u0011\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructureService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "context", "Lcom/intellij/database/view/structure/DvTreeContext;", "getContext", "()Lcom/intellij/database/view/structure/DvTreeContext;", "layer1", "Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "layer2", "layer3", "layer4", "childrenOf", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicNode;", "node", "clearAll", "", "countChildrenOf", "", "dispose", "getPath", "", "(Lcom/intellij/database/model/basic/BasicNode;)[Lcom/intellij/database/model/basic/BasicNode;", "getPathArray", "depth", "(Lcom/intellij/database/model/basic/BasicNode;I)[Lcom/intellij/database/model/basic/BasicNode;", "getRootNode", "isAlwaysLeaf", "", "notifyDataSourcePathChanged", "ds", "Lcom/intellij/database/dataSource/AbstractDataSource;", "onDataSourceChanged", "dbDS", "Lcom/intellij/database/psi/DbDataSource;", "onViewOptionsChanged", "parentOf", "presentableNameOf", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.database.impl"})
public final class DvTreeStructureService
implements Disposable {
    @NotNull
    private final DvTreeContext context;
    private final DvTreeAbstractLayer layer1;
    private final DvTreeAbstractLayer layer2;
    private final DvTreeAbstractLayer layer3;
    private final DvTreeAbstractLayer layer4;

    @NotNull
    public final DvTreeContext getContext() {
        return this.context;
    }

    @NotNull
    public final BasicNode getRootNode() {
        return this.layer4.getRoot();
    }

    @Nullable
    public final BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.layer4.parentOf(node);
    }

    @NotNull
    public final JBIterable<? extends BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.layer4.childrenOf(node);
    }

    public final int countChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.layer4.countChildrenOf(node);
    }

    public final boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.layer4.isAlwaysLeaf(node);
    }

    @NotNull
    public final String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.layer4.presentableNameOf(node);
    }

    @NotNull
    public final BasicNode[] getPath(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getPathArray(node, 1);
    }

    private final BasicNode[] getPathArray(BasicNode node, int depth) {
        BasicNode p2 = this.parentOf(node);
        if (p2 == node) {
            throw (Throwable)new InternalError("The method DvTreeStructureService.parentOf() works incorrectly for node: " + node + " (node class: " + node.getClass().getSimpleName() + ')');
        }
        if (p2 == null) {
            BasicNode[] result2 = new BasicNode[depth];
            result2[0] = node;
            return result2;
        }
        BasicNode[] result3 = this.getPathArray(p2, depth + 1);
        result3[result3.length - depth] = node;
        return result3;
    }

    public final void onViewOptionsChanged() {
        this.layer1.onViewOptionsChanged();
        this.layer2.onViewOptionsChanged();
        this.layer3.onViewOptionsChanged();
        this.layer4.onViewOptionsChanged();
    }

    public final void notifyDataSourcePathChanged(@NotNull AbstractDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        DvTreeAbstractLayer dvTreeAbstractLayer = this.layer1;
        if (dvTreeAbstractLayer == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.view.structure.DvTreeModelLayer");
        }
        ((DvTreeModelLayer)dvTreeAbstractLayer).notifyDataSourcePathChanged$intellij_database_impl(ds);
    }

    private final void onDataSourceChanged(DbDataSource dbDS) {
    }

    public final void clearAll() {
        this.layer4.clearAll();
        this.layer3.clearAll();
        this.layer2.clearAll();
        this.layer1.clearAll();
    }

    public void dispose() {
        this.clearAll();
    }

    public DvTreeStructureService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.context = new DvTreeContext(project);
        this.layer1 = new DvTreeModelLayer(this.context);
        this.layer2 = new DvTreeLayoutLayer(this.layer1, this.context);
        this.layer3 = new DvTreeTransformLayer(this.layer2, this.context);
        this.layer4 = new DvTreeOptimizationLayer(this.layer3, this.context);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((DvTreeStructureService)this.receiver).onViewOptionsChanged();
            }
        };
        messageBusConnection2.subscribe(DatabaseViewOptions.TOPIC, (Object)new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        });
        function0 = (Function1)new Function1<DbDataSource, Unit>(this){

            public final void invoke(@Nullable DbDataSource p1) {
                ((DvTreeStructureService)this.receiver).onDataSourceChanged(p1);
            }
        };
        messageBusConnection2.subscribe(DbPsiFacade.TOPIC, (Object)new DbPsiFacade.Listener((Function1)function0){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ void onChanged(@Nullable DbDataSource p0) {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke((Object)p0), (String)"invoke(...)");
            }
        });
    }
}

