/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableChildEditorModel;
import com.intellij.sql.util.NameTemplate;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForeignKeyEditorModel
extends TableChildEditorModel<DeForeignKey> {
    private final EditorModelUtil.GeneratedNameHelper myGenHelper;

    public ForeignKeyEditorModel(@NotNull DeForeignKey object, @NotNull EditorModelsCache models2) {
        if (object == null) {
            ForeignKeyEditorModel.$$$reportNull$$$0(0);
        }
        if (models2 == null) {
            ForeignKeyEditorModel.$$$reportNull$$$0(1);
        }
        super(object, models2);
        this.fix();
        this.myGenHelper = new EditorModelUtil.GeneratedNameHelper<DeForeignKey>(object, this::genName);
        this.myGenHelper.updateGenerated();
    }

    @NotNull
    public String genName(@NotNull DeForeignKey fk) {
        if (fk == null) {
            ForeignKeyEditorModel.$$$reportNull$$$0(2);
        }
        String string = this.getModel().getCasing((ObjectKind)ObjectKind.FOREIGN_KEY, null).plain.apply(new NameTemplate.ForeignKeyNameTemplate(this.modelsCache.settings).getName(fk.table.name, (Iterable)JBIterable.from(fk.getColumnNames()), fk.target == null ? "" : fk.target.name, fk.getTargetColumnNames()));
        if (string == null) {
            ForeignKeyEditorModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void fix() {
        ((DeForeignKey)this.myObject).target = EditorModelUtil.stubbize(((DeForeignKey)this.myObject).target, null, ((DeForeignKey)this.myObject).model);
        List<DeForeignKey.Ref> refs = ((DeForeignKey)this.myObject).refs;
        for (int i2 = 0; i2 < refs.size(); ++i2) {
            DeForeignKey.Ref ref = refs.get(i2);
            if (ref.ref != null && ref.target != null) continue;
            refs.set(i2, new DeForeignKey.Ref(EditorModelUtil.stubbize(ref.ref, ((DeForeignKey)this.myObject).table, ((DeForeignKey)this.myObject).model), EditorModelUtil.stubbize(ref.target, ((DeForeignKey)this.myObject).table, ((DeForeignKey)this.myObject).model)));
        }
    }

    @NotNull
    public List<DeForeignKey.Ref> getRefs() {
        List<DeForeignKey.Ref> list = Collections.unmodifiableList(((DeForeignKey)this.myObject).refs);
        if (list == null) {
            ForeignKeyEditorModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void setRefs(@NotNull List<DeForeignKey.Ref> refs) {
        if (refs == null) {
            ForeignKeyEditorModel.$$$reportNull$$$0(5);
        }
        if (((DeForeignKey)this.myObject).refs.equals(refs)) {
            return;
        }
        ((DeForeignKey)this.myObject).refs.clear();
        ((DeForeignKey)this.myObject).refs.addAll(refs);
        this.modify();
    }

    @NotNull
    public DasForeignKey.RuleAction getUpdateRule() {
        DasForeignKey.RuleAction ruleAction = ((DeForeignKey)this.myObject).updateRule;
        if (ruleAction == null) {
            ForeignKeyEditorModel.$$$reportNull$$$0(6);
        }
        return ruleAction;
    }

    @NotNull
    public DasForeignKey.RuleAction getDeleteRule() {
        DasForeignKey.RuleAction ruleAction = ((DeForeignKey)this.myObject).deleteRule;
        if (ruleAction == null) {
            ForeignKeyEditorModel.$$$reportNull$$$0(7);
        }
        return ruleAction;
    }

    @NotNull
    public DasForeignKey.Deferrability getDeferrability() {
        DasForeignKey.Deferrability deferrability = ((DeForeignKey)this.myObject).deferrability;
        if (deferrability == null) {
            ForeignKeyEditorModel.$$$reportNull$$$0(8);
        }
        return deferrability;
    }

    public void setUpdateRule(@NotNull DasForeignKey.RuleAction action2) {
        if (action2 == null) {
            ForeignKeyEditorModel.$$$reportNull$$$0(9);
        }
        if (action2 == ((DeForeignKey)this.myObject).updateRule) {
            return;
        }
        ((DeForeignKey)this.myObject).updateRule = action2;
        this.modify();
    }

    public void setDeleteRule(@NotNull DasForeignKey.RuleAction action2) {
        if (action2 == null) {
            ForeignKeyEditorModel.$$$reportNull$$$0(10);
        }
        if (action2 == ((DeForeignKey)this.myObject).deleteRule) {
            return;
        }
        ((DeForeignKey)this.myObject).deleteRule = action2;
        this.modify();
    }

    public void setDeferrability(@NotNull DasForeignKey.Deferrability deferrability) {
        if (deferrability == null) {
            ForeignKeyEditorModel.$$$reportNull$$$0(11);
        }
        if (deferrability == ((DeForeignKey)this.myObject).deferrability) {
            return;
        }
        ((DeForeignKey)this.myObject).deferrability = deferrability;
        this.modify();
    }

    public int getRefsCount() {
        return ((DeForeignKey)this.myObject).refs.size();
    }

    @Nullable
    public DeTable getTargetTable() {
        return ((DeForeignKey)this.myObject).target;
    }

    public void setTargetTable(@Nullable DeTable target) {
        if (target == ((DeForeignKey)this.myObject).target) {
            return;
        }
        ((DeForeignKey)this.myObject).target = target;
        this.modify();
    }

    @Override
    public void commit() {
        if (this.myGenHelper.updateGenerated()) {
            this.modify();
        }
        super.commit();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fk";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/models/ForeignKeyEditorModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deferrability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/models/ForeignKeyEditorModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "genName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateRule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteRule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeferrability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "genName";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRefs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setUpdateRule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setDeleteRule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDeferrability";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

