/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.actions.DbDeleteProvider;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.view.DatabaseNavBarService;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseNavBarExtension
extends AbstractNavBarModelExtension {
    @NotNull
    public DatabaseNavBarService getService(Project project) {
        DatabaseNavBarService databaseNavBarService = (DatabaseNavBarService)project.getService(DatabaseNavBarService.class);
        if (databaseNavBarService == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(0);
        }
        return databaseNavBarService;
    }

    public PsiElement getLeafElement(@NotNull DataContext dataContext) {
        Component contextComponent;
        if (dataContext == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(1);
        }
        if ((contextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext)) instanceof DatabaseView.TreeComponent) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return null;
            }
            DatabaseNavBarService service = this.getService(project);
            PsiElement leafElement = service.getLeafElement();
            return leafElement;
        }
        return null;
    }

    @Nullable
    public String getPopupMenuGroup(@NotNull DataProvider provider) {
        PsiElement object;
        if (provider == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(2);
        }
        if (!DatabaseStructure.isDatabaseObject(object = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(provider))) {
            return null;
        }
        return "DatabaseViewPopupMenu";
    }

    @Nullable
    public Object getData(@NotNull String dataId, @NotNull DataProvider provider) {
        PsiElement object;
        if (dataId == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(4);
        }
        if ((object = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(provider)) instanceof DatabaseStructure.DbRootGroup) {
            return null;
        }
        if (!DatabaseStructure.isDatabaseObject(object)) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && object instanceof DbElement) {
            return DbNavigationUtils.createFromTreeNavigatable((DbElement)object);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return DbDeleteProvider.getDeleteProvider(Collections.singletonList(object));
        }
        return DbNodeDescriptor.getData(dataId, object.getProject(), object);
    }

    @Nullable
    public String getPresentableText(Object object) {
        if (!DatabaseStructure.isDatabaseObject(object)) {
            return null;
        }
        return object instanceof DbElement ? DbPresentationCore.getPresentableName((DbElement)object, true) : (object instanceof PsiNamedElement ? ((PsiNamedElement)object).getName() : null);
    }

    @Nullable
    public PsiElement getParent(PsiElement psiElement) {
        if (psiElement instanceof DatabaseNavBarService.NodeWrapper) {
            return psiElement.getParent();
        }
        DatabaseNavBarService service = this.getService(psiElement.getProject());
        return service.getParent(psiElement);
    }

    @Nullable
    public PsiElement adjustElement(final @NotNull PsiElement psiElement) {
        if (psiElement == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(5);
        }
        if (psiElement instanceof DbElement || psiElement instanceof DatabaseNavBarService.NodeWrapper) {
            return psiElement;
        }
        final VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        if (DbImplUtil.isDatabaseVirtualFile(file)) {
            DbElement element2 = DbImplUtilCore.findElement(psiElement.getProject(), file);
            if (element2 != null) {
                return element2;
            }
            if (DbSrcUtilsCore.isDbSrcFile(file)) {
                PsiElement group = DbSrcFileSystemCore.processPath(file.getPath(), new DbSrcFileSystemCore.ItemProcessor<PsiElement>(){

                    @Override
                    public PsiElement processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                        DbElement parent2;
                        if (dataSourceId == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DbElement dbElement = parent2 = group == null ? null : DbImplUtilCore.findElement(psiElement.getProject(), file.getParent());
                        if (parent2 == null) {
                            return null;
                        }
                        DbDataSource dataSource2 = parent2.getDataSource();
                        return null;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/view/DatabaseNavBarExtension$1", "processFolder"));
                    }
                });
                if (group != null) {
                    return group;
                }
                return DbPsiFacade.getInstance(psiElement.getProject()).findDataSource(DbSrcUtilsCore.getDataSource(file));
            }
        } else {
            DataGrid dataGrid = DataGridPomTarget.unwrapDataGrid(psiElement);
            if (dataGrid != null) {
                VirtualFile virtualFile = DataGridUtil.getVirtualFile(dataGrid);
                return virtualFile == null ? null : psiElement.getManager().findFile(virtualFile);
            }
        }
        return psiElement;
    }

    public boolean processChildren(Object object, Object rootElement, Processor<Object> processor2) {
        BasicNode node;
        Object adjusted;
        if (object instanceof DatabaseNavBarService.NodeWrapper) {
            DatabaseNavBarService.NodeWrapper nw = (DatabaseNavBarService.NodeWrapper)((Object)object);
            JBIterable<PsiElement> children2 = nw.iterateChildren();
            return ContainerUtil.process(children2, processor2);
        }
        if (!(object instanceof PsiElement) || !((PsiElement)object).isValid()) {
            return true;
        }
        Object object2 = adjusted = object instanceof DbElement && !(object instanceof DbDataSource) ? ((DbElement)object).getDelegate() : object;
        if (!DatabaseStructure.isDatabaseObject(adjusted)) {
            return true;
        }
        if (DatabaseStructure.isAlwaysLeafImpl(adjusted)) {
            return true;
        }
        Project project = ((PsiElement)object).getProject();
        DvTreeStructureService structure = (DvTreeStructureService)project.getService(DvTreeStructureService.class);
        DatabaseViewOptions options = DatabaseViewOptions.getInstance(project);
        DatabaseNavBarService service = this.getService(project);
        if (adjusted instanceof BasicNode) {
            node = (BasicNode)adjusted;
        } else if (adjusted instanceof PsiElement) {
            node = service.unwrap((PsiElement)adjusted);
        } else {
            return false;
        }
        if (node == null) {
            return true;
        }
        JBIterable children3 = DatabaseStructure.getChildrenImpl(node, options, structure).filterMap(o -> service.wrap(o));
        return ContainerUtil.process((Iterable)children3, processor2);
    }

    public Boolean shouldExpandOnClick(PsiElement psiElement) {
        if (psiElement instanceof DatabaseNavBarService.NodeWrapper) {
            return true;
        }
        if (!DatabaseStructure.isDatabaseObject(psiElement)) {
            return null;
        }
        return !DatabaseStructure.isAlwaysLeafImpl(psiElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseNavBarExtension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseNavBarExtension";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLeafElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPopupMenuGroup";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

