/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.console.DatabaseServiceViewContributor;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileUtils;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FileColorManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseColorManager<T extends SharedColors>
implements PersistentStateComponent<T> {
    private static final Key<CachedColor> COLOR_KEY = Key.create((String)"COLOR_KEY");
    public static final Topic<ColorChangeListener> COLOR_CHANGE_TOPIC = new Topic("Color changed", ColorChangeListener.class);
    private static final SimpleModificationTracker ourModificationTracker = new SimpleModificationTracker();
    protected T myState;

    public static DatabaseColorManager<LocalColors> getLocalColorManager(@NotNull Project project) {
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(0);
        }
        return (DatabaseColorManager)project.getService(Local.class);
    }

    public static DatabaseColorManager<SharedColors> getSharedColorManager(@NotNull Project project) {
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(1);
        }
        return (DatabaseColorManager)project.getService(Shared.class);
    }

    private static long getModCount() {
        return ourModificationTracker.getModificationCount() + UISettings.getInstance().getState().getModificationCount();
    }

    @NotNull
    public T getState() {
        T t = this.myState;
        if (t == null) {
            DatabaseColorManager.$$$reportNull$$$0(2);
        }
        return t;
    }

    public void loadState(@NotNull T state) {
        if (state == null) {
            DatabaseColorManager.$$$reportNull$$$0(3);
        }
        this.myState = state;
        if (JBIterable.from(((SharedColors)this.myState).colors.keySet()).find(key -> key.endsWith(":ROOT") || key.endsWith(":NONE") || key.endsWith(":data source")) != null) {
            Map<String, String> orig = ((SharedColors)this.myState).colors;
            ((SharedColors)this.myState).colors = new HashMap<String, String>();
            for (String key2 : orig.keySet()) {
                String value2 = orig.get(key2);
                String newKey = StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)key2, (String)":data source"), (String)":NONE"), (String)":ROOT");
                if (((SharedColors)this.myState).colors.containsKey(newKey)) continue;
                ((SharedColors)this.myState).colors.put(newKey, value2);
            }
        }
    }

    @Nullable
    public static Color getColor(@NotNull Project project, @Nullable VirtualFile file, boolean includingAttached) {
        DbElement element2;
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(4);
        }
        if (DbImplUtil.isDatabaseVirtualFile(file)) {
            DbElement tableOrView = DbImplUtilCore.findElement(project, file);
            element2 = tableOrView != null ? tableOrView : DbImplUtilCore.findDataSource(project, file);
        } else {
            boolean isConsoleFile = DbVFSUtils.isConsoleFile(file);
            if (!isConsoleFile && !includingAttached) {
                return null;
            }
            JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file);
            if (console == null) {
                element2 = isConsoleFile ? DbVFSUtils.getDataSource(project, file) : null;
            } else {
                DbDataSource dataSource2 = DbImplUtilCore.getDbDataSource(project, (DasDataSource)console.getTarget());
                ObjectPath path = console.getCurrentNamespace();
                element2 = dataSource2 == null || path == null ? dataSource2 : DbSqlUtilCore.findElement(dataSource2, path);
            }
        }
        return DatabaseColorManager.getColor(element2);
    }

    @Nullable
    public static Color getColor(@Nullable DbElement element2) {
        if (element2 == null) {
            return null;
        }
        CachedColor info = (CachedColor)COLOR_KEY.get((UserDataHolder)element2);
        long modificationCount = DatabaseColorManager.getModCount();
        if (info != null && info.modCount != modificationCount) {
            info = null;
        }
        if (info == null) {
            Color c2;
            String colorName = DatabaseColorManager.getColorId(element2, null);
            info = new CachedColor();
            info.modCount = modificationCount;
            if (colorName != null && (c2 = FileColorManager.getInstance((Project)element2.getProject()).getColor(colorName)) != null) {
                info.color = c2;
            }
            COLOR_KEY.set((UserDataHolder)element2, (Object)info);
        }
        return info.color;
    }

    public static void setColorId(@NotNull DbElement element2, @Nullable @NonNls String colorID, boolean recursively, boolean isShared) {
        if (element2 == null) {
            DatabaseColorManager.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DatabaseColorManager<LocalColors> localColorManager = DatabaseColorManager.getLocalColorManager(element2.getProject());
        Object local = localColorManager.getState();
        Object shared = DatabaseColorManager.getSharedColorManager(element2.getProject()).getState();
        String elementId = DatabaseColorManager.getElementId(element2);
        boolean changed = ((SharedColors)shared).colors.remove(elementId) != null;
        changed |= ((SharedColors)local).colors.remove(elementId) != null;
        if (colorID != null) {
            boolean doNotChange;
            Ref sharedRef = Ref.create(null);
            boolean bl = doNotChange = !changed && colorID.equals(DatabaseColorManager.getColorId(element2, (Ref<Boolean>)sharedRef)) && isShared == Boolean.TRUE.equals(sharedRef.get());
            if (!doNotChange) {
                changed = true;
                ((SharedColors)(isShared ? shared : local)).colors.put(elementId, colorID);
            }
        }
        if (recursively) {
            changed |= DatabaseColorManager.clearChildren(elementId, ((SharedColors)shared).colors);
            changed |= DatabaseColorManager.clearChildren(elementId, ((SharedColors)local).colors);
        }
        if (changed) {
            ourModificationTracker.incModificationCount();
            DatabaseServiceViewContributor.refreshView(element2.getProject());
        }
    }

    private static boolean clearChildren(String elementId, Map<String, String> colors) {
        int colonIndex = elementId.lastIndexOf(58);
        String trimmedId = colonIndex == -1 ? elementId : elementId.substring(0, colonIndex + 1);
        return colors.keySet().removeIf(item -> DatabaseColorManager.isChild(item, trimmedId));
    }

    private static boolean isChild(String element2, String parent2) {
        int idx = element2.indexOf(parent2);
        return idx > 0 && element2.charAt(idx - 1) == '/';
    }

    @Nullable
    public static Color getColor(@NotNull Project project, @Nullable DasDataSource dataSource2) {
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (dataSource2 == null) {
            return null;
        }
        String id = dataSource2.getUniqueId();
        String colorName = (String)((LocalColors)DatabaseColorManager.getLocalColorManager((Project)project).getState()).colors.get(id);
        colorName = colorName != null ? colorName : ((SharedColors)DatabaseColorManager.getSharedColorManager((Project)project).getState()).colors.get(id);
        return colorName == null ? null : FileColorManager.getInstance((Project)project).getColor(colorName);
    }

    @Nullable
    @NonNls
    public static String getColorId(@Nullable DbElement element2, @Nullable Ref<Boolean> sharedRef) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (element2 == null) {
            return null;
        }
        Project project = element2.getProject();
        Object local = DatabaseColorManager.getLocalColorManager(project).getState();
        Object shared = DatabaseColorManager.getSharedColorManager(project).getState();
        if (((SharedColors)shared).colors.isEmpty() && ((SharedColors)local).colors.isEmpty()) {
            return null;
        }
        for (DbElement e = element2; e != null; e = e.getParent()) {
            boolean isShared;
            String elementId = DatabaseColorManager.getElementId(e);
            String s2 = ((SharedColors)local).colors.get(elementId);
            boolean bl = isShared = s2 == null;
            if (s2 == null) {
                s2 = ((SharedColors)shared).colors.get(elementId);
                boolean bl2 = isShared = s2 != null;
            }
            if (s2 == null) continue;
            if (sharedRef != null) {
                sharedRef.set((Object)isShared);
            }
            return s2;
        }
        return null;
    }

    @NotNull
    private static String getElementId(@NotNull DbElement element2) {
        if (element2 == null) {
            DatabaseColorManager.$$$reportNull$$$0(7);
        }
        StringBuilder sb = new StringBuilder();
        for (DbElement cur2 = element2; cur2 != null; cur2 = cur2.getParent()) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(cur2 instanceof DbDataSource ? ((DbDataSource)cur2).getUniqueId() : DatabaseElementVirtualFileUtils.escape(cur2.getName()));
        }
        if (!(element2 instanceof DbDataSource)) {
            sb.append(":").append(element2.getKind().name());
        }
        String string = sb.toString();
        if (string == null) {
            DatabaseColorManager.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void cleanupColors(@NotNull Project project) {
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(9);
        }
        Map local = ((LocalColors)DatabaseColorManager.getLocalColorManager((Project)project).getState()).colors;
        Map<String, String> shared = ((SharedColors)DatabaseColorManager.getSharedColorManager((Project)project).getState()).colors;
        if (local.isEmpty() && shared.isEmpty()) {
            return;
        }
        List<DbDataSource> dataSources = DbPsiFacade.getInstance(project).getDataSources();
        Set existingRoots = JBIterable.from(dataSources).map(o -> o.getUniqueId()).toSet();
        DatabaseColorManager.cleanupColors(local, existingRoots);
        DatabaseColorManager.cleanupColors(shared, existingRoots);
    }

    private static void cleanupColors(Map<String, String> colors, Set<String> roots2) {
        block0: for (String s2 : ArrayUtilRt.toStringArray(colors.keySet())) {
            for (String root2 : roots2) {
                if (!s2.contains(root2)) continue;
                continue block0;
            }
            colors.remove(s2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseColorManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseColorManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalColorManager";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSharedColorManager";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setColorId";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementId";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "cleanupColors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedColor {
        Color color;
        long modCount;

        private CachedColor() {
        }
    }

    public static class LocalColors
    extends SharedColors {
        @OptionTag(value="use-colors")
        public boolean useColors = true;
        @OptionTag(value="in-editor-tabs")
        public boolean inEditorTabs = true;
        @OptionTag(value="in-database-view")
        public boolean inDatabaseView = true;
        @OptionTag(value="in-toolbars")
        public boolean useInToolbars = true;
        @OptionTag(value="in-editor")
        public boolean useInEditor = false;
    }

    public static class SharedColors {
        @Tag(value="colors")
        @MapAnnotation(surroundWithTag=false)
        public Map<String, String> colors = new HashMap<String, String>();
    }

    @State(name="DatabaseLocalColorSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
    private static class Local
    extends DatabaseColorManager<LocalColors>
    implements PersistentStateComponent<LocalColors> {
        Local(final @NotNull Project project) {
            if (project == null) {
                Local.$$$reportNull$$$0(0);
            }
            this.myState = new LocalColors();
            project.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosingBeforeSave(@NotNull Project eventProject) {
                    if (eventProject == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (project == eventProject) {
                        DatabaseColorManager.cleanupColors(project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventProject", "com/intellij/database/view/DatabaseColorManager$Local$1", "projectClosingBeforeSave"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseColorManager$Local", "<init>"));
        }
    }

    @State(name="DatabaseColorSettings", storages={@Storage(value="databaseColors.xml")})
    private static class Shared
    extends DatabaseColorManager<SharedColors>
    implements PersistentStateComponent<SharedColors> {
        Shared() {
            this.myState = new SharedColors();
        }
    }

    public static interface ColorChangeListener {
        public void onChanged();
    }
}

