/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreePatternUtils {
    public static final GroupedGroupFactory UNION_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value2) {
            if (value2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> groups) {
            return !1.containsNotNull(groups);
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value2) {
            if (value2 == null) {
                1.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/util/TreePatternUtils$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final GroupedGroupFactory INTERSECTION_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value2) {
            if (value2 == null) {
                2.$$$reportNull$$$0(0);
            }
            return !2.containsNull(value2);
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> groups) {
            return 2.containsNull(groups);
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value2) {
            if (value2 == null) {
                2.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/util/TreePatternUtils$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final GroupedGroupFactory MINUS_PROCESSOR = new GroupedGroupFactory(){

        @Override
        @Nullable
        public TreePatternNode.Group[] mergeRoots(@NotNull Iterable<TreePatternNode<?>> nodes2) {
            if (nodes2 == null) {
                3.$$$reportNull$$$0(0);
            }
            JBIterable ji = JBIterable.from(nodes2);
            return super.mergeRoots((Iterable<TreePatternNode<?>>)ji.take(1).append((Iterable)ji.skip(1).filter(n -> n.groups.length != 0)));
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value2) {
            Iterator<TreePatternNode<?>> it2;
            if (value2 == null) {
                3.$$$reportNull$$$0(1);
            }
            if (!(it2 = value2.iterator()).hasNext()) {
                return false;
            }
            TreePatternNode<?> first2 = it2.next();
            if (first2 == null) {
                return false;
            }
            while (it2.hasNext()) {
                TreePatternNode<?> n = it2.next();
                if (n == null || first2.groups.length != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value2) {
            Iterator<TreePatternNode.Group> it2;
            if (value2 == null) {
                3.$$$reportNull$$$0(2);
            }
            return (it2 = value2.iterator()).hasNext() && it2.next() != null;
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> groups) {
            for (TreePatternNode<?> group : groups) {
                if (group == null || group.groups.length != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean mergeChildren() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/TreePatternUtils$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeRoots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkGroup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final TreePatternNode.Group SKIP_PROCESSING = new TreePatternNode.Group(ObjectKind.NONE, null, null);

    @NotNull
    public static String[] toStringArray(@NotNull Collection<String> names) {
        if (names == null) {
            TreePatternUtils.$$$reportNull$$$0(0);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(names);
        if (stringArray == null) {
            TreePatternUtils.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public static String[] toStringArray(@NotNull Iterable<String> names) {
        if (names == null) {
            TreePatternUtils.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.collect(names.iterator());
        return TreePatternUtils.toStringArray(list);
    }

    public static boolean isValid(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            TreePatternUtils.$$$reportNull$$$0(3);
        }
        HashSet<ObjectName> unique = new HashSet<ObjectName>();
        if (g.positiveChildren != null) {
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : g.positiveChildren) {
                for (ObjectName name : ((TreePatternNode.PositiveNaming)child.naming).getNames()) {
                    if (!unique.add(name)) assert (false) : "Duplicate `" + name + "` " + new TreePattern(g);
                }
            }
        }
        if (g.negativeChild != null) {
            List<ObjectName> anti = Arrays.asList(((TreePatternNode.NegativeNaming)g.negativeChild.naming).getAntiNames());
            assert (anti.containsAll(unique)) : "Neg. covers pos. `" + new ArrayList(unique).removeAll(anti) + "` " + new TreePattern(g);
        }
        return true;
    }

    @NotNull
    public static Iterable<ObjectName> getSinkNames(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            TreePatternUtils.$$$reportNull$$$0(4);
        }
        if (g.negativeChild == null) {
            JBIterable jBIterable = JBIterable.of((Object[])g.positiveChildren).flatten(c2 -> JBIterable.of((Object[])((TreePatternNode.PositiveNaming)c2.naming).getNames()));
            if (jBIterable == null) {
                TreePatternUtils.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        LinkedHashSet res2 = ContainerUtil.newLinkedHashSet((Object[])((TreePatternNode.NegativeNaming)g.negativeChild.naming).getAntiNames());
        if (g.positiveChildren != null) {
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : g.positiveChildren) {
                ContainerUtil.removeAll((Collection)res2, (Object[])((TreePatternNode.PositiveNaming)child.naming).getNames());
            }
        }
        LinkedHashSet linkedHashSet = res2;
        if (linkedHashSet == null) {
            TreePatternUtils.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    @NotNull
    public static TreePatternNode.NegativeNaming subdivideChildren(@NotNull Iterable<TreePatternNode.Group> groups, @NotNull MultiMap<TreePatternNode.PositiveNaming, TreePatternNode<?>> pSubdiv, @NotNull Collection<TreePatternNode<?>> nSubdiv, boolean mergeChildren) {
        if (groups == null) {
            TreePatternUtils.$$$reportNull$$$0(7);
        }
        if (pSubdiv == null) {
            TreePatternUtils.$$$reportNull$$$0(8);
        }
        if (nSubdiv == null) {
            TreePatternUtils.$$$reportNull$$$0(9);
        }
        LinkedHashSet allNames = new LinkedHashSet();
        for (TreePatternNode.Group group : groups) {
            if (group == null) continue;
            if (group.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group.positiveChildren) {
                    ContainerUtil.addAll(allNames, (Object[])((TreePatternNode.PositiveNaming)child.naming).getNames());
                }
            }
            if (group.negativeChild == null) continue;
            ContainerUtil.addAll(allNames, (Object[])((TreePatternNode.NegativeNaming)group.negativeChild.naming).getAntiNames());
        }
        MultiMap broadSubdiv = mergeChildren ? MultiMap.createLinkedSet() : MultiMap.createLinked();
        for (TreePatternNode.Group group : groups) {
            Object value2;
            HashSet antiNames;
            if (group == null) {
                for (ObjectName name : allNames) {
                    broadSubdiv.putValue((Object)name, null);
                }
                nSubdiv.add(null);
                continue;
            }
            if (group.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group.positiveChildren) {
                    for (ObjectName name : ((TreePatternNode.PositiveNaming)child.naming).getNames()) {
                        broadSubdiv.putValue((Object)name, child);
                    }
                }
            }
            LinkedHashSet sinks = ContainerUtil.newLinkedHashSet(TreePatternUtils.getSinkNames(group));
            if (group.negativeChild != null) {
                for (ObjectName sink : sinks) {
                    broadSubdiv.putValue((Object)sink, null);
                }
                antiNames = ContainerUtil.newHashSet((Object[])((TreePatternNode.NegativeNaming)group.negativeChild.naming).getAntiNames());
                TreePatternNode<TreePatternNode.NegativeNaming> value3 = group.negativeChild;
            } else {
                antiNames = sinks;
                value2 = null;
            }
            for (ObjectName name : allNames) {
                if (antiNames.contains(name)) continue;
                broadSubdiv.putValue((Object)name, value2);
            }
            nSubdiv.add((TreePatternNode<?>)value2);
        }
        MultiMap multiMap = MultiMap.createLinkedSet();
        for (Map.Entry entry : broadSubdiv.entrySet()) {
            multiMap.putValue((Object)((Collection)entry.getValue()), (Object)((ObjectName)entry.getKey()));
        }
        for (Map.Entry entry : multiMap.entrySet()) {
            pSubdiv.put((Object)new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)entry.getValue())), (Collection)entry.getKey());
        }
        return new TreePatternNode.NegativeNaming(ObjectName.toArray(broadSubdiv.keySet()));
    }

    @Nullable
    private static TreePatternNode.Group processGrouped(@NotNull ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> groups, @NotNull GroupedGroupFactory fac) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(10);
        }
        if (groups == null) {
            TreePatternUtils.$$$reportNull$$$0(11);
        }
        if (fac == null) {
            TreePatternUtils.$$$reportNull$$$0(12);
        }
        LinkedHashSet grouped = fac.mergeChildren() ? ContainerUtil.newLinkedHashSet(groups) : groups;
        MultiMap positive = fac.mergeChildren() ? MultiMap.createLinkedSet() : MultiMap.createLinked();
        LinkedHashSet negative = fac.mergeChildren() ? new LinkedHashSet() : new SmartList();
        TreePatternNode.NegativeNaming negativeNaming = TreePatternUtils.subdivideChildren(grouped, positive, negative, fac.mergeChildren());
        return fac.create(positive, negativeNaming, negative, kind);
    }

    public static boolean isValid(TreePatternNode<?> node) {
        HashSet<ObjectKind> kinds = new HashSet<ObjectKind>();
        for (TreePatternNode.Group group : node.groups) {
            if (kinds.add(group.kind)) continue;
            return false;
        }
        return true;
    }

    public static void print(@NotNull StringBuilder builder, @NotNull TreePatternNode.Group group, int depth) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(13);
        }
        if (group == null) {
            TreePatternUtils.$$$reportNull$$$0(14);
        }
        builder.append(StringUtil.repeat((String)"  ", (int)depth)).append("kind: ");
        builder.append(group.kind).append("\n");
        JBIterable.of((Object[])group.positiveChildren).append(group.negativeChild).forEach(n -> TreePatternUtils.print(builder, n, depth + 1));
    }

    public static void print(@NotNull StringBuilder builder, @NotNull TreePatternNode<?> node, int depth) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(15);
        }
        if (node == null) {
            TreePatternUtils.$$$reportNull$$$0(16);
        }
        builder.append(StringUtil.repeat((String)"  ", (int)depth)).append("name: ").append(node.naming).append("\n");
        JBIterable.of((Object[])node.groups).forEach(n -> TreePatternUtils.print(builder, n, depth + 1));
    }

    private static TreePatternNode.Group[] preserve(@NotNull TreePatternNode.Group[] groups, boolean preserveOthers, @Nullable TreePatternNode.Group res2, int pos) {
        if (groups == null) {
            TreePatternUtils.$$$reportNull$$$0(17);
        }
        if (pos == -1) {
            TreePatternNode.Group[] groupArray;
            if (preserveOthers) {
                groupArray = res2 == null ? groups : (TreePatternNode.Group[])ArrayUtil.append((Object[])groups, (Object)res2);
            } else if (res2 == null) {
                groupArray = null;
            } else {
                TreePatternNode.Group[] groupArray2 = new TreePatternNode.Group[1];
                groupArray = groupArray2;
                groupArray2[0] = res2;
            }
            return groupArray;
        }
        if (res2 == null) {
            return preserveOthers && groups.length != 1 ? (TreePatternNode.Group[])ArrayUtil.remove((Object[])groups, (int)pos) : null;
        }
        if (!preserveOthers) {
            return new TreePatternNode.Group[]{res2};
        }
        TreePatternNode.Group[] clone = (TreePatternNode.Group[])groups.clone();
        clone[pos] = res2;
        return clone;
    }

    @Nullable
    private static TreePatternNode.Group[] mask(@NotNull TreePatternNode.Group[] groups, @NotNull ObjectKind[] kinds, @NotNull boolean[] mask, int i2, boolean preserveOthers) {
        if (groups == null) {
            TreePatternUtils.$$$reportNull$$$0(18);
        }
        if (kinds == null) {
            TreePatternUtils.$$$reportNull$$$0(19);
        }
        if (mask == null) {
            TreePatternUtils.$$$reportNull$$$0(20);
        }
        if (i2 >= kinds.length) {
            return TreePatternNode.NO_GROUPS;
        }
        boolean wildcard = !mask[i2];
        int idx = -1;
        for (int k = 0; k < groups.length; ++k) {
            if (groups[k].kind != kinds[i2]) continue;
            idx = k;
            break;
        }
        if (idx == -1) {
            TreePatternNode.Group res2 = null;
            if (wildcard) {
                TreePatternNode.Group[] children2 = TreePatternUtils.mask(TreePatternNode.NO_GROUPS, kinds, mask, i2 + 1, preserveOthers);
                res2 = children2 == null ? null : new TreePatternNode.Group(kinds[i2], null, new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, children2));
            }
            return TreePatternUtils.preserve(groups, preserveOthers, res2, -1);
        }
        TreePatternNode.Group group = groups[idx];
        if (!wildcard) {
            TreePatternNode.Group[] masked;
            MultiMap positive = MultiMap.createLinkedSet();
            if (group.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group.positiveChildren) {
                    TreePatternNode.Group[] masked2 = TreePatternUtils.mask(child.groups, kinds, mask, i2 + 1, preserveOthers);
                    if (masked2 == null) continue;
                    positive.putValue(new AW<TreePatternNode.Group>(masked2), (Object)((TreePatternNode.PositiveNaming)child.naming));
                }
            }
            TreePatternNode<TreePatternNode.NegativeNaming> negChild = null;
            if (group.negativeChild != null && (masked = TreePatternUtils.mask(group.negativeChild.groups, kinds, mask, i2 + 1, preserveOthers)) != null) {
                Collection removed = positive.remove(new AW<TreePatternNode.Group>(masked));
                if (removed != null) {
                    ArrayList names = ContainerUtil.newArrayList((Object[])((TreePatternNode.NegativeNaming)group.negativeChild.naming).getAntiNames());
                    for (TreePatternNode.PositiveNaming naming : removed) {
                        ContainerUtil.removeAll((Collection)names, (Object[])naming.getNames());
                    }
                    negChild = new TreePatternNode<TreePatternNode.NegativeNaming>(new TreePatternNode.NegativeNaming(ObjectName.toArray(names)), masked);
                } else {
                    negChild = new TreePatternNode<TreePatternNode.NegativeNaming>((TreePatternNode.NegativeNaming)group.negativeChild.naming, masked);
                }
            }
            TreePatternNode.Group result2 = null;
            if (negChild != null || !positive.isEmpty()) {
                TreePatternNode[] res3;
                TreePatternNode[] treePatternNodeArray = res3 = positive.isEmpty() ? null : new TreePatternNode[positive.size()];
                if (res3 != null) {
                    int k = 0;
                    for (Map.Entry entry : positive.entrySet()) {
                        res3[k] = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable<ObjectName>)JBIterable.from((Iterable)((Iterable)entry.getValue())).flatten(x -> JBIterable.of((Object[])x.getNames())))), (TreePatternNode.Group[])((AW)entry.getKey()).array);
                        ++k;
                    }
                }
                result2 = new TreePatternNode.Group(kinds[i2], res3, negChild);
            }
            return TreePatternUtils.preserve(groups, preserveOthers, result2, idx);
        }
        LinkedHashSet res4 = new LinkedHashSet();
        for (TreePatternNode node : JBIterable.of((Object[])group.positiveChildren).append(group.negativeChild)) {
            TreePatternNode.Group[] grouped = TreePatternUtils.mask(node.groups, kinds, mask, i2 + 1, preserveOthers);
            if (grouped == null) continue;
            res4.add(new TreePatternNode(node.naming, grouped));
        }
        TreePatternNode.Group[] merged = UNION_PROCESSOR.mergeRoots(res4);
        TreePatternNode.Group result3 = merged == null ? null : new TreePatternNode.Group(kinds[i2], null, new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, merged));
        return TreePatternUtils.preserve(groups, preserveOthers, result3, idx);
    }

    @NotNull
    public static TreePattern union(TreePattern ... patterns2) {
        if (patterns2 == null) {
            TreePatternUtils.$$$reportNull$$$0(21);
        }
        return TreePatternUtils.union(Arrays.asList(patterns2));
    }

    @NotNull
    public static TreePattern union(@NotNull Iterable<TreePattern> patterns2) {
        if (patterns2 == null) {
            TreePatternUtils.$$$reportNull$$$0(22);
        }
        TreePattern treePattern = UNION_PROCESSOR.merge(patterns2);
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(23);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern intersect(TreePattern ... patterns2) {
        if (patterns2 == null) {
            TreePatternUtils.$$$reportNull$$$0(24);
        }
        TreePattern treePattern = INTERSECTION_PROCESSOR.merge((Iterable<TreePattern>)JBIterable.of((Object[])patterns2));
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(25);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern minus(TreePattern ... patterns2) {
        if (patterns2 == null) {
            TreePatternUtils.$$$reportNull$$$0(26);
        }
        TreePattern treePattern = MINUS_PROCESSOR.merge((Iterable<TreePattern>)JBIterable.of((Object[])patterns2));
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(27);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern diff(TreePattern ... patterns2) {
        if (patterns2 == null) {
            TreePatternUtils.$$$reportNull$$$0(28);
        }
        return TreePatternUtils.minus(TreePatternUtils.union(patterns2), TreePatternUtils.intersect(patterns2));
    }

    @NotNull
    public static TreePattern mask(@NotNull TreePattern pattern, @NotNull ObjectKind[] kinds, @NotNull boolean[] mask, boolean preserveOthers) {
        if (pattern == null) {
            TreePatternUtils.$$$reportNull$$$0(29);
        }
        if (kinds == null) {
            TreePatternUtils.$$$reportNull$$$0(30);
        }
        if (mask == null) {
            TreePatternUtils.$$$reportNull$$$0(31);
        }
        return new TreePattern(TreePatternUtils.mask(pattern.root.groups, kinds, mask, 0, preserveOthers));
    }

    @NotNull
    public static TreePatternNode.Group create(@NotNull DasObject obj, TreePatternNode.Group ... children2) {
        if (obj == null) {
            TreePatternUtils.$$$reportNull$$$0(32);
        }
        return TreePatternUtils.create(ObjectName.create(obj.getName(), DbSqlUtilCore.isQuoted(obj)), obj.getKind(), children2);
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable ObjectName name, @NotNull ObjectKind kind, TreePatternNode.Group ... children2) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(33);
        }
        return TreePatternUtils.create(name == null ? null : Collections.singletonList(name), kind, children2);
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable List<ObjectName> names, @NotNull ObjectKind kind, TreePatternNode.Group ... children2) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(34);
        }
        return TreePatternUtils.create(ObjectName.toArray(names), kind, children2);
    }

    @NotNull
    public static TreePatternNode.Group create(ObjectName @Nullable [] names, @NotNull ObjectKind kind, TreePatternNode.Group ... children2) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(35);
        }
        if (children2 == null) {
            children2 = TreePatternNode.NO_GROUPS;
        }
        int nonNulls = 0;
        for (TreePatternNode.Group child : children2) {
            if (child == null) continue;
            ++nonNulls;
        }
        if (nonNulls != children2.length) {
            if (nonNulls == 0) {
                children2 = TreePatternNode.NO_GROUPS;
            } else {
                TreePatternNode.Group[] children22 = new TreePatternNode.Group[nonNulls];
                nonNulls = 0;
                for (TreePatternNode.Group child : children2) {
                    if (child == null) continue;
                    children22[nonNulls++] = child;
                }
                children2 = children22;
            }
        }
        TreePatternNode.Group res2 = names == null ? new TreePatternNode.Group(kind, null, new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, children2)) : new TreePatternNode.Group(kind, new TreePatternNode[]{new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(names), children2)}, null);
        TreePatternNode.Group group = res2;
        if (group == null) {
            TreePatternUtils.$$$reportNull$$$0(36);
        }
        return group;
    }

    @NotNull
    public static TreePattern patternProcessor(@NotNull TreePattern processed, @NotNull TreePattern mask, final @NotNull PatternProcessor processor2) {
        TreePatternNode.Group[] newRoot;
        if (processed == null) {
            TreePatternUtils.$$$reportNull$$$0(37);
        }
        if (mask == null) {
            TreePatternUtils.$$$reportNull$$$0(38);
        }
        if (processor2 == null) {
            TreePatternUtils.$$$reportNull$$$0(39);
        }
        return (newRoot = new Object(){

            @Nullable
            public TreePatternNode.Group[] visit(@Nullable TreePatternNode<?> node, @Nullable TreePatternNode<?> checker, @Nullable TreePatternNode.BaseNaming parent2, @Nullable ObjectKind parentKind) {
                TreePatternNode.Group processed;
                if (checker == null) {
                    return node == null ? null : node.groups;
                }
                NodeBuilder b2 = null;
                LinkedHashMap<ObjectKind, TreePatternNode.Group> newGroups = new LinkedHashMap<ObjectKind, TreePatternNode.Group>();
                for (TreePatternNode.Group group : checker.groups) {
                    newGroups.put(group.kind, group);
                }
                if (node != null) {
                    for (int i2 = 0; i2 < node.groups.length; ++i2) {
                        TreePatternNode.Group group = node.groups[i2];
                        newGroups.remove(group.kind);
                        TreePatternNode.Group checkerGroup = checker.getGroup(group.kind);
                        processed = group;
                        if (checkerGroup != null) {
                            processed = this.visit(group, checkerGroup, parent2, parentKind);
                        }
                        if (processed != group && b2 == null) {
                            b2 = new NodeBuilder();
                            for (int k = 0; k < i2; ++k) {
                                b2.addGroup(node.groups[k]);
                            }
                        }
                        if (b2 == null || processed == null) continue;
                        b2.addGroup(processed);
                    }
                }
                Iterator iterator = newGroups.values().iterator();
                while (iterator.hasNext()) {
                    TreePatternNode.Group group;
                    TreePatternNode.Group temp = new TreePatternNode.Group(group.kind, null, null);
                    group = (TreePatternNode.Group)iterator.next();
                    processed = this.visit(temp, group, parent2, parentKind);
                    if (processed == temp || processed == null) continue;
                    if (b2 == null) {
                        b2 = NodeBuilder.from(node);
                    }
                    b2.addGroup(processed);
                }
                return b2 == null ? (node == null ? null : node.groups) : b2.buildGroupsOpt();
            }

            @Nullable
            public TreePatternNode.Group visit(@NotNull TreePatternNode.Group group, @NotNull TreePatternNode.Group checker, @Nullable TreePatternNode.BaseNaming parent2, @Nullable ObjectKind parentKind) {
                TreePatternNode n2;
                TreePatternNode.Group procRes;
                if (group == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (checker == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((procRes = processor2.process(group, parent2, parentKind)) == SKIP_PROCESSING) {
                    return group;
                }
                if (procRes == null) {
                    return null;
                }
                group = procRes;
                MultiMap gluedPositive = MultiMap.createLinked();
                MultiMap p2 = MultiMap.createLinked();
                SmartList n = new SmartList();
                TreePatternNode.NegativeNaming negativeNaming = TreePatternUtils.subdivideChildren((Iterable<TreePatternNode.Group>)JBIterable.of((Object[])new TreePatternNode.Group[]{group, checker}), p2, n, false);
                for (Map.Entry entry : p2.entrySet()) {
                    Iterator it2 = ((Collection)entry.getValue()).iterator();
                    TreePatternNode p1 = (TreePatternNode)it2.next();
                    TreePatternNode p22 = (TreePatternNode)it2.next();
                    TreePatternNode.Group[] processed = this.visit(p1, p22, (TreePatternNode.BaseNaming)entry.getKey(), group.kind);
                    gluedPositive.putValue(new AW<TreePatternNode.Group>(processed), (Object)((TreePatternNode.PositiveNaming)entry.getKey()));
                }
                Iterator it3 = n.iterator();
                TreePatternNode n1 = (TreePatternNode)it3.next();
                TreePatternNode.Group[] processedNegative = this.visit(n1, n2 = (TreePatternNode)it3.next(), (TreePatternNode.BaseNaming)negativeNaming, group.kind);
                Collection extra = gluedPositive.remove(new AW<TreePatternNode.Group>(processedNegative));
                if (extra != null) {
                    LinkedHashSet names = ContainerUtil.newLinkedHashSet((Object[])negativeNaming.getAntiNames());
                    for (TreePatternNode.PositiveNaming naming : extra) {
                        ContainerUtil.removeAll((Collection)names, (Object[])naming.getNames());
                    }
                    negativeNaming = new TreePatternNode.NegativeNaming(ObjectName.toArray(names));
                }
                return this.createNewIfChanged(group, (MultiMap<AW<TreePatternNode.Group>, TreePatternNode.PositiveNaming>)gluedPositive, processedNegative, negativeNaming);
            }

            private TreePatternNode.Group createNewIfChanged(@NotNull TreePatternNode.Group group, @NotNull MultiMap<AW<TreePatternNode.Group>, TreePatternNode.PositiveNaming> positive, TreePatternNode.Group @Nullable [] negative, @NotNull TreePatternNode.NegativeNaming negativeNaming) {
                if (group == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (positive == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (negativeNaming == null) {
                    4.$$$reportNull$$$0(4);
                }
                HashMap<TreePatternNode.PositiveNaming, TreePatternNode<TreePatternNode.PositiveNaming>> pool = new HashMap<TreePatternNode.PositiveNaming, TreePatternNode<TreePatternNode.PositiveNaming>>();
                if (group.positiveChildren != null) {
                    for (TreePatternNode<TreePatternNode.PositiveNaming> child : group.positiveChildren) {
                        pool.put((TreePatternNode.PositiveNaming)child.naming, child);
                    }
                }
                boolean changed = false;
                GroupBuilder builder = new GroupBuilder();
                if (negative != null) {
                    if (group.negativeChild != null && negativeNaming.equals(group.negativeChild.naming) && Arrays.equals(group.negativeChild.groups, negative)) {
                        builder.negative = group.negativeChild;
                    } else {
                        changed = true;
                        builder.negative = new TreePatternNode<TreePatternNode.NegativeNaming>(negativeNaming, negative);
                    }
                } else {
                    changed = group.negativeChild != null;
                }
                changed |= pool.size() != positive.size();
                for (Map.Entry entry : positive.entrySet()) {
                    SmartList names = new SmartList();
                    for (TreePatternNode.PositiveNaming naming : (Collection)entry.getValue()) {
                        ContainerUtil.addAll((Collection)names, (Object[])naming.getNames());
                    }
                    TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable<ObjectName>)names));
                    TreePatternNode node = (TreePatternNode)pool.get(naming);
                    if (node == null || node.groups != ((AW)entry.getKey()).array) {
                        changed = true;
                        node = ((AW)entry.getKey()).array == null ? null : new TreePatternNode<TreePatternNode.PositiveNaming>(naming, (TreePatternNode.Group[])((AW)entry.getKey()).array);
                    }
                    ContainerUtil.addIfNotNull(builder.positives, (Object)node);
                }
                return changed ? builder.build(group.kind) : group;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "checker";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "positive";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "negativeNaming";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/util/TreePatternUtils$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createNewIfChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visit(processed.root, mask.root, null, null)) == processed.root.groups ? processed : new TreePattern(newRoot);
    }

    public static boolean isWildcard(@Nullable TreePatternNode.Group g) {
        return g != null && g.positiveChildren == null && TreePatternUtils.isWildcard(g.negativeChild);
    }

    public static boolean isWildcard(@Nullable TreePatternNode<?> n) {
        return n != null && ((TreePatternNode.BaseNaming)n.naming).names.length == 0 && n.groups.length == 0;
    }

    @NotNull
    public static TreePattern sorted(@NotNull TreePattern pattern) {
        TreePatternNode<TreePatternNode.NegativeNaming> sortedRoot;
        if (pattern == null) {
            TreePatternUtils.$$$reportNull$$$0(40);
        }
        return (sortedRoot = TreePatternUtils.sorted(pattern.root)) == pattern.root ? pattern : new TreePattern(sortedRoot);
    }

    @NotNull
    private static <N extends TreePatternNode.BaseNaming> TreePatternNode<N> sorted(@NotNull TreePatternNode<N> node) {
        if (node == null) {
            TreePatternUtils.$$$reportNull$$$0(41);
        }
        TreePatternNode.Group[] newGroups = TreePatternUtils.sorted(node.groups, TreePatternNode.Group.BY_KIND);
        Object naming = TreePatternUtils.sorted(node.naming);
        return newGroups == node.groups && naming == node.naming ? node : new TreePatternNode<N>(naming, newGroups);
    }

    @NotNull
    private static <T> T[] sorted(T[] items2, Comparator<? super T> comp) {
        Object[] newItems = null;
        boolean unsorted = false;
        for (int i2 = 0; i2 < items2.length; ++i2) {
            Object newItem;
            Object object = newItem = items2[i2] instanceof TreePatternNode.Group ? TreePatternUtils.sorted((TreePatternNode.Group)items2[i2]) : TreePatternUtils.sorted((TreePatternNode)items2[i2]);
            if (!unsorted && i2 != 0) {
                boolean bl = unsorted = comp.compare(items2[i2 - 1], items2[i2]) > 0;
            }
            if (newItems == null) {
                if (newItem == items2[i2] && !unsorted) continue;
                newItems = (Object[])Array.newInstance(items2[i2].getClass(), items2.length);
                System.arraycopy(items2, 0, newItems, 0, i2);
            }
            newItems[i2] = newItem;
        }
        if (unsorted) {
            Arrays.sort(newItems, comp);
        }
        Object[] objectArray = newItems == null ? items2 : newItems;
        if (objectArray == null) {
            TreePatternUtils.$$$reportNull$$$0(42);
        }
        return objectArray;
    }

    @NotNull
    private static TreePatternNode.NegativeNaming merge(@NotNull TreePatternNode.NegativeNaming neg, @NotNull Iterable<TreePatternNode.PositiveNaming> pos) {
        if (neg == null) {
            TreePatternUtils.$$$reportNull$$$0(43);
        }
        if (pos == null) {
            TreePatternUtils.$$$reportNull$$$0(44);
        }
        LinkedHashSet names = null;
        for (TreePatternNode.PositiveNaming naming : pos) {
            if (names == null) {
                names = ContainerUtil.newLinkedHashSet((Object[])neg.getAntiNames());
            }
            ContainerUtil.removeAll((Collection)names, (Object[])naming.names);
        }
        return names == null ? neg : new TreePatternNode.NegativeNaming(ObjectName.toArray(names));
    }

    @Nullable
    private static TreePatternNode.PositiveNaming merge(@NotNull Iterable<TreePatternNode.PositiveNaming> pos) {
        if (pos == null) {
            TreePatternUtils.$$$reportNull$$$0(45);
        }
        LinkedHashSet names = null;
        TreePatternNode.PositiveNaming first2 = null;
        for (TreePatternNode.PositiveNaming naming : pos) {
            if (first2 == null) {
                first2 = naming;
                continue;
            }
            if (names == null) {
                names = ContainerUtil.newLinkedHashSet((Object[])first2.names);
            }
            ContainerUtil.addAll((Collection)names, (Object[])naming.names);
        }
        if (names == null) {
            return first2;
        }
        Object[] res2 = ObjectName.toArray(names);
        Arrays.sort(res2);
        return new TreePatternNode.PositiveNaming((ObjectName[])res2);
    }

    @NotNull
    private static TreePatternNode.Group sorted(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            TreePatternUtils.$$$reportNull$$$0(46);
        }
        Pair<TreePatternNode<TreePatternNode.NegativeNaming>, TreePatternNode<TreePatternNode.PositiveNaming>[]> nodes2 = Pair.create(g.negativeChild == null ? null : TreePatternUtils.sorted(g.negativeChild), g.positiveChildren == null ? null : TreePatternUtils.sorted(g.positiveChildren, TreePatternNode.BY_FIRST));
        nodes2 = TreePatternUtils.tighten((TreePatternNode)nodes2.first, (TreePatternNode[])nodes2.second);
        return nodes2.first == g.negativeChild && nodes2.second == g.positiveChildren ? g : new TreePatternNode.Group(g.kind, (TreePatternNode[])nodes2.second, (TreePatternNode)nodes2.first);
    }

    @NotNull
    private static Pair<TreePatternNode<TreePatternNode.NegativeNaming>, TreePatternNode<TreePatternNode.PositiveNaming>[]> tighten(@Nullable TreePatternNode<TreePatternNode.NegativeNaming> n, TreePatternNode<TreePatternNode.PositiveNaming> @Nullable [] p2) {
        Collection nodes2;
        if (p2 == null) {
            Pair pair = Pair.create(n, null);
            if (pair == null) {
                TreePatternUtils.$$$reportNull$$$0(47);
            }
            return pair;
        }
        MultiMap grouping = MultiMap.createLinked();
        for (TreePatternNode<TreePatternNode.PositiveNaming> node2 : p2) {
            grouping.putValue(new AW<TreePatternNode.Group>(node2.groups), node2);
        }
        if (n != null && (nodes2 = grouping.remove(new AW<TreePatternNode.Group>(n.groups))) != null) {
            n = new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternUtils.merge((TreePatternNode.NegativeNaming)n.naming, (Iterable<TreePatternNode.PositiveNaming>)JBIterable.from((Iterable)nodes2).transform(node -> (TreePatternNode.PositiveNaming)node.naming)), n.groups);
        }
        if (p2.length == grouping.size()) {
            Pair pair = Pair.create(n, p2);
            if (pair == null) {
                TreePatternUtils.$$$reportNull$$$0(48);
            }
            return pair;
        }
        if (grouping.isEmpty()) {
            Pair pair = Pair.create(n, null);
            if (pair == null) {
                TreePatternUtils.$$$reportNull$$$0(49);
            }
            return pair;
        }
        ArrayList<TreePatternNode<TreePatternNode.PositiveNaming>> pos = new ArrayList<TreePatternNode<TreePatternNode.PositiveNaming>>(grouping.size());
        for (Map.Entry entry : grouping.entrySet()) {
            if (((Collection)entry.getValue()).size() == 1) {
                pos.add((TreePatternNode)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())));
                continue;
            }
            TreePatternNode.PositiveNaming naming = TreePatternUtils.merge((Iterable<TreePatternNode.PositiveNaming>)JBIterable.from((Iterable)((Iterable)entry.getValue())).transform(node -> (TreePatternNode.PositiveNaming)node.naming));
            if (naming == null) continue;
            pos.add(new TreePatternNode<TreePatternNode.PositiveNaming>(naming, Objects.requireNonNull((TreePatternNode.Group[])((AW)entry.getKey()).array)));
        }
        p2 = pos.toArray(new TreePatternNode[0]);
        Pair pair = Pair.create(n, p2);
        if (pair == null) {
            TreePatternUtils.$$$reportNull$$$0(50);
        }
        return pair;
    }

    @NotNull
    private static <N extends TreePatternNode.BaseNaming> N sorted(@NotNull N naming) {
        if (naming == null) {
            TreePatternUtils.$$$reportNull$$$0(51);
        }
        boolean unsorted = false;
        ObjectName[] names = naming.names;
        int s2 = names.length;
        for (int i2 = 1; i2 < s2 && !unsorted; ++i2) {
            unsorted = names[i2 - 1].compareTo(names[i2]) > 0;
        }
        if (!unsorted) {
            N n = naming;
            if (n == null) {
                TreePatternUtils.$$$reportNull$$$0(52);
            }
            return n;
        }
        Object[] newNames = (ObjectName[])names.clone();
        Arrays.sort(newNames);
        return (N)(naming instanceof TreePatternNode.NegativeNaming ? new TreePatternNode.NegativeNaming((ObjectName[])newNames) : new TreePatternNode.PositiveNaming((ObjectName[])newNames));
    }

    @NotNull
    public static String exportScope(@NotNull MetaModel meta, @NotNull TreePattern pattern) {
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(53);
        }
        if (pattern == null) {
            TreePatternUtils.$$$reportNull$$$0(54);
        }
        String string = IntrospectionScopes.exportState(meta, pattern);
        if (string == null) {
            TreePatternUtils.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    public static TreePattern fromScopeMap(@NotNull BasicMetaModel<?> meta, @NotNull MultiMap<String, String> scope) {
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(56);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(57);
        }
        BasicMetaObject metaDb = BasicMetaUtils.findChild(meta.root, ObjectKind.DATABASE);
        BasicMetaObject metaSc = BasicMetaUtils.findChild((BasicMetaObject)ObjectUtils.notNull(metaDb, meta.root), ObjectKind.SCHEMA);
        TreePatternNode.Group[] g = metaDb != null ? TreePatternUtils.scopeGroup(scope.keySet(), metaDb, (Function<String, TreePatternNode.Group[]>)((Function)db -> TreePatternUtils.scopeGroup(scope.get(db), metaSc, null))) : TreePatternUtils.scopeGroup(scope.values(), metaSc, null);
        return new TreePattern(g);
    }

    private static TreePatternNode.Group[] scopeGroup(Collection<String> names, BasicMetaObject<?> meta, Function<String, TreePatternNode.Group[]> child) {
        BasicMetaObject<?> p2;
        GroupBuilder builder = new GroupBuilder();
        for (String name : ContainerUtil.sorted(names)) {
            TreePatternNode.Group[] schemas;
            TreePatternNode.Group[] groupArray = schemas = child == null ? null : (TreePatternNode.Group[])child.fun((Object)name);
            if (name.equals("*")) {
                builder.negative = new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, schemas == null ? TreePatternNode.NO_GROUPS : schemas);
                continue;
            }
            builder.positives.add(new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.quoted(name)), schemas == null ? TreePatternNode.NO_GROUPS : schemas));
        }
        builder.deduplicate();
        ArrayList<TreePatternNode.Group> res2 = new ArrayList<TreePatternNode.Group>();
        ContainerUtil.addIfNotNull(res2, (Object)builder.build(meta.kind, false));
        if (!res2.isEmpty() && meta.kindOf(BasicSchema.class) && (p2 = meta.getParent()) != null) {
            for (BasicMetaObject<BasicSchema> basicMetaObject : p2.children) {
                if (basicMetaObject == meta || !basicMetaObject.kindOf(BasicSchema.class)) continue;
                res2.add(builder.build(basicMetaObject.kind, false));
            }
        }
        return res2.toArray(TreePatternNode.NO_GROUPS);
    }

    private static void breakDown(@NotNull MetaModel meta, @NotNull TreePatternNode<?> node, @NotNull String database, @NotNull MultiMap<String, String> scope) {
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(58);
        }
        if (node == null) {
            TreePatternUtils.$$$reportNull$$$0(59);
        }
        if (database == null) {
            TreePatternUtils.$$$reportNull$$$0(60);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(61);
        }
        for (TreePatternNode.Group group : node.groups) {
            TreePatternUtils.breakDown(meta, group, database, scope);
        }
    }

    private static void breakDown(@NotNull MetaModel meta, @NotNull TreePatternNode.Group group, @NotNull String database, @NotNull MultiMap<String, String> scope) {
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(62);
        }
        if (group == null) {
            TreePatternUtils.$$$reportNull$$$0(63);
        }
        if (database == null) {
            TreePatternUtils.$$$reportNull$$$0(64);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(65);
        }
        if (!meta.getNamespaces().contains(group.kind)) {
            return;
        }
        if (group.positiveChildren != null) {
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : group.positiveChildren) {
                for (ObjectName name : ((TreePatternNode.PositiveNaming)child.naming).getNames()) {
                    TreePatternUtils.addToScope(name.name, group.kind, child, meta, database, scope);
                }
            }
        }
        if (group.negativeChild != null) {
            TreePatternUtils.addToScope("*", group.kind, group.negativeChild, meta, database, scope);
        }
    }

    private static void addToScope(@NotNull String name, @NotNull ObjectKind kind, @NotNull TreePatternNode<?> node, @NotNull MetaModel meta, @NotNull String database, @NotNull MultiMap<String, String> scope) {
        if (name == null) {
            TreePatternUtils.$$$reportNull$$$0(66);
        }
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(67);
        }
        if (node == null) {
            TreePatternUtils.$$$reportNull$$$0(68);
        }
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(69);
        }
        if (database == null) {
            TreePatternUtils.$$$reportNull$$$0(70);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(71);
        }
        if (kind == ObjectKind.DATABASE) {
            scope.getModifiable((Object)name);
            TreePatternUtils.breakDown(meta, node, name, scope);
        } else {
            scope.putValue((Object)database, (Object)name);
            TreePatternUtils.breakDown(meta, node, database, scope);
        }
    }

    public static ObjectName nameOf(DasObject o) {
        return o == null ? null : ObjectName.create(o.getName(), DbSqlUtilCore.isQuoted(o));
    }

    public static ObjectName nameOf(ObjectPath p2) {
        return p2 == null ? null : ObjectName.create(p2.name, p2.isQuoted());
    }

    @NotNull
    public static TreePattern create(@NotNull ObjectPath path) {
        if (path == null) {
            TreePatternUtils.$$$reportNull$$$0(72);
        }
        TreePatternNode.Group g = null;
        ObjectPath p2 = path;
        while (p2 != null) {
            g = TreePatternUtils.create(TreePatternUtils.nameOf(p2), p2.kind, g);
            p2 = p2.parent;
        }
        return new TreePattern(g);
    }

    @NotNull
    @Contract(pure=true)
    public static TreePattern importPattern(@NotNull Dbms dbms, @Nullable String string) {
        if (dbms == null) {
            TreePatternUtils.$$$reportNull$$$0(73);
        }
        MultiMap map2 = MultiMap.createLinkedSet();
        if (string != null) {
            IntrospectionScopes.importStateToMap(string, (MultiMap<String, String>)map2);
        }
        return TreePatternUtils.fromScopeMap(DbImplUtilCore.getMetaModel(dbms), (MultiMap<String, String>)map2);
    }

    @NotNull
    @Contract(pure=true)
    public static TreePattern patternFromPattern(@NotNull Dbms dbms, @Nullable String string) {
        if (dbms == null) {
            TreePatternUtils.$$$reportNull$$$0(74);
        }
        MultiMap map2 = MultiMap.createLinkedSet();
        IntrospectionScopes.fromSchemaPatternToMap(string, (MultiMap<String, String>)map2);
        return TreePatternUtils.fromScopeMap(DbImplUtilCore.getMetaModel(dbms), (MultiMap<String, String>)map2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 23: 
            case 25: 
            case 27: 
            case 36: 
            case 42: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 23: 
            case 25: 
            case 27: 
            case 36: 
            case 42: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 23: 
            case 25: 
            case 27: 
            case 36: 
            case 42: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/TreePatternUtils";
                break;
            }
            case 3: 
            case 4: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 7: 
            case 11: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pSubdiv";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nSubdiv";
                break;
            }
            case 10: 
            case 33: 
            case 34: 
            case 35: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fac";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 16: 
            case 41: 
            case 59: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 19: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 20: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mask";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 29: 
            case 40: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "neg";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "naming";
                break;
            }
            case 53: 
            case 56: 
            case 58: 
            case 62: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 57: 
            case 61: 
            case 65: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 60: 
            case 64: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/TreePatternUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringArray";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSinkNames";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "intersect";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 42: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "tighten";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "exportScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toStringArray";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 23: 
            case 25: 
            case 27: 
            case 36: 
            case 42: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 55: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSinkNames";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "subdivideChildren";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processGrouped";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "preserve";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "mask";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "patternProcessor";
                break;
            }
            case 40: 
            case 41: 
            case 46: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "exportScope";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "fromScopeMap";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "breakDown";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "addToScope";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "importPattern";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "patternFromPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 23: 
            case 25: 
            case 27: 
            case 36: 
            case 42: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PatternProcessor {
        @Nullable
        public TreePatternNode.Group process(@NotNull TreePatternNode.Group var1, @Nullable TreePatternNode.BaseNaming var2, @Nullable ObjectKind var3);
    }

    public static final class NodeBuilder {
        public final List<TreePatternNode.Group> groups = new SmartList();

        public NodeBuilder addGroup(@Nullable TreePatternNode.Group g) {
            if (g != null) {
                this.groups.add(g);
            }
            return this;
        }

        @NotNull
        public <T extends TreePatternNode.BaseNaming> TreePatternNode<T> build(T naming) {
            return new TreePatternNode<T>(naming, this.buildGroups());
        }

        public TreePatternNode.Group @Nullable [] buildGroupsOpt() {
            return this.groups.isEmpty() ? null : this.groups.toArray(new TreePatternNode.Group[0]);
        }

        public TreePatternNode.Group @NotNull [] buildGroups() {
            TreePatternNode.Group[] groupArray = (TreePatternNode.Group[])ObjectUtils.chooseNotNull((Object)this.buildGroupsOpt(), (Object)TreePatternNode.NO_GROUPS);
            if (groupArray == null) {
                NodeBuilder.$$$reportNull$$$0(0);
            }
            return groupArray;
        }

        @NotNull
        public static NodeBuilder from(@Nullable TreePatternNode<?> node) {
            return NodeBuilder.from(node == null ? null : node.groups);
        }

        @NotNull
        public static NodeBuilder from(@Nullable TreePatternNode.Group[] groups) {
            NodeBuilder b2 = new NodeBuilder();
            if (groups != null) {
                ContainerUtil.addAll(b2.groups, (Object[])groups);
            }
            NodeBuilder nodeBuilder = b2;
            if (nodeBuilder == null) {
                NodeBuilder.$$$reportNull$$$0(1);
            }
            return nodeBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/util/TreePatternUtils$NodeBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildGroups";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static final class GroupBuilder {
        public final List<TreePatternNode<TreePatternNode.PositiveNaming>> positives = new SmartList();
        public TreePatternNode<TreePatternNode.NegativeNaming> negative = null;

        @Nullable
        public TreePatternNode.Group build(@NotNull ObjectKind kind) {
            if (kind == null) {
                GroupBuilder.$$$reportNull$$$0(0);
            }
            return this.build(kind, true);
        }

        @Nullable
        public TreePatternNode.Group build(@NotNull ObjectKind kind, boolean validate2) {
            if (kind == null) {
                GroupBuilder.$$$reportNull$$$0(1);
            }
            TreePatternNode[] p2 = this.positives.isEmpty() ? null : this.positives.toArray(new TreePatternNode[0]);
            return p2 == null && this.negative == null ? null : new TreePatternNode.Group(kind, p2, this.negative, validate2);
        }

        public void add(@NotNull TreePatternNode<?> node) {
            TreePatternNode<TreePatternNode.PositiveNaming> pos;
            if (node == null) {
                GroupBuilder.$$$reportNull$$$0(2);
            }
            if ((pos = node.tryCast(TreePatternNode.PositiveNaming.class)) != null) {
                this.positives.add(pos);
            } else {
                if (this.negative != null) {
                    throw new AssertionError((Object)"Already has negative");
                }
                this.negative = Objects.requireNonNull(node.tryCast(TreePatternNode.NegativeNaming.class));
            }
        }

        public void deduplicate() {
            if (this.positives.size() < 2) {
                return;
            }
            MultiMap map2 = MultiMap.createLinked();
            for (TreePatternNode<TreePatternNode.PositiveNaming> positive : this.positives) {
                map2.putValue(new AW<TreePatternNode.Group>(positive.groups), positive);
            }
            if (map2.size() == this.positives.size()) {
                return;
            }
            ArrayList<TreePatternNode<TreePatternNode.PositiveNaming>> newPos = new ArrayList<TreePatternNode<TreePatternNode.PositiveNaming>>();
            for (Map.Entry entry : map2.entrySet()) {
                if (((Collection)entry.getValue()).size() == 1) {
                    newPos.add((TreePatternNode)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())));
                    continue;
                }
                ArrayList n = new ArrayList();
                for (TreePatternNode node : (Collection)entry.getValue()) {
                    ObjectName[] names = ((TreePatternNode.PositiveNaming)node.naming).names;
                    n.ensureCapacity(n.size() + names.length);
                    Collections.addAll(n, names);
                }
                newPos.add(new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(n.toArray(ObjectName.EMPTY_ARRAY)), (TreePatternNode.Group[])((AW)entry.getKey()).array));
            }
            this.positives.clear();
            this.positives.addAll(newPos);
        }

        @NotNull
        public static GroupBuilder from(@Nullable TreePatternNode.Group g) {
            GroupBuilder builder = new GroupBuilder();
            if (g != null) {
                if (g.positiveChildren != null) {
                    ContainerUtil.addAll(builder.positives, (Object[])g.positiveChildren);
                }
                builder.negative = g.negativeChild;
            }
            GroupBuilder groupBuilder = builder;
            if (groupBuilder == null) {
                GroupBuilder.$$$reportNull$$$0(3);
            }
            return groupBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/TreePatternUtils$GroupBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/TreePatternUtils$GroupBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class GroupedGroupFactory {
        @Nullable
        public TreePatternNode.Group create(@NotNull MultiMap<TreePatternNode.PositiveNaming, TreePatternNode<?>> p2, @NotNull TreePatternNode.NegativeNaming nn, @NotNull Iterable<TreePatternNode<?>> n, ObjectKind kind) {
            TreePatternNode[] positive;
            if (p2 == null) {
                GroupedGroupFactory.$$$reportNull$$$0(0);
            }
            if (nn == null) {
                GroupedGroupFactory.$$$reportNull$$$0(1);
            }
            if (n == null) {
                GroupedGroupFactory.$$$reportNull$$$0(2);
            }
            MultiMap mergedBranches = MultiMap.createLinkedSet();
            for (Map.Entry entry : p2.entrySet()) {
                TreePatternNode.Group[] merged = this.mergeNodes((TreePatternNode.BaseNaming)entry.getKey(), kind, (Iterable)entry.getValue());
                if (merged == null) continue;
                mergedBranches.putValue(new AW<TreePatternNode.Group>(merged), (Object)((TreePatternNode.PositiveNaming)entry.getKey()));
            }
            TreePatternNode.Group[] negGroups = this.mergeNodes(nn, kind, n);
            if (mergedBranches.isEmpty() && negGroups == null) {
                return null;
            }
            TreePatternNode<TreePatternNode.NegativeNaming> negative = null;
            if (negGroups != null) {
                Collection namings = mergedBranches.remove(new AW<TreePatternNode.Group>(negGroups));
                if (namings != null) {
                    ArrayList antiNames = ContainerUtil.newArrayList((Object[])nn.getAntiNames());
                    for (TreePatternNode.PositiveNaming naming : namings) {
                        ContainerUtil.removeAll((Collection)antiNames, (Object[])naming.getNames());
                    }
                    negative = new TreePatternNode<TreePatternNode.NegativeNaming>(new TreePatternNode.NegativeNaming(ObjectName.toArray(antiNames)), negGroups);
                } else {
                    negative = new TreePatternNode<TreePatternNode.NegativeNaming>(nn, negGroups);
                }
            }
            TreePatternNode[] treePatternNodeArray = positive = mergedBranches.isEmpty() ? null : new TreePatternNode[mergedBranches.size()];
            if (positive != null) {
                int i2 = 0;
                for (Map.Entry entry : mergedBranches.entrySet()) {
                    SmartList names = new SmartList();
                    ((Collection)entry.getValue()).forEach(arg_0 -> GroupedGroupFactory.lambda$create$0((List)names, arg_0));
                    positive[i2] = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable<ObjectName>)names)), (TreePatternNode.Group[])((AW)entry.getKey()).array);
                    ++i2;
                }
            }
            return new TreePatternNode.Group(kind, positive, negative);
        }

        @Nullable
        public TreePatternNode.Group[] mergeNodes(@Nullable TreePatternNode.BaseNaming naming, @Nullable ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> nodes2) {
            if (nodes2 == null) {
                GroupedGroupFactory.$$$reportNull$$$0(3);
            }
            this.enter(naming, kind, nodes2);
            if (!this.checkNode(naming, kind, nodes2)) {
                this.leave(naming, kind, nodes2);
                return null;
            }
            MultiMap grouped = this.mergeChildren() ? MultiMap.createLinkedSet() : MultiMap.createLinked();
            LinkedHashSet<ObjectKind> allKinds = new LinkedHashSet<ObjectKind>();
            for (TreePatternNode<?> node : nodes2) {
                if (node == null) continue;
                for (TreePatternNode.Group group : node.groups) {
                    allKinds.add(group.kind);
                }
            }
            for (TreePatternNode<?> node : nodes2) {
                HashSet<ObjectKind> currentKinds = null;
                if (node != null) {
                    currentKinds = new HashSet<ObjectKind>();
                    for (TreePatternNode.Group group : node.groups) {
                        grouped.putValue((Object)group.kind, (Object)group);
                        currentKinds.add(group.kind);
                    }
                }
                for (ObjectKind gkind : allKinds) {
                    if (currentKinds != null && currentKinds.contains(gkind)) continue;
                    grouped.putValue((Object)gkind, null);
                }
            }
            SmartList res2 = new SmartList();
            for (Map.Entry entry : grouped.entrySet()) {
                this.enterGroups(naming, kind, (Iterable)entry.getValue());
                if (this.checkGroup(naming, kind, (Iterable)entry.getValue())) {
                    ContainerUtil.addAllNotNull((Collection)res2, (Object[])new TreePatternNode.Group[]{TreePatternUtils.processGrouped((ObjectKind)entry.getKey(), (Iterable)entry.getValue(), this)});
                }
                this.leaveGroups(naming, kind, (Iterable)entry.getValue());
            }
            TreePatternNode.Group[] merged = !res2.isEmpty() ? res2.toArray(new TreePatternNode.Group[0]) : (this.willDestroyEmpty(naming, kind, nodes2) ? null : TreePatternNode.NO_GROUPS);
            this.leave(naming, kind, nodes2);
            return merged;
        }

        @NotNull
        public TreePattern merge(@NotNull Iterable<TreePattern> patterns2) {
            TreePatternNode.Group[] groups;
            if (patterns2 == null) {
                GroupedGroupFactory.$$$reportNull$$$0(4);
            }
            return (groups = this.mergeRoots((Iterable<TreePatternNode<?>>)JBIterable.from(patterns2).transform(p2 -> p2.root))) == null ? TreePattern.EMPTY : new TreePattern(groups);
        }

        @Nullable
        public TreePatternNode.Group[] mergeRoots(@NotNull Iterable<TreePatternNode<?>> nodes2) {
            if (nodes2 == null) {
                GroupedGroupFactory.$$$reportNull$$$0(5);
            }
            return this.mergeNodes(TreePatternNode.NegativeNaming.WILDCARD, ObjectKind.NONE, nodes2);
        }

        @Nullable
        public TreePatternNode.Group mergeGroups(@NotNull ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> groups) {
            if (kind == null) {
                GroupedGroupFactory.$$$reportNull$$$0(6);
            }
            if (groups == null) {
                GroupedGroupFactory.$$$reportNull$$$0(7);
            }
            return TreePatternUtils.processGrouped(kind, groups, this);
        }

        protected abstract boolean checkGroup(TreePatternNode.BaseNaming var1, ObjectKind var2, @NotNull Iterable<TreePatternNode.Group> var3);

        protected abstract boolean checkNode(TreePatternNode.BaseNaming var1, ObjectKind var2, @NotNull Iterable<TreePatternNode<?>> var3);

        protected abstract boolean willDestroyEmpty(TreePatternNode.BaseNaming var1, ObjectKind var2, Iterable<TreePatternNode<?>> var3);

        protected void enter(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> nodes2) {
        }

        protected void leave(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> nodes2) {
        }

        protected void enterGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
        }

        protected void leaveGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
        }

        public boolean mergeChildren() {
            return true;
        }

        protected static boolean containsNull(Iterable<?> it2) {
            if (it2 instanceof Collection) {
                return ((Collection)it2).contains(null);
            }
            for (Object o : it2) {
                if (o != null) continue;
                return true;
            }
            return false;
        }

        protected static boolean containsNotNull(Iterable<?> it2) {
            for (Object o : it2) {
                if (o == null) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void lambda$create$0(List names, TreePatternNode.PositiveNaming x) {
            ContainerUtil.addAll((Collection)names, (Object[])x.getNames());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nn";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "n";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groups";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/TreePatternUtils$GroupedGroupFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeNodes";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "merge";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeRoots";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeGroups";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class AW<T> {
        public final T[] array;
        private Integer myHashCode;

        AW(@Nullable T[] array) {
            this.array = array;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AW aw = (AW)o;
            return Arrays.equals(this.array, aw.array);
        }

        public int hashCode() {
            if (this.myHashCode != null) {
                return this.myHashCode;
            }
            this.myHashCode = Arrays.hashCode(this.array);
            return this.myHashCode;
        }
    }
}

