/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbUtil {
    private static final Interner<String> INTERNER = Interner.createWeakInterner();
    public static final Function<DbElement, Object> TO_DELEGATE = e -> e.getDelegate();

    private DbUtil() {
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSources(@NotNull Project project) {
        if (project == null) {
            DbUtil.$$$reportNull$$$0(0);
        }
        JBIterable jBIterable = JBIterable.from(DbPsiFacade.getInstance(project).getDataSources());
        if (jBIterable == null) {
            DbUtil.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @Contract(value="!null->!null")
    public static String intern2(@Nullable String str) {
        return str == null ? null : (String)INTERNER.intern((Object)str);
    }

    @NotNull
    public static String intern(@Nullable String str) {
        String string = DbUtil.intern(str, "");
        if (string == null) {
            DbUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Contract(value="_, !null->!null")
    public static String intern(@Nullable String str, @Nullable String def) {
        return str == null || str.isEmpty() ? def : (String)INTERNER.intern((Object)str);
    }

    @NotNull
    public static Set<String> getExistingDataSourceNames(@NotNull Project project) {
        if (project == null) {
            DbUtil.$$$reportNull$$$0(3);
        }
        THashSet result2 = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (DbDataSource dataSource2 : DbPsiFacade.getInstance(project).getDataSources()) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)dataSource2.getName());
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            DbUtil.$$$reportNull$$$0(4);
        }
        return tHashSet;
    }

    @NotNull
    public static String generateUniqueDataSourceName(@NotNull Project project, @NotNull String baseName) {
        if (project == null) {
            DbUtil.$$$reportNull$$$0(5);
        }
        if (baseName == null) {
            DbUtil.$$$reportNull$$$0(6);
        }
        return DbUtil.generateUniqueName(baseName, DbUtil.getExistingDataSourceNames(project));
    }

    @NotNull
    public static String generateUniqueName(@NotNull String baseName, @NotNull Set<String> existingNames) {
        Matcher matcher;
        if (baseName == null) {
            DbUtil.$$$reportNull$$$0(7);
        }
        if (existingNames == null) {
            DbUtil.$$$reportNull$$$0(8);
        }
        String fixedName = (matcher = Pattern.compile("([^\\[]*)(?:\\[\\d+])?").matcher(baseName)).matches() ? matcher.group(1).trim() : baseName;
        String string = new UniqueNameGenerator(existingNames, FunctionUtil.id()).generateUniqueName(fixedName, "", "", " [", "]");
        if (string == null) {
            DbUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static boolean isCaseSensitive(@Nullable String name, @NotNull DbElement source) {
        if (source == null) {
            DbUtil.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        Casing modes = source.getDataSource().getModel().getCasing(source.getKind(), source);
        return DbUtil.isCaseSensitive(name, modes);
    }

    public static boolean isCaseSensitive(@Nullable String name, Casing modes) {
        return Case.guessForName(name, null, modes.plain, modes.quoted) == Case.EXACT;
    }

    @NotNull
    public static String[] intern(@NotNull String[] arr) {
        if (arr == null) {
            DbUtil.$$$reportNull$$$0(11);
        }
        String[] stringArray = (String[])ContainerUtil.map((Object[])arr, str -> DbUtil.intern(str, null), (Object[])ArrayUtilRt.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            DbUtil.$$$reportNull$$$0(12);
        }
        return stringArray;
    }

    @Nullable
    public static DasObject getDasObject(@Nullable Object object) {
        return object instanceof DbDataSource ? (DasObject)object : (object instanceof DbElement ? (DasObject)((DbElement)object).getDelegate() : (object instanceof DasObject ? (DasObject)object : null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 2: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingDataSourceNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataSources";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExistingDataSourceNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateUniqueDataSourceName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateUniqueName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCaseSensitive";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

