/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbTargetUtil {
    @NotNull
    public static DbElement adjustForNavigation(@NotNull DbElement element2) {
        DbElement child;
        DbElement parent2;
        if (element2 == null) {
            DbTargetUtil.$$$reportNull$$$0(0);
        }
        if ((parent2 = element2.getParent()) instanceof DbTable) {
            if (!(element2 instanceof DbTrigger) && !(element2.getDelegate() instanceof BasicSourceAware)) {
                DbElement dbElement = parent2;
                if (dbElement == null) {
                    DbTargetUtil.$$$reportNull$$$0(1);
                }
                return dbElement;
            }
            DbElement dbElement = element2;
            if (dbElement == null) {
                DbTargetUtil.$$$reportNull$$$0(2);
            }
            return dbElement;
        }
        if (parent2 != null && parent2.getDelegate() instanceof BasicSourceAware) {
            if (element2.getDelegate() instanceof BasicSourceAware && element2.getKind() != ObjectKind.ROUTINE) {
                DbElement dbElement = element2;
                if (dbElement == null) {
                    DbTargetUtil.$$$reportNull$$$0(3);
                }
                return dbElement;
            }
            DbElement dbElement = parent2;
            if (dbElement == null) {
                DbTargetUtil.$$$reportNull$$$0(4);
            }
            return dbElement;
        }
        Dbms dbms = DbImplUtilCore.getDbms(element2);
        if (dbms.is(Dbms.SYBASE) && element2.getKind() == ObjectKind.PACKAGE && (child = (DbElement)element2.getDasChildren(null).first()) != null) {
            DbElement dbElement = child;
            if (dbElement == null) {
                DbTargetUtil.$$$reportNull$$$0(5);
            }
            return dbElement;
        }
        DbElement dbElement = element2;
        if (dbElement == null) {
            DbTargetUtil.$$$reportNull$$$0(6);
        }
        return dbElement;
    }

    public static int calcTargetOffset(@NotNull Project project, @NotNull VirtualFile file, @NotNull DasObject template) {
        DasObject target;
        if (project == null) {
            DbTargetUtil.$$$reportNull$$$0(7);
        }
        if (file == null) {
            DbTargetUtil.$$$reportNull$$$0(8);
        }
        if (template == null) {
            DbTargetUtil.$$$reportNull$$$0(9);
        }
        return (target = DbTargetUtil.calcTarget(project, file, template)) instanceof PsiElement ? ((PsiElement)target).getTextOffset() : -1;
    }

    @Nullable
    public static DasObject calcTarget(@NotNull Project project, @NotNull VirtualFile file, final @NotNull DasObject template) {
        if (project == null) {
            DbTargetUtil.$$$reportNull$$$0(10);
        }
        if (file == null) {
            DbTargetUtil.$$$reportNull$$$0(11);
        }
        if (template == null) {
            DbTargetUtil.$$$reportNull$$$0(12);
        }
        ObjectKind kind = template.getKind();
        ObjectKind parentKind = DasUtil.getKind(template.getDasParent());
        if (kind == ObjectKind.BODY) {
            kind = ObjectKind.PACKAGE;
        } else if (kind == ObjectKind.ALIAS_TYPE && parentKind == ObjectKind.PACKAGE) {
            kind = ObjectKind.OBJECT_TYPE;
        }
        String name = template.getName();
        Condition condition = DbTargetUtil.matchObject(name, DbSqlUtilCore.isQuoted(template), kind, DbTargetUtil.getCasingProvider(project, template, file));
        if (kind == ObjectKind.ROUTINE) {
            condition = Conditions.and(condition, (Condition)new Condition<DasObject>(){

                public boolean value(DasObject object) {
                    Iterator it1 = this.getRoutineArgs(template).iterator();
                    Iterator it2 = this.getRoutineArgs(object).iterator();
                    while (it1.hasNext() && it2.hasNext()) {
                        DasTypedObject o1 = (DasTypedObject)it1.next();
                        DasTypedObject o2 = (DasTypedObject)it2.next();
                        if (o1.getKind() != o2.getKind()) {
                            return false;
                        }
                        if (Comparing.equal((String)o1.getName(), (String)o2.getName(), (boolean)false)) continue;
                        return false;
                    }
                    return it1.hasNext() == it2.hasNext();
                }

                JBIterable<DasTypedObject> getRoutineArgs(DasObject template2) {
                    if (!(template2 instanceof DasRoutine)) {
                        return JBIterable.empty();
                    }
                    DasRoutine r = (DasRoutine)template2;
                    return JBIterable.from(DasUtil.getParameters(r)).filter(a2 -> a2.getArgumentDirection() != ArgumentDirection.SELF).append((Object)r.getReturnArgument()).filter(DasTypedObject.class);
                }
            });
        }
        return DbTargetUtil.calcTarget(project, file, condition);
    }

    @NotNull
    private static CasingProvider getCasingProvider(@NotNull Project project, @NotNull DasObject object, @NotNull VirtualFile file) {
        SqlLanguageDialect dialect;
        if (project == null) {
            DbTargetUtil.$$$reportNull$$$0(13);
        }
        if (object == null) {
            DbTargetUtil.$$$reportNull$$$0(14);
        }
        if (file == null) {
            DbTargetUtil.$$$reportNull$$$0(15);
        }
        if (object instanceof DbElement) {
            DasModel dasModel = ((DbElement)object).getDataSource().getModel();
            if (dasModel == null) {
                DbTargetUtil.$$$reportNull$$$0(16);
            }
            return dasModel;
        }
        SqlLanguageDialect sqlLanguageDialect = dialect = object instanceof PsiElement ? DbSqlUtilCore.getSqlDialect((PsiElement)object) : null;
        if (dialect == null) {
            dialect = (SqlLanguageDialect)ObjectUtils.tryCast((Object)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file), SqlLanguageDialect.class);
        }
        DatabaseDialectEx databaseDialectEx = dialect != null ? (DatabaseDialectEx)dialect.getDatabaseDialect() : DatabaseDialects.getGenericDialect();
        if (databaseDialectEx == null) {
            DbTargetUtil.$$$reportNull$$$0(17);
        }
        return databaseDialectEx;
    }

    public static Condition<DasObject> matchObject(String name, boolean quoted, ObjectKind kind, CasingProvider provider) {
        return Conditions.and(DasUtil.byKind(kind), DbSqlUtilCore.byName(name, quoted, null, provider));
    }

    private static DasObject calcTarget(@NotNull Project project, @NotNull VirtualFile file, @NotNull Condition<? super DasObject> equality) {
        if (project == null) {
            DbTargetUtil.$$$reportNull$$$0(18);
        }
        if (file == null) {
            DbTargetUtil.$$$reportNull$$$0(19);
        }
        if (equality == null) {
            DbTargetUtil.$$$reportNull$$$0(20);
        }
        return (DasObject)ReadAction.compute(() -> {
            PsiFile psiFile;
            PsiFile psiFile2 = psiFile = !file.isValid() ? null : PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof SqlFile)) {
                return null;
            }
            return (DasObject)((SqlFile)psiFile).traverser().traverse().filter(equality).first();
        });
    }

    public static VirtualFile getContainingFile(@NotNull DbElement dbElement, boolean refresh2) {
        if (dbElement == null) {
            DbTargetUtil.$$$reportNull$$$0(21);
        }
        DbElement navigateTo = DbTargetUtil.adjustForNavigation(dbElement);
        return DbImplUtil.findSourceVirtualFile(navigateTo, refresh2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbTargetUtil";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbTargetUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustForNavigation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustForNavigation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 17: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcTargetOffset";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calcTarget";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCasingProvider";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

