/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SqlDialects;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileAttributes;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSqlUtilCore {
    protected DbSqlUtilCore() {
    }

    public static boolean stringsAreEscapedWithSlash(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(0);
        }
        return dbms.isClickHouse() || dbms.isHive() || dbms.isSpark() || dbms.isMysql() || dbms.isRedshift() || dbms.isSnowflake() || dbms.isMongo() || dbms.isBigQuery();
    }

    public static boolean supportsEscapeStringLiterals(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(1);
        }
        return dbms.isGreenplum() || dbms == Dbms.POSTGRES || dbms.isVertica();
    }

    @Nullable
    public static SqlLanguageDialect getSqlDialect(@Nullable PsiElement element2) {
        SqlLanguageDialect language;
        if (element2 == null) {
            return null;
        }
        PsiFile containingFile = element2.getContainingFile();
        if (containingFile instanceof SqlFile) {
            language = ((SqlFile)containingFile).getSqlLanguage();
        } else if (containingFile instanceof DummyHolder) {
            language = containingFile.getLanguage();
        } else {
            if (element2 instanceof DbElement) {
                return DbSqlUtilCore.getSqlDialect((DbElement)element2);
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
            language = LanguageUtil.getLanguageForPsi((Project)element2.getProject(), (VirtualFile)virtualFile);
        }
        return language instanceof SqlLanguageDialect ? language : null;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DbElement element2) {
        DbDataSource dataSource2 = element2 == null ? null : (DbDataSource)ObjectUtils.tryCast((Object)element2.getDataSource(), DbDataSource.class);
        SqlLanguageDialect language = dataSource2 == null ? null : (SqlLanguageDialect)ObjectUtils.tryCast((Object)dataSource2.getQueryLanguage(), SqlLanguageDialect.class);
        SqlLanguageDialect sqlLanguageDialect = language == null ? SqlDialects.getGenericDialect() : language;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(2);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Project project, @NotNull DasDataSource databaseSystem) {
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(3);
        }
        if (databaseSystem == null) {
            DbSqlUtilCore.$$$reportNull$$$0(4);
        }
        if (databaseSystem instanceof DbDataSource) {
            return DbSqlUtilCore.getSqlDialect((DbDataSource)databaseSystem);
        }
        if (databaseSystem instanceof LocalDataSource) {
            return DbSqlUtilCore.getSqlDialect((LocalDataSource)databaseSystem);
        }
        DbDataSource dataSource2 = DbPsiFacade.getInstance(project).findDataSource(databaseSystem.getUniqueId());
        return dataSource2 == null ? SqlDialects.getGenericDialect() : DbSqlUtilCore.getSqlDialect(dataSource2);
    }

    @NotNull
    public static <T> JBIterable.SFun<T, T> checkCancelled(final int every) {
        return new JBIterable.SFun<T, T>(){
            int cnt = 0;

            public T fun(T o) {
                if (++this.cnt % every == 0) {
                    ProgressManager.checkCanceled();
                }
                return o;
            }
        };
    }

    public static boolean isQuoted(@Nullable DasObject object) {
        if (object instanceof DbElement) {
            return DbSqlUtilCore.isQuoted((DasObject)ObjectUtils.tryCast((Object)((DbElement)object).getDelegate(), DasObject.class));
        }
        if (object instanceof SqlDefinition) {
            return ((SqlDefinition)object).isNameQuoted();
        }
        if (object instanceof SqlNameElement) {
            return DbSqlUtilCore.isQuoted((SqlNameElement)object);
        }
        if (object instanceof BasicElement) {
            return BasicPaths.isQuoted((BasicElement)object);
        }
        return true;
    }

    public static boolean isQuoted(@Nullable SqlNameElement element2) {
        return element2 != null && element2.isQuotedIdentifier();
    }

    @Nullable
    public static DasObject getDasObject(@NotNull DasNamed named) {
        if (named == null) {
            DbSqlUtilCore.$$$reportNull$$$0(5);
        }
        if (named instanceof DasObject) {
            return (DasObject)named;
        }
        if (named instanceof DasSymbol) {
            return ((DasSymbol)named).getDasObject();
        }
        return null;
    }

    @Nullable
    public static PsiElement getPsiDelegate(@Nullable DasObject info) {
        DasObject delegate = info instanceof DbElement ? ((DbElement)info).getDelegate() : info;
        return delegate instanceof PsiElement ? (PsiElement)delegate : null;
    }

    public static boolean isSqlObject(@Nullable DasObject object) {
        if (object instanceof DbElement) {
            return DbSqlUtilCore.isSqlObject((DasObject)ObjectUtils.tryCast((Object)((DbElement)object).getDelegate(), DasObject.class));
        }
        if (object instanceof SqlElement) {
            return true;
        }
        if (object instanceof BasicNamedElement) {
            return ((BasicNamedElement)object).isNameScripted();
        }
        return false;
    }

    @NotNull
    public static <C extends DasNamed> Condition<C> byName(@Nullable String name, boolean quoted, @Nullable String id, @NotNull CasingProvider provider) {
        if (provider == null) {
            DbSqlUtilCore.$$$reportNull$$$0(6);
        }
        if (name == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                DbSqlUtilCore.$$$reportNull$$$0(7);
            }
            return condition;
        }
        NameChecker checker = new NameChecker(name, quoted, provider, null);
        Condition condition = named -> {
            DasObject dasObject = DbSqlUtilCore.getDasObject(named);
            return (id == null || dasObject != null && id.equalsIgnoreCase(ObjectPaths.getIdentity(dasObject))) && checker.checkName((DasNamed)named, null);
        };
        if (condition == null) {
            DbSqlUtilCore.$$$reportNull$$$0(8);
        }
        return condition;
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForResolve(@NotNull PsiFile sqlFile) {
        if (sqlFile == null) {
            DbSqlUtilCore.$$$reportNull$$$0(9);
        }
        return DbSqlUtilCore.getAppropriateDataSources(sqlFile, true, true);
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSources(@NotNull PsiFile sqlFile, boolean forResolve, boolean matchingOnly) {
        DatabaseDialect dialect;
        if (sqlFile == null) {
            DbSqlUtilCore.$$$reportNull$$$0(10);
        }
        if (DbSqlUtilCore.isJSLanguage(sqlFile.getLanguage())) {
            dialect = (DatabaseDialect)ObjectUtils.notNull((Object)DatabaseDialect.EP.forDbms(Dbms.MONGO), (Object)SqlDialects.getGenericDialect().getDatabaseDialect());
        } else {
            SqlLanguageDialect sqlDialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtilCore.getSqlDialect((PsiElement)sqlFile), (Object)SqlDialects.getGenericDialect());
            dialect = sqlDialect.getDatabaseDialect();
        }
        return DbSqlUtilCore.getAppropriateDataSources(dialect, PsiUtilCore.getVirtualFile((PsiElement)sqlFile), sqlFile.getProject(), forResolve, matchingOnly);
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSources(@NotNull DatabaseDialect databaseDialect, @Nullable VirtualFile virtualFile, @NotNull Project project, boolean forResolve, boolean matchingOnly) {
        JBIterable sqlDataSources;
        if (databaseDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(11);
        }
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(12);
        }
        DbPsiFacade facade = DbPsiFacade.getInstance(project);
        boolean isReadonly = virtualFile instanceof ReadOnlyLightVirtualFile;
        JBIterable resultAll = JBIterable.from(facade.getDataSources()).filter(ds -> (!isReadonly || !(ds instanceof SqlDataSource)) && ds.isValid());
        JBIterable resultSelected = resultAll.filter(ds -> DbImplUtilCore.getDatabaseDialect(ds).similarTo(databaseDialect));
        if (!isReadonly && forResolve && virtualFile != null && FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)SqlFileType.INSTANCE) && !(sqlDataSources = resultAll.filterMap(o -> o.getDelegate() instanceof SqlDataSource ? o : null).filter(o -> ((SqlDataSource)o.getDelegate()).containsFile(virtualFile)).collect()).isEmpty()) {
            JBIterable jBIterable = sqlDataSources;
            if (jBIterable == null) {
                DbSqlUtilCore.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        JBIterable jBIterable = !matchingOnly && resultSelected.isEmpty() ? resultAll : resultSelected;
        if (jBIterable == null) {
            DbSqlUtilCore.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    public static boolean isJSLanguage(@Nullable Language language) {
        if (language == MongoJSLanguage.INSTANCE) {
            return true;
        }
        while (language != null) {
            if (language.getID().equals("JavaScript")) {
                return true;
            }
            language = language.getBaseLanguage();
        }
        return false;
    }

    public static ObjectName getName(@Nullable DasObject object) {
        return object == null ? null : new ObjectName(object.getName(), DbSqlUtilCore.isQuoted(object));
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(15);
        }
        return DbSqlUtilCore.findSqlDialect(dialect.getDbms());
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(16);
        }
        return (SqlLanguageDialect)SqlLanguageDialect.EP.forDbms(dbms);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable LocalDataSource dataSource2) {
        SqlLanguageDialect dialect = DbSqlUtilCore.findSqlDialect(dataSource2);
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(17);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@Nullable LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            return null;
        }
        String defaultDialect = dataSource2.getDefaultDialect();
        SqlLanguageDialect result2 = StringUtil.isEmpty((String)defaultDialect) ? null : SqlDialects.findDialectById(defaultDialect);
        return result2 != null ? result2 : DbSqlUtilCore.guessSqlDialect(dataSource2);
    }

    @Nullable
    public static SqlLanguageDialect guessSqlDialect(@Nullable RawConnectionConfig connectionInfo) {
        DatabaseDialectEx dbDialect = connectionInfo == null ? null : DbImplUtilCore.guessDatabaseDialect(connectionInfo);
        return dbDialect == null ? null : DbSqlUtilCore.findSqlDialect(dbDialect);
    }

    @NotNull
    public static Dbms getDbms(@Nullable Language language) {
        Dbms dbms = language instanceof SqlLanguageDialect ? ((SqlLanguageDialect)language).getDbms() : (DbSqlUtilCore.isJSLanguage(language) ? Dbms.MONGO : Dbms.UNKNOWN);
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(18);
        }
        return dbms;
    }

    @NotNull
    public static <C extends DasObject> Condition<C> byName(@Nullable DasObject obj, @Nullable String id, @NotNull CasingProvider provider) {
        if (provider == null) {
            DbSqlUtilCore.$$$reportNull$$$0(19);
        }
        return DbSqlUtilCore.byName(obj == null ? null : obj.getName(), DbSqlUtilCore.isQuoted(obj), id, provider);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Dbms dbms) {
        SqlLanguageDialect res2;
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(20);
        }
        SqlLanguageDialect sqlLanguageDialect = (res2 = DbSqlUtilCore.findSqlDialect(dbms)) == null ? SqlDialects.getGenericDialect() : res2;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(21);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static Language getLanguage(@Nullable LocalDataSource dataSource2) {
        Language language = DbSqlUtilCore.findLanguage(dataSource2);
        Object object = language == null ? SqlDialects.getGenericDialect() : language;
        if (object == null) {
            DbSqlUtilCore.$$$reportNull$$$0(22);
        }
        return object;
    }

    @Nullable
    public static Language findLanguage(@Nullable LocalDataSource dataSource2) {
        if (dataSource2 != null) {
            String defaultDialect = dataSource2.getDefaultDialect();
            if (MongoJSLanguage.INSTANCE.getID().equals(defaultDialect) || dataSource2.getDbms() == Dbms.MONGO) {
                return MongoJSLanguage.INSTANCE;
            }
        }
        return DbSqlUtilCore.findSqlDialect(dataSource2);
    }

    @Nullable
    @Contract(value="!null, _, _, _, _, _ -> !null")
    public static String toStringLiteral(@Nullable String value2, @NotNull Dbms dbms, boolean escapeSqlRegexSymbols, @Nullable String prefix, @Nullable String suffix, @NotNull JdbcHelper helper) {
        SqlRegexDecorator sqlRegexDecorator;
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(23);
        }
        if (helper == null) {
            DbSqlUtilCore.$$$reportNull$$$0(24);
        }
        if (value2 == null) {
            return null;
        }
        SqlRegexDecorator sqlRegexDecorator2 = escapeSqlRegexSymbols && helper.supportsEscape() ? SqlRegexDecorator.WITH_ESCAPE_CLAUSE : (sqlRegexDecorator = escapeSqlRegexSymbols ? SqlRegexDecorator.DEFAULT : SqlRegexDecorator.NONE);
        String string = dbms.isMongo() ? (prefix == null && escapeSqlRegexSymbols ? "^" : "") : (prefix = prefix);
        suffix = dbms.isMongo() ? (suffix == null && escapeSqlRegexSymbols ? "$" : "") : suffix;
        return DbSqlUtilCore.toStringLiteralInner(value2, dbms, sqlRegexDecorator, StringUtil.notNullize((String)prefix), StringUtil.notNullize((String)suffix));
    }

    @NotNull
    private static String toStringLiteralInner(@NotNull String value2, @NotNull Dbms dbms, @NotNull SqlRegexDecorator sqlRegexDecorator, @NotNull String prefix, @NotNull String suffix) {
        char quote;
        if (value2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(25);
        }
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(26);
        }
        if (sqlRegexDecorator == null) {
            DbSqlUtilCore.$$$reportNull$$$0(27);
        }
        if (prefix == null) {
            DbSqlUtilCore.$$$reportNull$$$0(28);
        }
        if (suffix == null) {
            DbSqlUtilCore.$$$reportNull$$$0(29);
        }
        char c2 = quote = dbms.isMongo() ? (char)'\"' : '\'';
        if ((((String)value2).contains("\n") || ((String)value2).contains("\t") || ((String)value2).contains("\r")) && (DbSqlUtilCore.stringsAreEscapedWithSlash(dbms) || DbSqlUtilCore.supportsEscapeStringLiterals(dbms))) {
            value2 = StringUtil.escapeBackSlashes((String)value2);
            value2 = sqlRegexDecorator.decorateInner((String)value2, dbms);
            value2 = StringUtil.escapeChar((String)value2, (char)quote);
            value2 = StringUtil.escapeLineBreak((String)value2);
            value2 = StringUtil.replace((String)value2, (String)"\t", (String)"\\t");
            value2 = quote + prefix + (String)value2 + suffix + quote;
            value2 = DbSqlUtilCore.supportsEscapeStringLiterals(dbms) ? "e" + (String)value2 : value2;
        } else {
            value2 = sqlRegexDecorator.decorateInner((String)value2, dbms);
            String escapeChar = DbSqlUtilCore.stringsAreEscapedWithSlash(dbms) ? "\\" : "'";
            value2 = StringUtil.replace((String)value2, (String)String.valueOf(quote), (String)(escapeChar + quote));
            value2 = quote + prefix + (String)value2 + suffix + quote;
            value2 = dbms.isMicrosoft() ? "N" + (String)value2 : value2;
        }
        String string = sqlRegexDecorator.decorateOuter((String)value2, dbms);
        if (string == null) {
            DbSqlUtilCore.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Nullable
    public static SqlResultSetExpression parseSqlQuery(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull String queryText2, @Nullable Language hostLanguage) {
        SqlBinaryExpression varAssigment;
        SqlSelectClause selectClause;
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(31);
        }
        if (language == null) {
            DbSqlUtilCore.$$$reportNull$$$0(32);
        }
        if (queryText2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(33);
        }
        SqlPsiFacade psiFacade = SqlPsiFacade.getInstance((Project)project);
        SqlFile sql = psiFacade.createROFile(language, (CharSequence)queryText2, hostLanguage);
        SyntaxTraverser traverser = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)sql);
        SqlResultSetExpression queryExpression = (SqlResultSetExpression)traverser.filter(SqlResultSetExpression.class).first();
        if (queryExpression == null || queryExpression.getTextRange().getStartOffset() != 0) {
            return null;
        }
        SqlSelectIntoClause selectIntoClause = (SqlSelectIntoClause)traverser.filter(SqlSelectIntoClause.class).first();
        if (selectIntoClause != null) {
            return null;
        }
        if (language.getDbms().isTransactSql() && queryExpression instanceof SqlQueryExpression && (selectClause = ((SqlQueryExpression)queryExpression).getSelectClause()) != null && (varAssigment = (SqlBinaryExpression)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)selectClause)).filter(SqlBinaryExpression.class).filter(expr -> {
            SqlExpression lOperand = expr.getLOperand();
            boolean isVarLOperand = lOperand instanceof SqlReferenceExpression && ((SqlReferenceExpression)lOperand).getReferenceElementType().getTargetKind() == ObjectKind.VARIABLE;
            return isVarLOperand && expr.getOpSign() == SqlCommonTokens.SQL_OP_EQ;
        }).first()) != null) {
            return null;
        }
        return queryExpression;
    }

    @Nullable
    public static <T> T getSqlFileAttributeAt(@NotNull PsiFile file, @NotNull Key<T> attr, int offset) {
        SqlFile sqlFile;
        if (file == null) {
            DbSqlUtilCore.$$$reportNull$$$0(34);
        }
        if (attr == null) {
            DbSqlUtilCore.$$$reportNull$$$0(35);
        }
        return (T)((sqlFile = (SqlFile)ObjectUtils.tryCast((Object)file, SqlFile.class)) != null ? sqlFile.getAttributeAt(attr, offset) : null);
    }

    @NotNull
    public static String getDelimiterAt(@Nullable PsiFile file, int offset) {
        String delim = file == null ? null : (String)DbSqlUtilCore.getSqlFileAttributeAt(file, SqlFileAttributes.DELIMITER, offset);
        String string = StringUtil.notNullize((String)delim, (String)";");
        if (string == null) {
            DbSqlUtilCore.$$$reportNull$$$0(36);
        }
        return string;
    }

    public static boolean delimiterNeedsSpacing(@NotNull String delim) {
        if (delim == null) {
            DbSqlUtilCore.$$$reportNull$$$0(37);
        }
        return !delim.equals(";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<String> getQueries(@NotNull String text2, @NotNull Project project, @NotNull Language language) {
        if (text2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(38);
        }
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(39);
        }
        if (language == null) {
            DbSqlUtilCore.$$$reportNull$$$0(40);
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)project);
        ScriptModel model = facade.createScriptModel(DbSqlUtilCore.createTemporaryFile(text2, project, language));
        List list = model.statements().transform(ScriptModelUtilCore.TO_TEXT).toList();
        List list2 = list;
        if (list2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(41);
        }
        return list2;
        finally {
            Disposer.dispose((Disposable)model);
        }
    }

    @NotNull
    private static PsiFile createTemporaryFile(@NotNull String text2, @NotNull Project project, @NotNull Language language) {
        if (text2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(42);
        }
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(43);
        }
        if (language == null) {
            DbSqlUtilCore.$$$reportNull$$$0(44);
        }
        ReadOnlyLightVirtualFile file = new ReadOnlyLightVirtualFile("a", language, (CharSequence)text2);
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)project), (VirtualFile)file, false);
        PsiFile psi = viewProvider.getPsi(language);
        if (psi == null) {
            throw new AssertionError((Object)("language: " + language.getID() + "; text length: " + text2.length()));
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            DbSqlUtilCore.$$$reportNull$$$0(45);
        }
        return psiFile;
    }

    @NotNull
    public static JBIterable<DasObject> findObjects(@NotNull DbDataSource dbDataSource, @NotNull ObjectPath path) {
        if (dbDataSource == null) {
            DbSqlUtilCore.$$$reportNull$$$0(46);
        }
        if (path == null) {
            DbSqlUtilCore.$$$reportNull$$$0(47);
        }
        JBIterable<DasObject> jBIterable = dbDataSource.findObjects(path);
        if (jBIterable == null) {
            DbSqlUtilCore.$$$reportNull$$$0(48);
        }
        return jBIterable;
    }

    public static boolean referencesTarget(@NotNull DasObject candidate, @NotNull DasObject target, @NotNull ObjectKind targetKind) {
        if (candidate == null) {
            DbSqlUtilCore.$$$reportNull$$$0(49);
        }
        if (target == null) {
            DbSqlUtilCore.$$$reportNull$$$0(50);
        }
        if (targetKind == null) {
            DbSqlUtilCore.$$$reportNull$$$0(51);
        }
        if (targetKind == ObjectKind.TABLE) {
            DasTable refTable;
            if (candidate instanceof DasForeignKey && target.equals(refTable = ((DasForeignKey)candidate).getRefTable())) {
                return true;
            }
        } else if (targetKind == ObjectKind.COLUMN) {
            if (candidate instanceof DasConstraint) {
                if (ContainerUtil.find(((DasConstraint)candidate).getColumnsRef().resolveObjects(), (Object)target) != null) {
                    return true;
                }
                if (candidate instanceof DasForeignKey && ContainerUtil.find(((DasForeignKey)candidate).getRefColumns().resolveObjects(), (Object)target) != null) {
                    return true;
                }
            } else if (candidate instanceof DasIndex && ContainerUtil.find(((DasIndex)candidate).getColumnsRef().resolveObjects(), (Object)target) != null) {
                return true;
            }
        } else if (candidate instanceof DasSynonym && ((DasSynonym)candidate).resolveTarget() == target) {
            return true;
        }
        return candidate instanceof BasicElement && target instanceof BasicElement && Iterables.contains(((BasicElement)candidate).getPredecessors(), (Object)target);
    }

    @Nullable
    public static DbDataSource getDbDataSource(@NotNull Project project, @NotNull DasDataSource dataSource2) {
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(52);
        }
        if (dataSource2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(53);
        }
        if (dataSource2 instanceof DbDataSource) {
            return (DbDataSource)dataSource2;
        }
        return DbPsiFacade.getInstance(project).findDataSource(dataSource2.getUniqueId());
    }

    @Nullable
    public static DbElement findElement(@NotNull DbDataSource dbDataSource, @NotNull ObjectPath path) {
        if (dbDataSource == null) {
            DbSqlUtilCore.$$$reportNull$$$0(54);
        }
        if (path == null) {
            DbSqlUtilCore.$$$reportNull$$$0(55);
        }
        return dbDataSource.findElement(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbSqlUtilCore";
                break;
            }
            case 3: 
            case 12: 
            case 31: 
            case 39: 
            case 43: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseSystem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "named";
                break;
            }
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseDialect";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlRegexDecorator";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 32: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delim";
                break;
            }
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 46: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetKind";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbSqlUtilCore";
                break;
            }
            case 2: 
            case 17: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "byName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppropriateDataSources";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringLiteralInner";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiterAt";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryFile";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringsAreEscapedWithSlash";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "supportsEscapeStringLiterals";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 48: {
                break;
            }
            case 3: 
            case 4: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDasObject";
                break;
            }
            case 6: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "byName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesForResolve";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAppropriateDataSources";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findSqlDialect";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteral";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteralInner";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parseSqlQuery";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getSqlFileAttributeAt";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "delimiterNeedsSpacing";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryFile";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findObjects";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "referencesTarget";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getDbDataSource";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SqlRegexDecorator {
        NONE(false, false),
        DEFAULT(true, false),
        WITH_ESCAPE_CLAUSE(true, true);

        private final boolean escapeSqlRegex;
        private final boolean appendEscapeClause;

        private SqlRegexDecorator(boolean escapeSqlRegex, boolean appendEscapeClause) {
            this.escapeSqlRegex = escapeSqlRegex;
            this.appendEscapeClause = appendEscapeClause;
        }

        @NotNull
        String decorateInner(@NotNull String value2, @NotNull Dbms dbms) {
            if (value2 == null) {
                SqlRegexDecorator.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(1);
            }
            if (!this.escapeSqlRegex) {
                String string = value2;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(2);
                }
                return string;
            }
            JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
            if (!DbSqlUtilCore.stringsAreEscapedWithSlash(dbms) && !helper.supportsEscape()) {
                value2 = StringUtil.escapeBackSlashes((String)value2);
            }
            String string = (String)helper.escapeSqlRegex((Object)value2, true);
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        String decorateOuter(@NotNull String value2, @NotNull Dbms dbms) {
            if (value2 == null) {
                SqlRegexDecorator.$$$reportNull$$$0(4);
            }
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(5);
            }
            if (!this.appendEscapeClause) {
                String string = value2;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(6);
                }
                return string;
            }
            JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
            if (value2.indexOf(helper.getEscapeChar()) == -1) {
                String string = value2;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = value2 + this.getTail(dbms);
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public String getTail(@NotNull Dbms dbms) {
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(9);
            }
            if (!this.appendEscapeClause) {
                return "";
            }
            JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
            String string = " ESCAPE '" + helper.getEscapeChar() + "'";
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DbSqlUtilCore$SqlRegexDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DbSqlUtilCore$SqlRegexDecorator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorateInner";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorateOuter";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTail";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "decorateInner";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "decorateOuter";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getTail";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

