/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.SqlUiService;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ColumnRefKt;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.PredicateSpecKt;
import com.intellij.database.data.types.PredicateValuesKt;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.ValuesWhereClauseTask;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.rmi.ConnectException;
import java.rmi.UnmarshalException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public final class DbImplUtil
extends DbImplUtilCore {
    private static final Logger LOG = Logger.getInstance(DbImplUtil.class);
    private static final String READ_ONLY_WARNING = "Read-only mode is not supported. Dbms: %s";
    public static final Condition<DbElement> CAN_CONNECT_TO = DbImplUtilCore::canConnectTo;
    private static final char ESCAPE_CHAR = '#';

    private DbImplUtil() {
    }

    public static int valueHashCode(Object v) {
        if (v == ReservedCellValue.NULL) {
            v = null;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            return Long.valueOf(n.longValue()).hashCode() * 31 + Double.valueOf(n.doubleValue()).hashCode();
        }
        if (v instanceof byte[]) {
            return Arrays.hashCode((byte[])v);
        }
        if (v instanceof char[]) {
            return Arrays.hashCode((char[])v);
        }
        if (v instanceof LobInfo.ClobInfo) {
            return Comparing.hashcode((Object)((LobInfo.ClobInfo)v).data);
        }
        return Comparing.hashcode((Object)v);
    }

    @NotNull
    public static String findFreeAlias(@NotNull Project project, @NotNull Dbms dbms, @NotNull String query, @NotNull String alias) {
        SqlResultSetExpression expression;
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(0);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(1);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(2);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(3);
        }
        if ((expression = DbSqlUtilCore.parseSqlQuery(project, DbSqlUtilCore.getSqlDialect(dbms), query, null)) == null) {
            String string = alias;
            if (string == null) {
                DbImplUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        Set names = SyntaxTraverser.psiTraverser((PsiElement)expression).filter(SqlIdentifier.class).transform(SqlNameElement::getName).toSet();
        Object result2 = alias;
        int index2 = 1;
        while (names.contains(result2)) {
            result2 = alias + index2++;
        }
        String string = result2;
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean isConnected(@NotNull DbElement element2) {
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(6);
        }
        Object delegate = element2.getDelegate();
        Project project = element2.getProject();
        return delegate instanceof LocalDataSource && DbImplUtil.isConnected(project, (LocalDataSource)delegate);
    }

    @Nullable
    public static Domain getDomain(@Nullable DasTypedObject column2) {
        if (column2 == null) {
            return null;
        }
        DomainRegistry registry = BaseDomainRegistry.get(DbImplUtilCore.getDbms(column2), null);
        return registry == null ? null : registry.getDomain(new TypeNameColumnDescriptor(column2.getDataType().typeName));
    }

    public static boolean isConnected(@NotNull Project project, @NotNull LocalDataSource delegate) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(7);
        }
        if (delegate == null) {
            DbImplUtil.$$$reportNull$$$0(8);
        }
        return !JdbcDriverManager.getDriverManager(project).getActiveConfigurations(delegate).isEmpty();
    }

    public static int getActiveConnectionCount(@NotNull LocalDataSource delegate) {
        if (delegate == null) {
            DbImplUtil.$$$reportNull$$$0(9);
        }
        int result2 = 0;
        for (DatabaseConnection connection2 : DatabaseConnectionManager.getInstance().getActiveConnections()) {
            if (delegate != connection2.getConnectionPoint().getDataSource()) continue;
            ++result2;
        }
        return result2;
    }

    @Nullable
    public static GuardedRef<DatabaseConnection> getDatabaseConnection(@NotNull DbElement element2, @NotNull DatabaseDepartment department) throws Exception {
        DatabaseSystem ds;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(10);
        }
        if (department == null) {
            DbImplUtil.$$$reportNull$$$0(11);
        }
        if (!((ds = element2.getDataSource().getDelegate()) instanceof LocalDataSource)) {
            return null;
        }
        SearchPath path = SearchPath.of(ObjectPaths.of(DasUtil.getNamespace(element2)));
        Project project = element2.getProject();
        LocalDataSource localDataSource = (LocalDataSource)ds;
        GuardedRef<DatabaseConnection> connection2 = DatabaseSessionManager.facade(project, localDataSource, null, path, false, null, department).connect();
        JdbcNativeUtil.performSafe(() -> ((DatabaseConnection)connection2.get()).getRemoteConnection().setCatalog(DasUtil.getCatalog(element2)));
        return connection2;
    }

    public static boolean isRemoteProcessDown(@NotNull Throwable e) {
        if (e == null) {
            DbImplUtil.$$$reportNull$$$0(12);
        }
        if (ExceptionUtil.findCause((Throwable)e, ConnectException.class) != null) {
            return true;
        }
        UnmarshalException unmarshal = (UnmarshalException)ExceptionUtil.findCause((Throwable)e, UnmarshalException.class);
        return unmarshal != null && unmarshal.getCause() instanceof EOFException;
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull BasicElement element2) {
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(13);
        }
        ModelHelper modelHelper = (ModelHelper)ObjectUtils.tryCast((Object)DbImplUtilCore.getModelHelper(element2), ModelHelper.class);
        if (modelHelper == null) {
            DbImplUtil.$$$reportNull$$$0(14);
        }
        return modelHelper;
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(15);
        }
        ModelHelper modelHelper = (ModelHelper)ObjectUtils.tryCast((Object)DbImplUtilCore.getModelHelper(dbms), ModelHelper.class);
        if (modelHelper == null) {
            DbImplUtil.$$$reportNull$$$0(16);
        }
        return modelHelper;
    }

    public static LobInfo.FileClobInfo clobFromFile(@NotNull VirtualFile virtualFile) {
        Charset encoding;
        if (virtualFile == null) {
            DbImplUtil.$$$reportNull$$$0(17);
        }
        String charset = (encoding = EncodingManager.getInstance().getEncoding(virtualFile, true)) != null ? encoding.name() : null;
        File file = new File(virtualFile.getPath());
        return new LobInfo.FileClobInfo(file, charset);
    }

    @NotNull
    public static LobInfo.FileBlobInfo blobFromFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            DbImplUtil.$$$reportNull$$$0(18);
        }
        return new LobInfo.FileBlobInfo(new File(virtualFile.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadViewDefinition(ConnectionProvider provider, @NotNull DbTable element2, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(19);
        }
        if (!(dialect = DbImplUtil.getDatabaseDialect(element2)).supportsViewDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            Dbms dbms = element2.getDataSource().getDbms();
            Pair<String, DbImplUtilCore.ConcatenationProps> query = dialect.sqlViewDefinition(element2);
            if (query == null) {
                return;
            }
            int initialLength = sb.length();
            DbImplUtil.concatStringResults((DatabaseConnectionCore)provider.getConnection(), dbms, 0, (String)query.first, sb, (DbImplUtilCore.ConcatenationProps)query.second);
            if (sb.length() > initialLength) {
                if (dbms.isMysql() || dbms.isPostgres() || dbms.isOracle()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder(element2, false);
                    String fullDefinition = dialect.sqlCreateView(builder, element2, sb.substring(initialLength)).getStatement();
                    sb.setLength(initialLength);
                    sb.append(fullDefinition);
                } else if (dbms.isDerby()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder(element2, false);
                    sb.insert(initialLength, dialect.sqlDropView(builder, element2, true).getStatement() + ";\n");
                } else if (dbms.isMicrosoft()) {
                    DbImplUtil.replaceTokenInDefinition(element2, sb, dbms, SqlCreateViewStatement.class, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_ALTER);
                } else if (dbms.isSybase()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder(element2, false);
                    sb.insert(initialLength, dialect.sqlDropView(builder, element2, true).newLine().keyword("GO").getStatement() + "\n");
                } else if (dbms.isH2()) {
                    sb.insert(initialLength + "CREATE ".length(), "OR REPLACE ");
                }
            }
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void tryLoadProcedureDefinition(@NotNull ConnectionProvider provider, @NotNull DbRoutine element2, @NotNull StringBuilder sb) throws Exception {
        if (provider == null) {
            DbImplUtil.$$$reportNull$$$0(20);
        }
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(21);
        }
        if (sb == null) {
            DbImplUtil.$$$reportNull$$$0(22);
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element2);
        if (!provider.acquire()) {
            provider.release();
            return;
        }
        String fromDialect = dialect.tryToLoadProcedureDefinition(element2, provider.getConnection());
        if (StringUtil.isNotEmpty((String)fromDialect)) {
            sb.append(fromDialect);
            provider.release();
            return;
        }
        if (!dialect.supportsProcedureDefinition()) {
            return;
        }
        Dbms dbms = DbImplUtil.getDbms(element2);
        Pair<String, DbImplUtilCore.ConcatenationProps> query = dialect.sqlProcedureDefinition(element2);
        StringBuilder definition = DbImplUtil.concatStringResults((DatabaseConnectionCore)provider.getConnection(), dbms, (String)query.first, 0, new StringBuilder(), (DbImplUtilCore.ConcatenationProps)query.second);
        if (StringUtil.isEmptyOrSpaces((String)definition.toString())) return;
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder(element2, false);
        if (dbms.isOracle()) {
            definition.insert(0, builder.keywords("create", "or", "replace").space().getStatement());
        } else if (dbms.isH2()) {
            definition.insert(0, builder.keywords("create", "alias").space().qualifiedRef(element2).space().keyword("as").space().symbol("$$").getStatement()).append("$$");
        } else if (dbms.isDb2()) {
            definition.insert(0, dialect.sqlDropProcedure(builder, element2).getStatement() + ";\n");
        } else if (dbms.isMicrosoft()) {
            DbImplUtil.replaceTokenInDefinition(element2, definition, dbms, SqlCreateStatement.class, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_ALTER);
        } else if (dbms.isSybase()) {
            builder.keyword("drop").space().keyword(StringUtil.startsWithIgnoreCase((String)definition.toString().trim(), (String)"create function") ? "function" : "procedure").space();
            dialect.qualifiedIdentifier(builder, element2.getName(), element2, element2);
            builder.newLine();
            builder.keyword("go").newLine();
            definition.insert(0, builder.getStatement());
        }
        String trim = definition.toString().trim();
        sb.append(trim);
        if (dbms.isTransactSql()) {
            sb.append(DatabaseDialogsHelper.createDdlBuilder(element2, false).clear().newLine().keyword("go").getStatement());
            return;
        }
        if (trim.endsWith(";")) return;
        sb.append(";");
        return;
    }

    private static void replaceTokenInDefinition(@NotNull DbElement element2, @NotNull StringBuilder sb, @NotNull Dbms dbms, @NotNull Class<? extends SqlDefinition> defClazz, @NotNull SqlTokenType fromToken, @NotNull SqlTokenType toToken) {
        SqlFile psi;
        SyntaxTraverser st;
        PsiElement keyword;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(23);
        }
        if (sb == null) {
            DbImplUtil.$$$reportNull$$$0(24);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(25);
        }
        if (defClazz == null) {
            DbImplUtil.$$$reportNull$$$0(26);
        }
        if (fromToken == null) {
            DbImplUtil.$$$reportNull$$$0(27);
        }
        if (toToken == null) {
            DbImplUtil.$$$reportNull$$$0(28);
        }
        if ((keyword = (PsiElement)(st = SyntaxTraverser.psiTraverser((PsiElement)(psi = SqlPsiFacade.getInstance((Project)element2.getProject()).createROFile(DbSqlUtilCore.getSqlDialect(dbms), (CharSequence)sb.toString())))).traverse().skipWhile(Conditions.notInstanceOf(defClazz)).filter(Conditions.compose((Function)st.api.TO_TYPE, (Condition)Conditions.equalTo((Object)fromToken))).first()) != null) {
            TextRange r = st.api.rangeOf((Object)keyword);
            int i0 = r.getStartOffset();
            int i1 = r.getEndOffset();
            String replacement = ((Case)((Object)ObjectUtils.notNull((Object)((Object)Case.forString(sb.substring(i0, i1))), (Object)((Object)Case.EXACT)))).apply(toToken.toString());
            sb.replace(i0, i1, replacement);
        }
    }

    @NotNull
    public static Dbms getDbms(@NotNull JdbcConsoleBase console) {
        if (console == null) {
            DbImplUtil.$$$reportNull$$$0(29);
        }
        Dbms dbms = console.getDataSource().getDbms();
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(30);
        }
        return dbms;
    }

    public static boolean isGenericSupport(Dbms dbms) {
        if (dbms.in(Dbms.PSEUDO_SUPPORTED)) {
            return true;
        }
        DatabaseDialectEx db = DbImplUtil.getDatabaseDialect(dbms);
        SqlLanguageDialect sql = DbSqlUtilCore.getSqlDialect(dbms);
        return SqlDialects.isGenericDialect(sql) && DatabaseDialects.isGenericDialect(db);
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull JdbcConsoleBase console) {
        if (console == null) {
            DbImplUtil.$$$reportNull$$$0(31);
        }
        return DbImplUtil.getDatabaseDialect(console.getDataSource());
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull RawConnectionConfig connectionInfo) {
        if (connectionInfo == null) {
            DbImplUtil.$$$reportNull$$$0(32);
        }
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(connectionInfo), (Object)DatabaseDialects.getGenericDialect());
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(33);
        }
        return databaseDialectEx;
    }

    @Nullable
    protected static DatabaseDialectEx guessDatabaseDialect(@Nullable Dbms dbms) {
        return (DatabaseDialectEx)ObjectUtils.tryCast((Object)DbImplUtilCore.guessDatabaseDialect(dbms), DatabaseDialectEx.class);
    }

    @Nullable
    public static DatabaseDialect guessDatabaseDialect(@Nullable DasObject object) {
        return DbImplUtil.guessDatabaseDialect(DbImplUtil.guessDbms(object));
    }

    @Nullable
    public static Dbms guessDbms(@Nullable DasObject object) {
        Language language;
        BasicModel model;
        DasObject o;
        DasObject dasObject = o = object instanceof DbElement ? ((DbElement)object).getDelegate() : object;
        Dbms dbms = o instanceof BasicElement ? ((model = ((BasicElement)o).getModel()) == null ? null : model.getDbms()) : (o instanceof SqlElement ? ((language = ((SqlElement)o).getContainingFile().getLanguage()) instanceof SqlLanguageDialect ? ((SqlLanguageDialect)language).getDbms() : null) : null);
        return dbms;
    }

    public static boolean supportsDynamicSchemaSwitching(@NotNull LocalDataSource dataSource2) {
        DatabaseDialectEx dialect;
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(34);
        }
        return (dialect = DbImplUtil.guessDatabaseDialect(dataSource2)) == null || !dataSource2.getDbms().isMysql() || !dataSource2.isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadPackageDefinition(ConnectionProvider provider, @NotNull DbPackage element2, boolean spec, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(35);
        }
        if (!(dialect = DbImplUtil.getDatabaseDialect(element2)).supportsPackageDefinition()) {
            return;
        }
        Dbms dbms = element2.getDataSource().getDbms();
        try {
            if (!provider.acquire()) {
                return;
            }
            Pair<String, DbImplUtilCore.ConcatenationProps> query = spec ? dialect.sqlPackageDefinition(element2) : dialect.sqlPackageBodyDefinition(element2);
            StringBuilder def = DbImplUtil.concatStringResults((DatabaseConnectionCore)provider.getConnection(), dbms, (String)query.first, 0, new StringBuilder(), (DbImplUtilCore.ConcatenationProps)query.second);
            Case caseMode = (Case)((Object)ObjectUtils.notNull((Object)((Object)Case.forString(def.substring(0, Math.min(sb.length(), 7)))), (Object)((Object)Case.EXACT)));
            if (StringUtil.startsWith((CharSequence)def, (CharSequence)"package") || StringUtil.startsWith((CharSequence)def, (CharSequence)"PACKAGE")) {
                def.insert(0, caseMode.apply("CREATE OR REPLACE "));
            }
            sb.append((CharSequence)def);
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadSequenceDefinition(ConnectionProvider provider, DbTable element2, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element2);
        if (!dialect.supportsSequenceDefinition()) {
            return;
        }
        Dbms dbms = element2.getDataSource().getDbms();
        StringBuilder builder = new StringBuilder();
        String drop = dialect.sqlDropSequence(DatabaseDialogsHelper.createDdlBuilder(element2, false), element2, false).getStatement() + ";\n";
        builder.append(drop);
        try {
            if (!provider.acquire()) {
                return;
            }
            Pair<String, DbImplUtilCore.ConcatenationProps> query = dialect.sqlSequenceDefinition(element2);
            DbImplUtil.concatStringResults((DatabaseConnectionCore)provider.getConnection(), dbms, (String)query.first, 0, builder, (DbImplUtilCore.ConcatenationProps)query.second);
            sb.append((CharSequence)builder);
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadTableDefinition(ConnectionProvider provider, DbTable element2, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element2);
        if (!dialect.supportsTableDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String sql = dialect.tryToLoadTableDefinition(element2, provider.getConnection());
            if (!StringUtil.isEmptyOrSpaces((String)sql)) {
                sb.append(sql);
            }
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> tryLoadTableInfo(ConnectionProvider provider, DbTable element2) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element2);
        if (!dialect.supportsTableInfo()) {
            return Collections.emptyMap();
        }
        try {
            if (!provider.acquire()) {
                Map<String, Object> map2 = Collections.emptyMap();
                return map2;
            }
            Map<String, Object> map3 = dialect.tryToLoadTableInfo(element2, provider.getConnection());
            return map3;
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadSynonymDefinition(ConnectionProvider provider, DbTable element2, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element2);
        if (!dialect.supportsTableDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String sql = dialect.tryToLoadSynonymDefinition(element2, provider.getConnection());
            if (!StringUtil.isEmpty((String)sql)) {
                sb.append(sql);
            }
        }
        finally {
            provider.release();
        }
    }

    public static boolean isScriptFile(@Nullable Project project, @Nullable VirtualFile file) {
        return DbSqlUtil.SQL_FILE_FILTER(project).value((Object)file) || DbImplUtil.isJSScriptFile(project, file);
    }

    public static boolean isJSScriptFile(Project project, VirtualFile file) {
        if (!"js".equals(file.getExtension()) && !FileTypeRegistry.getInstance().getFileTypeByFile(file).getName().equals("JavaScript")) {
            return false;
        }
        for (LocalDataSource localDataSource : DbSrcUtilsCore.getDataSources(project)) {
            if (!localDataSource.getDbms().isMongo()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDatabaseVirtualFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return DbSrcUtilsCore.isDbSrcFile(file) || file instanceof DatabaseElementVirtualFileImpl;
    }

    @Nullable
    public static ObjectKind getKind(@NotNull VirtualFile file) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(36);
        }
        if (DbSrcUtilsCore.isDbSrcFile(file)) {
            return DbSrcUtils.getKind(file.getPath());
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).getObjectKind();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findSourceVirtualFile(@NotNull DbElement o, boolean refresh2) {
        VirtualFile file;
        if (o == null) {
            DbImplUtil.$$$reportNull$$$0(37);
        }
        if ((file = DbImplUtil.findVirtualFileInSourceStorage(o, false, refresh2)) != null) {
            return file;
        }
        return o.getVirtualFile();
    }

    @Nullable
    public static VirtualFile findDataVirtualFile(@NotNull DbElement o, boolean refresh2) {
        ObjectKind kind;
        if (o == null) {
            DbImplUtil.$$$reportNull$$$0(38);
        }
        if (DbImplUtil.isDataTable(kind = o.getKind())) {
            return DatabaseElementVirtualFileImpl.findFile(o, false);
        }
        return DbImplUtil.findSourceVirtualFile(o, refresh2);
    }

    @Nullable
    public static VirtualFile findVirtualFileInSourceStorage(@Nullable DbElement o, boolean original, boolean refresh2) {
        VirtualFile vf;
        Object delegate;
        Object object = delegate = o != null ? o.getDelegate() : null;
        if (delegate instanceof BasicSourceAware && (vf = DbSrcUtils.findDbSrcFile(o.getDataSource(), o, refresh2)) != null) {
            return original ? DbSrcFileSystem.getInstance().getBaseFile(vf, false) : vf;
        }
        return null;
    }

    @Nullable
    public static String loadDefinitionFromStorage(@Nullable DbElement o) {
        VirtualFile file = DbImplUtil.findVirtualFileInSourceStorage(o, true, false);
        if (file == null) {
            return null;
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean canSwitchTo(@NotNull SearchPath to, @NotNull DatabaseDialectEx dialect) {
        if (to == null) {
            DbImplUtil.$$$reportNull$$$0(39);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(40);
        }
        return dialect.sqlSetSearchPath(to) != null;
    }

    @Nullable
    public static String getSearchPathSql(@NotNull SearchPath to, @NotNull LocalDataSource dataSource2, @NotNull DatabaseDialectEx dialect) {
        if (to == null) {
            DbImplUtil.$$$reportNull$$$0(41);
        }
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(42);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(43);
        }
        if (dataSource2.getSchemaControl() == SchemaControl.FORBID) {
            return null;
        }
        String setSchemaSql = dialect.sqlSetSearchPath(to);
        if (setSchemaSql != null) {
            return setSchemaSql;
        }
        ObjectPath current = to.getCurrent();
        ObjectPath db = current.kind != ObjectKind.SCHEMA ? null : current.findParent(ObjectKind.DATABASE, true);
        return db == null ? null : dialect.sqlSetSearchPath(SearchPath.of(db));
    }

    public static boolean switchSchemaThroughJdbc(@NotNull SearchPath path, @NotNull DatabaseConnection connection2, @NotNull LocalDataSource dataSource2) throws SQLException {
        if (path == null) {
            DbImplUtil.$$$reportNull$$$0(44);
        }
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(45);
        }
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(46);
        }
        if (dataSource2.getSchemaControl() == SchemaControl.FORBID) {
            return false;
        }
        if (!dataSource2.getDbms().isClickHouse() && !DatabaseDialects.isGenericDialect(DbImplUtil.getDatabaseDialect(dataSource2))) {
            return false;
        }
        ObjectPath schema = path.getCurrent().findParent(ObjectKind.SCHEMA, false);
        if (dataSource2.getDbms().isClickHouse()) {
            if (schema == null) {
                return false;
            }
            JdbcNativeUtil.performRemote(() -> connection2.getRemoteConnection().setCatalog(schema.name));
        } else {
            ObjectPath database = path.getCurrent().findParent(ObjectKind.DATABASE, false);
            if (schema == null && database == null) {
                return false;
            }
            JdbcNativeUtil.performRemote(() -> {
                if (database != null) {
                    connection2.getRemoteConnection().setCatalog(database.name);
                }
                if (schema != null) {
                    connection2.getRemoteConnection().setSchema(schema.name);
                }
            });
        }
        return true;
    }

    @NotNull
    public static <T extends ColumnDescriptor> List<T> getWhereClauseColumns(@Nullable DasTable table, @NotNull List<T> descriptors, @NotNull Dbms dbms) {
        ColumnDescriptor idColumn;
        if (descriptors == null) {
            DbImplUtil.$$$reportNull$$$0(47);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(48);
        }
        DasTableKey primaryKey = table == null ? null : DasUtil.getPrimaryKey(table);
        ArrayList<ColumnDescriptor> result2 = new ArrayList<ColumnDescriptor>(descriptors.size());
        if (primaryKey != null) {
            THashSet set = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            ContainerUtil.addAll((Collection)set, primaryKey.getColumnsRef().names());
            result2.addAll(ContainerUtil.filter(descriptors, arg_0 -> DbImplUtil.lambda$getWhereClauseColumns$3((Set)set, arg_0)));
        } else if (dbms.is(Dbms.MONGO) && (idColumn = (ColumnDescriptor)ContainerUtil.find(descriptors, d2 -> "_id".equals(d2.getName()))) != null) {
            result2.add(idColumn);
        }
        if (!result2.isEmpty()) {
            ArrayList<ColumnDescriptor> arrayList = result2;
            if (arrayList == null) {
                DbImplUtil.$$$reportNull$$$0(49);
            }
            return arrayList;
        }
        result2.addAll(ContainerUtil.filter(descriptors, descriptor2 -> DbImplUtil.isSuitable(descriptor2, dbms)));
        ArrayList<ColumnDescriptor> arrayList = result2;
        if (arrayList == null) {
            DbImplUtil.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    public static boolean supportsDomainAuth(@Nullable DatabaseDriver driver) {
        return SystemInfo.isWindows && driver != null && ("sqlserver.ms".equals(driver.getId()) || "sqlserver.jtds".equals(driver.getId()) || "com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(driver.getDriverClass()) || "net.sourceforge.jtds.jdbc.Driver".equals(driver.getDriverClass()));
    }

    public static boolean supportsReadOnlyChangeOnTheFly(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(51);
        }
        return !dbms.isSqlite() && !dbms.isHive() && dbms != Dbms.SNOWFLAKE && dbms != Dbms.COCKROACH;
    }

    public static void tryToSetReadOnly(@NotNull DatabaseConnection connection2, boolean isReadOnly) {
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(52);
        }
        try {
            connection2.setReadOnly(isReadOnly);
        }
        catch (Throwable t) {
            LOG.warn(String.format(READ_ONLY_WARNING, connection2.getDbms()), t);
        }
    }

    public static void tryToSetReadOnly(@NotNull RemoteConnection remoteConnection, boolean isReadOnly, Dbms dbms) {
        if (remoteConnection == null) {
            DbImplUtil.$$$reportNull$$$0(53);
        }
        try {
            remoteConnection.setReadOnly(isReadOnly);
        }
        catch (Throwable t) {
            LOG.warn(String.format(READ_ONLY_WARNING, dbms), t);
        }
    }

    public static boolean supportsReadOnlyChangeDuringTx(@NotNull Dbms family) {
        if (family == null) {
            DbImplUtil.$$$reportNull$$$0(54);
        }
        return family == Dbms.MYSQL;
    }

    @Nullable
    public static DbDataSource findDataSourceByFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(55);
        }
        if (file == null) {
            return null;
        }
        for (DbDataSource dataSource2 : DbPsiFacade.getInstance(project).getDataSources()) {
            String adjusted;
            LocalDataSource d2 = DbImplUtil.getMaybeLocalDataSource(dataSource2);
            JdbcUrlParser parsed = JdbcUrlParserUtil.parsed(d2);
            String path = parsed == null ? null : parsed.getParameter("file");
            if (path == null || !Objects.equals(adjusted = FileUtil.toSystemIndependentName((String)PathManager.getAbsolutePath((String)path)), file.getPath())) continue;
            return dataSource2;
        }
        return null;
    }

    public static TriConsumer<DdlBuilder, List<DasColumn>, Dbms> defaultWhereCondition(@NotNull String[] columnNames, @NotNull String[] values2, @Nullable Version version) {
        if (columnNames == null) {
            DbImplUtil.$$$reportNull$$$0(56);
        }
        if (values2 == null) {
            DbImplUtil.$$$reportNull$$$0(57);
        }
        return (builder, columns, dbms) -> {
            List<ColumnRef> actualColumns = ColumnRefKt.toColumnsRef(columns, columnNames);
            ArrayList<Triple> v = new ArrayList<Triple>();
            for (int i2 = 0; i2 < actualColumns.size(); ++i2) {
                v.add(new Triple((Object)actualColumns.get(i2), (Object)PredicateValuesKt.predicateValue(values2[i2]), PredicateSpecKt.DEFAULT_OPS));
            }
            ValuesWhereClauseTask task2 = DmlTaskKt.whereClause(new ValuesWhereClause(v, "AND", null)).version(version).build((DdlBuilder)builder);
            DmlUtilKt.dmlGenerator(dbms).generate(task2);
        };
    }

    public static long getCount(@NotNull DatabaseConnection connection2, @NotNull String query) throws SQLException {
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(58);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(59);
        }
        ExecutionEnvironmentHelper helper = ExecutionEnvironmentHelper.EP.forDbms(connection2.getDbms());
        Long result2 = (Long)DbImplUtil.executeAndGetResult(connection2, query, helper::getCountRows);
        if (result2 == null) {
            throw new AssertionError((Object)"Incorrect count query!");
        }
        return result2;
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForExec(@NotNull PsiFile file, boolean ignoreForced, boolean matchingOnly) {
        DbDataSource forced;
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(60);
        }
        DbDataSource dbDataSource = forced = ignoreForced ? null : DbImplUtil.getForcedDataSource(file);
        if (forced != null) {
            JBIterable jBIterable = JBIterable.of((Object)forced).filter(CAN_CONNECT_TO);
            if (jBIterable == null) {
                DbImplUtil.$$$reportNull$$$0(61);
            }
            return jBIterable;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        SqlLanguageDialect dialect = virtualFile == null ? null : (SqlLanguageDialect)ObjectUtils.chooseNotNull((Object)DbSqlUtilCore.getSqlDialect((PsiElement)file), (Object)SqlPsiFacade.getInstance((Project)file.getProject()).getConfiguredSqlLanguageDialect(virtualFile));
        DatabaseDialect databaseDialect = dialect == null ? null : dialect.getDatabaseDialect();
        JBIterable jBIterable = databaseDialect == null ? JBIterable.empty() : DbSqlUtilCore.getAppropriateDataSources(databaseDialect, PsiUtilCore.getVirtualFile((PsiElement)file), file.getProject(), false, matchingOnly).filter(CAN_CONNECT_TO);
        if (jBIterable == null) {
            DbImplUtil.$$$reportNull$$$0(62);
        }
        return jBIterable;
    }

    public static int composeWhereItemWithParameters(@NotNull DdlBuilder builder, @NotNull DataConsumer.Column column2, boolean isNull, @Nullable String alias, @NotNull Dbms dbms, boolean inUpdate) {
        boolean useLike;
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(63);
        }
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(64);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(65);
        }
        if (DbImplUtil.isRowId(column2)) {
            builder.plain(column2.name);
        } else {
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.identifier(column2.name);
        }
        builder.space();
        if (isNull) {
            builder.keywords("IS", "NULL");
            return 0;
        }
        JdbcHelper helper = DbImplUtil.getJdbcHelper(dbms);
        boolean bl = useLike = DbImplUtil.getDatabaseDialect(dbms).getLikeSupport(null).isSupported(inUpdate) && "java.lang.String".equals(column2.clazz);
        if (useLike) {
            builder.keyword("LIKE");
        } else if (dbms.isPostgres() && PgBaseJdbcHelper.isCustomOperatorType((String)column2.getTypeName())) {
            builder.symbol("~=");
        } else {
            builder.symbol("=");
        }
        builder.space().placeholder();
        if (useLike && helper.supportsEscape()) {
            builder.space().keyword("ESCAPE").space().plain("'#'");
        }
        return 1;
    }

    public static DataConsumer.Column makeRowId(DataConsumer.Column column2) {
        if (column2.attributes.contains((Object)DataConsumer.Column.Attribute.ROW_ID)) {
            return column2;
        }
        EnumSet<DataConsumer.Column.Attribute> attributes2 = EnumSet.noneOf(DataConsumer.Column.Attribute.class);
        attributes2.addAll(column2.attributes);
        attributes2.add(DataConsumer.Column.Attribute.ROW_ID);
        return new DataConsumer.Column(column2.columnNum, column2.name, column2.type, column2.typeName, column2.clazz, -1, -1, column2.catalog, column2.schema, column2.table, attributes2);
    }

    public static boolean writeVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute, @Nullable String value2) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(66);
        }
        if (attribute == null) {
            DbImplUtil.$$$reportNull$$$0(67);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return false;
        }
        try {
            return DbImplUtil.writeVFSAttribute(file, attribute, value2);
        }
        catch (IOException ex) {
            LOG.warn((Throwable)ex);
            return false;
        }
    }

    @Nullable
    public static String readVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(68);
        }
        if (attribute == null) {
            DbImplUtil.$$$reportNull$$$0(69);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        try {
            return DbImplUtil.readVFSAttribute(file, attribute);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static boolean writeVFSAttribute(@NotNull VirtualFile fileOrDir, @NotNull FileAttribute attribute, @Nullable String value2) throws IOException {
        String oldValue;
        if (fileOrDir == null) {
            DbImplUtil.$$$reportNull$$$0(70);
        }
        if (attribute == null) {
            DbImplUtil.$$$reportNull$$$0(71);
        }
        if (Objects.equals(oldValue = DbImplUtil.readVFSAttribute(fileOrDir, attribute), value2)) {
            return false;
        }
        try (DataOutputStream oStream = attribute.writeAttribute(fileOrDir);){
            DataInputOutputUtil.writeINT((DataOutput)oStream, (int)DbImplUtil.enumerateDialectName(value2));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readVFSAttribute(VirtualFile fileOrDir, FileAttribute attribute) throws IOException {
        DataInputStream iStream = attribute.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                String string = StringUtil.nullize((String)SqlUiService.getInstance().getDialectName(DataInputOutputUtil.readINT((DataInput)iStream)));
                return string;
            }
            finally {
                iStream.close();
            }
        }
        return null;
    }

    public static void initLanguageComboBox(JComboBox<Language> comboBox, boolean allowNull) {
        ArrayList<Object> languages2 = new ArrayList<Object>();
        if (allowNull) {
            languages2.add(null);
        }
        languages2.addAll(SqlDialects.getTopLevelSqlDialects());
        Language mongo = DbSqlUtil.getLanguage(Dbms.MONGO);
        if (DbSqlUtilCore.getDbms(mongo) == Dbms.MONGO) {
            languages2.add(mongo);
        }
        comboBox.setModel((ComboBoxModel<Language>)new CollectionComboBoxModel(languages2));
        comboBox.setEditable(false);
        comboBox.setRenderer((ListCellRenderer<Language>)SimpleListCellRenderer.create((label, language, index2) -> {
            if (language == null) {
                label.setText(DatabaseBundle.message("label.default", new Object[0]));
                label.setIcon(null);
            } else {
                if (language instanceof SqlLanguageDialect) {
                    label.setIcon(((SqlLanguageDialect)language).getIcon());
                } else {
                    LanguageFileType fileType = language.getAssociatedFileType();
                    label.setIcon(fileType == null ? null : fileType.getIcon());
                }
                label.setText(language.getDisplayName());
            }
        }));
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done, @Nullable String reason, @NotNull ModalityState modalityState) {
        if (modalityState == null) {
            DbImplUtil.$$$reportNull$$$0(72);
        }
        if (callback == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (done) {
                callback.setResult(null);
            } else {
                callback.setError(StringUtil.isEmptyOrSpaces((String)reason) ? "not done" : reason);
            }
        }, modalityState);
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done, @NotNull ModalityState state) {
        if (state == null) {
            DbImplUtil.$$$reportNull$$$0(73);
        }
        DbImplUtil.setActionCallbackDone(callback, done, null, state);
    }

    @NotNull
    public static EnumSet<ReservedCellValue> getSpecialValues(@Nullable DasColumn databaseColumn, @NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(74);
        }
        EnumSet<ReservedCellValue> result2 = EnumSet.noneOf(ReservedCellValue.class);
        if (dbms.in(Dbms.DOCUMENT_ORIENTED)) {
            result2.add(ReservedCellValue.UNSET);
        }
        if (databaseColumn == null) {
            result2.add(ReservedCellValue.NULL);
            EnumSet<ReservedCellValue> enumSet = result2;
            if (enumSet == null) {
                DbImplUtil.$$$reportNull$$$0(75);
            }
            return enumSet;
        }
        if (DasUtil.isAutoGenerated(databaseColumn)) {
            result2.add(ReservedCellValue.GENERATED);
        }
        if (DasUtil.isComputed(databaseColumn)) {
            result2.add(ReservedCellValue.COMPUTED);
        }
        if (!databaseColumn.isNotNull()) {
            result2.add(ReservedCellValue.NULL);
        }
        if (databaseColumn.getDefault() != null) {
            result2.add(ReservedCellValue.DEFAULT);
        }
        EnumSet<ReservedCellValue> enumSet = result2;
        if (enumSet == null) {
            DbImplUtil.$$$reportNull$$$0(76);
        }
        return enumSet;
    }

    @Nullable
    public static SearchPath getAutoSwitchPath(@Nullable LocalDataSource dataSource2, @Nullable SearchPath path) {
        SchemaControl control;
        if (path == null) {
            return null;
        }
        SchemaControl schemaControl = control = dataSource2 == null ? SchemaControl.AUTOMATIC : dataSource2.getSchemaControl();
        if (control == SchemaControl.AUTOMATIC) {
            return path;
        }
        return DbImplUtil.getDatabaseToSwitch(dataSource2, path);
    }

    @Nullable
    public static SearchPath getDatabaseToSwitch(@Nullable LocalDataSource dataSource2, @Nullable SearchPath path) {
        return path == null ? null : SearchPath.of(path.getCurrent().findParent(ObjectKind.DATABASE, false));
    }

    private static boolean isSuitable(@NotNull ColumnDescriptor descriptor2, @NotNull Dbms dbms) {
        if (descriptor2 == null) {
            DbImplUtil.$$$reportNull$$$0(77);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(78);
        }
        int type = descriptor2.getType();
        String typeName = descriptor2.getTypeName();
        return !(type == 2004 || type == 2005 || type == 2011 || StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"xml") && dbms.isMicrosoft() || type == 2009 && (dbms.isPostgres() || dbms.isOracle()) || dbms.isPostgres() && !PgBaseJdbcHelper.canCompare((String)typeName));
    }

    @NotNull
    public static String searchPathPresentation(List<ObjectPath> schemas) {
        StringBuilder res2 = new StringBuilder();
        int pos = 0;
        while (pos < schemas.size()) {
            if (res2.length() != 0) {
                res2.append("; ");
            }
            ObjectPath cur2 = schemas.get(pos);
            if (++pos < schemas.size() && cur2.parent != null && cur2.parent.equals(schemas.get((int)pos).parent)) {
                res2.append(cur2.parent.getDisplayName());
                res2.append(": ");
                res2.append(cur2.getName()).append(", ").append(schemas.get(pos).getName());
                ++pos;
                while (pos < schemas.size() && cur2.parent.equals(schemas.get((int)pos).parent)) {
                    res2.append(", ").append(schemas.get(pos).getName());
                    ++pos;
                }
                continue;
            }
            res2.append(cur2.getDisplayName());
        }
        String string = res2.toString();
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(79);
        }
        return string;
    }

    private static boolean isChildrenAccessible(@Nullable DasObject parent2, @NotNull DasObject child, Map<DasObject, Boolean> cache, Condition<? super DasObject> expandCondition) {
        if (child == null) {
            DbImplUtil.$$$reportNull$$$0(80);
        }
        if (parent2 == null || parent2.getKind() == ObjectKind.ROOT) {
            return true;
        }
        Boolean res2 = cache.get(parent2);
        if (res2 == null) {
            res2 = DbImplUtil.isChildrenAccessible(parent2.getDasParent(), parent2, cache, expandCondition) && expandCondition.value((Object)parent2);
            cache.put(parent2, res2);
        }
        return res2;
    }

    public static boolean processCandidates(JBIterable<DasObject> candidates2, Condition<? super DasObject> expandCondition, Processor<? super DasObject> processor2) {
        HashMap<DasObject, Boolean> cache = new HashMap<DasObject, Boolean>();
        for (DasObject candidate : candidates2) {
            if (!DbImplUtil.isChildrenAccessible(candidate.getDasParent(), candidate, cache, expandCondition) || processor2.process((Object)candidate)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static LocalDataSource getMaybeLocalDataSource(@Nullable DasDataSource info) {
        return (LocalDataSource)ObjectUtils.tryCast((Object)DbImplUtilCore.getMaybeLocalDataSource(info), LocalDataSource.class);
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@Nullable Dbms dbms) {
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.tryCast((Object)DbImplUtilCore.getDatabaseDialect(dbms), DatabaseDialectEx.class);
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(81);
        }
        return databaseDialectEx;
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbImplUtil.$$$reportNull$$$0(82);
        }
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbImplUtil.$$$reportNull$$$0(83);
        }
        SwingUtilities.invokeLater(runnable);
    }

    public static void invokeOnPooledThreadSync(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbImplUtil.$$$reportNull$$$0(84);
        }
        SecondaryLoop loop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
        Ref th = Ref.create();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                th.set((Object)e);
            }
            finally {
                DbImplUtil.invokeLater(() -> loop.exit());
            }
        });
        loop.enter();
        if (!th.isNull()) {
            ExceptionUtil.rethrow((Throwable)((Throwable)th.get()));
        }
    }

    private static /* synthetic */ boolean lambda$getWhereClauseColumns$3(Set set, ColumnDescriptor descriptor2) {
        return set.contains(descriptor2.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 16: 
            case 30: 
            case 33: 
            case 49: 
            case 50: 
            case 61: 
            case 62: 
            case 75: 
            case 76: 
            case 79: 
            case 81: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 16: 
            case 30: 
            case 33: 
            case 49: 
            case 50: 
            case 61: 
            case 62: 
            case 75: 
            case 76: 
            case 79: 
            case 81: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 15: 
            case 25: 
            case 48: 
            case 51: 
            case 65: 
            case 74: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 16: 
            case 30: 
            case 33: 
            case 49: 
            case 50: 
            case 61: 
            case 62: 
            case 75: 
            case 76: 
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbImplUtil";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 19: 
            case 21: 
            case 23: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defClazz";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromToken";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toToken";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionInfo";
                break;
            }
            case 34: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 36: 
            case 60: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 45: 
            case 52: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteConnection";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 67: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbImplUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findFreeAlias";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelHelper";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 33: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhereClauseColumns";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourcesForExec";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialValues";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "searchPathPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFreeAlias";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 16: 
            case 30: 
            case 33: 
            case 49: 
            case 50: 
            case 61: 
            case 62: 
            case 75: 
            case 76: 
            case 79: 
            case 81: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isConnected";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConnectionCount";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseConnection";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteProcessDown";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getModelHelper";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "clobFromFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "blobFromFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadViewDefinition";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadProcedureDefinition";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "replaceTokenInDefinition";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "supportsDynamicSchemaSwitching";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadPackageDefinition";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findSourceVirtualFile";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findDataVirtualFile";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "canSwitchTo";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathSql";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "switchSchemaThroughJdbc";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getWhereClauseColumns";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "supportsReadOnlyChangeOnTheFly";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "tryToSetReadOnly";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "supportsReadOnlyChangeDuringTx";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findDataSourceByFile";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "defaultWhereCondition";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getCount";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesForExec";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "composeWhereItemWithParameters";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "writeVFSAttributeSafe";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "readVFSAttributeSafe";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "writeVFSAttribute";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "setActionCallbackDone";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialValues";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isChildrenAccessible";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnPooledThreadSync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 16: 
            case 30: 
            case 33: 
            case 49: 
            case 50: 
            case 61: 
            case 62: 
            case 75: 
            case 76: 
            case 79: 
            case 81: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

