/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u001a-\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001H\u0086\u0004\u001a/\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0002\u0010\t\u001a*\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\n2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00050\b\u001a'\u0010\u000b\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\fH\u0086\u0004\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\n\u001aM\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u0010\"\b\b\u0000\u0010\u0011*\u00020\u0013\"\b\b\u0001\u0010\u0012*\u00020\u0013*\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u00102\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u0010H\u0086\u0004\u00a8\u0006\u0014"}, d2={"concat", "", "T", "that", "containsElements", "", "", "predicate", "Lkotlin/Function1;", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Z", "", "intersects", "", "toJB", "Lcom/intellij/util/containers/JBIterable;", "union", "", "K", "V", "", "intellij.database.core.impl"})
@JvmName(name="CollectionFun")
public final class CollectionFun {
    @NotNull
    public static final <T> JBIterable<T> toJB(@NotNull Iterable<? extends T> $this$toJB) {
        Intrinsics.checkNotNullParameter($this$toJB, (String)"$this$toJB");
        JBIterable jBIterable = JBIterable.from($this$toJB);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
        return jBIterable;
    }

    public static final <T> boolean intersects(@NotNull Set<? extends T> $this$intersects, @NotNull Set<? extends T> that) {
        Intrinsics.checkNotNullParameter($this$intersects, (String)"$this$intersects");
        Intrinsics.checkNotNullParameter(that, (String)"that");
        int n1 = $this$intersects.size();
        if (n1 == 0) {
            return false;
        }
        int n2 = that.size();
        if (n2 == 0) {
            return false;
        }
        if (n1 <= n2) {
            for (T element2 : $this$intersects) {
                if (!that.contains(element2)) continue;
                return true;
            }
        } else {
            for (T element3 : that) {
                if (!$this$intersects.contains(element3)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static final <K, V> Map<K, V> union(@NotNull Map<K, ? extends V> $this$union, @NotNull Map<K, ? extends V> that) {
        Intrinsics.checkNotNullParameter($this$union, (String)"$this$union");
        Intrinsics.checkNotNullParameter(that, (String)"that");
        int n1 = $this$union.size();
        int n2 = that.size();
        int n = n1 + n2;
        if (n == 0) {
            return MapsKt.emptyMap();
        }
        if (n2 == 0) {
            return $this$union;
        }
        if (n1 == 0) {
            return that;
        }
        HashMap<K, V> result2 = new HashMap<K, V>(n);
        result2.putAll($this$union);
        result2.putAll(that);
        return result2;
    }

    @NotNull
    public static final <T> List<T> concat(@NotNull List<? extends T> $this$concat, @NotNull List<? extends T> that) {
        Intrinsics.checkNotNullParameter($this$concat, (String)"$this$concat");
        Intrinsics.checkNotNullParameter(that, (String)"that");
        int nA = $this$concat.size();
        int nB = that.size();
        if (nB == 0) {
            return $this$concat;
        }
        if (nA == 0) {
            return that;
        }
        ArrayList result2 = new ArrayList(nA + nB);
        result2.addAll($this$concat);
        result2.addAll(that);
        return result2;
    }

    public static final <T> boolean containsElements(@NotNull Iterable<? extends T> $this$containsElements, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$containsElements, (String)"$this$containsElements");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        for (T o : $this$containsElements) {
            if (!((Boolean)predicate.invoke(o)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static final <T> boolean containsElements(@NotNull T[] $this$containsElements, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$containsElements, (String)"$this$containsElements");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        for (T o : $this$containsElements) {
            if (!((Boolean)predicate.invoke(o)).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

