/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.CompositeTextFun;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingNativeDefinitionTaskBuilder;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilderBase;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.script.generator.ui.ScriptFileLayoutPanel;
import com.intellij.database.script.generator.ui.ScriptGeneratorSettings;
import com.intellij.database.script.generator.ui.ScriptGeneratorTool;
import com.intellij.database.script.generator.ui.ScriptGeneratorUI;
import com.intellij.database.script.generator.ui.ScriptGeneratorUI$WhenMappings;
import com.intellij.database.script.generator.ui.ScriptOptionsPanel;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.content.Content;
import com.intellij.util.Function;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SingleAlarmKt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 j2\u00020\u0001:\u0003jklB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000205H\u0002J\u0010\u00107\u001a\u0002052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u00108\u001a\u000205H\u0002J\u001e\u00109\u001a\u0002052\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0002J\b\u0010?\u001a\u000205H\u0002J\b\u0010@\u001a\u000205H\u0002JB\u0010A\u001a\u00020B2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010:\u001a\u00020;2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00120D2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020F0D2\f\u0010G\u001a\b\u0012\u0002\b\u0003\u0018\u00010HH\u0002J\u0018\u0010A\u001a\u0004\u0018\u00010B2\f\u0010G\u001a\b\u0012\u0002\b\u0003\u0018\u00010HH\u0002J\b\u0010I\u001a\u000205H\u0016J.\u0010J\u001a\u0002HK\"\u0004\b\u0000\u0010K2\b\b\u0001\u0010L\u001a\u00020M2\u000e\b\u0004\u0010N\u001a\b\u0012\u0004\u0012\u0002HK0OH\u0082\b\u00a2\u0006\u0002\u0010PJ\u0014\u0010Q\u001a\u0004\u0018\u00010R2\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\u001c\u0010S\u001a\u0002052\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=J\u0016\u0010T\u001a\u0002052\f\u0010U\u001a\b\u0012\u0004\u0012\u0002050OH\u0002J\b\u0010V\u001a\u000205H\u0002J\b\u0010W\u001a\u000205H\u0002J\b\u0010X\u001a\u000205H\u0002J\"\u0010Y\u001a\u00020\u00162\u0006\u0010Z\u001a\u00020\u00162\b\u0010[\u001a\u0004\u0018\u00010M2\u0006\u0010\\\u001a\u00020RH\u0002J\b\u0010]\u001a\u000205H\u0002J(\u0010^\u001a\u0014\u0012\u0004\u0012\u00020F\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0`0_2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020F0DH\u0002J(\u0010b\u001a\u0014\u0012\u0004\u0012\u00020F\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0`0_2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020F0DH\u0002J\b\u0010c\u001a\u000205H\u0002J\b\u0010d\u001a\u000205H\u0002J\b\u0010e\u001a\u000205H\u0002J\b\u0010f\u001a\u000205H\u0002J(\u0010g\u001a\u0012\u0012\u0004\u0012\u0002HK0hj\b\u0012\u0004\u0012\u0002HK`i\"\u0004\b\u0000\u0010K*\b\u0012\u0004\u0012\u0002HK0\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010+\u001a\n -*\u0004\u0018\u00010,0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u000201X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006m"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "category", "Lcom/intellij/database/script/generator/ScriptCategory;", "categorySelector", "Lcom/intellij/openapi/ui/ComboBox;", "content", "Lcom/intellij/ui/content/Content;", "getContent$intellij_database_impl", "()Lcom/intellij/ui/content/Content;", "setContent$intellij_database_impl", "(Lcom/intellij/ui/content/Content;)V", "currentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "document", "Lcom/intellij/openapi/editor/Document;", "generatedText", "Lcom/intellij/database/script/CompositeText;", "generationInProgress", "Ljava/lang/Object;", "layoutPanel", "Lcom/intellij/database/script/generator/ui/ScriptFileLayoutPanel;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel$intellij_database_impl", "()Ljavax/swing/JPanel;", "optionsPanel", "Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "scriptingOptions", "Lcom/intellij/database/script/generator/ScriptingOptions;", "selection", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$Selection;", "settings", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorSettings;", "kotlin.jvm.PlatformType", "toRequestFocus", "Ljava/util/concurrent/atomic/AtomicBoolean;", "viewer", "Lcom/intellij/ui/EditorTextField;", "getViewer$intellij_database_impl", "()Lcom/intellij/ui/EditorTextField;", "adjustCategories", "", "adjustOptionsUI", "assignCategory", "assignOptionsFromSettings", "assignSelection", "model", "Lcom/intellij/database/model/basic/BasicModel;", "nodes", "", "Lcom/intellij/database/model/basic/BasicNode;", "clear", "copyToClipboard", "createTask", "Lcom/intellij/database/script/generator/ScriptingTask;", "schemasToGenerate", "", "objectsToGenerate", "Lcom/intellij/database/model/basic/BasicElement;", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "dispose", "doing", "T", "message", "", "operation", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "findDsForModel", "Lcom/intellij/database/dataSource/LocalDataSource;", "generate", "inUI", "block", "openInConsole", "prepareDocument", "processOptionChange", "reformatCompositeText", "compositeText", "comment", "dataSource", "regenerate", "retrieveNativeDefinitionsForElements", "", "", "elements", "retrieveNativeDefinitionsForElementsInternal", "saveOutputSettings", "saveToFile", "showTheScript", "showTheScriptInsideUI", "getItems", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "Companion", "FinalAction", "Selection", "intellij.database.impl"})
public final class ScriptGeneratorUI
implements Disposable {
    public Content content;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final EditorTextField viewer;
    private final JBLoadingPanel loadingPanel;
    private final ComboBox<ScriptCategory> categorySelector;
    private ScriptOptionsPanel optionsPanel;
    private ScriptFileLayoutPanel layoutPanel;
    private final SingleAlarm alarm;
    private final ScriptGeneratorSettings settings;
    private Selection selection;
    private ScriptCategory category;
    private final Object generationInProgress;
    private final AtomicBoolean toRequestFocus;
    private CompositeText generatedText;
    private BasicSchema currentSchema;
    private ScriptingOptions scriptingOptions;
    private Document document;
    private PsiFile psiFile;
    @NotNull
    private final Project project;
    @NotNull
    private static final Application application;
    @NotNull
    private static final Key<ScriptGeneratorUI> contextKey;
    @NotNull
    private static final Key<BasicModel> modelKey;
    @NotNull
    private static final List<ScriptCategory> implementedCategories;
    @NotNull
    private static final Logger log;
    @Nullable
    private static String lastPath;
    @NotNull
    private static final Map<CompositeText.Kind, CompositeText.Kind> formattableKindRemapping;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Content getContent$intellij_database_impl() {
        Content content = this.content;
        if (content == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
        }
        return content;
    }

    public final void setContent$intellij_database_impl(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"<set-?>");
        this.content = content;
    }

    @NotNull
    public final JPanel getMainPanel$intellij_database_impl() {
        return this.mainPanel;
    }

    @NotNull
    public final EditorTextField getViewer$intellij_database_impl() {
        return this.viewer;
    }

    public final void generate(@NotNull BasicModel model, @NotNull Iterable<? extends BasicNode> nodes2) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
                this.alarm.cancel();
                this.assignSelection(model, nodes2);
                this.adjustCategories();
                this.assignOptionsFromSettings();
                this.adjustOptionsUI();
                Object object = this.selection;
                if (object == null || (object = ((Selection)object).getElements()) == null) break block2;
                Object object2 = object;
                boolean bl = false;
                if (!object2.isEmpty()) break block3;
            }
            this.clear();
            return;
        }
        this.toRequestFocus.set(true);
        SingleAlarm.cancelAndRequest$default((SingleAlarm)this.alarm, (boolean)false, (int)1, null);
    }

    private final void saveOutputSettings() {
        this.settings.setOutputPath(this.layoutPanel.getPath());
        this.settings.setOutputLayout(this.layoutPanel.getLayout());
    }

    /*
     * WARNING - void declaration
     */
    private final void assignSelection(BasicModel model, Iterable<? extends BasicNode> nodes2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable<? extends BasicNode> iterable = nodes2;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BasicElement basicElement;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            BasicNode it2 = (BasicNode)element$iv$iv;
            boolean bl2 = false;
            BasicNode basicNode = it2;
            if (!(basicNode instanceof BasicElement)) {
                basicNode = null;
            }
            if ((BasicElement)basicNode == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            BasicElement it$iv$iv = basicElement;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elements = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        this.selection = new Selection(model, elements);
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustCategories() {
        void $this$filterTo$iv$iv;
        Object object = this.selection;
        if (object == null || (object = ((Selection)object).getModel()) == null || (object = object.getDbms()) == null) {
            object = Dbms.UNKNOWN;
        }
        Object dbms = object;
        Iterable $this$filter$iv = implementedCategories;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ScriptCategory it2 = (ScriptCategory)((Object)element$iv$iv);
            boolean bl = false;
            if (!it2.getApplicableDbs().value(dbms)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Collection collection = list;
        ArrayList needCategories = new ArrayList(collection);
        ArrayList<ScriptCategory> existentCategories = this.getItems(this.categorySelector);
        if (Intrinsics.areEqual(needCategories, existentCategories)) {
            return;
        }
        ScriptCategory savedCategory = this.category;
        this.categorySelector.removeAllItems();
        if (needCategories.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = needCategories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScriptCategory it3 = (ScriptCategory)((Object)element$iv);
            boolean bl = false;
            this.categorySelector.addItem((Object)it3);
        }
        if (needCategories.contains((Object)savedCategory)) {
            this.categorySelector.setSelectedItem((Object)savedCategory);
            this.assignCategory(savedCategory);
        } else {
            this.categorySelector.setSelectedIndex(0);
            this.assignCategory((ScriptCategory)((Object)CollectionsKt.first((List)needCategories)));
        }
    }

    private final void assignCategory(ScriptCategory category) {
        this.category = category;
        this.assignOptionsFromSettings();
    }

    private final void assignOptionsFromSettings() {
        Object object = this.selection;
        Dbms rdbms = object != null && (object = ((Selection)object).getModel()) != null ? object.getDbms() : null;
        CustomScriptingOptions customScriptingOptions = rdbms != null ? this.settings.get(rdbms, this.category) : null;
        this.scriptingOptions = customScriptingOptions != null ? (ScriptingOptions)customScriptingOptions : (ScriptingOptions)DefaultScriptingOptions.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustOptionsUI() {
        ScriptingTask scriptingTask;
        ScriptOptionsPanel scriptOptionsPanel = this.optionsPanel;
        Object object = this.selection;
        if (object != null && (object = ((Selection)object).getModel()) != null) {
            void it2;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object object3 = object2;
            ScriptOptionsPanel scriptOptionsPanel2 = scriptOptionsPanel;
            boolean bl3 = false;
            boolean bl4 = false;
            bl4 = false;
            ScriptingTask scriptingTask2 = this.createTask(this.category, (BasicModel)it2, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null);
            scriptOptionsPanel = scriptOptionsPanel2;
            scriptingTask = scriptingTask2;
        } else {
            scriptingTask = null;
        }
        scriptOptionsPanel.adjustOptionsUI(scriptingTask, this.scriptingOptions);
    }

    private final void processOptionChange() {
        Dbms rdbms;
        ScriptingOptions newOptions;
        this.scriptingOptions = newOptions = this.optionsPanel.gatherOptions();
        Object object = this.selection;
        Dbms dbms = object != null && (object = ((Selection)object).getModel()) != null ? object.getDbms() : (rdbms = null);
        if (rdbms != null) {
            ScriptingOptions scriptingOptions = newOptions;
            if (!(scriptingOptions instanceof CustomScriptingOptions)) {
                scriptingOptions = null;
            }
            this.settings.set(rdbms, this.category, (CustomScriptingOptions)scriptingOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void regenerate() {
        ScriptingTask scriptingTask = this.createTask(null);
        if (scriptingTask == null) {
            return;
        }
        ScriptingTask task2 = scriptingTask;
        Object object = this.selection;
        if (object == null || (object = ((Selection)object).getModel()) == null) {
            return;
        }
        Object model = object;
        Companion.invokeLater((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$getLoadingPanel$p(this.this$0).startLoading();
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }));
        Object object2 = this.generationInProgress;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object2) {
            boolean bl3 = false;
            ScriptingResult result2 = ScriptGenerators.INSTANCE.makeScript(this.project, task2);
            CompositeText gt = result2.getScript();
            if (this.scriptingOptions.get(ScriptingOptionStatic.REFORMAT).booleanValue()) {
                BasicElement any;
                LocalDataSource dataSource2 = this.findDsForModel((BasicModel)model);
                Object object3 = this.selection;
                BasicElement basicElement = object3 != null && (object3 = ((Selection)object3).getElements()) != null ? (BasicElement)CollectionsKt.firstOrNull((Iterable)((Iterable)object3)) : (any = null);
                if (dataSource2 != null) {
                    ObjectPath objectPath = BasicPaths.of(any);
                    gt = this.reformatCompositeText(gt, objectPath != null ? objectPath.getDisplayName() : null, dataSource2);
                }
            }
            this.generatedText = gt;
            BasicSchema basicSchema = task2.getCurrentSchema();
            if (basicSchema == null) {
                BasicRoot basicRoot = model.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"model.root");
                BasicDatabase basicDatabase = basicRoot.getCurrentDatabase();
                basicSchema = basicDatabase != null ? ModelFun.getCurrentSchema(basicDatabase) : null;
            }
            this.currentSchema = basicSchema;
            Unit unit = Unit.INSTANCE;
        }
        this.showTheScript();
    }

    private final ScriptingTask createTask(ScriptConsumer<?> consumer2) {
        Selection selection = this.selection;
        if (selection == null) {
            return null;
        }
        Selection selection2 = selection;
        ScriptCategory category = this.category;
        JBIterable jBIterable = JBIterable.from((Iterable)selection2.getElements());
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(selection.elements)");
        JBIterable sel = jBIterable;
        JBIterable jBIterable2 = sel.filter(BasicDatabase.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"sel.filter(BasicDatabase::class.java)");
        JBIterable explicitDatabases = jBIterable2;
        JBIterable jBIterable3 = sel.filter(BasicSchema.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"sel.filter(BasicSchema::class.java)");
        JBIterable explicitSchemas = jBIterable3;
        JBIterable jBIterable4 = sel.filter(BasicElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"sel.filter(BasicElement::class.java)");
        JBIterable explicitScriptableObjects = jBIterable4;
        List list = explicitDatabases.flatten((Function)createTask.schemasToGenerate.1.INSTANCE).append((Iterable)explicitSchemas).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"explicitDatabases.flatte\u2026explicitSchemas).toList()");
        List schemasToGenerate2 = list;
        List list2 = explicitScriptableObjects.filter(new Condition(schemasToGenerate2){
            final /* synthetic */ List $schemasToGenerate;

            public final boolean value(BasicElement it2) {
                BasicElement basicElement = it2;
                Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"it");
                return !this.$schemasToGenerate.contains(basicElement.getSchema());
            }
            {
                this.$schemasToGenerate = list;
            }
        }).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"explicitScriptableObject\u2026emasToGenerate }.toList()");
        List objectsToGenerate2 = list2;
        return this.createTask(category, selection2.getModel(), schemasToGenerate2, objectsToGenerate2, consumer2);
    }

    private final ScriptingTask createTask(ScriptCategory category, BasicModel model, List<? extends BasicSchema> schemasToGenerate2, List<? extends BasicElement> objectsToGenerate2, ScriptConsumer<?> consumer2) {
        BasicSchema schema;
        ScriptingSingleModelTaskBuilderBase scriptingSingleModelTaskBuilderBase;
        ScriptingSingleModelTaskBuilderBase $this$apply;
        boolean bl;
        boolean bl2;
        ScriptingSingleModelTaskBuilderBase scriptingSingleModelTaskBuilderBase2;
        switch (ScriptGeneratorUI$WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
            case 1: {
                scriptingSingleModelTaskBuilderBase2 = new ScriptingNativeDefinitionTaskBuilder(model);
                bl2 = false;
                bl = false;
                $this$apply = scriptingSingleModelTaskBuilderBase2;
                boolean bl3 = false;
                ((ScriptingNativeDefinitionTaskBuilder)$this$apply).setNativeDefinitionsRetriever((Function1<? super List<? extends BasicElement>, ? extends Map<BasicElement, String[]>>)((Function1)new Function1<List<? extends BasicElement>, Map<BasicElement, ? extends String[]>>(this){

                    @NotNull
                    public final Map<BasicElement, String[]> invoke(@NotNull List<? extends BasicElement> p1) {
                        Intrinsics.checkNotNullParameter(p1, (String)"p1");
                        return ScriptGeneratorUI.access$retrieveNativeDefinitionsForElements((ScriptGeneratorUI)this.receiver, p1);
                    }
                }));
                scriptingSingleModelTaskBuilderBase = scriptingSingleModelTaskBuilderBase2;
                break;
            }
            default: {
                scriptingSingleModelTaskBuilderBase = new ScriptingSingleModelTaskBuilder(model, category);
            }
        }
        scriptingSingleModelTaskBuilderBase2 = scriptingSingleModelTaskBuilderBase;
        bl2 = false;
        bl = false;
        $this$apply = scriptingSingleModelTaskBuilderBase2;
        boolean bl4 = false;
        BasicSchema basicSchema = schema = schemasToGenerate2.size() == 1 ? schemasToGenerate2.get(0) : null;
        if (category == ScriptCategory.CREATE_DEFINITION) {
            $this$apply.getElements().addAll((Collection<BasicElement>)schemasToGenerate2);
            $this$apply.getElements().addAll((Collection<BasicElement>)objectsToGenerate2);
        } else {
            ScriptGenerator gen = ScriptGenerators.INSTANCE.byModel(model);
            JBIterable jBIterable = JBIterable.from((Iterable)schemasToGenerate2).flatten((Function)createTask.2.objects.1.INSTANCE).append((Iterable)objectsToGenerate2);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(schemasT\u2026append(objectsToGenerate)");
            JBIterable objects2 = jBIterable;
            Object object = createTask.2.1.INSTANCE;
            if (object != null) {
                Function1 function1 = object;
                object = new Function(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    public final /* synthetic */ Object fun(Object p0) {
                        return this.function.invoke(p0);
                    }
                };
            }
            Intrinsics.checkNotNullExpressionValue((Object)((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from((Function)((Function)object)).withRoots((Iterable)objects2)).expandAndSkip(new Condition($this$apply, gen, this, schemasToGenerate2, category, objectsToGenerate2, model, consumer2){
                final /* synthetic */ ScriptingSingleModelTaskBuilderBase $this_apply;
                final /* synthetic */ ScriptGenerator $gen;
                final /* synthetic */ ScriptGeneratorUI this$0;
                final /* synthetic */ List $schemasToGenerate$inlined;
                final /* synthetic */ ScriptCategory $category$inlined;
                final /* synthetic */ List $objectsToGenerate$inlined;
                final /* synthetic */ BasicModel $model$inlined;
                final /* synthetic */ ScriptConsumer $consumer$inlined;
                {
                    this.$this_apply = scriptingSingleModelTaskBuilderBase;
                    this.$gen = scriptGenerator;
                    this.this$0 = scriptGeneratorUI;
                    this.$schemasToGenerate$inlined = list;
                    this.$category$inlined = scriptCategory;
                    this.$objectsToGenerate$inlined = list2;
                    this.$model$inlined = basicModel;
                    this.$consumer$inlined = scriptConsumer;
                }

                public final boolean value(BasicElement it2) {
                    BasicElement basicElement = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"it");
                    return this.$gen.capabilities(basicElement).get(this.$category$inlined).get(this.$this_apply.getVersion()) == false;
                }
            })).traverse().collect($this$apply.getElements()), (String)"JBTreeTraverser.from(Bas\u2026       .collect(elements)");
        }
        $this$apply.setCurrentSchema(schema);
        $this$apply.setOptions(this.scriptingOptions);
        LocalDataSource localDataSource = this.findDsForModel(model);
        if (localDataSource != null) {
            LocalDataSource localDataSource2 = localDataSource;
            boolean bl5 = false;
            boolean bl6 = false;
            LocalDataSource it2 = localDataSource2;
            boolean bl7 = false;
            $this$apply.setCodeStyleFrom(it2);
        }
        $this$apply.setConsumer(consumer2);
        return scriptingSingleModelTaskBuilderBase2.build();
    }

    private final CompositeText reformatCompositeText(CompositeText compositeText, String comment, LocalDataSource dataSource2) {
        if (compositeText.getLength() > FileUtilRt.getUserFileSizeLimit()) {
            return compositeText;
        }
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(dataSource2);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dataSource)");
        SqlLanguageDialect dialect = sqlLanguageDialect;
        CompositeText newCompositeText = CompositeTextFun.remapFragmentKinds(compositeText, formattableKindRemapping);
        CodeStyleSettings codeStyleSettings = SqlCodeStyles.getSettings((Project)this.project, (String)ScriptingTaskBuilderKt.getCodeStyleName(dataSource2));
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"SqlCodeStyles.getSetting\u2026odeStyleName(dataSource))");
        CodeStyleSettings codeStyle = codeStyleSettings;
        PersistentMarkup persistentMarkup = DbSrcUtilsCore.formatCompositeText(this.project, dialect, comment, newCompositeText, codeStyle);
        Intrinsics.checkNotNullExpressionValue((Object)persistentMarkup, (String)"DbSrcUtilsCore.formatCom\u2026CompositeText, codeStyle)");
        return persistentMarkup;
    }

    private final void showTheScript() {
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$prepareDocument(this.this$0);
                ScriptGeneratorUI.access$showTheScriptInsideUI(this.this$0);
                ScriptGeneratorUI.access$getLoadingPanel$p(this.this$0).stopLoading();
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }));
    }

    private final void prepareDocument() {
        Document document;
        Selection selection = this.selection;
        if (selection == null) {
            return;
        }
        Selection selection2 = selection;
        BasicModel model = selection2.getModel();
        Document document2 = this.document;
        if ((document2 != null ? (BasicModel)document2.getUserData(modelKey) : null) == model) {
            return;
        }
        LocalDataSource localDataSource = this.findDsForModel(model);
        if (localDataSource == null) {
            return;
        }
        LocalDataSource dataSource2 = localDataSource;
        DbDataSource dbDataSource = DbPsiFacadeImpl.getInstance(this.project).findDataSource(dataSource2.getUniqueId());
        if (dbDataSource == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"DbPsiFacadeImpl.getInsta\u2026ource.uniqueId) ?: return");
        DbDataSource dbDataSource2 = dbDataSource;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(dataSource2);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dataSource)");
        SqlLanguageDialect language = sqlLanguageDialect;
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText("generated.sql", (Language)language, (CharSequence)"");
        DatabaseDataKeys.DATA_SOURCE_KEY.set((UserDataHolder)psiFile, (Object)dbDataSource2);
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)ObjectPaths.searchPathOf(this.currentSchema));
        this.psiFile = psiFile;
        Document document3 = document = PsiDocumentManager.getInstance((Project)this.project).getDocument(psiFile);
        Intrinsics.checkNotNull((Object)document3);
        document3.putUserData(modelKey, (Object)model);
        this.document = document;
    }

    private final void showTheScriptInsideUI() {
        block4: {
            Document document = this.document;
            if (document == null) {
                String string = "The document is not prepared";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Document document2 = document;
            document2.setReadOnly(false);
            Object object = this.generatedText;
            if (object == null || (object = object.getText()) == null || (object = object.toString()) == null) {
                object = "";
            }
            document2.setText((CharSequence)StringUtil.convertLineSeparators((String)object));
            document2.setReadOnly(true);
            if (this.viewer.getDocument() != document2) {
                this.viewer.setDocument(document2);
            }
            this.viewer.setVisible(true);
            Editor editor = this.viewer.getEditor();
            if (!(editor instanceof EditorImpl)) {
                editor = null;
            }
            EditorImpl editorImpl = (EditorImpl)editor;
            if (editorImpl == null) break block4;
            editorImpl.setCaretEnabled(true);
        }
    }

    private final void copyToClipboard() {
        CompositeText compositeText = this.generatedText;
        if (compositeText == null) {
            return;
        }
        CompositeText generatedText = compositeText;
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(((Object)generatedText.getText()).toString()));
    }

    private final void saveToFile() {
        String string;
        CompositeText compositeText = this.generatedText;
        if (compositeText == null) {
            return;
        }
        CompositeText generatedText = compositeText;
        if (lastPath != null) {
            String string2 = lastPath;
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else if (StringsKt.equals((String)this.project.getName(), (String)"default", (boolean)true)) {
            string = System.getProperty("user.home");
            if (string == null) {
                string = "";
            }
        } else {
            String string3 = this.project.getBasePath();
            if (string3 == null) {
                string3 = "";
            }
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"project.basePath ?: \"\"");
        }
        String path = string;
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(DatabaseBundle.message("scriptGen.ui.dialog.title.selectFileToSaveScript", new Object[0]), "", new String[]{"sql"});
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"FileChooserFactory.getIn\u2026alog(descriptor, project)");
        FileSaverDialog chooser = fileSaverDialog;
        VirtualFile virtualBaseDir = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
        VirtualFileWrapper virtualFileWrapper = chooser.save(virtualBaseDir, "script.sql");
        if (virtualFileWrapper == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileWrapper, (String)"chooser.save(virtualBase\u2026, \"script.sql\") ?: return");
        VirtualFileWrapper fileWrapper = virtualFileWrapper;
        File file = fileWrapper.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"fileWrapper.file");
        File file2 = file;
        lastPath = file2.getParent();
        try {
            Files.write(Paths.get(file2.getPath(), new String[0]), (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)generatedText.getText()), new OpenOption[0]);
        }
        catch (Exception e) {
            String message2 = "Failed to save SQL script into a file \"" + file2.getAbsolutePath() + ": exception " + e.getClass().getSimpleName() + ": " + e.getMessage();
            log.warn(message2, (Throwable)e);
        }
    }

    private final void openInConsole() {
        CompositeText compositeText = this.generatedText;
        if (compositeText == null) {
            return;
        }
        CompositeText generatedText = compositeText;
        Selection selection = this.selection;
        LocalDataSource localDataSource = this.findDsForModel(selection != null ? selection.getModel() : null);
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ds = localDataSource;
        VirtualFile virtualFile = DatabaseEditorHelper.createNewConsoleVirtualFile(ds);
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"DatabaseEditorHelper.cre\u2026VirtualFile(ds) ?: return");
        VirtualFile virtualFile2 = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026nt(virtualFile) ?: return");
        Document document2 = document;
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(document2, generatedText){
            final /* synthetic */ Document $document;
            final /* synthetic */ CompositeText $generatedText;

            public final void run() {
                this.$document.setText((CharSequence)StringUtil.convertLineSeparators((String)((Object)this.$generatedText.getText()).toString()));
            }
            {
                this.$document = document;
                this.$generatedText = compositeText;
            }
        });
        DatabaseEditorHelper.openConsoleForFile(this.project, ds, null, virtualFile2);
    }

    private final LocalDataSource findDsForModel(BasicModel model) {
        Object v4;
        Object v3;
        block3: {
            if (model == null) {
                return null;
            }
            DataSourceStorage dataSourceStorage = DataSourceStorage.getProjectStorage(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)dataSourceStorage, (String)"com.intellij.database.da\u2026etProjectStorage(project)");
            List<LocalDataSource> list = dataSourceStorage.getDataSources();
            Intrinsics.checkNotNullExpressionValue(list, (String)"com.intellij.database.da\u2026oject)\n      .dataSources");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LocalDataSource ds = (LocalDataSource)element$iv;
                boolean bl = false;
                LocalDataSource localDataSource = ds;
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"ds");
                if (!Intrinsics.areEqual((Object)localDataSource.getModel(), (Object)model)) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = v4 = null;
        }
        if (!(v3 instanceof LocalDataSource)) {
            v4 = null;
        }
        return v4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<BasicElement, String[]> retrieveNativeDefinitionsForElements(List<? extends BasicElement> elements) {
        Map map2;
        void this_$iv;
        int n = elements.size();
        if (n == 0) {
            return MapsKt.emptyMap();
        }
        ScriptGeneratorUI scriptGeneratorUI = this;
        String string = DatabaseBundle.message("retrieving.native.definitions.for.0.1.choice.0.element.1.elements", n, n == 1 ? 0 : 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"retrieving.nati\u2026 n, if (n == 1) 0 else 1)");
        String message$iv = string;
        boolean $i$f$doing = false;
        ((ScriptGeneratorUI)this_$iv).loadingPanel.setLoadingText(message$iv);
        try {
            boolean bl = false;
            map2 = this.retrieveNativeDefinitionsForElementsInternal(elements);
        }
        finally {
            ((ScriptGeneratorUI)this_$iv).loadingPanel.setLoadingText(Companion.getNormalLoadingPanelText());
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<BasicElement, String[]> retrieveNativeDefinitionsForElementsInternal(List<? extends BasicElement> elements) {
        Selection selection = this.selection;
        Intrinsics.checkNotNull((Object)selection);
        BasicModel model = selection.getModel();
        LocalDataSource dataSource2 = this.findDsForModel(model);
        if (dataSource2 == null) {
            Map map2 = JBIterable.from((Iterable)elements).toMap((Convertor)retrieveNativeDefinitionsForElementsInternal.1.INSTANCE, (Convertor)retrieveNativeDefinitionsForElementsInternal.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"JBIterable.from(elements\u2026taSource not found :(\")})");
            return map2;
        }
        Map result2 = null;
        AutoCloseable autoCloseable = DatabaseSessionManager.facade$default(this.project, dataSource2, null, null, null, DGDepartment.CODE_GENERATION, 24, null).connect();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            GuardedRef c2 = (GuardedRef)autoCloseable;
            boolean bl3 = false;
            ModelFactory modelFactory = new ModelFactory(BlackHoleTextStorage.INSTANCE);
            Object t = c2.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"c.get()");
            DBIntrospector introspector = DBIntrospectorFactory.createIntrospector(this.project, modelFactory, (DatabaseConnectionCore)t, dataSource2);
            Object t2 = c2.get();
            Intrinsics.checkNotNullExpressionValue(t2, (String)"c.get()");
            introspector.attachToDB((DatabaseConnectionCore)t2);
            BasicModel basicModel = model;
            if (basicModel == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModModel");
            }
            BasicModModel basicModModel = (BasicModModel)basicModel;
            String string = dataSource2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataSource.uniqueId");
            introspector.init(basicModModel, string);
            result2 = introspector.introspectNativeDefinitions((Iterable<? extends BasicElement>)elements, false);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Map map3 = result2;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        return map3;
    }

    private final void clear() {
        this.generatedText = null;
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$setDocument$p(this.this$0, null);
                this.this$0.getViewer$intellij_database_impl().getDocument().setText((CharSequence)"");
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }));
    }

    public void dispose() {
        Content content = this.content;
        if (content == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
        }
        content.putUserData(contextKey, null);
        this.loadingPanel.removeAll();
        ScriptGeneratorTool.INSTANCE.forgetProjectToolWindow$intellij_database_impl(this.project);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> ArrayList<T> getItems(ComboBox<T> $this$getItems) {
        int n = $this$getItems.getItemCount();
        ArrayList<Object> list = new ArrayList<Object>(n);
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void i2;
            list.add($this$getItems.getItemAt((int)i2));
            ++i2;
        }
        return list;
    }

    private final void inUI(Function0<Unit> block) {
        Companion.invokeLater((Function0<Unit>)((Function0)new Function0<Unit>(block){
            final /* synthetic */ Function0 $block;

            public final void invoke() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                    final /* synthetic */ inUI.1 this$0;

                    public final void run() {
                        this.this$0.$block.invoke();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$block = function0;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T doing(@Nls String message2, Function0<? extends T> operation) {
        int $i$f$doing = 0;
        this.loadingPanel.setLoadingText(message2);
        try {
            Object object = operation.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.loadingPanel.setLoadingText(Companion.getNormalLoadingPanelText());
            InlineMarker.finallyEnd((int)1);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public ScriptGeneratorUI(@NotNull Project project) {
        void $this$apply;
        Object $this$apply2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.alarm = SingleAlarmKt.pooledThreadSingleAlarm$default((int)250, null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$regenerate(this.this$0);
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }), (int)2, null);
        this.settings = (ScriptGeneratorSettings)this.project.getService(ScriptGeneratorSettings.class);
        this.category = ScriptCategory.CREATE_COMPLETE;
        this.generationInProgress = new Object();
        this.toRequestFocus = new AtomicBoolean(false);
        this.scriptingOptions = DefaultScriptingOptions.INSTANCE;
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        boolean bl = false;
        boolean bl2 = false;
        Document document2 = document;
        ScriptGeneratorUI scriptGeneratorUI = this;
        boolean bl3 = false;
        $this$apply2.setReadOnly(true);
        Unit unit = Unit.INSTANCE;
        scriptGeneratorUI.document = document;
        this.viewer = new EditorTextField(this.document, this.project, null, true, false);
        this.viewer.setFontInheritedFromLAF(false);
        this.viewer.addSettingsProvider(new EditorSettingsProvider(){

            public final void customizeSettings(EditorEx editor) {
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
                EditorEx editorEx = editor;
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"editor");
                PsiFile psiFile = psiDocumentManager.getPsiFile((Document)editorEx.getDocument());
                if (psiFile != null) {
                    DatabaseDialogsHelper.setSpecificSyntaxHighlighter(this.getProject(), psiFile.getLanguage(), editor, psiFile.getVirtualFile());
                }
                editor.setHorizontalScrollbarVisible(true);
                editor.setVerticalScrollbarVisible(true);
                editor.setBorder((Border)JBUI.Borders.empty());
                EditorSettings editorSettings = editor.getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
                EditorSettings settings = editorSettings;
                settings.setWheelFontChangeEnabled(true);
                settings.setFoldingOutlineShown(true);
                settings.setAdditionalLinesCount(2);
                settings.setUseSoftWraps(false);
                settings.setLineNumbersShown(true);
                settings.setAnimatedScrolling(true);
            }
        });
        document = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        bl = false;
        bl2 = false;
        $this$apply2 = document;
        scriptGeneratorUI = this;
        boolean bl4 = false;
        $this$apply2.add((Component)this.viewer, (Object)"Center");
        $this$apply2.setLoadingText(Companion.getNormalLoadingPanelText());
        unit = Unit.INSTANCE;
        scriptGeneratorUI.loadingPanel = document;
        Collection $this$toTypedArray$iv = implementedCategories;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv22 = $this$toTypedArray$iv;
        ScriptCategory[] scriptCategoryArray = thisCollection$iv22.toArray(new ScriptCategory[0]);
        if (scriptCategoryArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $this$toTypedArray$iv = new ComboBox((Object[])scriptCategoryArray);
        $i$f$toTypedArray22 = false;
        boolean thisCollection$iv22 = false;
        $this$apply2 = $this$toTypedArray$iv;
        scriptGeneratorUI = this;
        boolean bl5 = false;
        $this$apply2.setEditable(false);
        $this$apply2.setSelectedItem((Object)this.category);
        $this$apply2.addActionListener(new ActionListener((ComboBox)$this$apply2, this){
            final /* synthetic */ ComboBox $this_apply;
            final /* synthetic */ ScriptGeneratorUI this$0;
            {
                this.$this_apply = comboBox;
                this.this$0 = scriptGeneratorUI;
            }

            public final void actionPerformed(ActionEvent it2) {
                ScriptCategory selectedCategory;
                Object object = this.$this_apply.getSelectedItem();
                if (!(object instanceof ScriptCategory)) {
                    object = null;
                }
                if ((selectedCategory = (ScriptCategory)((Object)object)) != null) {
                    ScriptGeneratorUI.access$assignCategory(this.this$0, selectedCategory);
                    ScriptGeneratorUI.access$adjustOptionsUI(this.this$0);
                    SingleAlarm.cancelAndRequest$default((SingleAlarm)ScriptGeneratorUI.access$getAlarm$p(this.this$0), (boolean)false, (int)1, null);
                }
            }
        });
        unit = Unit.INSTANCE;
        scriptGeneratorUI.categorySelector = $this$toTypedArray$iv;
        this.optionsPanel = new ScriptOptionsPanel((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.processOptionChange();
                SingleAlarm.cancelAndRequest$default((SingleAlarm)alarm, (boolean)false, (int)1, null);
            }
        }));
        this.layoutPanel = new ScriptFileLayoutPanel(this.project, (Function1)new Function1<ScriptConsumer<?>, Unit>(){

            public final void invoke(@NotNull ScriptConsumer<?> it2) {
                Intrinsics.checkNotNullParameter(it2, (String)"it");
                ScriptingTask scriptingTask = this.createTask(it2);
                if (scriptingTask == null) {
                    return;
                }
                ScriptingTask task2 = scriptingTask;
                ScriptGenerators.INSTANCE.makeScript(this.getProject(), task2);
                this.saveOutputSettings();
            }
        });
        this.layoutPanel.setPath(this.settings.getOutputPath());
        this.layoutPanel.setLayout(this.settings.getOutputLayout());
        JPanel $i$f$toTypedArray22 = new JPanel((LayoutManager)new VerticalLayout(4), false);
        thisCollection$iv22 = false;
        boolean $this$apply22 = false;
        JPanel $this$apply3 = $i$f$toTypedArray22;
        boolean bl6 = false;
        String string = DatabaseBundle.message("scriptGen.ui.selectCategory.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"scriptGen.ui.selectCategory.label\")");
        $this$apply3.add(new ScriptOptionsPanel.LabeledComponent(string, (JComponent)this.categorySelector));
        $this$apply3.add(this.optionsPanel.getComponent());
        JPanel optionsInnerPanel = $i$f$toTypedArray22;
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)optionsInnerPanel, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"ScrollPaneFactory.create\u2026(optionsInnerPanel, true)");
        JScrollPane optionsScrollPane = jScrollPane;
        optionsScrollPane.setVerticalScrollBarPolicy(20);
        optionsScrollPane.setHorizontalScrollBarPolicy(31);
        String string2 = DatabaseBundle.message("scriptGen.ui.sidePanel.copyToClipboard", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"scriptGen.ui.sidePanel.copyToClipboard\")");
        FinalAction copyToClipboardAction2 = new FinalAction(this, string2, null, AllIcons.Actions.Copy, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$copyToClipboard(this.this$0);
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }, 2, null);
        String string3 = DatabaseBundle.message("scriptGen.ui.sidePanel.saveIntoFile", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"scriptGen.ui.sidePanel.saveIntoFile\")");
        FinalAction saveToFileAction2 = new FinalAction(this, string3, null, AllIcons.Actions.MenuSaveall, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$saveToFile(this.this$0);
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }, 2, null);
        String string4 = DatabaseBundle.message("scriptGen.ui.sidePanel.openInConsole", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"scriptGen.ui.sidePanel.openInConsole\")");
        FinalAction openInConsoleAction2 = new FinalAction(this, string4, null, DatabaseIcons.ConsoleRun, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$openInConsole(this.this$0);
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }, 2, null);
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actions = new DefaultActionGroup(new AnAction[]{copyToClipboardAction2, saveToFileAction2, openInConsoleAction2});
        ActionToolbar actionToolbar = actionManager.createActionToolbar("EditorToolbar", (ActionGroup)actions, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"actionManager.createActi\u2026_TOOLBAR, actions, false)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)this.viewer);
        JBTabbedPane tabs = new JBTabbedPane(2);
        tabs.addTab(null, AllIcons.General.GearPlain, (Component)optionsScrollPane, DatabaseBundle.message("scriptGen.ui.sidePanel.generatorOptions", new Object[0]));
        tabs.addTab(null, AllIcons.Actions.MenuSaveall, (Component)this.layoutPanel.getComponent(), DatabaseBundle.message("scriptGen.ui.sidePanel.fileOutputOptions", new Object[0]));
        JPanel jPanel = new JPanel(new BorderLayout());
        boolean bl7 = false;
        boolean bl8 = false;
        JPanel jPanel2 = jPanel;
        scriptGeneratorUI = this;
        boolean bl9 = false;
        $this$apply.add((Component)this.loadingPanel, "Center");
        $this$apply.add((Component)tabs, "West");
        $this$apply.add((Component)actionToolbar2.getComponent(), "East");
        unit = Unit.INSTANCE;
        scriptGeneratorUI.mainPanel = jPanel;
    }

    static {
        Companion = new Companion(null);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        ScriptGeneratorUI.application = application;
        contextKey = new Key("DatabaseScriptingContext");
        modelKey = new Key("DatabaseModel");
        implementedCategories = CollectionsKt.listOf((Object[])new ScriptCategory[]{ScriptCategory.CREATE_COMPLETE, ScriptCategory.CREATE_DEFINITION, ScriptCategory.NATIVE_DEFINITION, ScriptCategory.ENABLE_CONSTRAINTS, ScriptCategory.DISABLE_CONSTRAINTS, ScriptCategory.REFRESH, ScriptCategory.RECOMPILE, ScriptCategory.EXECUTE, ScriptCategory.TRUNCATE, ScriptCategory.DROP_COMPLETE});
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(ScriptGeneratorUI.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        log = logger2;
        formattableKindRemapping = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)CompositeText.Kind.PLAIN_TEXT), (Object)((Object)CompositeText.Kind.PLAIN_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.FIXED_TEXT), (Object)((Object)CompositeText.Kind.PLAIN_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.ORIGINAL_TEXT), (Object)((Object)CompositeText.Kind.DECOMPILED_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.DECOMPILED_TEXT), (Object)((Object)CompositeText.Kind.DECOMPILED_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.SPECIFICATION_TEXT), (Object)((Object)CompositeText.Kind.PLAIN_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.SQL_DELIMITER), (Object)((Object)CompositeText.Kind.SQL_DELIMITER))});
    }

    public static final /* synthetic */ Map access$retrieveNativeDefinitionsForElements(ScriptGeneratorUI $this, List elements) {
        return $this.retrieveNativeDefinitionsForElements(elements);
    }

    public static final /* synthetic */ void access$prepareDocument(ScriptGeneratorUI $this) {
        $this.prepareDocument();
    }

    public static final /* synthetic */ void access$showTheScriptInsideUI(ScriptGeneratorUI $this) {
        $this.showTheScriptInsideUI();
    }

    public static final /* synthetic */ Document access$getDocument$p(ScriptGeneratorUI $this) {
        return $this.document;
    }

    public static final /* synthetic */ void access$setDocument$p(ScriptGeneratorUI $this, Document document) {
        $this.document = document;
    }

    public static final /* synthetic */ void access$regenerate(ScriptGeneratorUI $this) {
        $this.regenerate();
    }

    public static final /* synthetic */ void access$assignCategory(ScriptGeneratorUI $this, ScriptCategory category) {
        $this.assignCategory(category);
    }

    public static final /* synthetic */ void access$adjustOptionsUI(ScriptGeneratorUI $this) {
        $this.adjustOptionsUI();
    }

    public static final /* synthetic */ void access$copyToClipboard(ScriptGeneratorUI $this) {
        $this.copyToClipboard();
    }

    public static final /* synthetic */ void access$saveToFile(ScriptGeneratorUI $this) {
        $this.saveToFile();
    }

    public static final /* synthetic */ void access$openInConsole(ScriptGeneratorUI $this) {
        $this.openInConsole();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$Selection;", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicModel;Ljava/util/Collection;)V", "getElements", "()Ljava/util/Collection;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.impl"})
    private static final class Selection {
        @NotNull
        private final BasicModel model;
        @NotNull
        private final Collection<BasicElement> elements;

        @NotNull
        public final BasicModel getModel() {
            return this.model;
        }

        @NotNull
        public final Collection<BasicElement> getElements() {
            return this.elements;
        }

        public Selection(@NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elements) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.model = model;
            this.elements = elements;
        }

        @NotNull
        public final BasicModel component1() {
            return this.model;
        }

        @NotNull
        public final Collection<BasicElement> component2() {
            return this.elements;
        }

        @NotNull
        public final Selection copy(@NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elements) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return new Selection(model, elements);
        }

        public static /* synthetic */ Selection copy$default(Selection selection, BasicModel basicModel, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                basicModel = selection.model;
            }
            if ((n & 2) != 0) {
                collection = selection.elements;
            }
            return selection.copy(basicModel, collection);
        }

        @NotNull
        public String toString() {
            return "Selection(model=" + this.model + ", elements=" + this.elements + ")";
        }

        public int hashCode() {
            BasicModel basicModel = this.model;
            Collection<BasicElement> collection = this.elements;
            return (basicModel != null ? basicModel.hashCode() : 0) * 31 + (collection != null ? ((Object)collection).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Selection)) break block3;
                    Selection selection = (Selection)object;
                    if (!Intrinsics.areEqual((Object)this.model, (Object)selection.model) || !Intrinsics.areEqual(this.elements, selection.elements)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B7\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$FinalAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "text", "", "description", "icon", "Ljavax/swing/Icon;", "action", "Lkotlin/Function0;", "", "(Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;Lkotlin/jvm/functions/Function0;)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    private final class FinalAction
    extends AnAction {
        @NotNull
        private final Function0<Unit> action;
        final /* synthetic */ ScriptGeneratorUI this$0;

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.action.invoke();
        }

        public FinalAction(@NlsActions.ActionText @NotNull ScriptGeneratorUI this$0, @NlsActions.ActionDescription @Nullable String text2, @Nullable String description, @NotNull Icon icon, Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            super(text2, description, icon);
            this.this$0 = this$0;
            this.action = action2;
        }

        public /* synthetic */ FinalAction(ScriptGeneratorUI scriptGeneratorUI, String string, String string2, Icon icon, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this(scriptGeneratorUI, string, string2, icon, (Function0<Unit>)function0);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020'0)R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000bR\u0011\u0010$\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0019\u00a8\u0006*"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$Companion;", "", "()V", "application", "Lcom/intellij/openapi/application/Application;", "getApplication", "()Lcom/intellij/openapi/application/Application;", "contextKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI;", "getContextKey", "()Lcom/intellij/openapi/util/Key;", "formattableKindRemapping", "", "Lcom/intellij/database/script/CompositeText$Kind;", "getFormattableKindRemapping", "()Ljava/util/Map;", "implementedCategories", "", "Lcom/intellij/database/script/generator/ScriptCategory;", "getImplementedCategories", "()Ljava/util/List;", "lastPath", "", "getLastPath", "()Ljava/lang/String;", "setLastPath", "(Ljava/lang/String;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "modelKey", "Lcom/intellij/database/model/basic/BasicModel;", "getModelKey", "normalLoadingPanelText", "getNormalLoadingPanelText", "invokeLater", "", "whatToDo", "Lkotlin/Function0;", "intellij.database.impl"})
    public static final class Companion {
        @NotNull
        public final Application getApplication() {
            return application;
        }

        @NotNull
        public final Key<ScriptGeneratorUI> getContextKey() {
            return contextKey;
        }

        @NotNull
        public final Key<BasicModel> getModelKey() {
            return modelKey;
        }

        @NotNull
        public final List<ScriptCategory> getImplementedCategories() {
            return implementedCategories;
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @Nullable
        public final String getLastPath() {
            return lastPath;
        }

        public final void setLastPath(@Nullable String string) {
            lastPath = string;
        }

        @NotNull
        public final Map<CompositeText.Kind, CompositeText.Kind> getFormattableKindRemapping() {
            return formattableKindRemapping;
        }

        @NotNull
        public final String getNormalLoadingPanelText() {
            String string = DatabaseBundle.message("scriptGen.ui.generatingSqlScript", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"scriptGen.ui.generatingSqlScript\")");
            return string;
        }

        public final void invokeLater(@NotNull Function0<Unit> whatToDo) {
            Intrinsics.checkNotNullParameter(whatToDo, (String)"whatToDo");
            Function0<Unit> function0 = whatToDo;
            this.getApplication().invokeLater(new Runnable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ void run() {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                }
            }, this.getApplication().getAnyModalityState());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

