/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeColumnListBase;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeForeignKey
extends DeColumnListBase {
    @Nullable
    public DeTable target;
    @NotNull
    public final List<Ref> refs;
    public DasForeignKey.RuleAction updateRule;
    public DasForeignKey.RuleAction deleteRule;
    public DasForeignKey.Deferrability deferrability;

    protected DeForeignKey(@NotNull DeModel model) {
        if (model == null) {
            DeForeignKey.$$$reportNull$$$0(0);
        }
        super(model);
        this.refs = new ArrayList<Ref>();
        this.updateRule = DasForeignKey.RuleAction.NO_ACTION;
        this.deleteRule = DasForeignKey.RuleAction.NO_ACTION;
        this.deferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    public DeForeignKey(@NotNull String name, @NotNull DeTable table, @NotNull DeModel model) {
        if (name == null) {
            DeForeignKey.$$$reportNull$$$0(1);
        }
        if (table == null) {
            DeForeignKey.$$$reportNull$$$0(2);
        }
        if (model == null) {
            DeForeignKey.$$$reportNull$$$0(3);
        }
        super(name, table, model);
        this.refs = new ArrayList<Ref>();
        this.updateRule = DasForeignKey.RuleAction.NO_ACTION;
        this.deleteRule = DasForeignKey.RuleAction.NO_ACTION;
        this.deferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    @Override
    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj, boolean withChildren, @NotNull DeObject.DeCopier copier) {
        if (obj == null) {
            DeForeignKey.$$$reportNull$$$0(4);
        }
        if (copier == null) {
            DeForeignKey.$$$reportNull$$$0(5);
        }
        super.copyFrom(obj, withChildren, copier);
        DeForeignKey fk = (DeForeignKey)obj;
        this.target = copier.copy(fk.target, true);
        this.refs.clear();
        for (Ref ref : fk.refs) {
            DeColumn reference = copier.copy(ref.ref, false);
            DeColumn target = copier.copy(ref.target, false);
            this.refs.add(new Ref(reference, target));
        }
        this.updateRule = fk.updateRule;
        this.deleteRule = fk.deleteRule;
        this.deferrability = fk.deferrability;
        DeForeignKey deForeignKey = this;
        if (deForeignKey == null) {
            DeForeignKey.$$$reportNull$$$0(6);
        }
        return deForeignKey;
    }

    public @NotNull JBIterable<@Nullable DeColumn> getColumns() {
        JBIterable jBIterable = JBIterable.from(this.refs).transform(ref -> ref.ref);
        if (jBIterable == null) {
            DeForeignKey.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    public @NotNull JBIterable<@Nullable DeColumn> getTargetColumns() {
        JBIterable jBIterable = JBIterable.from(this.refs).transform(ref -> ref.target);
        if (jBIterable == null) {
            DeForeignKey.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    public @NotNull Iterable<@NotNull String> getTargetColumnNames() {
        JBIterable jBIterable = this.getTargetColumns().map(c2 -> c2 == null ? DasUtil.NO_NAME : c2.name);
        if (jBIterable == null) {
            DeForeignKey.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public DeObject emptyClone(@NotNull DeModel model) {
        if (model == null) {
            DeForeignKey.$$$reportNull$$$0(10);
        }
        return new DeForeignKey(model);
    }

    @Override
    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children2, @NotNull Collection<? extends DeObject> otherChildren) {
        if (other == null) {
            DeForeignKey.$$$reportNull$$$0(11);
        }
        if (children2 == null) {
            DeForeignKey.$$$reportNull$$$0(12);
        }
        if (otherChildren == null) {
            DeForeignKey.$$$reportNull$$$0(13);
        }
        DeForeignKey otherFk = (DeForeignKey)other;
        return this.updateRule != otherFk.updateRule || this.deleteRule != otherFk.deleteRule || this.deferrability != otherFk.deferrability || DeForeignKey.isObjectIdentityAltered(this.target, otherFk.target) || DeForeignKey.isObjectsIdentityAltered(this.getTargetColumns(), otherFk.getTargetColumns()) || super.isAlteredIgnoringChild(other, children2, otherChildren);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
        if (objectKind == null) {
            DeForeignKey.$$$reportNull$$$0(14);
        }
        return objectKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copier";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DeForeignKey";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DeForeignKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFrom";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetColumns";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetColumnNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "emptyClone";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAlteredIgnoringChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Ref {
        @Nullable
        public final DeColumn ref;
        @Nullable
        public final DeColumn target;

        public Ref(@Nullable DeColumn ref, @Nullable DeColumn target) {
            this.ref = ref;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ref ref1 = (Ref)o;
            if (!Objects.equals(this.ref, ref1.ref)) {
                return false;
            }
            return Objects.equals(this.target, ref1.target);
        }

        public int hashCode() {
            int result2 = this.ref != null ? this.ref.hashCode() : 0;
            result2 = 31 * result2 + (this.target != null ? this.target.hashCode() : 0);
            return result2;
        }
    }
}

