/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.DbObjectEditor;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundObjectEditor
extends DbObjectEditor {
    private final List<DbObjectEditor> myEditors;
    private final JComponent myComponent;
    public static final int SMALL_WIDTH = 2;
    public static final int GRID_WIDTH = 6;

    public CompoundObjectEditor(@NotNull List<DbObjectEditor> editors) {
        if (editors == null) {
            CompoundObjectEditor.$$$reportNull$$$0(0);
        }
        this.myEditors = editors;
        List<Pair<Integer, Integer>> cells = this.getCells();
        Pair last = (Pair)ContainerUtil.getLastItem(cells);
        this.myComponent = new JPanel((LayoutManager)new GridLayoutManager(((Integer)last.first).intValue(), 6));
        for (int i2 = 0; i2 < editors.size(); ++i2) {
            DbObjectEditor editor = editors.get(i2);
            String title = editor.getTitle();
            FieldSize size = editor.getFieldSize();
            boolean vertical = editor.isVertical();
            Pair<Integer, Integer> cell = cells.get(i2);
            if (title != null) {
                JBLabel label = new JBLabel(title);
                GridConstraints lc = UrlPropertiesPanel.createLabelConstraints((Integer)cell.first, (Integer)cell.second, label.getPreferredSize().getWidth());
                if (vertical) {
                    lc.setColSpan(6);
                }
                this.myComponent.add((Component)label, lc);
            }
            int vOffset = vertical ? 1 : 0;
            int hOffset = title == null || vertical ? 0 : 1;
            GridConstraints constraints = UrlPropertiesPanel.createConstraints((Integer)cell.first + vOffset, (Integer)cell.second + hOffset, this.getWidth(size) - hOffset, 0, vertical ? 3 : 1, -1, true);
            if (vertical) {
                constraints.setVSizePolicy(UrlPropertiesPanel.getPolicy(true));
            }
            this.myComponent.add((Component)editor.getComponent(), constraints);
        }
    }

    @NotNull
    public List<DbObjectEditor> getEditors() {
        List<DbObjectEditor> list = this.myEditors;
        if (list == null) {
            CompoundObjectEditor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<Pair<Integer, Integer>> getCells() {
        ArrayList<Pair<Integer, Integer>> cells = new ArrayList<Pair<Integer, Integer>>();
        int row = 0;
        int col = 0;
        for (DbObjectEditor editor : this.myEditors) {
            FieldSize s2 = editor.getFieldSize();
            int w = this.getWidth(s2);
            if (col + w > 6) {
                col = 0;
                ++row;
            }
            cells.add((Pair<Integer, Integer>)Pair.create((Object)row, (Object)col));
            col += w;
            if (!editor.isVertical()) continue;
            assert (s2 == FieldSize.LARGE);
            ++row;
        }
        cells.add(Pair.create((Object)(row + 1), (Object)0));
        ArrayList<Pair<Integer, Integer>> arrayList = cells;
        if (arrayList == null) {
            CompoundObjectEditor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    protected int getWidth(FieldSize s2) {
        return s2 == FieldSize.LARGE ? 6 : (s2 == FieldSize.MEDIUM ? 4 : 2);
    }

    @Override
    public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
        if (e == null) {
            CompoundObjectEditor.$$$reportNull$$$0(3);
        }
        for (DbObjectEditor editor : this.myEditors) {
            editor.apply(edited, e);
        }
    }

    @Override
    public void reset(@NotNull BasicElement e) {
        if (e == null) {
            CompoundObjectEditor.$$$reportNull$$$0(4);
        }
        for (DbObjectEditor editor : this.myEditors) {
            editor.reset(e);
        }
    }

    @Override
    public void enable(@NotNull Function<BasicMetaPropertyId<?>, Boolean> enabled) {
        if (enabled == null) {
            CompoundObjectEditor.$$$reportNull$$$0(5);
        }
        for (DbObjectEditor editor : this.myEditors) {
            editor.enable(enabled);
        }
    }

    @Override
    public void initCompletion(@NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, @Nullable ObjectPath context) {
        if (dataSource2 == null) {
            CompoundObjectEditor.$$$reportNull$$$0(6);
        }
        for (DbObjectEditor editor : this.myEditors) {
            editor.initCompletion(dataSource2, searchPath, context);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            CompoundObjectEditor.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @Override
    @Nullable
    public String getTitle() {
        return null;
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = FieldSize.LARGE;
        if (fieldSize == null) {
            CompoundObjectEditor.$$$reportNull$$$0(8);
        }
        return fieldSize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/CompoundObjectEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabled";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/CompoundObjectEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCells";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

