/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.remote.jdbc.helpers.NestedObjectWrapper;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.run.ui.grid.editors.OptionalValueParser;
import com.intellij.database.run.ui.grid.editors.UniversalFormatter;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.run.ui.grid.editors.ValueParserWrapper;
import com.intellij.openapi.util.text.StringUtil;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoObjectEditorFactory
extends FormatBasedGridCellEditorFactory
implements FactoryWithDomainSupport {
    private final OptionalValueParser<NestedObjectWrapper> myParser = text2 -> (text2 = text2.trim()).startsWith("{") && text2.endsWith("}") || text2.startsWith("[") && text2.endsWith("]") ? new NestedObjectWrapper(text2) : null;

    public MongoObjectEditorFactory() {
        super(true);
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            MongoObjectEditorFactory.$$$reportNull$$$0(0);
        }
        if (domain == null) {
            MongoObjectEditorFactory.$$$reportNull$$$0(1);
        }
        return DataGridUtil.getDbms(grid).is(Dbms.MONGO) ? MongoObjectEditorFactory.getSuitability(domain.simpleName()) : 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            MongoObjectEditorFactory.$$$reportNull$$$0(2);
        }
        if (domain == null) {
            MongoObjectEditorFactory.$$$reportNull$$$0(3);
        }
        return new ValueParserWrapper<NestedObjectWrapper>(this.myParser, true, DataGridUtil.getDefaultNullValue(grid, null), (Function1<? super String, ? extends UnparsedValue>)((Function1)text2 -> new UnparsedValue((String)text2, domain)));
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            MongoObjectEditorFactory.$$$reportNull$$$0(4);
        }
        if (row == null) {
            MongoObjectEditorFactory.$$$reportNull$$$0(5);
        }
        if (column2 == null) {
            MongoObjectEditorFactory.$$$reportNull$$$0(6);
        }
        return DataGridUtil.getDbms(grid).is(Dbms.MONGO) ? MongoObjectEditorFactory.getSuitability(GridCellEditorsUtil.guessTypeNameForEditing(grid, row, column2)) : 0;
    }

    private static int getSuitability(@Nullable String typeName) {
        return StringUtil.equalsIgnoreCase((CharSequence)"Object", (CharSequence)typeName) || StringUtil.equalsIgnoreCase((CharSequence)"Array", (CharSequence)typeName) ? 10 : 0;
    }

    @Override
    @NotNull
    protected Formatter getFormatInner(final @NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowIdx, final @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (grid == null) {
            MongoObjectEditorFactory.$$$reportNull$$$0(7);
        }
        if (rowIdx == null) {
            MongoObjectEditorFactory.$$$reportNull$$$0(8);
        }
        if (columnIdx == null) {
            MongoObjectEditorFactory.$$$reportNull$$$0(9);
        }
        final GridModel model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        return new UniversalFormatter(new Format(){

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                DataConsumer.Column column2 = (DataConsumer.Column)model.getColumn(columnIdx);
                return toAppendTo.append(grid.getObjectFormatter().objectToString(obj, column2, DataGridUtil.getDbms(grid), ObjectFormatterMode.DISPLAY));
            }

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                NestedObjectWrapper parsed = MongoObjectEditorFactory.this.myParser.parse(source);
                if (parsed != null) {
                    pos.setIndex(source.length());
                    return parsed;
                }
                pos.setErrorIndex(0);
                return null;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/MongoObjectEditorFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitability";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueParser";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getFormatInner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

