/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridCellEditorsUtil {
    private GridCellEditorsUtil() {
    }

    public static int guessJdbcTypeForEditing(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(0);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(2);
        }
        if (!row.isValid(grid) || !column2.isValid(grid)) {
            return 1111;
        }
        Domain overriddenType = GridCellEditorsUtil.getOverriddenType(grid, row, column2);
        if (overriddenType != null) {
            return ExtractorsUtil.guessJdbcType(overriddenType, DataGridUtil.getDbms(grid));
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        DataConsumer.Column c2 = model.getColumn(column2);
        return c2 == null ? 1111 : ExtractorsUtil.guessJdbcType(c2, model.getValueAt(row, column2), DataGridUtil.getDbms(grid));
    }

    @NlsSafe
    @Nullable
    public static String guessTypeNameForEditing(@NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(3);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(5);
        }
        if (!row.isValid(grid) || !column2.isValid(grid)) {
            return null;
        }
        Domain overriddenType = GridCellEditorsUtil.getOverriddenType(grid, row, column2);
        if (overriddenType != null) {
            return overriddenType.simpleName();
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Object value2 = model.getValueAt(row, column2);
        DataConsumer.Column c2 = model.getColumn(column2);
        Dbms dbms = DataGridUtil.getDbms(grid);
        if (c2 != null && (value2 instanceof ReservedCellValue || value2 == null) && dbms.in(Dbms.DOCUMENT_ORIENTED)) {
            return c2.typeName;
        }
        return ExtractorsUtil.getTypeName(c2, value2, dbms);
    }

    @Nullable
    public static Domain guessDomainForEditing(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(6);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(8);
        }
        if (!row.isValid(grid) || !column2.isValid(grid)) {
            return null;
        }
        Domain overriddenType = GridCellEditorsUtil.getOverriddenType(grid, row, column2);
        if (overriddenType != null) {
            return overriddenType;
        }
        String typeName = GridCellEditorsUtil.guessTypeNameForEditing(grid, row, column2);
        return typeName == null ? null : BaseDomainRegistry.getDomain(DataGridUtil.getDbms(grid), DbImplUtil.getDatabaseVersion(DataGridUtil.getDatabaseSystem(grid)), new TypeNameColumnDescriptor(typeName), true);
    }

    @Nullable
    public static Domain getOverriddenType(CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, ModelIndex<DataConsumer.Row> row, ModelIndex<DataConsumer.Column> column2) {
        Domain domain;
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = grid.getDataHookup().getMutator();
        if (mutator instanceof GridMutator.TypesMutator && (domain = ((GridMutator.TypesMutator)mutator).getType(row, column2)) != null) {
            return domain;
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Object value2 = model.getValueAt(row, column2);
        return value2 instanceof UnparsedValue ? ((UnparsedValue)value2).getDomain() : null;
    }

    public static boolean isBooleanCell(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        boolean isBooleanColumn;
        Domain overriddenType;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(9);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(10);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(11);
        }
        if ((overriddenType = GridCellEditorsUtil.getOverriddenType(grid, row, column2)) != null) {
            return overriddenType.getLogicType() == LogicalType.BOOLEAN;
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        DataConsumer.Column c2 = model.getColumn(column2);
        Object value2 = model.getValueAt(row, column2);
        boolean bl = isBooleanColumn = c2 != null && ObjectFormatter.isBooleanColumn(c2, value2, DataGridUtil.getDbms(grid));
        if (DataGridUtil.getDbms(grid).is(Dbms.MONGO)) {
            return value2 instanceof Boolean || isBooleanColumn && (value2 == null || value2 instanceof ReservedCellValue);
        }
        if (!isBooleanColumn) {
            return false;
        }
        return value2 == null || value2 == ReservedCellValue.NULL || value2 == ReservedCellValue.DEFAULT || ObjectFormatter.getBooleanValue(value2) != null;
    }

    public static boolean isNumericCell(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        Domain overriddenType;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(12);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(13);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(14);
        }
        if ((overriddenType = GridCellEditorsUtil.getOverriddenType(grid, row, column2)) != null) {
            return LogicalType.isNumeric(overriddenType.getLogicType());
        }
        GridModel model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        DataConsumer.Column c2 = model.getColumn(column2);
        Object value2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column2);
        return c2 != null && ObjectFormatter.isNumericValue(value2, c2, DataGridUtil.getDbms(grid));
    }

    public static void showCellEditorPopup(final DataGrid grid, final Component component, int x, int y) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup popupActions = (ActionGroup)actionManager.getAction("Console.TableResult.CellEditor.Popup");
        JPopupMenu popup2 = actionManager.createActionPopupMenu("EditorPopup", popupActions).getComponent();
        popup2.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                IdeFocusManager fm = IdeFocusManager.findInstanceByComponent((Component)component);
                fm.requestFocus((Component)grid.getPreferredFocusedComponent(), true);
            }
        });
        popup2.show(component, x, y);
    }

    @Nullable
    public static TextCompletionProvider createCompletionProvider(final @NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, final @NotNull ModelIndex<DataConsumer.Column> column2) {
        GridModel model;
        DataConsumer.Column c2;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(15);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(16);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(17);
        }
        if ((c2 = (model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS)).getColumn(column2)) == null || !GridCellEditorsUtil.canComplete(grid, row, column2)) {
            return null;
        }
        return new TextFieldWithAutoCompletion.StringsCompletionProvider(null, null){

            @NotNull
            public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                List<String> items2 = GridCellEditorsUtil.getPossibleValues(grid, column2);
                if (!items2.isEmpty()) {
                    List<String> list = items2;
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                List rows = model.getRows();
                HashSet<String> objects2 = new HashSet<String>(rows.size());
                Dbms dbms = DataGridUtil.getDbms(grid);
                for (DataConsumer.Row r : rows) {
                    Object v = c2.getValue(r);
                    if (v == null) continue;
                    objects2.add(grid.getObjectFormatter().getPlainValue(c2, r, dbms, ObjectFormatterMode.DISPLAY));
                }
                HashSet<String> hashSet = objects2;
                if (hashSet == null) {
                    2.$$$reportNull$$$0(1);
                }
                return hashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil$2", "getItems"));
            }
        };
    }

    private static boolean canComplete(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        GridModel model;
        DataConsumer.Column c2;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(18);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(19);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(20);
        }
        return (c2 = (model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS)).getColumn(column2)) != null && !DataGridUtil.canInsertBlob(grid, row, column2) && (JdbcUtil.isNumberType(c2.type) || !c2.clazz.equals("java.lang.Integer") || JdbcUtil.isStringType(c2.type));
    }

    @NotNull
    private static List<String> getPossibleValues(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column2) {
        ModelHelper modelHelper;
        DataType dataType;
        List<String> values2;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(21);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(22);
        }
        List<String> list = values2 = (dataType = (modelHelper = DbImplUtil.getModelHelper(DataGridUtil.getDbms(grid))).getDataTypeForGridCompletion(grid, column2)) != null ? dataType.enumValues : null;
        List list2 = values2 != null ? ContainerUtil.map(values2, modelHelper::unquoteEnumValue) : ContainerUtil.emptyList();
        if (list2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(23);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "guessJdbcTypeForEditing";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "guessTypeNameForEditing";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "guessDomainForEditing";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanCell";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isNumericCell";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionProvider";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canComplete";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleValues";
                break;
            }
            case 23: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

