/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.EditMaximizedViewRequestPlace;
import com.intellij.database.run.ui.EditorCellViewer;
import com.intellij.database.run.ui.FormattedModeHandler;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.ValueParserCache;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0087\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\"\u0018\u0000 C2\u00020\u0001:\u0001CB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0*H\u0002J\b\u0010+\u001a\u00020(H\u0016J\b\u0010,\u001a\u00020(H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0002J\u0016\u00101\u001a\u00020(2\u0006\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u0019J\u0006\u00104\u001a\u00020(J,\u00105\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020.2\f\u00106\u001a\b\u0012\u0004\u0012\u000208072\f\u00109\u001a\b\u0012\u0004\u0012\u00020:07H\u0002J\b\u0010;\u001a\u00020(H\u0016J\u0012\u0010;\u001a\u00020(2\b\u0010<\u001a\u0004\u0018\u00010.H\u0016J\u001a\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010AH\u0002J\b\u0010B\u001a\u00020(H\u0002J.\u0010B\u001a\u00020(2\b\u0010\u0011\u001a\u0004\u0018\u00010.2\f\u00106\u001a\b\u0012\u0004\u0012\u000208072\f\u00109\u001a\b\u0012\u0004\u0012\u00020:07H\u0002R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R$\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/intellij/database/run/ui/EditorCellViewer;", "Lcom/intellij/database/run/ui/CellViewer;", "project", "Lcom/intellij/openapi/project/Project;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "editable", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/datagrid/DataGrid;Z)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "formattedModeHandler", "Lcom/intellij/database/run/ui/FormattedModeHandler;", "value", "isFormattedMode", "()Z", "setFormattedMode", "(Z)V", "isFormattedModeSupported", "isSoftWraps", "setSoftWraps", "", "offset", "getOffset", "()I", "setOffset", "(I)V", "preferedFocusComponent", "getPreferedFocusComponent", "updateDocumentListener", "com/intellij/database/run/ui/EditorCellViewer$updateDocumentListener$1", "Lcom/intellij/database/run/ui/EditorCellViewer$updateDocumentListener$1;", "valueParserCache", "Lcom/intellij/database/run/ui/ValueParserCache;", "createEditor", "disableUpdateListener", "", "action", "Lkotlin/Function0;", "dispose", "documentChanged", "getData", "", "dataId", "", "select", "start", "end", "selectAll", "setText", "rowIdx", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "columnIdx", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "update", "editedValue", "updateLanguage", "language", "Lcom/intellij/lang/Language;", "fragment", "Lcom/intellij/psi/PsiCodeFragment;", "updateText", "Companion", "intellij.database.impl"})
public final class EditorCellViewer
implements CellViewer {
    private final EditorEx editor;
    private final FormattedModeHandler formattedModeHandler;
    private final ValueParserCache valueParserCache;
    private final updateDocumentListener.1 updateDocumentListener;
    private final Project project;
    private final DataGrid grid;
    private static final String SOFT_WRAPS_DISABLED = "EditMaximizedView.SOFT_WRAPS_DISABLED";
    private static final Key<LineSeparator> LINE_SEPARATOR_KEY;
    @NotNull
    public static final Companion Companion;

    public final boolean isSoftWraps() {
        EditorSettings editorSettings = this.editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
        return editorSettings.isUseSoftWraps();
    }

    public final void setSoftWraps(boolean value2) {
        PropertiesComponent.getInstance().setValue(SOFT_WRAPS_DISABLED, !value2);
        EditorSettings editorSettings = this.editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
        editorSettings.setUseSoftWraps(value2);
    }

    public final boolean isFormattedModeSupported() {
        return this.formattedModeHandler.supportsCurrentValue();
    }

    public final boolean isFormattedMode() {
        return this.formattedModeHandler.isEnabled();
    }

    public final void setFormattedMode(boolean value2) {
        if (value2 == this.formattedModeHandler.isEnabled()) {
            return;
        }
        this.formattedModeHandler.setEnabled(value2);
        if (value2) {
            this.formattedModeHandler.reformat();
        } else {
            this.updateText();
        }
    }

    public final int getOffset() {
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        return caretModel.getOffset();
    }

    public final void setOffset(int value2) {
        if (value2 >= 0) {
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
            if (value2 <= documentEx.getTextLength()) {
                this.editor.getCaretModel().moveToOffset(value2);
                this.editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.component");
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent getPreferedFocusComponent() {
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.contentComponent");
        return jComponent;
    }

    private final void disableUpdateListener(Function0<Unit> action2) {
        this.editor.getDocument().removeDocumentListener((DocumentListener)this.updateDocumentListener);
        action2.invoke();
        this.editor.getDocument().addDocumentListener((DocumentListener)this.updateDocumentListener);
    }

    private final Object getData(String dataId) {
        return CommonDataKeys.EDITOR.is(dataId) || CommonDataKeys.HOST_EDITOR.is(dataId) ? this.editor : null;
    }

    public void dispose() {
        if (!this.editor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.editor);
        }
    }

    @Override
    public void update(@Nullable Object editedValue) {
        this.editor.getSelectionModel().removeSelection();
        SelectionModel selectionModel = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Column> modelIndex = selectionModel.getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionColumn");
        ModelIndex<DataConsumer.Column> columnIdx = modelIndex;
        SelectionModel selectionModel2 = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Row> modelIndex2 = selectionModel2.getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionRow");
        ModelIndex<DataConsumer.Row> rowIdx = modelIndex2;
        this.updateText(editedValue, rowIdx, columnIdx);
    }

    @Override
    public void update() {
        this.editor.getSelectionModel().removeSelection();
        this.updateText();
    }

    private final EditorEx createEditor(boolean editable) {
        EditorEx editorEx;
        LightVirtualFile virtualFile = new LightVirtualFile("Value Editor", (Language)PlainTextLanguage.INSTANCE, (CharSequence)"");
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
        if (document == null) {
            document = EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026ance().createDocument(\"\")");
        Document document2 = document;
        if (editable) {
            Editor editor = EditorFactory.getInstance().createEditor(document2, this.project);
            if (editor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            }
            editorEx = (EditorEx)editor;
        } else {
            Editor editor = EditorFactory.getInstance().createViewer(document2, this.project);
            if (editor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            }
            editorEx = (EditorEx)editor;
        }
        EditorEx editor = editorEx;
        JScrollPane jScrollPane = editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"editor.scrollPane");
        jScrollPane.setBorder(null);
        editor.setShowPlaceholderWhenFocused(true);
        editor.setContextMenuGroupId("Console.TableResult.CellEditor.Popup");
        EditorSettings editorSettings = editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
        editorSettings.setUseSoftWraps(!PropertiesComponent.getInstance().getBoolean(SOFT_WRAPS_DISABLED));
        EditorSettings editorSettings2 = editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings2, (String)"editor.settings");
        editorSettings2.setLineNumbersShown(false);
        editor.putUserData(CellViewer.CELL_VIEWER_KEY, (Object)this);
        return editor;
    }

    private final void updateText() {
        SelectionModel selectionModel = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Row> modelIndex = selectionModel.getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionRow");
        ModelIndex<DataConsumer.Row> rowIdx = modelIndex;
        SelectionModel selectionModel2 = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Column> modelIndex2 = selectionModel2.getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionColumn");
        ModelIndex<DataConsumer.Column> columnIdx = modelIndex2;
        if (!rowIdx.isValid(this.grid) || !columnIdx.isValid(this.grid)) {
            return;
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> gridModel = this.grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Intrinsics.checkNotNullExpressionValue(gridModel, (String)"grid.getDataModel(DataAc\u2026Type.DATA_WITH_MUTATIONS)");
        GridModel<DataConsumer.Row, DataConsumer.Column> model = gridModel;
        Object value2 = model.getValueAt(rowIdx, columnIdx);
        this.updateText(value2, rowIdx, columnIdx);
    }

    private final void updateText(Object value2, ModelIndex<DataConsumer.Row> rowIdx, ModelIndex<DataConsumer.Column> columnIdx) {
        Object object = value2;
        if (object == null) {
            object = ReservedCellValue.NULL;
        }
        this.setText(object, rowIdx, columnIdx);
        Language language = DefaultTextRendererFactory.getLanguage(this.grid, rowIdx, columnIdx);
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"DefaultTextRendererFacto\u2026(grid, rowIdx, columnIdx)");
        Language language2 = language;
        Dbms dbms = DataGridUtil.getDbms(this.grid);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"DataGridUtil.getDbms(grid)");
        GridHelper gridHelper = GridHelper.Companion.get(dbms);
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        String string = documentEx.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editor.document.text");
        PsiCodeFragment fragment = gridHelper.createCellCodeFragment(string, this.project, this.grid, rowIdx, columnIdx);
        this.updateLanguage(language2, fragment);
    }

    private final void updateLanguage(Language language, PsiCodeFragment fragment) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile((Document)this.editor.getDocument());
        if (!(virtualFile instanceof LightVirtualFile)) {
            virtualFile = null;
        }
        LightVirtualFile lightVirtualFile = (LightVirtualFile)virtualFile;
        if (lightVirtualFile == null) {
            return;
        }
        LightVirtualFile virtualFile2 = lightVirtualFile;
        if (Intrinsics.areEqual((Object)virtualFile2.getLanguage(), (Object)language) ^ true) {
            virtualFile2.setLanguage(language);
            EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((Project)this.project, (VirtualFile)((VirtualFile)virtualFile2));
            Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"HighlighterFactory.creat\u2026ter(project, virtualFile)");
            EditorHighlighter highlighter = editorHighlighter;
            this.editor.setHighlighter(highlighter);
        }
        if (fragment != null) {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
            if (psiDocumentManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.impl.PsiDocumentManagerBase");
            }
            ((PsiDocumentManagerBase)psiDocumentManager).associatePsi((Document)this.editor.getDocument(), (PsiFile)fragment);
        } else {
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{(VirtualFile)virtualFile2});
        }
        this.formattedModeHandler.reformat();
    }

    public final void select(int start2, int end2) {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        int len = documentEx.getTextLength();
        int n = 0;
        boolean bl = false;
        n = Math.max(n, start2);
        bl = false;
        int n2 = Math.min(len, n);
        n = 0;
        this.editor.getSelectionModel().setSelection(n2, Math.min(len, end2));
    }

    public final void selectAll() {
        com.intellij.openapi.editor.SelectionModel selectionModel = this.editor.getSelectionModel();
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        selectionModel.setSelection(0, documentEx.getTextLength());
    }

    private final void setText(Object value2, ModelIndex<DataConsumer.Row> rowIdx, ModelIndex<DataConsumer.Column> columnIdx) {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        DocumentEx document = documentEx;
        this.disableUpdateListener((Function0<Unit>)((Function0)new Function0<Unit>(this, rowIdx, columnIdx, value2, document){
            final /* synthetic */ EditorCellViewer this$0;
            final /* synthetic */ ModelIndex $rowIdx;
            final /* synthetic */ ModelIndex $columnIdx;
            final /* synthetic */ Object $value;
            final /* synthetic */ DocumentEx $document;

            public final void invoke() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                    final /* synthetic */ setText.1 this$0;

                    public final void run() {
                        VirtualFile file;
                        int offsetBefore = this.this$0.this$0.getOffset();
                        ResultView resultView = EditorCellViewer.access$getGrid$p(this.this$0.this$0).getResultView();
                        Intrinsics.checkNotNullExpressionValue((Object)resultView, (String)"grid.resultView");
                        Object object = resultView.getEditorFactoryProvider();
                        if (object == null || (object = object.getEditorFactory(EditorCellViewer.access$getGrid$p(this.this$0.this$0), this.this$0.$rowIdx, this.this$0.$columnIdx)) == null || (object = object.getValueFormatter(EditorCellViewer.access$getGrid$p(this.this$0.this$0), this.this$0.$rowIdx, this.this$0.$columnIdx, this.this$0.$value)) == null) {
                            object = new GridCellEditorFactory.DefaultValueToText(EditorCellViewer.access$getGrid$p(this.this$0.this$0), this.this$0.$columnIdx, this.this$0.$value);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"grid.resultView.editorFa\u2026t(grid, columnIdx, value)");
                        Object formatter = object;
                        GridCellEditorFactory.ValueFormatterResult valueFormatterResult = formatter.format();
                        Intrinsics.checkNotNullExpressionValue((Object)valueFormatterResult, (String)"formatter.format()");
                        GridCellEditorFactory.ValueFormatterResult result2 = valueFormatterResult;
                        VirtualFile virtualFile = file = FileDocumentManager.getInstance().getFile((Document)this.this$0.$document);
                        if (virtualFile != null) {
                            virtualFile.setCharset(result2.charset);
                        }
                        VirtualFile virtualFile2 = file;
                        if (virtualFile2 != null) {
                            virtualFile2.setBOM(result2.bom);
                        }
                        Document document = (Document)this.this$0.$document;
                        String string = result2.text;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.text");
                        com.intellij.database.run.ui.EditorCellViewer$Companion.access$setText(EditorCellViewer.Companion, document, string);
                        int n = this.this$0.$document.getTextLength();
                        boolean bl = false;
                        this.this$0.this$0.setOffset(Math.min(offsetBefore, n));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (this.$value instanceof ReservedCellValue) {
                    EditorCellViewer.access$getEditor$p(this.this$0).setPlaceholder((CharSequence)((ReservedCellValue)((Object)this.$value)).getDisplayName());
                } else {
                    EditorCellViewer.access$getEditor$p(this.this$0).setPlaceholder(null);
                }
            }
            {
                this.this$0 = editorCellViewer;
                this.$rowIdx = modelIndex;
                this.$columnIdx = modelIndex2;
                this.$value = object;
                this.$document = documentEx;
                super(0);
            }
        }));
    }

    private final void documentChanged() {
        String string;
        this.editor.setPlaceholder(null);
        SelectionModel selectionModel = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Row> modelIndex = selectionModel.getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionRow");
        ModelIndex<DataConsumer.Row> row = modelIndex;
        SelectionModel selectionModel2 = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Column> modelIndex2 = selectionModel2.getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionColumn");
        ModelIndex<DataConsumer.Column> column2 = modelIndex2;
        if (!row.isValid(this.grid) || !column2.isValid(this.grid)) {
            return;
        }
        GridCellEditorFactory.ValueParser parser2 = this.valueParserCache.getValueParser(row, column2);
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        DocumentEx document = documentEx;
        PsiDocumentManager.getInstance((Project)this.project).commitDocument((Document)document);
        PsiFile file = PsiDocumentManager.getInstance((Project)this.project).getPsiFile((Document)document);
        if (file != null) {
            string = EditorCellViewer.Companion.getText((Document)document, this.formattedModeHandler.minimize(file));
        } else {
            Document document2 = (Document)document;
            String string2 = document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
            string = EditorCellViewer.Companion.getText(document2, string2);
        }
        String text2 = string;
        Object object = parser2.parse(text2, (Document)document);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parser.parse(text, document)");
        Object value2 = object;
        this.grid.getResultView().setValueAt(value2, row, column2, false, new GridRequestSource(new EditMaximizedViewRequestPlace(this.grid)));
    }

    public EditorCellViewer(@NotNull Project project, @NotNull DataGrid grid, boolean editable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.project = project;
        this.grid = grid;
        this.editor = this.createEditor(editable);
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        this.formattedModeHandler = new FormattedModeHandler(this.grid, (Document)documentEx, this.project, (Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>(this){

            public final void invoke(@NotNull Function0<Unit> p1) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                EditorCellViewer.access$disableUpdateListener((EditorCellViewer)this.receiver, p1);
            }
        }));
        this.valueParserCache = new ValueParserCache(this.grid);
        this.updateDocumentListener = new DocumentListener(this){
            final /* synthetic */ EditorCellViewer this$0;

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EditorCellViewer.access$documentChanged(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.editor.getDocument().addDocumentListener((DocumentListener)this.updateDocumentListener);
        Function1 function1 = (Function1)new Function1<String, Object>(this){

            @Nullable
            public final Object invoke(@NotNull String p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((EditorCellViewer)this.receiver).getData(p1);
            }
        };
        DataManager.registerDataProvider((JComponent)this.editor.getComponent(), (DataProvider)new DataProvider(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            @Nullable
            public final /* synthetic */ Object getData(@NotNull @NonNls String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.function.invoke((Object)p0);
            }
        });
        this.grid.addDataGridListener(new DataGridListener(){

            @Override
            public void onCellTypeChanged(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @NotNull Domain newType) {
                ModelIndex it2;
                boolean bl;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block8: {
                    Intrinsics.checkNotNullParameter(rows, (String)"rows");
                    Intrinsics.checkNotNullParameter(columns, (String)"columns");
                    Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
                    JBIterable jBIterable = rows.asIterable();
                    Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"rows.asIterable()");
                    $this$any$iv = (Iterable)jBIterable;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it2 = (ModelIndex)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it2, valueParserCache.getRow())) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    boolean bl3;
                    block9: {
                        JBIterable jBIterable = columns.asIterable();
                        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"columns.asIterable()");
                        $this$any$iv = (Iterable)jBIterable;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it2 = (ModelIndex)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)it2, valueParserCache.getColumn())) continue;
                                bl3 = true;
                                break block9;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        valueParserCache.clearCache();
                    }
                }
            }

            @Override
            public void onContentChanged(@Nullable DataGrid dataGrid, @Nullable GridRequestSource.RequestPlace place) {
                valueParserCache.clearCache();
            }
        }, this);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"EDIT_MAXIMIZED_ETF_LINE_SEPARATOR");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"EDIT_MAXIMIZED_ETF_LINE_SEPARATOR\")");
        LINE_SEPARATOR_KEY = key;
    }

    public static final /* synthetic */ DataGrid access$getGrid$p(EditorCellViewer $this) {
        return $this.grid;
    }

    public static final /* synthetic */ EditorEx access$getEditor$p(EditorCellViewer $this) {
        return $this.editor;
    }

    public static final /* synthetic */ void access$disableUpdateListener(EditorCellViewer $this, Function0 action2) {
        $this.disableUpdateListener((Function0<Unit>)action2);
    }

    public static final /* synthetic */ void access$documentChanged(EditorCellViewer $this) {
        $this.documentChanged();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/run/ui/EditorCellViewer$Companion;", "", "()V", "LINE_SEPARATOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/util/LineSeparator;", "SOFT_WRAPS_DISABLED", "", "getText", "document", "Lcom/intellij/openapi/editor/Document;", "text", "setText", "", "intellij.database.impl"})
    public static final class Companion {
        private final String getText(Document document, String text2) {
            String string;
            LineSeparator separator = (LineSeparator)LINE_SEPARATOR_KEY.get((UserDataHolder)document);
            if (separator == null) {
                string = text2;
            } else {
                String string2 = StringUtil.convertLineSeparators((String)text2, (String)separator.getSeparatorString());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.convertLineSe\u2026eparator.separatorString)");
            }
            return string;
        }

        private final void setText(Document document, String text2) {
            LineSeparator separator = (LineSeparator)LINE_SEPARATOR_KEY.get((UserDataHolder)document);
            if (separator == null) {
                separator = StringUtil.detectSeparators((CharSequence)text2);
            }
            LINE_SEPARATOR_KEY.set((UserDataHolder)document, (Object)separator);
            document.setText((CharSequence)StringUtil.convertLineSeparators((String)text2));
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$setText(Companion $this, Document document, String text2) {
            $this.setText(document, text2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

