/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.CellViewerFactory;
import com.intellij.database.run.ui.EditMaximizedViewRequestPlace;
import com.intellij.database.run.ui.EditorCellViewerFactory;
import com.intellij.database.run.ui.EmptyCellViewerFactory;
import com.intellij.database.run.ui.ImageCellViewerFactory;
import com.intellij.database.run.ui.ReadonlyEditorCellViewerFactory;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u0011J\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u0016H\u0002J\b\u0010 \u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/run/ui/EditMaximizedView;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "(Lcom/intellij/database/datagrid/DataGrid;)V", "currentViewerFactory", "Lcom/intellij/database/run/ui/CellViewerFactory;", "header", "Lcom/intellij/openapi/editor/impl/EditorHeaderComponent;", "preferedFocusComponent", "Ljavax/swing/JComponent;", "getPreferedFocusComponent", "()Ljavax/swing/JComponent;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "viewer", "Lcom/intellij/database/run/ui/CellViewer;", "viewerFactories", "", "chooseViewerFactory", "dispose", "", "getData", "", "dataId", "", "getViewer", "setHeaderPosition", "horizontal", "", "updateViewer", "updateViewerComponent", "Companion", "intellij.database.impl"})
public final class EditMaximizedView
extends JPanel
implements Disposable {
    private CellViewerFactory currentViewerFactory;
    private final List<CellViewerFactory> viewerFactories;
    private CellViewer viewer;
    private EditorHeaderComponent header;
    private ActionToolbar toolbar;
    private final DataGrid grid;
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final DataKey<EditMaximizedView> EDIT_MAXIMIZED_KEY;
    @JvmField
    @NotNull
    public static final Key<EditMaximizedView> EDIT_MAXIMIZED_GRID_KEY;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final JComponent getPreferedFocusComponent() {
        return this.viewer.getPreferedFocusComponent();
    }

    /*
     * WARNING - void declaration
     */
    public final void setHeaderPosition(boolean horizontal) {
        void header;
        ActionToolbar $this$apply;
        EditorHeaderComponent editorHeaderComponent = this.header;
        if (editorHeaderComponent != null) {
            EditorHeaderComponent editorHeaderComponent2 = editorHeaderComponent;
            boolean bl = false;
            boolean bl2 = false;
            EditorHeaderComponent it2 = editorHeaderComponent2;
            boolean bl3 = false;
            this.remove((Component)it2);
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("Console.TableResult.EditMaximized.Group");
        if (anAction == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        ActionGroup actionGroup = (ActionGroup)anAction;
        ActionGroup a2 = new ActionGroup(actionGroup, horizontal){
            final /* synthetic */ ActionGroup $actionGroup;
            final /* synthetic */ boolean $horizontal;

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                Object[] objectArray;
                Object[] children2 = this.$actionGroup.getChildren(e);
                if (this.$horizontal) {
                    Intrinsics.checkNotNullExpressionValue((Object)children2, (String)"children");
                    objectArray = (AnAction[])ArraysKt.reversedArray((Object[])children2);
                } else {
                    objectArray = children2;
                    Intrinsics.checkNotNullExpressionValue((Object)children2, (String)"children");
                }
                return objectArray;
            }
            {
                this.$actionGroup = $captured_local_variable$0;
                this.$horizontal = $captured_local_variable$1;
            }
        };
        ActionToolbar actionToolbar = actionManager.createActionToolbar("EditorToolbar", a2, horizontal);
        boolean bl = false;
        boolean bl4 = false;
        ActionToolbar actionToolbar2 = actionToolbar;
        EditMaximizedView editMaximizedView = this;
        boolean bl5 = false;
        $this$apply.setReservePlaceAutoPopupIcon(false);
        $this$apply.setTargetComponent(this.viewer.getComponent());
        Unit unit = Unit.INSTANCE;
        editMaximizedView.toolbar = actionToolbar;
        actionToolbar = new EditorHeaderComponent();
        bl = false;
        bl4 = false;
        $this$apply = actionToolbar;
        editMaximizedView = this;
        boolean bl6 = false;
        header.setBorder((Border)new CustomLineBorder(JBColor.border(), 0, horizontal ? 0 : 1, horizontal ? 1 : 0, 0));
        ActionToolbar actionToolbar3 = this.toolbar;
        Intrinsics.checkNotNull((Object)actionToolbar3);
        header.add((Component)actionToolbar3.getComponent(), (Object)(horizontal ? "East" : "Center"));
        this.add((Component)header, horizontal ? "North" : "East");
        unit = Unit.INSTANCE;
        editMaximizedView.header = actionToolbar;
    }

    private final CellViewerFactory chooseViewerFactory() {
        CellViewerFactory cellViewerFactory;
        Object v4;
        SelectionModel selectionModel = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Row> modelIndex = selectionModel.getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionRow");
        ModelIndex<DataConsumer.Row> rowIdx = modelIndex;
        SelectionModel selectionModel2 = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Column> modelIndex2 = selectionModel2.getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionColumn");
        ModelIndex<DataConsumer.Column> columnIdx = modelIndex2;
        Iterable $this$maxByOrNull$iv = this.viewerFactories;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v4 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v4 = maxElem$iv;
            } else {
                CellViewerFactory it2 = (CellViewerFactory)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)((Object)it2.getSuitability(this.grid, rowIdx, columnIdx));
                do {
                    Object e$iv = iterator$iv.next();
                    CellViewerFactory it3 = (CellViewerFactory)e$iv;
                    $i$a$-maxByOrNull-EditMaximizedView$chooseViewerFactory$factory$1 = false;
                    Comparable v$iv = (Comparable)((Object)it3.getSuitability(this.grid, rowIdx, columnIdx));
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v4 = maxElem$iv;
            }
        }
        CellViewerFactory factory = v4;
        if (factory == null) {
            LOG.error("Cannot find cell viewer factory for " + rowIdx + ' ' + columnIdx);
        }
        if ((cellViewerFactory = factory) == null) {
            cellViewerFactory = EmptyCellViewerFactory.INSTANCE;
        }
        return cellViewerFactory;
    }

    @NotNull
    public final CellViewer getViewer() {
        return this.viewer;
    }

    private final void updateViewer() {
        CellViewerFactory factory = this.chooseViewerFactory();
        if (Intrinsics.areEqual((Object)this.currentViewerFactory, (Object)factory) ^ true) {
            Disposer.dispose((Disposable)this.viewer);
            this.currentViewerFactory = factory;
            this.viewer = factory.createViewer(this.grid);
            this.updateViewerComponent();
        }
    }

    private final void updateViewerComponent() {
        block2: {
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.BorderLayout");
            }
            Component oldComponent = ((BorderLayout)layoutManager).getLayoutComponent("Center");
            if (oldComponent != null) {
                this.remove(oldComponent);
            }
            this.add((Component)this.viewer.getComponent(), "Center");
            ActionToolbar actionToolbar = this.toolbar;
            if (actionToolbar == null) break block2;
            actionToolbar.setTargetComponent(this.viewer.getComponent());
        }
    }

    private final Object getData(String dataId) {
        String string = dataId;
        return Intrinsics.areEqual((Object)string, (Object)EDIT_MAXIMIZED_KEY.getName()) ? this : null;
    }

    public void dispose() {
        this.grid.putUserData(EDIT_MAXIMIZED_GRID_KEY, null);
        Disposer.dispose((Disposable)this.viewer);
    }

    public EditMaximizedView(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        super(new BorderLayout());
        this.grid = grid;
        this.viewerFactories = CollectionsKt.listOf((Object[])new CellViewerFactory[]{EditorCellViewerFactory.INSTANCE, ReadonlyEditorCellViewerFactory.INSTANCE, EmptyCellViewerFactory.INSTANCE, ImageCellViewerFactory.INSTANCE});
        this.currentViewerFactory = this.chooseViewerFactory();
        this.viewer = this.currentViewerFactory.createViewer(this.grid);
        this.updateViewerComponent();
        this.viewer.update();
        this.grid.addDataGridListener(new DataGridListener(){

            @Override
            public void onContentChanged(@NotNull DataGrid dataGrid, @Nullable GridRequestSource.RequestPlace place) {
                Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
                if (!(place instanceof EditMaximizedViewRequestPlace) || Intrinsics.areEqual((Object)((EditMaximizedViewRequestPlace)place).getGrid(), (Object)grid) ^ true) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ 1 this$0;

                        public final void run() {
                            EditMaximizedView.access$getViewer$p(this.this$0.this).update();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }

            @Override
            public void onCellLanguageChanged(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Language language) {
                block0: {
                    Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
                    Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                    viewer.update();
                    ActionToolbar actionToolbar = toolbar;
                    if (actionToolbar == null) break block0;
                    actionToolbar.updateActionsImmediately();
                }
            }

            @Override
            public void onSelectionChanged(@Nullable DataGrid dataGrid) {
                this.updateViewer();
                viewer.update();
                ActionToolbar actionToolbar = toolbar;
                if (actionToolbar != null) {
                    actionToolbar.updateActionsImmediately();
                }
                this.revalidate();
                this.repaint();
            }

            @Override
            public void onValueEdited(@Nullable DataGrid dataGrid, @Nullable Object value2) {
                ApplicationManager.getApplication().invokeLater(new Runnable(this, value2){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ Object $value;

                    public final void run() {
                        EditMaximizedView.access$getViewer$p(this.this$0.this).update(this.$value);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$value = object;
                    }
                });
            }
        }, this);
        this.grid.putUserData(EDIT_MAXIMIZED_GRID_KEY, this);
        Function1 function1 = (Function1)new Function1<String, Object>(this){

            @Nullable
            public final Object invoke(@Nullable String p1) {
                return ((EditMaximizedView)this.receiver).getData(p1);
            }
        };
        DataManager.registerDataProvider((JComponent)this, (DataProvider)new DataProvider(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            @Nullable
            public final /* synthetic */ Object getData(@NotNull @NonNls String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.function.invoke((Object)p0);
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(EditMaximizedView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(EditMaximizedView::class.java)");
        LOG = logger2;
        DataKey dataKey = DataKey.create((String)"EDIT_MAXIMIZED_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"DataKey.create(\"EDIT_MAXIMIZED_KEY\")");
        EDIT_MAXIMIZED_KEY = dataKey;
        EDIT_MAXIMIZED_GRID_KEY = new Key("EDIT_MAXIMIZED_GRID_KEY");
    }

    public static final /* synthetic */ void access$setViewer$p(EditMaximizedView $this, CellViewer cellViewer) {
        $this.viewer = cellViewer;
    }

    public static final /* synthetic */ void access$setToolbar$p(EditMaximizedView $this, ActionToolbar actionToolbar) {
        $this.toolbar = actionToolbar;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/run/ui/EditMaximizedView$Companion;", "", "()V", "EDIT_MAXIMIZED_GRID_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/run/ui/EditMaximizedView;", "EDIT_MAXIMIZED_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

