/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.NodeGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumpAction {
    private final DataExtractorFactory myFactory;
    private final ExtractionConfig myConfig;

    public DumpAction(@NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
        if (factory == null) {
            DumpAction.$$$reportNull$$$0(0);
        }
        if (config == null) {
            DumpAction.$$$reportNull$$$0(1);
        }
        this.myFactory = factory;
        this.myConfig = config;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        DumpSource<?> source = DumpAction.getDumpSource(e);
        if (project == null || source == null) {
            return;
        }
        this.actionPerformed(project, source);
    }

    public void actionPerformed(@NotNull Project project, @NotNull DumpSource<?> source) {
        DumpHandler<?> handler;
        if (project == null) {
            DumpAction.$$$reportNull$$$0(3);
        }
        if (source == null) {
            DumpAction.$$$reportNull$$$0(4);
        }
        if ((handler = DumpAction.createHandler(project, source, this.createHelper(), this.myConfig, this.myFactory)) == null) {
            return;
        }
        handler.performDump(project);
    }

    @Nullable
    public static DumpHandler<?> createHandler(@NotNull Project project, @NotNull DumpSource<?> source, ExtractionHelper manager, @NotNull ExtractionConfig config, @NotNull DataExtractorFactory factory) {
        if (project == null) {
            DumpAction.$$$reportNull$$$0(5);
        }
        if (source == null) {
            DumpAction.$$$reportNull$$$0(6);
        }
        if (config == null) {
            DumpAction.$$$reportNull$$$0(7);
        }
        if (factory == null) {
            DumpAction.$$$reportNull$$$0(8);
        }
        return source instanceof DumpSource.ConsoleSource ? DumpAction.createConsoleHandler((DumpSource.ConsoleSource)source, manager, factory, config) : (source instanceof DumpSource.DataGridSource ? new DumpHandler.GridHandler(project, ((DumpSource.DataGridSource)source).getGrid(), manager, factory, config) : new DumpHandler.DatabaseViewHandler(project, ((DumpSource.DbTablesSource)source).getSources(), manager, config, factory));
    }

    @Nullable
    private static DumpHandler<?> createConsoleHandler(@NotNull DumpSource.ConsoleSource source, @NotNull ExtractionHelper manager, @NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
        if (source == null) {
            DumpAction.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            DumpAction.$$$reportNull$$$0(10);
        }
        if (factory == null) {
            DumpAction.$$$reportNull$$$0(11);
        }
        if (config == null) {
            DumpAction.$$$reportNull$$$0(12);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        if (!source.getConsole().beforeExecuteQueries(source.getModel())) {
            return null;
        }
        JBIterable<String> queries = source.getSources();
        if (queries.isEmpty()) {
            return null;
        }
        Project project = source.getConsole().getProject();
        return new DumpHandler.ConsoleHandler(project, queries, source.getConsole(), manager, factory, config);
    }

    @Nullable
    public static DumpSource<?> getDumpSource(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            DumpAction.$$$reportNull$$$0(13);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            return dataGrid.isReady() && !dataGrid.isEmpty() ? new DumpSource.DataGridSource(dataGrid) : null;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        JdbcConsoleProvider.Info info = QueryActionBase.getInfoClassic(e, DatabaseSettings.getDefaultExecOption());
        if (console != null && info != null) {
            return new DumpSource.ConsoleSource(console, DumpAction.getAdjustedScriptModel(info));
        }
        JBIterable<DbElement> elements = DatabaseContextFun.getSelectedDbElements(e.getDataContext(), (Condition<? super NodeGroup>)((Condition)o -> o instanceof DatabaseStructure.FamilyGroup && DbImplUtilCore.isDataTable(o.getChildrenKind())));
        JBIterable<DbTable> tables = DumpAction.getTables(elements);
        return tables.isEmpty() ? null : new DumpSource.DbTablesSource(tables);
    }

    @NotNull
    private static ScriptModel<?> getAdjustedScriptModel(@NotNull JdbcConsoleProvider.Info info) {
        if (info == null) {
            DumpAction.$$$reportNull$$$0(14);
        }
        TextRange range = ScriptModelUtil.getSelectionForConsole((Editor)info.editor, info.execOption);
        TextRange adjusted = ScriptModelUtil.adjustSelectionRange(info.model, (Document)info.editor.getDocument(), range, info.execOption);
        ScriptModel<?> scriptModel = info.model.subModel(adjusted);
        if (scriptModel == null) {
            DumpAction.$$$reportNull$$$0(15);
        }
        return scriptModel;
    }

    @NotNull
    private static JBIterable<DbTable> getTables(@NotNull JBIterable<DbElement> elements) {
        if (elements == null) {
            DumpAction.$$$reportNull$$$0(16);
        }
        Set sources = elements.map(e -> e.getDataSource()).toSet();
        List canConnectSources = ContainerUtil.filter((Collection)sources, DbImplUtilCore::canConnectTo);
        JBIterable jBIterable = elements.filter(e -> canConnectSources.contains(e.getDataSource())).flatten(r -> ((JBTreeTraverser)((JBTreeTraverser)DbImplUtilCore.traverseVisibleObjects(r.getDataSource()).withRoot(r)).expand(Conditions.not(DasUtil.byClass(DasSchemaChild.class)))).filter(DbTable.class));
        if (jBIterable == null) {
            DumpAction.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    public static int getSize(@Nullable DumpSource<?> object) {
        return object == null ? 1 : object.estimateSize();
    }

    @NotNull
    public static Dbms getDbms(@Nullable DumpSource<?> object) {
        if (object instanceof DumpSource.ConsoleSource) {
            Dbms dbms = DbImplUtil.getDbms(((DumpSource.ConsoleSource)object).getConsole());
            if (dbms == null) {
                DumpAction.$$$reportNull$$$0(18);
            }
            return dbms;
        }
        if (object instanceof DumpSource.DbTablesSource) {
            Dbms dbms = DbImplUtilCore.getDbms((DbElement)((DumpSource.DbTablesSource)object).getSources().first());
            if (dbms == null) {
                DumpAction.$$$reportNull$$$0(19);
            }
            return dbms;
        }
        if (object instanceof DumpSource.DataGridSource) {
            Dbms dbms = DataGridUtil.getDbms(((DumpSource.DataGridSource)object).getGrid());
            if (dbms == null) {
                DumpAction.$$$reportNull$$$0(20);
            }
            return dbms;
        }
        Dbms dbms = Dbms.UNKNOWN;
        if (dbms == null) {
            DumpAction.$$$reportNull$$$0(21);
        }
        return dbms;
    }

    @NotNull
    public abstract ExtractionHelper createHelper();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DumpAction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DumpAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjustedScriptModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTables";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleHandler";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDumpSource";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedScriptModel";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ToFile
    extends DumpAction {
        private final File myFile;

        public ToFile(@NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config, @NotNull File file) {
            if (factory == null) {
                ToFile.$$$reportNull$$$0(0);
            }
            if (config == null) {
                ToFile.$$$reportNull$$$0(1);
            }
            if (file == null) {
                ToFile.$$$reportNull$$$0(2);
            }
            super(factory, config);
            this.myFile = file;
        }

        @Override
        @NotNull
        public ExtractionHelper createHelper() {
            return new ExtractionHelper.FileExtractionHelper(this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "config";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/DumpAction$ToFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToClipboard
    extends DumpAction {
        public ToClipboard(@NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
            if (factory == null) {
                ToClipboard.$$$reportNull$$$0(0);
            }
            if (config == null) {
                ToClipboard.$$$reportNull$$$0(1);
            }
            super(factory, config);
        }

        @Override
        @NotNull
        public ExtractionHelper createHelper() {
            return new ExtractionHelper.ClipboardExtractionHelper();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "config";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/DumpAction$ToClipboard";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

