/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddColumnAction
extends DumbAwareAction
implements GridAction {
    private static final String COLUMN_NAME_PREFIX = "column ";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddColumnAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(DataGridUtil.canMutateColumns((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            AddColumnAction.$$$reportNull$$$0(1);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            return;
        }
        AddColumnAction.insertColumn(dataGrid);
    }

    public static void insertColumn(@NotNull DataGrid grid) {
        GridDataHookUp hookup;
        if (grid == null) {
            AddColumnAction.$$$reportNull$$$0(2);
        }
        if ((hookup = grid.getDataHookup()) instanceof CsvDocumentDataHookUp) {
            CsvFormat format = ((CsvDocumentDataHookUp)hookup).getFormat();
            if (format.headerRecord == null) {
                AddColumnAction.insertColumn(grid, null);
                return;
            }
        }
        NewItemSimplePopupPanel contentPanel = new NewItemSimplePopupPanel();
        JTextField nameField = contentPanel.getTextField();
        String defaultColumnName = AddColumnAction.generateColumnName(grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS));
        nameField.setText(defaultColumnName);
        nameField.selectAll();
        JBPopup popup2 = NewItemPopupUtil.createNewItemPopup((String)DatabaseBundle.message("action.insert.column.dialog.title", new Object[0]), (JComponent)contentPanel, (JComponent)nameField);
        contentPanel.setApplyAction(event -> {
            String name = nameField.getText();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return;
            }
            popup2.closeOk(event);
            AddColumnAction.insertColumn(grid, name);
        });
        popup2.showCenteredInCurrentWindow(DataGridUtil.getProject(grid));
    }

    public static String generateColumnName(@NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model) {
        if (model == null) {
            AddColumnAction.$$$reportNull$$$0(3);
        }
        int idx = model.getColumnCount() + 1;
        String name = COLUMN_NAME_PREFIX + idx;
        while (DataGridUtil.findColumn(model, name, false).asInteger() != -1) {
            name = COLUMN_NAME_PREFIX + ++idx;
        }
        return name;
    }

    public static void insertColumn(@NotNull DataGrid grid, @Nullable String columnName) {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (grid == null) {
            AddColumnAction.$$$reportNull$$$0(4);
        }
        if ((mutator = DataGridUtil.getColumnsMutator(grid)) == null) {
            return;
        }
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            grid.submit().doWhenDone(() -> mutator.insertColumn(AddColumnAction.newInsertOrCloneColumnRequestSource(grid), columnName));
            return;
        }
        mutator.insertColumn(AddColumnAction.newInsertOrCloneColumnRequestSource(grid), columnName);
    }

    public static GridRequestSource newInsertOrCloneColumnRequestSource(@NotNull DataGrid grid) {
        if (grid == null) {
            AddColumnAction.$$$reportNull$$$0(5);
        }
        GridRequestSource source = new GridRequestSource(new DataGridRequestPlace(grid));
        source.getActionCallback().doWhenDone(() -> {
            ModelIndex<DataConsumer.Column> column2 = ModelIndex.forColumn(grid, grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumnCount() - 1);
            DataGridUtil.scrollToLocally(grid, ViewIndex.forRow(grid, 0), column2.toView(grid));
        });
        return source;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/AddColumnAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "insertColumn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generateColumnName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "newInsertOrCloneColumnRequestSource";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

