/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbViewGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement element2) {
        DasObject psiElement;
        if (element2 == null) {
            DbViewGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        Project project = element2.getProject();
        DasObject dasObject = psiElement = element2 instanceof DasObject ? (DasObject)element2 : (DasObject)SqlPsiFacade.getInstance((Project)project).findRelatedDbElements(element2, false).first();
        if (psiElement == null) {
            List list = Collections.emptyList();
            if (list == null) {
                DbViewGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        LinkedHashMap<DasObject, GotoRelatedItem> result2 = new LinkedHashMap<DasObject, GotoRelatedItem>();
        final ArrayList resultExt = new ArrayList();
        if (psiElement instanceof DasColumn) {
            DasColumn columnInfo = (DasColumn)psiElement;
            if (DasUtil.isForeign(columnInfo)) {
                for (DasForeignKey keyInfo : ModelRelationManager.getForeignKeys(project, columnInfo.getTable())) {
                    MultiRef.It<? extends DasTypedObject> it2 = keyInfo.getColumnsRef().iterate();
                    while (it2.hasNext()) {
                        String next = (String)it2.next();
                        if (!Objects.equals(next, columnInfo.getName())) continue;
                        DbViewGotoRelatedProvider.addItem(result2, it2.resolve());
                    }
                }
            }
        } else if (psiElement instanceof DasTableChild) {
            if (psiElement instanceof DasForeignKey) {
                this.addItems(result2, ((DasForeignKey)psiElement).getRefColumns(), DatabaseBundle.message("separator.referenced", new Object[0]));
            }
            if (psiElement instanceof DasConstraint) {
                String group = psiElement instanceof DasForeignKey ? DatabaseBundle.message("separator.referring", new Object[0]) : "";
                this.addItems(result2, ((DasConstraint)psiElement).getColumnsRef(), group);
            } else if (psiElement instanceof DasIndex) {
                this.addItems(result2, ((DasIndex)psiElement).getColumnsRef(), "");
            }
        } else if (psiElement instanceof DasSynonym) {
            DbViewGotoRelatedProvider.addItem(result2, ((DasSynonym)psiElement).resolveTarget());
        } else if (psiElement instanceof DasDataSource) {
            VirtualFile dsRoot;
            String uniqueId = ((DasDataSource)((Object)psiElement)).getUniqueId();
            final DbConsoleRootType rootType = DbConsoleRootType.getInstance();
            VirtualFile root2 = LocalFileSystem.getInstance().findFileByPath(ScratchFileService.getInstance().getRootPath((RootType)rootType));
            VirtualFile virtualFile = dsRoot = root2 != null && root2.isDirectory() ? root2.findChild(uniqueId) : null;
            if (dsRoot != null && dsRoot.isDirectory()) {
                final PsiManager psiManager = element2.getManager();
                VfsUtilCore.visitChildrenRecursively((VirtualFile)dsRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(final @NotNull VirtualFile file) {
                        if (file == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (file.isDirectory()) {
                            return true;
                        }
                        PsiFile psiFile = psiManager.findFile(file);
                        if (psiFile instanceof SqlFile) {
                            resultExt.add(new GotoRelatedItem((PsiElement)psiFile){

                                @NlsSafe
                                @Nullable
                                public String getCustomName() {
                                    return rootType.substituteName(psiManager.getProject(), file);
                                }

                                @Nls
                                public String getCustomContainerName() {
                                    return "(" + rootType.getDisplayName() + ")";
                                }

                                @Nullable
                                public Icon getCustomIcon() {
                                    return rootType.substituteIcon(psiManager.getProject(), file);
                                }
                            });
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/psi/DbViewGotoRelatedProvider$1", "visitFile"));
                    }
                });
            }
        }
        DbViewGotoRelatedProvider.addPredecessors(psiElement, result2);
        DbViewGotoRelatedProvider.addSuccessors(psiElement, result2);
        ArrayList res2 = new ArrayList(result2.values());
        res2.addAll(resultExt);
        ArrayList arrayList = res2;
        if (arrayList == null) {
            DbViewGotoRelatedProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void addPredecessors(DasObject psiElement, Map<DasObject, GotoRelatedItem> result2) {
        BasicElement basic = DbImplUtilCore.getMaybeBasicElement(psiElement);
        if (basic != null) {
            DbDataSource ds = ((DbElement)psiElement).getDataSource();
            for (BasicElement basicElement : basic.getPredecessors()) {
                DbElement tgt = DbImplUtilCore.findElement(ds, basicElement);
                if (tgt == null) continue;
                DbViewGotoRelatedProvider.addItem(result2, tgt);
            }
        }
    }

    private static void addSuccessors(DasObject psiElement, Map<DasObject, GotoRelatedItem> result2) {
        BasicElement basic = DbImplUtilCore.getMaybeBasicElement(psiElement);
        if (basic != null) {
            DbDataSource ds = ((DbElement)psiElement).getDataSource();
            for (BasicElement candidate : DbImplUtilCore.traverseVisibleObjects(ds).filter(BasicElement.class)) {
                DbElement tgt;
                if (candidate == basic || ContainerUtil.find(candidate.getPredecessors(), (Object)basic) == null || (tgt = DbImplUtilCore.findElement(ds, candidate)) == null) continue;
                DbViewGotoRelatedProvider.addItem(result2, tgt, DatabaseBundle.message("separator.referenced.by", new Object[0]));
            }
        }
    }

    protected void addItems(Map<DasObject, GotoRelatedItem> result2, MultiRef<? extends DasTypedObject> columns, @NlsContexts.Separator String title) {
        for (DasTypedObject dasTypedObject : columns.resolveObjects()) {
            DbViewGotoRelatedProvider.addItem(result2, dasTypedObject, title);
        }
    }

    private static void addItem(Map<DasObject, GotoRelatedItem> result2, DasObject target) {
        DbViewGotoRelatedProvider.addItem(result2, target, "");
    }

    private static void addItem(Map<DasObject, GotoRelatedItem> result2, DasObject target, @NlsContexts.Separator String title) {
        if (result2.containsKey(target)) {
            return;
        }
        if (target instanceof DbElement) {
            final NavigationItem navElement = DatabaseTargetElementEvaluator.getGotoDeclarationTarget((DbElement)target);
            result2.put(target, new GotoRelatedItem((DbElement)target, title){

                public void navigate() {
                    Objects.requireNonNull(navElement).navigate(true);
                }
            });
        } else if (target instanceof PsiElement) {
            result2.put(target, new GotoRelatedItem((PsiElement)target, title));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbViewGotoRelatedProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbViewGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

