/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasDataSource;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataSourceManager<T extends DasDataSource> {
    public static final ProjectExtensionPointName<DataSourceManager<?>> EP_NAME = new ProjectExtensionPointName("com.intellij.database.dataSourceManager");
    public static final Topic<Listener> TOPIC = new Topic("DATASOURCE_TOPIC", Listener.class);

    @NotNull
    public static List<DataSourceManager<?>> getManagers(@NotNull Project project) {
        if (project == null) {
            DataSourceManager.$$$reportNull$$$0(0);
        }
        List list = EP_NAME.getExtensions((AreaInstance)project);
        if (list == null) {
            DataSourceManager.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public static <T extends DasDataSource> DataSourceManager<T> byDataSource(@NotNull Project project, @NotNull Class<? extends T> clazz) {
        ExtensionPoint ep;
        if (project == null) {
            DataSourceManager.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            DataSourceManager.$$$reportNull$$$0(3);
        }
        return (ep = project.getExtensionArea().getExtensionPointIfRegistered(EP_NAME.getName())) == null ? null : (DataSourceManager)ContainerUtil.find((Iterable)ep.getExtensionList(), m -> m.isMyDataSource(clazz));
    }

    @NotNull
    public abstract List<T> getDataSources();

    public abstract boolean containsDataSource(@NotNull T var1);

    public abstract void addDataSource(@NotNull T var1);

    public abstract void removeDataSource(@NotNull T var1);

    @Nullable
    public abstract AnAction getCreateDataSourceAction(@NotNull Consumer<? super T> var1);

    @NotNull
    public abstract T copyDataSource(@NotNull String var1, @NotNull T var2);

    public abstract void renameDataSource(@NotNull T var1, @NotNull String var2);

    public boolean canCreateDataSourceByFiles(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            DataSourceManager.$$$reportNull$$$0(4);
        }
        return false;
    }

    @NotNull
    public List<T> createDataSourceByFiles(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            DataSourceManager.$$$reportNull$$$0(5);
        }
        List list = Collections.emptyList();
        if (list == null) {
            DataSourceManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    public abstract boolean isMyDataSource(@NotNull Class<? extends DasDataSource> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DataSourceManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DataSourceManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceByFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getManagers";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "byDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canCreateDataSourceByFiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceByFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener
    extends EventListener {
        default public <T extends DasDataSource> void dataSourceAdded(@NotNull DataSourceManager<T> manager, @NotNull T dataSource2) {
            if (manager == null) {
                Listener.$$$reportNull$$$0(0);
            }
            if (dataSource2 == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public <T extends DasDataSource> void dataSourceRemoved(@NotNull DataSourceManager<T> manager, @NotNull T dataSource2) {
            if (manager == null) {
                Listener.$$$reportNull$$$0(2);
            }
            if (dataSource2 == null) {
                Listener.$$$reportNull$$$0(3);
            }
        }

        default public <T extends DasDataSource> void dataSourceChanged(@Nullable DataSourceManager<T> manager, @Nullable T dataSource2) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/psi/DataSourceManager$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

