/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.intellij.database.Dbms;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.serialization.FixHierarchicalStreamReader;
import com.intellij.database.model.serialization.ImportException;
import com.intellij.database.model.serialization.ModelConverters;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.ModelSerializationVersions;
import com.intellij.database.model.serialization.MutableNameAndValue;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelImporter {
    private static final ModelConverters ourConverters = new ModelConverters();
    private static final Logger LOG = Logger.getInstance(ModelImporter.class);
    @NotNull
    private final ModelFactory myModelFactory;
    public Set<String> myUnconsumedProperties;
    @NotNull
    public Version expectedVersion;
    public final Version[] versionRange;
    public boolean currentFormat;
    public boolean wasMigrated;

    public ModelImporter(@NotNull ModelFactory modelFactory) {
        if (modelFactory == null) {
            ModelImporter.$$$reportNull$$$0(0);
        }
        this.myUnconsumedProperties = null;
        this.expectedVersion = Version.INFINITY;
        this.versionRange = new Version[]{Version.ZERO, Version.INFINITY};
        this.myModelFactory = modelFactory;
    }

    public BasicModModel deserialize(@NotNull HierarchicalStreamReader reader, @Nullable String dataSourceName) {
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(1);
        }
        FixHierarchicalStreamReader fReader = new FixHierarchicalStreamReader(reader);
        ModelMem modelMem = this.deserializeModelHeader(reader, dataSourceName);
        if (ModelSerializationVersions.CURRENT_VERSION.equals(modelMem.getVersion())) {
            return this.deserializeFast(fReader, dataSourceName, modelMem);
        }
        this.wasMigrated = true;
        LOG.warn("Reading from xml because of version: " + dataSourceName);
        this.deserializeModelHierarchy(fReader, dataSourceName, modelMem);
        return this.importModel(modelMem);
    }

    @NotNull
    private BasicModModel deserializeFast(FixHierarchicalStreamReader fReader, @Nullable String dataSourceName, ModelMem modelMem) {
        boolean restored;
        BasicModModel model = this.myModelFactory.createModel(modelMem.getDbms(), true);
        try {
            restored = BaseModel.restoreFromStorage(model);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable th) {
            LOG.warn(th);
            model.clearModel();
            restored = false;
        }
        if (!restored) {
            if (BaseModel.isPersistent(model)) {
                LOG.warn("Reading from xml: " + dataSourceName);
            }
            try {
                this.deserializeModelHierarchy(fReader, dataSourceName, modelMem);
                this.importToModel(modelMem, model);
            }
            catch (Throwable th) {
                model.shelve(false);
                throw th;
            }
        }
        BasicModModel basicModModel = model;
        if (basicModModel == null) {
            ModelImporter.$$$reportNull$$$0(2);
        }
        return basicModModel;
    }

    @NotNull
    public ModelMem deserializeModel(@NotNull HierarchicalStreamReader reader, @Nullable String dataSourceName) throws ImportException {
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(3);
        }
        ModelMem mm = this.deserializeModelHeader(reader, dataSourceName);
        this.deserializeModelHierarchy(reader, dataSourceName, mm);
        ModelMem modelMem = mm;
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(4);
        }
        return modelMem;
    }

    public void deserializeModelHierarchy(@NotNull HierarchicalStreamReader reader, @Nullable String dataSourceName, ModelMem mm) {
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(5);
        }
        if (mm.getVersion().compareTo(ModelSerializationVersions.MIN_VERSION) < 0 || mm.getVersion().compareTo(ModelSerializationVersions.CURRENT_VERSION) > 0) {
            String message2 = ModelImporter.getProblemPrefix(dataSourceName) + "Unsupported format version " + mm.getVersion() + " (the " + ModelSerializationVersions.CURRENT_VERSION + " is expected)";
            reader.appendErrors((ErrorWriter)new ConversionException(message2));
        } else {
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                this.deserializeObject(reader, null, mm.getNodes());
                reader.moveUp();
            }
        }
    }

    @NotNull
    public ModelMem deserializeModelHeader(@NotNull HierarchicalStreamReader reader, @Nullable String dataSourceName) {
        Version formatVersion;
        Dbms dbms;
        String rootNodeName;
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(6);
        }
        if (!(rootNodeName = reader.getNodeName()).equalsIgnoreCase("database-model")) {
            throw new ImportException(ModelImporter.getProblemPrefix(dataSourceName) + "The root node of the database model must be database-model, but found " + rootNodeName);
        }
        String dbmsStr = (String)ObjectUtils.chooseNotNull((Object)reader.getAttribute("dbms"), (Object)reader.getAttribute("family-id"));
        if (dbmsStr != null) {
            dbms = Dbms.byName(dbmsStr);
            if (dbms == null) {
                throw new ImportException(ModelImporter.getProblemPrefix(dataSourceName) + "Unknown dbms: " + dbmsStr);
            }
        } else {
            String rdbmsCode = reader.getAttribute("rdbms");
            if (rdbmsCode != null) {
                String code = rdbmsCode.equalsIgnoreCase("POSTGRE") ? (rdbmsCode = "POSTGRES") : rdbmsCode;
                dbms = Dbms.byName(StringUtil.toUpperCase((String)code));
                if (dbms == null) {
                    throw new ImportException(ModelImporter.getProblemPrefix(dataSourceName) + "Unknown rdbms: " + rdbmsCode);
                }
            } else {
                throw new ImportException(ModelImporter.getProblemPrefix(dataSourceName) + "Dbms is not specified");
            }
        }
        try {
            String formatVersionString = reader.getAttribute("format-version");
            formatVersion = formatVersionString == null ? (this.currentFormat ? ModelSerializationVersions.CURRENT_VERSION : Version.ZERO) : Version.of(formatVersionString);
        }
        catch (Exception e) {
            throw new ImportException(ModelImporter.getProblemPrefix(dataSourceName) + "Error reading format version: " + e.getMessage(), e);
        }
        ModelMem mm = new ModelMem();
        mm.setDbms(dbms);
        mm.setVersion(formatVersion);
        int n = reader.getAttributeCount();
        for (int i2 = 0; i2 < n; ++i2) {
            String attrValue;
            String attrName = reader.getAttributeName(i2);
            if (attrName.equalsIgnoreCase("dbms") || attrName.equalsIgnoreCase("family-id") || attrName.equalsIgnoreCase("serializer") || attrName.equalsIgnoreCase("rdbms") || attrName.equalsIgnoreCase("format-version") || (attrValue = reader.getAttribute(i2)) == null || attrValue.isEmpty()) continue;
            mm.getProperties().put(attrName, attrValue);
        }
        ModelMem modelMem = mm;
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(7);
        }
        return modelMem;
    }

    @NotNull
    private static String getProblemPrefix(@Nullable String dataSourceName) {
        return dataSourceName != null ? "Problem occurred when reading data source " + dataSourceName + ": " : "";
    }

    void deserializeObject(@NotNull HierarchicalStreamReader reader, ModelElementMem parent2, List<ModelElementMem> output) throws ImportException {
        Integer parentId;
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(8);
        }
        String kind = reader.getNodeName();
        Integer id = ModelImporter.parseId(reader);
        Integer n = parentId = parent2 != null ? parent2.getId() : ModelImporter.parseParentId(reader);
        if (id == null) {
            String fromVerStr = reader.getAttribute("from-version");
            String toVerStr = reader.getAttribute("to-version");
            if (fromVerStr != null || toVerStr != null) {
                Version toVer;
                Version fromVer = fromVerStr == null ? Version.ZERO : Version.of(fromVerStr);
                Version version = toVer = toVerStr == null ? Version.INFINITY : Version.of(toVerStr);
                if (!this.expectedVersion.isOrGreater(fromVer)) {
                    if (!fromVer.isOrGreater(this.versionRange[1])) {
                        this.versionRange[1] = fromVer;
                    }
                    return;
                }
                if (toVer != Version.INFINITY && this.expectedVersion.isOrGreater(toVer)) {
                    if (!this.versionRange[0].isOrGreater(toVer)) {
                        this.versionRange[0] = toVer;
                    }
                    return;
                }
                if (!this.versionRange[0].isOrGreater(fromVer)) {
                    this.versionRange[0] = fromVer;
                }
                if (!toVer.isOrGreater(this.versionRange[1])) {
                    this.versionRange[1] = toVer;
                }
            }
            id = output.size() + 1;
        }
        String name = DbUtil.intern2(StringUtil.nullize((String)reader.getAttribute("name")));
        ModelElementMem em = new ModelElementMem();
        output.add(em);
        em.setKind(kind);
        em.setId(id);
        em.setParentId(parentId);
        em.setName(name);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String key = reader.getNodeName();
            ObjectKind ok = ObjectKind.ourKinds.get(key);
            if (ok != null && ObjectKind.isDatabaseKind(ok)) {
                this.deserializeObject(reader, em, output);
            } else {
                key = ModelSerializationFun.normalize(key);
                key = DbUtil.intern2(key);
                String value2 = reader.getValue();
                value2 = ModelSerializationFun.normalize(value2);
                value2 = DbUtil.intern2(value2);
                if (key != null && value2 != null && !key.equalsIgnoreCase("name") && this.acceptsProperty(em, key)) {
                    em.getProperties().add(new MutableNameAndValue(key, value2));
                }
            }
            reader.moveUp();
        }
    }

    protected boolean acceptsProperty(ModelElementMem em, String name) {
        return true;
    }

    private static Integer parseId(@NotNull HierarchicalStreamReader reader) throws ImportException {
        String str;
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmpty((String)(str = reader.getAttribute("id")))) {
            return null;
        }
        try {
            return Integer.valueOf(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Failed to parse id", nfe);
        }
    }

    private static Integer parseParentId(@NotNull HierarchicalStreamReader reader) throws ImportException {
        String str;
        if (reader == null) {
            ModelImporter.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmpty((String)(str = reader.getAttribute("parent")))) {
            return null;
        }
        try {
            return Integer.valueOf(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Failed to parse parent id", nfe);
        }
    }

    public BasicModModel importModel(@NotNull ModelMem modelMem) throws ImportException {
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(11);
        }
        ourConverters.convertMem(modelMem);
        BasicModModel model = this.myModelFactory.createModel(modelMem.getDbms());
        this.importToModel(modelMem, model);
        return model;
    }

    private void importToModel(@NotNull ModelMem modelMem, BasicModModel model) {
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(12);
        }
        BaseModel baseModel = (BaseModel)model;
        baseModel.modify(model.getRoot(), BasicModRoot.class, true, root2 -> {
            baseModel.clearModel();
            this.populateModel(modelMem, (BasicModRoot)root2);
        });
        ourConverters.convertModel(model, modelMem.getVersion());
    }

    private void populateModel(@NotNull ModelMem modelMem, @NotNull BasicModRoot root2) {
        if (modelMem == null) {
            ModelImporter.$$$reportNull$$$0(13);
        }
        if (root2 == null) {
            ModelImporter.$$$reportNull$$$0(14);
        }
        HashMap<Integer, BasicHierarchicalObject> elements = new HashMap<Integer, BasicHierarchicalObject>(modelMem.getNodes().size());
        TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        for (ModelElementMem mem : modelMem.getNodes()) {
            BasicHierarchicalObject element2;
            ObjectKind kind;
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if ((kind = ObjectKind.ourKinds.get(mem.getKind())) == null) {
                LOG.warn("ObjectKind " + mem.getKind() + " not found");
                continue;
            }
            if (mem.getParentId() == null) {
                if (kind != ObjectKind.ROOT) {
                    throw new ImportException("Only a root object can be a root of the tree. However, found " + mem.getKind() + " without a parent");
                }
                element2 = (BasicHierarchicalObject)((Object)root2);
            } else {
                BasicHierarchicalObject parent2 = (BasicHierarchicalObject)elements.get(mem.getParentId());
                if (parent2 == null) {
                    throw new ImportException("Object " + mem.getId() + " references parent " + mem.getParentId() + " that is not found or not processed yet");
                }
                Family family = parent2.familyOf(kind);
                if (family == null) {
                    LOG.error(mem + "'s family not in parent");
                    continue;
                }
                element2 = family.asHierarchical().createNewOne();
            }
            ModelImporter.populateObject(element2, mem, propertiesMap, this.myUnconsumedProperties);
            elements.put(mem.getId(), element2);
        }
    }

    public static void populateObject(BasicModElement element2, ModelElementMem mem, Map<String, String> propertiesMap, Set<String> unconsumedProperties) {
        propertiesMap.clear();
        for (MutableNameAndValue p2 : mem.getProperties()) {
            propertiesMap.put(ModelImporter.nameFromXmlToHumps(p2.getName()), p2.getValue());
        }
        if (StringUtil.isNotEmpty((String)mem.getName())) {
            propertiesMap.put(ModelImporter.nameFromXmlToHumps("name"), mem.getName());
        }
        ModelImporter.importElementProperties(element2, propertiesMap);
        if (unconsumedProperties != null) {
            for (BasicMetaProperty property : element2.getMetaObject().properties) {
                propertiesMap.remove(property.id.name);
            }
            if (!propertiesMap.isEmpty()) {
                BasicModel model = element2.getModel();
                String className = (String)(model == null ? "" : model.getClass().getSimpleName() + ".") + element2.getClass().getSimpleName() + ".";
                for (String propName : propertiesMap.keySet()) {
                    unconsumedProperties.add(className + propName);
                }
            }
        }
    }

    private static void importElementProperties(@NotNull BasicModElement element2, @NotNull Map<String, String> propertiesMap) {
        if (element2 == null) {
            ModelImporter.$$$reportNull$$$0(15);
        }
        if (propertiesMap == null) {
            ModelImporter.$$$reportNull$$$0(16);
        }
        try {
            element2.importProperties(propertiesMap);
        }
        catch (Exception e) {
            Dbms dbms = DbImplUtilCore.getDbms(element2);
            String message2 = String.format("Importing %s model: failed to import element %s: %s: %s", dbms.getName(), element2.getClass().getSimpleName(), e.getClass().getSimpleName(), e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(message2, (Throwable)e);
            }
            LOG.warn(message2);
        }
    }

    public void setUnconsumedProperties(Set<String> unconsumedProperties) {
        this.myUnconsumedProperties = unconsumedProperties;
    }

    @NotNull
    static String nameFromXmlToHumps(@NotNull String name) {
        if (name == null) {
            ModelImporter.$$$reportNull$$$0(17);
        }
        String string = StringUtil.capitalizeWords((String)name, (String)"-", (boolean)true, (boolean)true).replace("-", "");
        if (string == null) {
            ModelImporter.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFactory";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/serialization/ModelImporter";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelMem";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesMap";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/serialization/ModelImporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeFast";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeModelHeader";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "nameFromXmlToHumps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserializeModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserializeModelHierarchy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserializeModelHeader";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserializeObject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseParentId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "importModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "importToModel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "populateModel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "importElementProperties";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "nameFromXmlToHumps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

