/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.MemoryTextStorageKt;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.CompositeTextFun;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0015\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0016J\u001f\u0010\u0017\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\f\u0010\u001f\u001a\u00020\u0005*\u00020\rH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/database/model/MemoryTextStorage;", "Lcom/intellij/database/model/ModelTextStorage;", "()V", "content", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/database/script/CompositeText;", "versions", "", "flushQueues", "", "getVersion", "element", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicElement;)Ljava/lang/Long;", "handleRename", "e", "oldName", "load", "Lcom/intellij/database/model/basic/BasicSourceAware;", "queueDelete", "save", "text", "setVersion", "version", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/Long;)V", "writeSession", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "runnable", "Ljava/lang/Runnable;", "composeElementKey", "intellij.database.core.impl"})
public final class MemoryTextStorage
implements ModelTextStorage {
    private final ConcurrentHashMap<String, CompositeText> content = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> versions = new ConcurrentHashMap();

    @Override
    public void save(@NotNull BasicSourceAware element2, @Nullable CompositeText text2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        String key = this.composeElementKey(element2);
        if (text2 != null) {
            ((Map)this.content).put(key, CompositeTextFun.copy(text2));
        } else {
            this.content.remove(key);
        }
    }

    @Override
    public void handleRename(@NotNull BasicElement e, @NotNull String oldName) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            String newKey = this.composeElementKey(e);
            int idx = StringsKt.lastIndexOf$default((CharSequence)newKey, (String)('/' + e.getName()), (int)0, (boolean)false, (int)6, null);
            if (idx == -1) {
                return;
            }
            Object object = newKey;
            int n = idx + 1;
            int n2 = idx + 1 + e.getName().length();
            boolean bl = false;
            String string = object;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String oldKey = ((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n2, (CharSequence)oldName)).toString();
            CompositeText compositeText = this.content.remove(oldKey);
            if (compositeText == null) break block2;
            object = compositeText;
            n = 0;
            n2 = 0;
            Object it2 = object;
            boolean bl2 = false;
            Map map2 = this.content;
            Object object2 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it");
            map2.put(newKey, object2);
        }
    }

    @Override
    public void queueDelete(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.content.remove(this.composeElementKey(element2));
    }

    @Override
    public void flushQueues() {
    }

    @Override
    @Nullable
    public CompositeText load(@NotNull BasicSourceAware element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        String key = this.composeElementKey(element2);
        return this.content.get(key);
    }

    @Override
    public void writeSession(@NotNull BasicModModel model, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        runnable.run();
    }

    @Override
    @Nullable
    public Long getVersion(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.versions.get(this.composeElementKey(element2));
    }

    @Override
    public void setVersion(@NotNull BasicElement element2, @Nullable Long version) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        String key = this.composeElementKey(element2);
        if (version != null) {
            ((Map)this.versions).put(key, version);
        } else {
            this.versions.remove(key);
        }
    }

    private final String composeElementKey(BasicElement $this$composeElementKey) {
        BasicModel basicModel = $this$composeElementKey.getModel();
        String prefix = String.valueOf(basicModel != null ? basicModel.hashCode() : 0);
        return prefix + '/' + CollectionsKt.joinToString$default((Iterable)MemoryTextStorageKt.getDbPath($this$composeElementKey), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }
}

