/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.fulltextsearch;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.domain.LikeOpType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FullTextSearchOptions {
    public static final int DEFAULT_MAX_NUM_OF_FETCHED_ROWS = 10;
    public static final Location DEFAULT_LOCATION = Location.CONTAINS;
    public static final SearchScope DEFAULT_SEARCH_SCOPE = SearchScope.ALL_COLUMNS;
    public static final boolean DEFAULT_MATCH_CASE = false;
    private final String myText;
    private final boolean myMatchCase;
    private final SearchScope mySearchScope;
    private final Location myLocation;
    private final int myMaxNumOfFetchedRows;

    public FullTextSearchOptions(@NotNull String text2, boolean matchCase, @NotNull SearchScope searchScope, @NotNull Location location, int maxNumOfFetchedRows) {
        if (text2 == null) {
            FullTextSearchOptions.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            FullTextSearchOptions.$$$reportNull$$$0(1);
        }
        if (location == null) {
            FullTextSearchOptions.$$$reportNull$$$0(2);
        }
        this.myText = text2;
        this.myMatchCase = matchCase;
        this.mySearchScope = searchScope;
        this.myLocation = location;
        this.myMaxNumOfFetchedRows = maxNumOfFetchedRows;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            FullTextSearchOptions.$$$reportNull$$$0(3);
        }
        return string;
    }

    public int getMaxNumOfFetchedRows() {
        return this.myMaxNumOfFetchedRows;
    }

    @NotNull
    public Location getLocation() {
        Location location = this.myLocation;
        if (location == null) {
            FullTextSearchOptions.$$$reportNull$$$0(4);
        }
        return location;
    }

    @NotNull
    public SearchScope getSearchScope() {
        SearchScope searchScope = this.mySearchScope;
        if (searchScope == null) {
            FullTextSearchOptions.$$$reportNull$$$0(5);
        }
        return searchScope;
    }

    public boolean isMatchCase() {
        return this.myMatchCase;
    }

    public String toString() {
        return String.format("%s(text: %s, maxNumOfFetchedRows: %d, target: %s, location: %s, match-case: %b)", new Object[]{FullTextSearchOptions.class.getSimpleName(), this.myText, this.myMaxNumOfFetchedRows, this.mySearchScope, this.myLocation, this.myMatchCase});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/fulltextsearch/FullTextSearchOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/fulltextsearch/FullTextSearchOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Location {
        CONTAINS(DatabaseBundle.message("FullTextSearch.contains", new Object[0]), LikeOpType.CONTAINS),
        STARTS_WITH(DatabaseBundle.message("FullTextSearch.starts.with", new Object[0]), LikeOpType.STARTS_WITH),
        ENDS_WITH(DatabaseBundle.message("FullTextSearch.ends.with", new Object[0]), LikeOpType.ENDS_WITH),
        MATCHES(DatabaseBundle.message("FullTextSearch.matches", new Object[0]), LikeOpType.MATCHES),
        LIKE_PATTERN(DatabaseBundle.message("FullTextSearch.like.pattern", new Object[0]), LikeOpType.CUSTOM_LIKE_PATTERN);

        private final String myName;
        private final LikeOpType myType;

        private Location(String name, LikeOpType type) {
            if (name == null) {
                Location.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Location.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myType = type;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Location.$$$reportNull$$$0(2);
            }
            return string;
        }

        public LikeOpType getLikeOpType() {
            return this.myType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/fulltextsearch/FullTextSearchOptions$Location";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/fulltextsearch/FullTextSearchOptions$Location";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum SearchScope {
        TEXT_COLUMNS(DatabaseBundle.message("FullTextSearch.text.columns", new Object[0]), Arrays.asList(OperandType.INDEXED_TEXT, OperandType.TEXT)),
        INDEXED_COLUMNS(DatabaseBundle.message("FullTextSearch.fts.text.columns", new Object[0]), Collections.singletonList(OperandType.INDEXED_TEXT)),
        NUMERIC_COLUMNS(DatabaseBundle.message("FullTextSearch.numeric.columns", new Object[0]), Collections.singletonList(OperandType.NUMBER)),
        ALL_COLUMNS(DatabaseBundle.message("FullTextSearch.all.columns", new Object[0]), Arrays.asList(OperandType.INDEXED_TEXT, OperandType.NUMBER, OperandType.OTHER, OperandType.TEXT));

        private final String myName;
        private final List<OperandType> myTypes;

        private SearchScope(String name, List<OperandType> types) {
            if (name == null) {
                SearchScope.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myTypes = types;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                SearchScope.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public List<OperandType> getTypes() {
            List<OperandType> list = this.myTypes;
            if (list == null) {
                SearchScope.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/fulltextsearch/FullTextSearchOptions$SearchScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/fulltextsearch/FullTextSearchOptions$SearchScope";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

